/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class StoreLoadReplacer
extends SimplifiedVisitor
implements InstructionVisitor {
    private final Instruction dupInstruction = new SimpleInstruction(89);
    private final Instruction dup2Instruction = new SimpleInstruction(92);
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public StoreLoadReplacer(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(branchTargetFinder, codeAttributeEditor, null);
    }

    public StoreLoadReplacer(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor instructionVisitor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        if (!variableInstruction.isLoad() && variableInstruction.opcode != -124) {
            Instruction instruction;
            byte by = variableInstruction.opcode;
            int n2 = variableInstruction.variableIndex;
            int n3 = n + variableInstruction.length(n);
            if (!this.codeAttributeEditor.isModified(n) && !this.codeAttributeEditor.isModified(n3) && !this.branchTargetFinder.isTarget(n3) && (instruction = InstructionFactory.create(codeAttribute.code, n3)) instanceof VariableInstruction && (variableInstruction = (VariableInstruction)instruction).isLoad() && variableInstruction.opcode != -87 && variableInstruction.variableIndex == n2) {
                Instruction instruction2 = variableInstruction.isCategory2() ? this.dup2Instruction : this.dupInstruction;
                this.codeAttributeEditor.replaceInstruction(n, instruction2);
                Instruction instruction3 = new VariableInstruction(by, variableInstruction.variableIndex).shrink();
                this.codeAttributeEditor.replaceInstruction(n3, instruction3);
                if (this.extraInstructionVisitor != null) {
                    this.extraInstructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, n, variableInstruction);
                }
            }
        }
    }
}

