/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.KeepMarker;

public class SingleImplementationMarker
extends SimplifiedVisitor
implements ClassVisitor {
    private static final boolean DEBUG = false;
    private final boolean allowAccessModification;
    private final ClassVisitor extraClassVisitor;

    public SingleImplementationMarker(boolean bl) {
        this(bl, null);
    }

    public SingleImplementationMarker(boolean bl, ClassVisitor classVisitor) {
        this.allowAccessModification = bl;
        this.extraClassVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if ((programClass.getAccessFlags() & 0x200) == 0 || KeepMarker.isKept(programClass)) {
            return;
        }
        Clazz[] clazzArray = programClass.subClasses;
        if (clazzArray == null || clazzArray.length != 1) {
            return;
        }
        Clazz clazz = clazzArray[0];
        int n = clazz.getAccessFlags();
        if ((n & 0x200) != 0) {
            clazz.accept(this);
            clazz = SingleImplementationMarker.singleImplementation(clazz);
            if (clazz == null) {
                return;
            }
            n = clazz.getAccessFlags();
        }
        for (int i = 0; i < programClass.u2methodsCount; ++i) {
            ProgramMethod programMethod = programClass.methods[i];
            if ((programMethod.getAccessFlags() & 8) != 0 || clazz.findMethod(programMethod.getName(programClass), programMethod.getDescriptor(programClass)) != null) continue;
            return;
        }
        if (AccessUtil.accessLevel(n) < AccessUtil.accessLevel(programClass.getAccessFlags())) {
            if (this.allowAccessModification) {
                ((ProgramClass)clazz).u2accessFlags = AccessUtil.replaceAccessFlags(n, programClass.getAccessFlags());
            } else {
                return;
            }
        }
        SingleImplementationMarker.markSingleImplementation(programClass, clazz);
        if (this.extraClassVisitor != null) {
            clazz.accept(this.extraClassVisitor);
        }
    }

    public static void markSingleImplementation(VisitorAccepter visitorAccepter, Clazz clazz) {
        visitorAccepter.setVisitorInfo(clazz);
    }

    public static Clazz singleImplementation(VisitorAccepter visitorAccepter) {
        return visitorAccepter != null && visitorAccepter.getVisitorInfo() instanceof Clazz ? (Clazz)visitorAccepter.getVisitorInfo() : null;
    }
}

