/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BranchUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class Processor
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private final Variables variables;
    private final Stack stack;
    private final ValueFactory valueFactory;
    private final BranchUnit branchUnit;
    private final InvocationUnit invocationUnit;
    private boolean handleClassConstantAsClassValue;
    private Value cpValue;

    public Processor(Variables variables, Stack stack, ValueFactory valueFactory, BranchUnit branchUnit, InvocationUnit invocationUnit) {
        this.variables = variables;
        this.stack = stack;
        this.valueFactory = valueFactory;
        this.branchUnit = branchUnit;
        this.invocationUnit = invocationUnit;
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.stack.push(this.valueFactory.createReferenceValueNull());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                this.stack.push(this.valueFactory.createIntegerValue(simpleInstruction.constant));
                break;
            }
            case 9: 
            case 10: {
                this.stack.push(this.valueFactory.createLongValue(simpleInstruction.constant));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.stack.push(this.valueFactory.createFloatValue(simpleInstruction.constant));
                break;
            }
            case 14: 
            case 15: {
                this.stack.push(this.valueFactory.createDoubleValue(simpleInstruction.constant));
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(this.valueFactory.createIntegerValue());
                break;
            }
            case 47: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(this.valueFactory.createLongValue());
                break;
            }
            case 48: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(this.valueFactory.createFloatValue());
                break;
            }
            case 49: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(this.valueFactory.createDoubleValue());
                break;
            }
            case 50: {
                IntegerValue integerValue = this.stack.ipop();
                ReferenceValue referenceValue = this.stack.apop();
                this.stack.push(referenceValue.arrayLoad(integerValue, this.valueFactory));
                break;
            }
            case 79: 
            case 84: 
            case 85: 
            case 86: {
                this.stack.ipop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 80: {
                this.stack.lpop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 81: {
                this.stack.fpop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 82: {
                this.stack.dpop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 83: {
                this.stack.apop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 87: {
                this.stack.pop1();
                break;
            }
            case 88: {
                this.stack.pop2();
                break;
            }
            case 89: {
                this.stack.dup();
                break;
            }
            case 90: {
                this.stack.dup_x1();
                break;
            }
            case 91: {
                this.stack.dup_x2();
                break;
            }
            case 92: {
                this.stack.dup2();
                break;
            }
            case 93: {
                this.stack.dup2_x1();
                break;
            }
            case 94: {
                this.stack.dup2_x2();
                break;
            }
            case 95: {
                this.stack.swap();
                break;
            }
            case 96: {
                this.stack.push(this.stack.ipop().add(this.stack.ipop()));
                break;
            }
            case 97: {
                this.stack.push(this.stack.lpop().add(this.stack.lpop()));
                break;
            }
            case 98: {
                this.stack.push(this.stack.fpop().add(this.stack.fpop()));
                break;
            }
            case 99: {
                this.stack.push(this.stack.dpop().add(this.stack.dpop()));
                break;
            }
            case 100: {
                this.stack.push(this.stack.ipop().subtractFrom(this.stack.ipop()));
                break;
            }
            case 101: {
                this.stack.push(this.stack.lpop().subtractFrom(this.stack.lpop()));
                break;
            }
            case 102: {
                this.stack.push(this.stack.fpop().subtractFrom(this.stack.fpop()));
                break;
            }
            case 103: {
                this.stack.push(this.stack.dpop().subtractFrom(this.stack.dpop()));
                break;
            }
            case 104: {
                this.stack.push(this.stack.ipop().multiply(this.stack.ipop()));
                break;
            }
            case 105: {
                this.stack.push(this.stack.lpop().multiply(this.stack.lpop()));
                break;
            }
            case 106: {
                this.stack.push(this.stack.fpop().multiply(this.stack.fpop()));
                break;
            }
            case 107: {
                this.stack.push(this.stack.dpop().multiply(this.stack.dpop()));
                break;
            }
            case 108: {
                try {
                    this.stack.push(this.stack.ipop().divideOf(this.stack.ipop()));
                }
                catch (ArithmeticException arithmeticException) {
                    this.stack.push(this.valueFactory.createIntegerValue());
                }
                break;
            }
            case 109: {
                try {
                    this.stack.push(this.stack.lpop().divideOf(this.stack.lpop()));
                }
                catch (ArithmeticException arithmeticException) {
                    this.stack.push(this.valueFactory.createLongValue());
                }
                break;
            }
            case 110: {
                this.stack.push(this.stack.fpop().divideOf(this.stack.fpop()));
                break;
            }
            case 111: {
                this.stack.push(this.stack.dpop().divideOf(this.stack.dpop()));
                break;
            }
            case 112: {
                try {
                    this.stack.push(this.stack.ipop().remainderOf(this.stack.ipop()));
                }
                catch (ArithmeticException arithmeticException) {
                    this.stack.push(this.valueFactory.createIntegerValue());
                }
                break;
            }
            case 113: {
                try {
                    this.stack.push(this.stack.lpop().remainderOf(this.stack.lpop()));
                }
                catch (ArithmeticException arithmeticException) {
                    this.stack.push(this.valueFactory.createLongValue());
                }
                break;
            }
            case 114: {
                this.stack.push(this.stack.fpop().remainderOf(this.stack.fpop()));
                break;
            }
            case 115: {
                this.stack.push(this.stack.dpop().remainderOf(this.stack.dpop()));
                break;
            }
            case 116: {
                this.stack.push(this.stack.ipop().negate());
                break;
            }
            case 117: {
                this.stack.push(this.stack.lpop().negate());
                break;
            }
            case 118: {
                this.stack.push(this.stack.fpop().negate());
                break;
            }
            case 119: {
                this.stack.push(this.stack.dpop().negate());
                break;
            }
            case 120: {
                this.stack.push(this.stack.ipop().shiftLeftOf(this.stack.ipop()));
                break;
            }
            case 121: {
                this.stack.push(this.stack.ipop().shiftLeftOf(this.stack.lpop()));
                break;
            }
            case 122: {
                this.stack.push(this.stack.ipop().shiftRightOf(this.stack.ipop()));
                break;
            }
            case 123: {
                this.stack.push(this.stack.ipop().shiftRightOf(this.stack.lpop()));
                break;
            }
            case 124: {
                this.stack.push(this.stack.ipop().unsignedShiftRightOf(this.stack.ipop()));
                break;
            }
            case 125: {
                this.stack.push(this.stack.ipop().unsignedShiftRightOf(this.stack.lpop()));
                break;
            }
            case 126: {
                this.stack.push(this.stack.ipop().and(this.stack.ipop()));
                break;
            }
            case 127: {
                this.stack.push(this.stack.lpop().and(this.stack.lpop()));
                break;
            }
            case -128: {
                this.stack.push(this.stack.ipop().or(this.stack.ipop()));
                break;
            }
            case -127: {
                this.stack.push(this.stack.lpop().or(this.stack.lpop()));
                break;
            }
            case -126: {
                this.stack.push(this.stack.ipop().xor(this.stack.ipop()));
                break;
            }
            case -125: {
                this.stack.push(this.stack.lpop().xor(this.stack.lpop()));
                break;
            }
            case -123: {
                this.stack.push(this.stack.ipop().convertToLong(this.valueFactory));
                break;
            }
            case -122: {
                this.stack.push(this.stack.ipop().convertToFloat(this.valueFactory));
                break;
            }
            case -121: {
                this.stack.push(this.stack.ipop().convertToDouble(this.valueFactory));
                break;
            }
            case -120: {
                this.stack.push(this.stack.lpop().convertToInteger(this.valueFactory));
                break;
            }
            case -119: {
                this.stack.push(this.stack.lpop().convertToFloat(this.valueFactory));
                break;
            }
            case -118: {
                this.stack.push(this.stack.lpop().convertToDouble(this.valueFactory));
                break;
            }
            case -117: {
                this.stack.push(this.stack.fpop().convertToInteger(this.valueFactory));
                break;
            }
            case -116: {
                this.stack.push(this.stack.fpop().convertToLong(this.valueFactory));
                break;
            }
            case -115: {
                this.stack.push(this.stack.fpop().convertToDouble(this.valueFactory));
                break;
            }
            case -114: {
                this.stack.push(this.stack.dpop().convertToInteger(this.valueFactory));
                break;
            }
            case -113: {
                this.stack.push(this.stack.dpop().convertToLong(this.valueFactory));
                break;
            }
            case -112: {
                this.stack.push(this.stack.dpop().convertToFloat(this.valueFactory));
                break;
            }
            case -111: {
                this.stack.push(this.stack.ipop().convertToByte(this.valueFactory));
                break;
            }
            case -110: {
                this.stack.push(this.stack.ipop().convertToCharacter(this.valueFactory));
                break;
            }
            case -109: {
                this.stack.push(this.stack.ipop().convertToShort(this.valueFactory));
                break;
            }
            case -108: {
                LongValue longValue = this.stack.lpop();
                LongValue longValue2 = this.stack.lpop();
                this.stack.push(longValue2.compare(longValue, this.valueFactory));
                break;
            }
            case -107: {
                FloatValue floatValue = this.stack.fpop();
                FloatValue floatValue2 = this.stack.fpop();
                this.stack.push(floatValue2.compare(floatValue, this.valueFactory));
                break;
            }
            case -106: {
                this.stack.push(this.stack.fpop().compareReverse(this.stack.fpop(), this.valueFactory));
                break;
            }
            case -105: {
                DoubleValue doubleValue = this.stack.dpop();
                DoubleValue doubleValue2 = this.stack.dpop();
                this.stack.push(doubleValue2.compare(doubleValue, this.valueFactory));
                break;
            }
            case -104: {
                this.stack.push(this.stack.dpop().compareReverse(this.stack.dpop(), this.valueFactory));
                break;
            }
            case -84: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.ipop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -83: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.lpop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -82: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.fpop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -81: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.dpop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -80: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.apop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -79: {
                this.branchUnit.returnFromMethod();
                break;
            }
            case -68: {
                IntegerValue integerValue = this.stack.ipop();
                this.stack.push(this.valueFactory.createArrayReferenceValue(String.valueOf(InstructionUtil.internalTypeFromArrayType((byte)simpleInstruction.constant)), null, integerValue));
                break;
            }
            case -66: {
                this.stack.apop();
                this.stack.push(this.valueFactory.createIntegerValue());
                break;
            }
            case -65: {
                ReferenceValue referenceValue = this.stack.apop();
                this.stack.clear();
                this.stack.push(referenceValue);
                this.branchUnit.throwException();
                break;
            }
            case -62: 
            case -61: {
                this.stack.apop();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown simple instruction [" + simpleInstruction.opcode + "]");
            }
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        int n2 = constantInstruction.constantIndex;
        switch (constantInstruction.opcode) {
            case 18: 
            case 19: 
            case 20: {
                this.stack.push(this.cpValue(clazz, n2, true));
                break;
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: 
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.invocationUnit.invokeMember(clazz, method, codeAttribute, n, constantInstruction, this.stack);
                break;
            }
            case -69: {
                this.stack.push(this.cpValue(clazz, n2).referenceValue());
                break;
            }
            case -67: {
                ReferenceValue referenceValue = this.cpValue(clazz, n2).referenceValue();
                this.stack.push(this.valueFactory.createArrayReferenceValue(referenceValue.internalType(), referenceValue.getReferencedClass(), this.stack.ipop()));
                break;
            }
            case -64: {
                ReferenceValue referenceValue = this.stack.apop();
                ReferenceValue referenceValue2 = referenceValue.isNull() == 1 ? referenceValue : (referenceValue.isNull() == -1 ? this.cpValue(clazz, n2).referenceValue() : this.cpValue(clazz, n2).referenceValue().generalize(this.valueFactory.createReferenceValueNull()));
                this.stack.push(referenceValue2);
                break;
            }
            case -63: {
                ReferenceValue referenceValue = this.cpValue(clazz, n2).referenceValue();
                int n3 = this.stack.apop().instanceOf(referenceValue.getType(), referenceValue.getReferencedClass());
                this.stack.push(n3 == -1 ? this.valueFactory.createIntegerValue(0) : (n3 == 1 ? this.valueFactory.createIntegerValue(1) : this.valueFactory.createIntegerValue()));
                break;
            }
            case -59: {
                int n4 = constantInstruction.constant;
                for (int i = 0; i < n4; ++i) {
                    IntegerValue integerValue = this.stack.ipop();
                }
                this.stack.push(this.cpValue(clazz, n2).referenceValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constant pool instruction [" + constantInstruction.opcode + "]");
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.stack.push(this.variables.iload(n2));
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.stack.push(this.variables.lload(n2));
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.stack.push(this.variables.fload(n2));
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.stack.push(this.variables.dload(n2));
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.stack.push(this.variables.aload(n2));
                break;
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.variables.store(n2, this.stack.ipop());
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.variables.store(n2, this.stack.lpop());
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.variables.store(n2, this.stack.fpop());
                break;
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.variables.store(n2, this.stack.dpop());
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.variables.store(n2, this.stack.pop());
                break;
            }
            case -124: {
                this.variables.store(n2, this.variables.iload(n2).add(this.valueFactory.createIntegerValue(variableInstruction.constant)));
                break;
            }
            case -87: {
                InstructionOffsetValue instructionOffsetValue = this.variables.oload(n2);
                this.branchUnit.branch(clazz, codeAttribute, n, instructionOffsetValue.instructionOffset(instructionOffsetValue.instructionOffsetCount() - 1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variable instruction [" + variableInstruction.opcode + "]");
            }
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        int n2 = n + branchInstruction.branchOffset;
        switch (branchInstruction.opcode) {
            case -103: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().equal(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -102: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().notEqual(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -101: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().lessThan(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -100: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().greaterThanOrEqual(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -99: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().greaterThan(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -98: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().lessThanOrEqual(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -97: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().equal(this.stack.ipop()));
                break;
            }
            case -96: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().notEqual(this.stack.ipop()));
                break;
            }
            case -95: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().greaterThan(this.stack.ipop()));
                break;
            }
            case -94: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().lessThanOrEqual(this.stack.ipop()));
                break;
            }
            case -93: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().lessThan(this.stack.ipop()));
                break;
            }
            case -92: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.ipop().greaterThanOrEqual(this.stack.ipop()));
                break;
            }
            case -91: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.apop().equal(this.stack.apop()));
                break;
            }
            case -90: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.apop().notEqual(this.stack.apop()));
                break;
            }
            case -89: 
            case -56: {
                this.branchUnit.branch(clazz, codeAttribute, n, n2);
                break;
            }
            case -88: 
            case -55: {
                this.stack.push(new InstructionOffsetValue(n + branchInstruction.length(n)));
                this.branchUnit.branch(clazz, codeAttribute, n, n2);
                break;
            }
            case -58: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.apop().isNull());
                break;
            }
            case -57: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, n, n2, this.stack.apop().isNotNull());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown branch instruction [" + branchInstruction.opcode + "]");
            }
        }
    }

    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        IntegerValue integerValue = this.stack.ipop();
        this.branchUnit.branch(clazz, codeAttribute, n, n + tableSwitchInstruction.defaultOffset);
        for (int i = 0; i < tableSwitchInstruction.jumpOffsets.length; ++i) {
            int n2 = integerValue.equal(this.valueFactory.createIntegerValue(tableSwitchInstruction.lowCase + i));
            this.branchUnit.branchConditionally(clazz, codeAttribute, n, n + tableSwitchInstruction.jumpOffsets[i], n2);
            if (n2 == 1) break;
        }
    }

    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        IntegerValue integerValue = this.stack.ipop();
        this.branchUnit.branch(clazz, codeAttribute, n, n + lookUpSwitchInstruction.defaultOffset);
        for (int i = 0; i < lookUpSwitchInstruction.jumpOffsets.length; ++i) {
            int n2 = integerValue.equal(this.valueFactory.createIntegerValue(lookUpSwitchInstruction.cases[i]));
            this.branchUnit.branchConditionally(clazz, codeAttribute, n, n + lookUpSwitchInstruction.jumpOffsets[i], n2);
            if (n2 == 1) break;
        }
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.cpValue = this.valueFactory.createIntegerValue(integerConstant.getValue());
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.cpValue = this.valueFactory.createLongValue(longConstant.getValue());
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.cpValue = this.valueFactory.createFloatValue(floatConstant.getValue());
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.cpValue = this.valueFactory.createDoubleValue(doubleConstant.getValue());
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.cpValue = this.valueFactory.createReferenceValue("java/lang/String", stringConstant.javaLangStringClass, false);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.cpValue = this.handleClassConstantAsClassValue ? this.valueFactory.createReferenceValue("java/lang/Class", classConstant.javaLangClassClass, false) : this.valueFactory.createReferenceValue(classConstant.getName(clazz), classConstant.referencedClass, false);
    }

    private Value cpValue(Clazz clazz, int n) {
        return this.cpValue(clazz, n, false);
    }

    private Value cpValue(Clazz clazz, int n, boolean bl) {
        this.handleClassConstantAsClassValue = bl;
        clazz.constantPoolEntryAccept(n, this);
        return this.cpValue;
    }
}

