/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.netbeans.junit.Filter;
import org.netbeans.junit.NbTest;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.RandomlyFails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbTestSuite
extends TestSuite
implements NbTest {
    private Filter fFilter;

    static boolean ignoreRandomFailures() {
        return Boolean.getBoolean("ignore.random.failures");
    }

    public NbTestSuite() {
    }

    public NbTestSuite(Class<? extends TestCase> clazz) {
        super(NbTestSuite.testCaseClassOrDummy(clazz));
    }

    private static Class<? extends TestCase> testCaseClassOrDummy(Class<? extends TestCase> clazz) {
        if (NbTestSuite.ignoreRandomFailures() && clazz.isAnnotationPresent(RandomlyFails.class)) {
            return APIJail.Dummy.class;
        }
        return clazz;
    }

    public NbTestSuite(String string) {
        super(string);
    }

    void addTests(Class<? extends TestCase> clazz, String ... stringArray) throws Exception {
        Constructor<? extends TestCase> constructor = clazz.getConstructor(String.class);
        for (String string : stringArray) {
            Test test = (Test)constructor.newInstance(string);
            this.addTest(test);
        }
    }

    public void addTest(Test test) {
        if (test instanceof NbTest) {
            ((NbTest)test).setFilter(this.fFilter);
        }
        super.addTest(test);
    }

    public void addTestSuite(Class<? extends TestCase> clazz) {
        if (NbTestSuite.ignoreRandomFailures() && clazz.isAnnotationPresent(RandomlyFails.class)) {
            return;
        }
        NbTestSuite nbTestSuite = new NbTestSuite(clazz);
        nbTestSuite.setFilter(this.fFilter);
        this.addTest(nbTestSuite);
    }

    @Override
    public void setFilter(Filter filter) {
        this.fFilter = filter;
        Enumeration enumeration = this.tests();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof NbTest)) continue;
            ((NbTest)e).setFilter(filter);
        }
    }

    @Override
    public boolean canRun() {
        return true;
    }

    @Override
    public String getExpectedFail() {
        return null;
    }

    public static NbTestSuite speedSuite(Class<? extends TestCase> clazz, int n, int n2) {
        if (NbTestSuite.ignoreRandomFailures()) {
            return new NbTestSuite("skipping");
        }
        return new SpeedSuite(clazz, n2, n, 0);
    }

    public static NbTestSuite linearSpeedSuite(Class<? extends TestCase> clazz, int n, int n2) {
        if (NbTestSuite.ignoreRandomFailures()) {
            return new NbTestSuite("skipping");
        }
        return new SpeedSuite(clazz, n2, n, 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SpeedSuite
    extends NbTestSuite {
        public static final int CONSTANT = 0;
        public static final int LINEAR = 1;
        private int repeat;
        private int slowness;
        private int type;

        public SpeedSuite(Class<? extends TestCase> clazz, int n, int n2, int n3) {
            super(clazz);
            this.repeat = n;
            this.slowness = n2;
            this.type = n3;
        }

        public void run(TestResult testResult) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.repeat; ++i) {
                super.run(testResult);
                stringBuffer.setLength(0);
                if (!testResult.wasSuccessful()) {
                    return;
                }
                Enumeration enumeration = this.tests();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e instanceof NbTestCase) {
                        NbTestCase nbTestCase = (NbTestCase)e;
                        stringBuffer.append("Test ");
                        stringBuffer.append(nbTestCase.getName());
                        stringBuffer.append(" took ");
                        stringBuffer.append(nbTestCase.getExecutionTime() / 1000000L);
                        stringBuffer.append(" ms\n");
                        continue;
                    }
                    stringBuffer.append("Test ");
                    stringBuffer.append(e);
                    stringBuffer.append(" is not NbTestCase");
                }
                double d = 9.223372036854776E18;
                double d2 = -9.223372036854776E18;
                Enumeration enumeration2 = this.tests();
                while (enumeration2.hasMoreElements()) {
                    Object e = enumeration2.nextElement();
                    if (!(e instanceof NbTestCase)) continue;
                    double d3 = ((NbTestCase)e).getExecutionTime();
                    if (this.type == 1) {
                        d3 /= (double)((NbTestCase)e).getTestNumber();
                    }
                    if (d3 > d2) {
                        d2 = d3;
                    }
                    if (!(d3 < d)) continue;
                    d = d3;
                }
                System.err.println(stringBuffer.toString());
                if (!(d2 <= d * (double)this.slowness)) continue;
                return;
            }
            testResult.addFailure((Test)this, new AssertionFailedError("Execution times of tests differ too much;\nthe results are supposed to be " + this.typeName() + ":\n" + stringBuffer.toString()));
        }

        private String typeName() {
            switch (this.type) {
                case 0: {
                    return "constant";
                }
                case 1: {
                    return "linear";
                }
            }
            NbTestCase.fail((String)("This is not supported type: " + this.type));
            return null;
        }
    }

    private static class APIJail {
        private APIJail() {
        }

        public static class Dummy
        extends TestCase {
            public Dummy(String string) {
                super(string);
            }

            public void testNothing() {
            }
        }
    }
}

