/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.compapp.javaee.sunresources.SunResourcesUtil;
import org.netbeans.modules.compapp.projects.jbi.CasaHelper;
import org.netbeans.modules.compapp.projects.jbi.ComponentHelper;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectHelper;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.sun.manager.jbi.management.model.ComponentInformationParser;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentStatus;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiProjectProperties {
    public static final String J2EE_1_4 = "1.4";
    public static final String J2EE_1_3 = "1.3";
    public static final String EJB_PROJECT_NAME = "j2ee.jbi.name";
    public static final String JAVA_PLATFORM = "platform.active";
    public static final String J2EE_PLATFORM = "j2ee.platform";
    public static final String SOURCE_ROOT = "source.root";
    public static final String BUILD_FILE = "buildfile";
    public static final String DIST_DIR = "dist.dir";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    public static final String DEBUG_CLASSPATH = "debug.classpath";
    public static final String JAR_COMPRESS = "jar.compress";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVAC_DEBUG = "javac.debug";
    public static final String JAVAC_DEPRECATION = "javac.deprecation";
    public static final String JAVAC_TARGET = "javac.target";
    public static final String JAVAC_ARGS = "javac.compilerargs";
    public static final String SRC_DIR = "src.dir";
    public static final String META_INF = "meta.inf";
    public static final String BUILD_DIR = "build.dir";
    public static final String BUILD_GENERATED_DIR = "build.generated.dir";
    public static final String BUILD_CLASSES_DIR = "build.classes.dir";
    public static final String BUILD_CLASSES_EXCLUDES = "build.classes.excludes";
    public static final String DIST_JAVADOC_DIR = "dist.javadoc.dir";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_PREVIEW = "javadoc.preview";
    public static final String JBI_CONTENT_ADDITIONAL = "jbi.content.additional";
    public static final String JBI_JAVAEE_JARS = "jbi.content.javaee.jars";
    public static final String JBI_JAVAEE_RESOURCE_DIRS = "jbi.javaee.res.dirs";
    public static final String JBI_CONTENT_COMPONENT = "jbi.content.component";
    public static final String TEST_DIR = "test.dir";
    public static final String TEST_RESULTS_DIR = "test.results.dir";
    public static final String SRC_BUILD_DIR = "src.build.dir";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String OSGI_SUPPORT = "osgi.support";
    public static final String OSGI_CONTAINER_DIR = "osgi.container.dir";
    public static final String ASSEMBLY_UNIT_ALIAS = "org.netbeans.modules.compapp.jbiserver.alias.assembly-unit";
    public static final String ASSEMBLY_UNIT_UUID = "org.netbeans.modules.compapp.projects.jbi.descriptor.uuid.assembly-unit";
    public static final String SERVICE_ASSEMBLY_ID = "jbi.service-assembly.id";
    public static final String ASSEMBLY_UNIT_DESCRIPTION = "org.netbeans.modules.compapp.jbiserver.description.assembly-unit";
    public static final String SERVICE_ASSEMBLY_DESCRIPTION = "jbi.service-assembly.description";
    public static final String APPLICATION_SUB_ASSEMBLY_ALIAS = "org.netbeans.modules.compapp.jbiserver.alias.application-sub-assembly";
    public static final String APPLICATION_SUB_ASSEMBLY_DESCRIPTION = "org.netbeans.modules.compapp.jbiserver.description.application-sub-assembly";
    public static final String SERVICE_UNIT_DESCRIPTION = "jbi.service-unit.description";
    public static final String JBI_COMPONENT_CONF_ROOT = "org.netbeans.modules.compapp.jbiserver.component.conf.root";
    public static final String JBI_DEPLOYMENT_CONF_ROOT = "org.netbeans.modules.compapp.jbiserver.deployment.conf.root";
    public static final String DISPLAY_NAME_PROPERTY_KEY = "com.sun.appserver.instance.displayName";
    public static final String HOST_NAME_PROPERTY_KEY = "com.sun.appserver.instance.hostName";
    public static final String ADMINISTRATION_PORT_PROPERTY_KEY = "com.sun.appserver.instance.administrationPort";
    public static final String DOMAIN_PROPERTY_KEY = "com.sun.appserver.instance.domain";
    public static final String HTTP_MONITOR_ON_PROPERTY_KEY = "com.sun.appserver.instance.httpMonitorOn";
    public static final String HTTP_PORT_NUMBER_PROPERTY_KEY = "com.sun.appserver.instance.httpPortNumber";
    public static final String LOCATION_PROPERTY_KEY = "com.sun.appserver.instance.location";
    public static final String PASSWORD_PROPERTY_KEY = "com.sun.appserver.instance.password";
    public static final String URL_PROPERTY_KEY = "com.sun.appserver.instance.url";
    public static final String USER_NAME_PROPERTY_KEY = "com.sun.appserver.instance.userName";
    public static final String JBI_REGISTRY_COMPONENT_FILE_KEY = "com.sun.jbi.registry.component.file";
    public static final String JBI_REGISTRY_BROKER_HOST_KEY = "com.sun.jbi.messaging.brokerHost";
    public static final String JBI_ROUTING = "com.sun.jbi.routing";
    public static final String JBI_SA_INTERNAL_ROUTING = "com.sun.jbi.sa.internal.routing";
    private static final String PROJECT = "nbproject/project.properties";
    private static final String PRIVATE = "nbproject/private/private.properties";
    private static final PropertyParser STRING_PARSER = new StringParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final InverseBooleanParser INVERSE_BOOLEAN_PARSER = new InverseBooleanParser();
    private static final CharsetParser CHARSET_PARSER = new CharsetParser();
    private static final PathParser PATH_PARSER = new PathParser();
    private static final PathParser SEMICOLON_PATH_PARSER = new SemiColonPathParser();
    private static final PlatformParser PLATFORM_PARSER = new PlatformParser();
    private static final StringListParser STRING_LIST_PARSER = new StringListParser();
    private static final String LIBRARY_PREFIX = "${libs.";
    private static final String[][] WELL_KNOWN_PATHS = new String[][]{{"javac.classpath", NbBundle.getMessage(JbiProjectProperties.class, (String)"LBL_JavacClasspath_DisplayName")}, {"build.classes.dir", NbBundle.getMessage(JbiProjectProperties.class, (String)"LBL_BuildClassesDir_DisplayName")}};
    private PropertyDescriptor[] PROPERTY_DESCRIPTORS = new PropertyDescriptor[]{new PropertyDescriptor("j2ee.jbi.name", null, STRING_PARSER), new PropertyDescriptor("j2ee.platform", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("source.root", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("buildfile", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("dist.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("dist.jar", "nbproject/project.properties", PATH_PARSER), new PropertyDescriptor("javac.classpath", "nbproject/project.properties", PATH_PARSER), new PropertyDescriptor("debug.classpath", "nbproject/project.properties", PATH_PARSER), new PropertyDescriptor("jar.compress", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("j2ee.server.type", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("j2ee.server.instance", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("javac.source", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javac.debug", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javac.deprecation", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javac.target", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javac.compilerargs", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("src.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("meta.inf", "nbproject/project.properties", PATH_PARSER), new PropertyDescriptor("build.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("build.classes.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("build.classes.excludes", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("dist.javadoc.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("platform.active", "nbproject/project.properties", PLATFORM_PARSER), new PropertyDescriptor("javadoc.private", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.notree", "nbproject/project.properties", INVERSE_BOOLEAN_PARSER), new PropertyDescriptor("javadoc.use", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.nonavbar", "nbproject/project.properties", INVERSE_BOOLEAN_PARSER), new PropertyDescriptor("javadoc.noindex", "nbproject/project.properties", INVERSE_BOOLEAN_PARSER), new PropertyDescriptor("javadoc.splitindex", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.author", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.version", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.windowtitle", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javadoc.encoding", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javadoc.preview", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("source.encoding", "nbproject/project.properties", CHARSET_PARSER), new PropertyDescriptor("osgi.support", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("osgi.container.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("jbi.content.additional", "nbproject/project.properties", SEMICOLON_PATH_PARSER), new PropertyDescriptor("jbi.content.javaee.jars", "nbproject/project.properties", SEMICOLON_PATH_PARSER), new PropertyDescriptor("jbi.javaee.res.dirs", "nbproject/project.properties", STRING_LIST_PARSER), new PropertyDescriptor("jbi.content.component", "nbproject/project.properties", STRING_LIST_PARSER), new PropertyDescriptor("test.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("test.results.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("com.sun.jbi.routing", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("jbi.service-assembly.id", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("jbi.service-assembly.description", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("jbi.service-unit.description", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.displayName", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.hostName", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.administrationPort", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.domain", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.httpMonitorOn", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.httpPortNumber", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.location", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.password", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.url", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.appserver.instance.userName", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.jbi.registry.component.file", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("com.sun.jbi.messaging.brokerHost", "nbproject/private/private.properties", STRING_PARSER)};
    private JbiProject project;
    private HashMap<String, PropertyInfo> properties;
    private AntProjectHelper antProjectHelper;
    private ReferenceHelper refHelper;
    private AntBasedProjectType abpt;
    private List<VisualClassPathItem> bindingList = new Vector<VisualClassPathItem>();
    private List<AntArtifact> sunresourceProjs;
    Document DIST_JAR_MODEL;
    private static final char ANT_FILE_SEPERATOR = '/';

    public JbiProjectProperties(JbiProject jbiProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.project = jbiProject;
        this.properties = new HashMap();
        this.antProjectHelper = antProjectHelper;
        this.refHelper = referenceHelper;
        this.abpt = jbiProject.getAntBasedProjectType();
        this.read();
        PropertyEvaluator propertyEvaluator = antProjectHelper.getStandardPropertyEvaluator();
        StoreGroup storeGroup = new StoreGroup();
        this.DIST_JAR_MODEL = storeGroup.createStringDocument(propertyEvaluator, DIST_JAR);
    }

    static String getAntPropertyName(String string) {
        if (string != null && string.startsWith("${") && string.endsWith("}")) {
            return string.substring(2, string.length() - 1);
        }
        return string;
    }

    public List<VisualClassPathItem> getBindingList() {
        return this.bindingList;
    }

    public void put(String string, Object object) {
        assert (string != null) : "Unknown property " + string;
        PropertyInfo propertyInfo = this.properties.get(string);
        if (propertyInfo == null) {
            PropertyDescriptor propertyDescriptor = null;
            for (int i = 0; i < this.PROPERTY_DESCRIPTORS.length; ++i) {
                propertyDescriptor = this.PROPERTY_DESCRIPTORS[i];
                if (propertyDescriptor.name.compareTo(string) == 0) break;
                propertyDescriptor = null;
            }
            if (propertyDescriptor == null) {
                return;
            }
            propertyInfo = new PropertyInfo(propertyDescriptor, (String)object, (String)object);
            this.properties.put(propertyDescriptor.name, propertyInfo);
        }
        propertyInfo.setValue(object);
        if (J2EE_SERVER_INSTANCE.equals(string)) {
            this.put(J2EE_SERVER_TYPE, Deployment.getDefault().getServerID((String)object));
        }
    }

    public Object get(String string) {
        assert (string != null) : "Unknown property " + string;
        PropertyInfo propertyInfo = this.properties.get(string);
        if (propertyInfo == null) {
            return null;
        }
        return propertyInfo.getValue();
    }

    public boolean isModified(String string) {
        assert (string != null) : "Unknown property " + string;
        PropertyInfo propertyInfo = this.properties.get(string);
        if (propertyInfo == null) {
            return false;
        }
        return propertyInfo.isModified();
    }

    public List getSortedSubprojectsList() {
        ArrayList<Project> arrayList = new ArrayList<Project>(5);
        this.addSubprojects(this.project, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Project project = (Project)arrayList.get(i);
            arrayList.set(i, (Project)ProjectUtils.getInformation((Project)project).getDisplayName());
        }
        Collections.sort(arrayList, Collator.getInstance());
        return arrayList;
    }

    JbiProject getProject() {
        return this.project;
    }

    private void addSubprojects(Project project, List<Project> list) {
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider == null) {
            return;
        }
        for (Project project2 : subprojectProvider.getSubprojects()) {
            if (list.contains(project2)) continue;
            list.add(project2);
            this.addSubprojects(project2, list);
        }
    }

    private void read() {
        HashMap<String, EditableProperties> hashMap = new HashMap<String, EditableProperties>(2);
        hashMap.put(PROJECT, this.antProjectHelper.getProperties(PROJECT));
        hashMap.put(PRIVATE, this.antProjectHelper.getProperties(PRIVATE));
        for (PropertyDescriptor propertyDescriptor : this.PROPERTY_DESCRIPTORS) {
            String string;
            if (propertyDescriptor.dest == null) {
                if (!EJB_PROJECT_NAME.equals(propertyDescriptor.name)) continue;
                string = ProjectUtils.getInformation((Project)this.project).getDisplayName();
                this.properties.put(propertyDescriptor.name, new PropertyInfo(propertyDescriptor, string, string));
                continue;
            }
            string = ((EditableProperties)hashMap.get(propertyDescriptor.dest)).getProperty(propertyDescriptor.name);
            String string2 = this.antProjectHelper.getStandardPropertyEvaluator().getProperty(propertyDescriptor.name);
            this.properties.put(propertyDescriptor.name, new PropertyInfo(propertyDescriptor, string, string2));
        }
    }

    public void addSunResourceProject(AntArtifact antArtifact) {
        if (this.sunresourceProjs == null) {
            this.sunresourceProjs = new ArrayList<AntArtifact>();
        }
        this.sunresourceProjs.add(antArtifact);
    }

    public void removeSunResourceProject(AntArtifact antArtifact) {
        if (this.sunresourceProjs != null) {
            this.sunresourceProjs.remove(antArtifact);
        }
    }

    public void store() {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    Object object;
                    Object object22;
                    JbiProjectProperties.this.resolveProjectDependencies();
                    for (Object object22 : JbiProjectProperties.this.properties.values()) {
                        Object object3 = ((PropertyInfo)object22).getPropertyDescriptor();
                        ((PropertyInfo)object22).encode();
                        object = ((PropertyInfo)object22).getNewValueEncoded();
                        if (((PropertyDescriptor)object3).dest == null && object != null && JbiProjectProperties.EJB_PROJECT_NAME.equals(((PropertyDescriptor)object3).name)) assert (false) : "No support yet for changing name of EJBProject; cf. EJBProject.setName";
                        if (!JbiProjectProperties.JAVA_PLATFORM.equals(((PropertyDescriptor)object3).name) || object == null) continue;
                        JbiProjectProperties.this.setPlatform(((PropertyInfo)object22).getNewValueEncoded().equals(JavaPlatformManager.getDefault().getDefaultPlatform().getProperties().get("platform.ant.name")));
                    }
                    try {
                        JbiProjectProperties.this.updateAssemblyInfoAndCasa();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    HashMap hashMap = new HashMap(2);
                    hashMap.put(JbiProjectProperties.PROJECT, JbiProjectProperties.this.antProjectHelper.getProperties(JbiProjectProperties.PROJECT));
                    hashMap.put(JbiProjectProperties.PRIVATE, JbiProjectProperties.this.antProjectHelper.getProperties(JbiProjectProperties.PRIVATE));
                    for (Object object3 : JbiProjectProperties.this.properties.values()) {
                        object = ((PropertyInfo)object3).getPropertyDescriptor();
                        String string = ((PropertyInfo)object3).getNewValueEncoded();
                        if (string == null || ((PropertyDescriptor)object).dest == null) continue;
                        ((EditableProperties)hashMap.get(((PropertyDescriptor)object).dest)).setProperty(((PropertyDescriptor)object).name, string);
                    }
                    JbiProjectProperties.this.antProjectHelper.putProperties(JbiProjectProperties.PROJECT, (EditableProperties)hashMap.get(JbiProjectProperties.PROJECT));
                    JbiProjectProperties.this.antProjectHelper.putProperties(JbiProjectProperties.PRIVATE, (EditableProperties)hashMap.get(JbiProjectProperties.PRIVATE));
                    ProjectManager.getDefault().saveProject((Project)JbiProjectProperties.this.project);
                    object22 = (Charset)JbiProjectProperties.this.get(JbiProjectProperties.SOURCE_ENCODING);
                    if (object22 != null) {
                        try {
                            FileEncodingQuery.setDefaultEncoding((Charset)object22);
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
            if (this.sunresourceProjs != null) {
                Iterator<AntArtifact> iterator = this.sunresourceProjs.iterator();
                AntArtifact antArtifact = null;
                while (iterator.hasNext()) {
                    antArtifact = iterator.next();
                    SunResourcesUtil.addJavaEEResourceMetaData(this.getProject(), antArtifact);
                }
            }
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
    }

    private void updateAssemblyInfoAndCasa() throws Exception {
        this.saveAssemblyInfo();
        CasaHelper.updateCasaWithJBIModules(this.project, this);
    }

    private void setPlatform(boolean bl) {
        Element element = this.antProjectHelper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagName("explicit-platform");
        if (bl && nodeList.getLength() > 0) {
            element.removeChild(nodeList.item(0));
        } else if (!bl && nodeList.getLength() == 0) {
            element.appendChild(element.getOwnerDocument().createElement("explicit-platform"));
        }
        this.antProjectHelper.putPrimaryConfigurationData(element, true);
    }

    private void resolveProjectDependencies() {
        String[] stringArray = new String[]{JBI_CONTENT_ADDITIONAL};
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<VisualClassPathItem> hashSet2 = new HashSet<VisualClassPathItem>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            PropertyInfo propertyInfo = this.properties.get(stringArray[i]);
            Object object3 = (List)propertyInfo.getOldValue();
            if (object3 != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (VisualClassPathItem)object2.next();
                    if (((VisualClassPathItem)object).getType() != 2) continue;
                    hashSet.add(object);
                }
            }
            if ((object2 = (List)propertyInfo.getValue()) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                VisualClassPathItem visualClassPathItem = (VisualClassPathItem)object.next();
                if (visualClassPathItem.getType() != 2) continue;
                hashSet2.add(visualClassPathItem);
            }
        }
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet3.removeAll(hashSet2);
        for (Object object3 : hashSet3) {
            this.refHelper.destroyReference(((VisualClassPathItem)object3).getRaw());
        }
    }

    private static Element generateIdentificationElement(org.w3c.dom.Document document, String string, String string2) {
        Element element = document.createElement("identification");
        Element element2 = document.createElement("name");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElement("description");
        element3.appendChild(document.createTextNode(string2));
        element.appendChild(element3);
        return element;
    }

    private static Element generateTargetElement(org.w3c.dom.Document document, String string, String string2) {
        Element element = document.createElement("target");
        Element element2 = document.createElement("artifacts-zip");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElement("component-name");
        element3.appendChild(document.createTextNode(string2));
        element.appendChild(element3);
        return element;
    }

    private static String[] getFileNameParts(String string) {
        String string2;
        int n;
        String[] stringArray = new String[3];
        int n2 = string.lastIndexOf(47);
        if (n2 != -1 && (n = (string2 = string.substring(n2 + 1)).indexOf(".")) != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            stringArray[0] = string2;
            stringArray[1] = string3;
            stringArray[2] = string4;
        }
        return stringArray;
    }

    private static Element generateServiceUnitElement(JbiProject jbiProject, org.w3c.dom.Document document, VisualClassPathItem visualClassPathItem, String string, boolean bl) {
        Object object;
        String string2;
        String string3;
        String string4;
        Element element = document.createElement("service-unit");
        String string5 = visualClassPathItem.getAsaDescription();
        AntArtifact antArtifact = visualClassPathItem.getAntArtifact();
        if (string5 == null) {
            string5 = JbiProjectHelper.getServiceUnitDescription(jbiProject);
            visualClassPathItem.setAsaDescription(string5);
        }
        visualClassPathItem.setAsaTarget(string);
        String string6 = jbiProject.getName();
        if (bl) {
            string4 = antArtifact.getArtifactLocations()[0].toString();
            string3 = visualClassPathItem.getProjectName();
            if (string4.indexOf("build/SEDeployment.jar") >= 0) {
                string2 = string3 + ".jar";
            } else {
                object = JbiProjectProperties.getFileNameParts(string4);
                string2 = object[0];
            }
        } else {
            string3 = string;
            string2 = string + ".jar";
        }
        string4 = string6 + "-" + string3;
        object = JbiProjectProperties.generateIdentificationElement(document, string4, string5);
        element.appendChild((Node)object);
        Element element2 = JbiProjectProperties.generateTargetElement(document, string2, string);
        element.appendChild(element2);
        return element;
    }

    private List<VisualClassPathItem> loadBindingComponentInfo(String string) {
        ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
        AntArtifact antArtifact = this.antProjectHelper.createSimpleAntArtifact("CAPS.jbi:bpelse", "build/BCDeployment.jar", this.antProjectHelper.getStandardPropertyEvaluator(), "dist_bc", "clean");
        try {
            File file = new File(string);
            if (file.exists()) {
                List list = ComponentInformationParser.parse((File)file);
                Iterator iterator = list.iterator();
                JBIComponentStatus jBIComponentStatus = null;
                HashSet<String> hashSet = new HashSet<String>();
                while (iterator != null && iterator.hasNext()) {
                    jBIComponentStatus = (JBIComponentStatus)iterator.next();
                    String string2 = jBIComponentStatus.getName();
                    if (hashSet.contains(string2)) continue;
                    hashSet.add(string2);
                    if (jBIComponentStatus.getType().compareToIgnoreCase("Binding") != 0) continue;
                    VisualClassPathItem visualClassPathItem = new VisualClassPathItem(antArtifact, 2, "BCDeployment.jar", null, true);
                    visualClassPathItem.setAsaTarget(jBIComponentStatus.getName());
                    arrayList.add(visualClassPathItem);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public void saveAssemblyInfo() {
        Object object;
        List list = (List)this.get(META_INF);
        String string = null;
        String string2 = null;
        if (list != null && list.size() > 0) {
            object = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getPath() + File.separator + list.get(0).toString();
            string = (String)object + File.separator + "ComponentInformation.xml";
            string2 = (String)object + File.separator + "AssemblyInformation.xml";
        }
        try {
            Object object2;
            Object object3;
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document document = ((DocumentBuilder)object).newDocument();
            Element element = document.createElement("jbi");
            element.setAttribute("version", "1.0");
            element.setAttribute("xmlns", "http://java.sun.com/xml/ns/jbi");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/jbi ./jbi.xsd");
            document.appendChild(element);
            Element element2 = document.createElement("service-assembly");
            Element element3 = JbiProjectProperties.generateIdentificationElement(document, JbiProjectHelper.getJbiProjectName(this.project), JbiProjectHelper.getServiceAssemblyDescription(this.project));
            element2.appendChild(element3);
            List list2 = (List)this.get(JBI_CONTENT_ADDITIONAL);
            List list3 = (List)this.get(JBI_CONTENT_COMPONENT);
            assert (list2.size() == list3.size()) : "Corrupted project.properties file: mismatching service unit artifacts and target components.";
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                object3 = (VisualClassPathItem)list2.get(i);
                object2 = (String)list3.get(i);
                assert (object3 != null && object2 != null);
                Element element4 = JbiProjectProperties.generateServiceUnitElement(this.project, document, (VisualClassPathItem)object3, (String)object2, true);
                element2.appendChild(element4);
            }
            this.bindingList = this.loadBindingComponentInfo(string);
            for (VisualClassPathItem visualClassPathItem : this.bindingList) {
                object3 = visualClassPathItem.getAsaTarget();
                if (visualClassPathItem == null || object3 == null || !visualClassPathItem.isInDeployment()) continue;
                object2 = JbiProjectProperties.generateServiceUnitElement(this.project, document, visualClassPathItem, (String)object3, false);
                element2.appendChild((Node)object2);
            }
            element.appendChild(element2);
            document.getDocumentElement().normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            object3 = new DOMSource(document);
            object2 = new StreamResult(new File(string2));
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform((Source)object3, (Result)object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fixComponentTargetList() {
        List list = (List)this.get(JBI_CONTENT_ADDITIONAL);
        List list2 = (List)this.get(JBI_CONTENT_COMPONENT);
        boolean bl = false;
        if (list.size() != list2.size()) {
            bl = true;
        } else {
            for (Object object : list2) {
                if (!((String)object).startsWith("com.sun.") && !((String)object).equals("JavaEEServiceEngine")) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            Object object;
            ArrayList arrayList = new ArrayList();
            object = new ComponentHelper(this.project);
            for (VisualClassPathItem visualClassPathItem : list) {
                String string = visualClassPathItem.getAsaType();
                String string2 = ((ComponentHelper)object).getDefaultTarget(string);
                if (string2 == null) {
                    throw new RuntimeException("Unknown component target name for asaType of \"" + string + "\".");
                }
                arrayList.add(string2);
            }
            this.put(JBI_CONTENT_COMPONENT, arrayList);
            this.store();
        }
    }

    public static String findText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    private static List librariesInDeployment(AntProjectHelper antProjectHelper) {
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-jbi/1", "included-library");
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(JbiProjectProperties.findText(element2));
        }
        return arrayList;
    }

    private static class StringListParser
    extends PropertyParser {
        private StringListParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            if (string == null || string.trim().length() < 1) {
                return new ArrayList();
            }
            String[] stringArray = string.split(";");
            return Arrays.asList(stringArray);
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            List list = (List)object;
            String string = "";
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (iterator.hasNext()) {
                    string = string + string2 + ";";
                    continue;
                }
                string = string + string2;
            }
            return string;
        }
    }

    private static class SemiColonPathParser
    extends PathParser {
        private SemiColonPathParser() {
        }

        protected String getPathSeparator() {
            return ";";
        }
    }

    private static class PathParser
    extends PropertyParser {
        private PathParser() {
        }

        protected String getPathSeparator() {
            return File.pathSeparator;
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            if (string == null || string.trim().length() < 1) {
                return new ArrayList();
            }
            EditableProperties editableProperties = antProjectHelper.getProperties(JbiProjectProperties.PROJECT);
            String string2 = string;
            if (string2 == null) {
                return new ArrayList();
            }
            String[] stringArray = string2.split(this.getPathSeparator());
            ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
            List list = JbiProjectProperties.librariesInDeployment(antProjectHelper);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                VisualClassPathItem visualClassPathItem;
                String string4 = stringArray[i];
                String string5 = JbiProjectProperties.getAntPropertyName(string4);
                boolean bl = list.contains(string5);
                int n = -1;
                for (int j = 0; j < WELL_KNOWN_PATHS.length; ++j) {
                    if (!WELL_KNOWN_PATHS[j][0].equals(string5)) continue;
                    n = j;
                    break;
                }
                if (n != -1) {
                    visualClassPathItem = new VisualClassPathItem(string4, 3, string4, WELL_KNOWN_PATHS[n][1], bl);
                } else if (string4.startsWith(JbiProjectProperties.LIBRARY_PREFIX)) {
                    String string6 = string4.substring(JbiProjectProperties.LIBRARY_PREFIX.length(), string4.lastIndexOf(46));
                    string3 = LibraryManager.getDefault().getLibrary(string6);
                    visualClassPathItem = string3 != null ? new VisualClassPathItem(string3, 1, string4, string6, bl) : null;
                } else {
                    Object[] objectArray = referenceHelper.findArtifactAndLocation(string4);
                    if (objectArray != null && objectArray.length > 0) {
                        string3 = (AntArtifact)objectArray[0];
                        String string7 = antProjectHelper.getStandardPropertyEvaluator().evaluate(string4);
                        visualClassPathItem = new VisualClassPathItem(string3, 2, string4, string7, bl);
                    } else {
                        string3 = antProjectHelper.getStandardPropertyEvaluator().evaluate(string4);
                        visualClassPathItem = new VisualClassPathItem(string4, 0, string4, string3, bl);
                    }
                }
                if (visualClassPathItem == null) continue;
                arrayList.add(visualClassPathItem);
            }
            return arrayList;
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return this.encode(object, antProjectHelper, referenceHelper, object);
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, Object object2) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            Element element = antProjectHelper.getPrimaryConfigurationData(true);
            org.w3c.dom.Document document = element.getOwnerDocument();
            NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-jbi/1", "included-library");
            for (int i = n = nodeList.getLength(); i > 0; --i) {
                Iterator iterator = nodeList.item(i - 1);
                iterator.getParentNode().removeChild((Node)((Object)iterator));
            }
            if (object != null) {
                ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
                for (VisualClassPathItem visualClassPathItem : (List)object2) {
                    if (((List)object).indexOf(visualClassPathItem) != -1) continue;
                    arrayList.add(visualClassPathItem);
                }
                for (VisualClassPathItem visualClassPathItem : arrayList) {
                    switch (visualClassPathItem.getType()) {
                        case 2: {
                            referenceHelper.destroyReference(visualClassPathItem.getRaw());
                        }
                    }
                }
            }
            String string = this.getPathSeparator();
            for (VisualClassPathItem visualClassPathItem : (List)object) {
                Object object3;
                String string2 = "";
                switch (visualClassPathItem.getType()) {
                    case 0: {
                        String string3;
                        Object object4;
                        object3 = visualClassPathItem.getRaw();
                        if (object3 == null) {
                            object4 = (File)visualClassPathItem.getObject();
                            string2 = string3 = referenceHelper.createForeignFileReference((File)object4, "jar");
                            break;
                        }
                        string2 = object3;
                        break;
                    }
                    case 1: {
                        string2 = visualClassPathItem.getRaw();
                        break;
                    }
                    case 2: {
                        String string3;
                        Object object4 = (AntArtifact)visualClassPathItem.getObject();
                        string2 = string3 = object4 == null ? visualClassPathItem.getRaw() : referenceHelper.addReference(object4, object4.getArtifactLocations()[0]);
                        break;
                    }
                    case 3: {
                        string2 = visualClassPathItem.getRaw();
                    }
                }
                stringBuffer.append(string2);
                stringBuffer.append(string);
                if (!visualClassPathItem.isInDeployment()) continue;
                object3 = document.createElementNS("http://www.netbeans.org/ns/j2ee-jbi/1", "included-library");
                object3.appendChild(document.createTextNode(JbiProjectProperties.getAntPropertyName(string2)));
                element.appendChild((Node)object3);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            antProjectHelper.putPrimaryConfigurationData(element, true);
            return stringBuffer.toString();
        }
    }

    private static class PlatformParser
    extends PropertyParser {
        private PlatformParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                String string2 = (String)javaPlatformArray[i].getProperties().get("platform.ant.name");
                if (string2 == null || !string2.equals(string)) continue;
                return javaPlatformArray[i].getDisplayName();
            }
            return JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms((String)object, new Specification("j2se", null));
            if (javaPlatformArray.length == 0) {
                return null;
            }
            return (String)javaPlatformArray[0].getProperties().get("platform.ant.name");
        }
    }

    private static class CharsetParser
    extends PropertyParser {
        private CharsetParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            if (string == null) {
                string = FileEncodingQuery.getDefaultEncoding().name();
            }
            return new Charset(string, new String[0]){

                public boolean contains(Charset charset) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public CharsetDecoder newDecoder() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public CharsetEncoder newEncoder() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return ((Charset)object).name();
        }
    }

    private static class InverseBooleanParser
    extends BooleanParser {
        private InverseBooleanParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return (Boolean)super.decode(string, antProjectHelper, referenceHelper) != false ? Boolean.FALSE : Boolean.TRUE;
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return super.encode((Boolean)object != false ? Boolean.FALSE : Boolean.TRUE, antProjectHelper, referenceHelper);
        }
    }

    private static class BooleanParser
    extends PropertyParser {
        private BooleanParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            String string2;
            if (string != null && ((string2 = string.toLowerCase()).equals("true") || string2.equals("yes") || string2.equals("enabled"))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return (Boolean)object != false ? "true" : "false";
        }
    }

    private static class StringParser
    extends PropertyParser {
        private StringParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return string;
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return (String)object;
        }
    }

    private static abstract class PropertyParser {
        private PropertyParser() {
        }

        public abstract Object decode(String var1, AntProjectHelper var2, ReferenceHelper var3);

        public abstract String encode(Object var1, AntProjectHelper var2, ReferenceHelper var3);

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, Object object2) {
            return this.encode(object, antProjectHelper, referenceHelper);
        }
    }

    private static class PropertyDescriptor {
        final PropertyParser parser;
        final String name;
        final String dest;

        PropertyDescriptor(String string, String string2, PropertyParser propertyParser) {
            this.name = string;
            this.dest = string2;
            this.parser = propertyParser;
        }
    }

    private class PropertyInfo {
        private PropertyDescriptor propertyDesciptor;
        private String rawValue;
        private String evaluatedValue;
        private Object value;
        private Object newValue;
        private String newValueEncoded;

        public PropertyInfo(PropertyDescriptor propertyDescriptor, String string, String string2) {
            this.propertyDesciptor = propertyDescriptor;
            this.rawValue = string;
            this.evaluatedValue = string2;
            this.value = propertyDescriptor.parser.decode(string, JbiProjectProperties.this.antProjectHelper, JbiProjectProperties.this.refHelper);
            this.newValue = null;
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDesciptor;
        }

        public void encode() {
            this.newValueEncoded = this.isModified() ? this.propertyDesciptor.parser.encode(this.newValue, JbiProjectProperties.this.antProjectHelper, JbiProjectProperties.this.refHelper, this.getOldValue()) : null;
        }

        public Object getValue() {
            return this.isModified() ? this.newValue : this.value;
        }

        public void setValue(Object object) {
            this.newValue = object;
        }

        public String getNewValueEncoded() {
            return this.newValueEncoded;
        }

        public boolean isModified() {
            return this.newValue != null;
        }

        public Object getOldValue() {
            return this.value;
        }
    }
}

