/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiJarCustomizer;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerGeneral
extends JPanel
implements JbiJarCustomizer.Panel,
HelpCtx.Provider {
    private JbiProjectProperties projProperties;
    private VisualPropertySupport vps;
    private JButton browseButton;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxEncoding;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelProjectName;
    private JLabel jLabelServiceAssemblyDescription;
    private JLabel jLabelServiceUnitDescription;
    private JTextField jTextFieldOsgiContainerDir;
    private JTextField jTextFieldProjectFolder;
    private JTextField jTextFieldServiceAssemblyDescription;
    private JTextField jTextFieldServiceUnitDescription;
    private JLabel osgiContainerLabel;

    public CustomizerGeneral(JbiProjectProperties jbiProjectProperties) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACS_CustomizeGeneral_A11YDesc"));
        this.projProperties = jbiProjectProperties;
        this.vps = new VisualPropertySupport(jbiProjectProperties);
    }

    public void initValues() {
        FileObject fileObject = this.projProperties.getProject().getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        this.jTextFieldProjectFolder.setText(file == null ? "" : file.getPath());
        this.vps.register(this.jTextFieldServiceAssemblyDescription, "jbi.service-assembly.description");
        this.vps.register(this.jTextFieldServiceUnitDescription, "jbi.service-unit.description");
        String string = this.projProperties.getProject().evaluator().getProperty("source.encoding");
        if (string == null) {
            string = Charset.defaultCharset().name();
        }
        this.vps.register(this.jComboBoxEncoding, new EncodingModel(string), new EncodingRenderer(), "source.encoding", Charset.class);
        this.vps.register(this.jCheckBox1, "osgi.support");
        this.vps.register(this.jTextFieldOsgiContainerDir, "osgi.container.dir");
        boolean bl = this.jCheckBox1.isSelected();
        this.osgiContainerLabel.setEnabled(bl);
        this.jTextFieldOsgiContainerDir.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    private void initComponents() {
        this.jLabelProjectName = new JLabel();
        this.jLabelServiceAssemblyDescription = new JLabel();
        this.jTextFieldServiceAssemblyDescription = new JTextField();
        this.jLabelServiceUnitDescription = new JLabel();
        this.jTextFieldServiceUnitDescription = new JTextField();
        this.jTextFieldProjectFolder = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxEncoding = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.osgiContainerLabel = new JLabel();
        this.jTextFieldOsgiContainerDir = new JTextField();
        this.browseButton = new JButton();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelProjectName.setLabelFor(this.jTextFieldProjectFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProjectName, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_CustomizeGeneral_ProjectFolder_JLabel"));
        this.jLabelServiceAssemblyDescription.setLabelFor(this.jTextFieldServiceAssemblyDescription);
        Mnemonics.setLocalizedText((JLabel)this.jLabelServiceAssemblyDescription, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_CustomizeGeneral_AssemblyUnitDescription_JLabel"));
        this.jLabelServiceUnitDescription.setLabelFor(this.jTextFieldServiceUnitDescription);
        Mnemonics.setLocalizedText((JLabel)this.jLabelServiceUnitDescription, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_CustomizeGeneral_ApplicationSubAssemblyDescription_JLabel"));
        this.jTextFieldProjectFolder.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"jLabel1");
        this.jLabel2.setLabelFor(this.jComboBoxEncoding);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"TXT_Encoding"));
        this.jComboBoxEncoding.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CustomizerGeneral.this.osgiSupportItemStateChanged(itemEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)"OSGi Platform Support:");
        Mnemonics.setLocalizedText((JLabel)this.osgiContainerLabel, (String)"OSGi Container Location:");
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)"Browse...");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerGeneral.this.browseButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelServiceUnitDescription, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelServiceAssemblyDescription, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelProjectName, -1, 164, Short.MAX_VALUE)).add((Component)this.jLabel3)).add(4, 4, 4).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.jTextFieldServiceUnitDescription, -1, 413, Short.MAX_VALUE).add(2, (Component)this.jTextFieldServiceAssemblyDescription, -1, 413, Short.MAX_VALUE).add((Component)this.jTextFieldProjectFolder, -1, 413, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jCheckBox1, -2, 30, -2).add((Component)this.jComboBoxEncoding, 0, 413, Short.MAX_VALUE))))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.osgiContainerLabel).add(48, 48, 48).add((Component)this.jTextFieldOsgiContainerDir, -1, 324, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.browseButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelProjectName, -2, 24, -2).add((Component)this.jTextFieldProjectFolder, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jTextFieldServiceAssemblyDescription, -2, -1, -2).add((Component)this.jLabelServiceAssemblyDescription)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jTextFieldServiceUnitDescription, -2, -1, -2).add((Component)this.jLabelServiceUnitDescription)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxEncoding, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jCheckBox1).add((Component)this.jLabel3)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.osgiContainerLabel).add((Component)this.browseButton).add((Component)this.jTextFieldOsgiContainerDir, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabelProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACS_PROJECT_FOLDER"));
        this.jLabelServiceAssemblyDescription.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACS_SA_DESCRIPTION"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/compapp/projects/jbi/ui/customizer/Bundle");
        this.jTextFieldServiceAssemblyDescription.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_CustomizeGeneral_AssemblyUnitDescription_A11YDesc"));
        this.jLabelServiceUnitDescription.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACS_DEFAULT_SU_DESCRIPTION"));
        this.jTextFieldServiceUnitDescription.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_CustomizeGeneral_ApplicationSubAssemblyDescription_A11YDesc"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACS_ENCODING"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(NbBundle.getMessage(CustomizerGeneral.class, (String)"CHOOSE_OSGI_CONTAINER_LOCATION_TITLE"));
        int n = jFileChooser.showDialog(this, NbBundle.getMessage(CustomizerGeneral.class, (String)"CHOOSE_OSGI_CONTAINER_LOCATION_BUTTON"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.jTextFieldOsgiContainerDir.setText(file.getAbsolutePath());
        }
    }

    private void osgiSupportItemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        this.osgiContainerLabel.setEnabled(bl);
        this.jTextFieldOsgiContainerDir.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerGeneral.class);
    }

    private static class UnknownCharset
    extends Charset {
        UnknownCharset(String string) {
            super(string, new String[0]);
        }

        public boolean contains(Charset charset) {
            throw new UnsupportedOperationException();
        }

        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EncodingModel
    extends DefaultComboBoxModel {
        public EncodingModel(String string) {
            Charset charset = null;
            for (Charset charset2 : Charset.availableCharsets().values()) {
                if (charset2.name().equals(string)) {
                    charset = charset2;
                }
                this.addElement(charset2);
            }
            if (charset == null) {
                try {
                    charset = new UnknownCharset(string);
                    this.addElement(charset);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Logger.getLogger(this.getClass().getName()).info("IllegalCharsetName: " + string);
                }
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            this.setSelectedItem(charset);
        }
    }

    private static class EncodingRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public EncodingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof Charset);
            this.setName("ComboBox.listRenderer");
            this.setText(((Charset)object).displayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

