/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.jeese.actions;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.compapp.javaee.sunresources.SunResourcesUtil;
import org.netbeans.modules.compapp.javaee.sunresources.tool.JavaEETool;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.ArchiveConstants;
import org.netbeans.modules.compapp.javaee.sunresources.ui.ResourcesPanel;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public class ServerResourcesAction
extends NodeAction {
    private String name = NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("SERVER_RES_ACTION_NAME");

    protected void performAction(Node[] nodeArray) {
        Node node = nodeArray[0];
        Lookup lookup = node.getLookup();
        JbiProject jbiProject = (JbiProject)lookup.lookup(JbiProject.class);
        VisualClassPathItem visualClassPathItem = (VisualClassPathItem)lookup.lookup(VisualClassPathItem.class);
        String string = "project." + visualClassPathItem.getProjectName();
        AntProjectHelper antProjectHelper = (AntProjectHelper)jbiProject.getLookup().lookup(AntProjectHelper.class);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        PropertyEvaluator propertyEvaluator = antProjectHelper.getStandardPropertyEvaluator();
        String string2 = propertyEvaluator.evaluate(editableProperties.getProperty(string));
        FileObject fileObject = jbiProject.getProjectDirectory();
        try {
            JavaEETool javaEETool;
            File file = new File(FileUtil.toFile((FileObject)fileObject).getCanonicalPath() + File.separator + string2);
            FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (fileObject2 == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ServerResourcesAction.class, (String)"EXC_proj_notfound", (Object)visualClassPathItem.getProjectName(), (Object)string2), 0));
                return;
            }
            Project project = ProjectManager.getDefault().findProject(fileObject2);
            if (project == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ServerResourcesAction.class, (String)"EXC_cannot_open_proj", (Object)visualClassPathItem.getProjectName()), 0));
                return;
            }
            ArchiveConstants.ArchiveType archiveType = SunResourcesUtil.getJavaEEProjectType(project);
            if (archiveType == ArchiveConstants.ArchiveType.EAR || archiveType == ArchiveConstants.ArchiveType.EJB || archiveType == ArchiveConstants.ArchiveType.WAR) {
                javaEETool = null;
                try {
                    javaEETool = new JavaEETool(archiveType, project);
                }
                catch (ProjectNotBuiltException projectNotBuiltException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ServerResourcesAction.class, (String)"EXC_proj_notbuild", (Object)projectNotBuiltException.getMessage()), 0));
                    return;
                }
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ServerResourcesAction.class, (String)"EXC_proj_notsupported", (Object)visualClassPathItem.getProjectName(), (Object)((Object)archiveType)), 0));
                return;
            }
            Dialog dialog = this.createResourcesDialog(javaEETool);
            dialog.setVisible(true);
            javaEETool.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    private Dialog createResourcesDialog(JavaEETool javaEETool) {
        JDialog jDialog = new JDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(ServerResourcesAction.class, (String)"SERVER_RES_ACTION_NAME"));
        ResourcesPanel resourcesPanel = new ResourcesPanel(jDialog, javaEETool);
        jDialog.getContentPane().add(resourcesPanel);
        jDialog.setModal(true);
        jDialog.setPreferredSize(resourcesPanel.getPreferredSize());
        int n = jDialog.getPreferredSize().width;
        int n2 = jDialog.getPreferredSize().height;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jDialog.setBounds((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
        return jDialog;
    }

    public static class ProjectNotBuiltException
    extends Exception {
        public ProjectNotBuiltException(String string) {
            super(string);
        }
    }
}

