/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.annotation.handler;

import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.compapp.javaee.annotation.handler.ClassFileLoader;

public class JarClassFileLoader
implements ClassFileLoader {
    private JarFile jf;
    private String rootClassDir;
    private Logger logger = Logger.getLogger(JarClassFileLoader.class.getName());

    public JarClassFileLoader(JarFile jarFile, String string) {
        this.jf = jarFile;
        this.rootClassDir = string;
    }

    private String getClassPath(ClassName className) {
        String string = className.getExternalName(true).replaceAll("\\.", "\\/");
        string = string + ".class";
        return string;
    }

    private String getClassPath(String string) {
        return this.getClassPath(ClassName.getClassName((String)string));
    }

    public ClassFile getClassFileFromInternalName(String string) {
        ClassFile classFile = null;
        string = this.getClassPath(string);
        try {
            JarEntry jarEntry = this.jf.getJarEntry(this.rootClassDir + string);
            classFile = new ClassFile(this.jf.getInputStream(jarEntry));
        }
        catch (IOException iOException) {
            this.logger.warning("Exception while reading class file:" + string + ":" + iOException.getMessage());
        }
        return classFile;
    }

    public ClassFile getClassFile(ClassName className) {
        ClassFile classFile = null;
        try {
            JarEntry jarEntry = this.jf.getJarEntry(this.rootClassDir + this.getClassPath(className));
            classFile = new ClassFile(this.jf.getInputStream(jarEntry));
        }
        catch (IOException iOException) {
            this.logger.warning("Exception while reading class file:" + className + ":" + iOException.getMessage());
        }
        return classFile;
    }

    public ClassFile getClassFileUsingJarEntry(JarEntry jarEntry) {
        ClassFile classFile = null;
        try {
            classFile = new ClassFile(this.jf.getInputStream(jarEntry));
        }
        catch (IOException iOException) {
            this.logger.warning("Exception while reading class file:" + jarEntry.getName() + ":" + iOException.getMessage());
        }
        return classFile;
    }
}

