/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public class CsmFileTaskFactoryManager {
    private static CsmFileTaskFactoryManager INSTANCE;
    private Lookup.Result<CsmFileTaskFactory> factories;
    public static Accessor ACCESSOR;

    public static synchronized void register() {
        if (INSTANCE == null) {
            INSTANCE = new CsmFileTaskFactoryManager();
        }
    }

    private CsmFileTaskFactoryManager() {
        final RequestProcessor.Task task = new RequestProcessor("CsmFileTaskFactoryManager Worker", 1).create(new Runnable(){

            public void run() {
                CsmFileTaskFactoryManager.this.update();
            }
        });
        this.factories = Lookup.getDefault().lookupResult(CsmFileTaskFactory.class);
        Logger.getLogger(CsmFileTaskFactoryManager.class.getName()).log(Level.FINE, "CsmFileTaskFactoryManager: " + this.factories.allInstances().size() + " factories were found.");
        this.factories.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                task.schedule(0);
            }
        });
        this.update();
    }

    private void update() {
        for (CsmFileTaskFactory csmFileTaskFactory : this.factories.allInstances()) {
            ACCESSOR.fireChangeEvent(csmFileTaskFactory);
        }
    }

    public static interface Accessor {
        public void fireChangeEvent(CsmFileTaskFactory var1);
    }
}

