/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.xref;

import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class CsmReferenceResolver {
    private static final CsmReferenceResolver DEFAULT = new Default();

    protected CsmReferenceResolver() {
    }

    public static CsmReferenceResolver getDefault() {
        return DEFAULT;
    }

    public abstract CsmReference findReference(CsmFile var1, int var2);

    public CsmReference findReference(Node node) {
        JEditorPane[] jEditorPaneArray;
        assert (node != null) : "activatedNode must be not null";
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = CsmUtilities.getOpenedPanesInEQ((EditorCookie)editorCookie)) != null && jEditorPaneArray.length > 0) {
            int n = jEditorPaneArray[0].getSelectionStart();
            CsmFile csmFile = CsmUtilities.getCsmFile((Node)node, (boolean)false);
            if (csmFile != null) {
                return this.findReference(csmFile, n);
            }
        }
        return null;
    }

    public abstract Scope fastCheckScope(CsmReference var1);

    private static final class Default
    extends CsmReferenceResolver {
        private final Lookup.Result<CsmReferenceResolver> res = Lookup.getDefault().lookupResult(CsmReferenceResolver.class);

        Default() {
        }

        public CsmReference findReference(CsmFile csmFile, int n) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                CsmReference csmReference = csmReferenceResolver.findReference(csmFile, n);
                if (csmReference == null) continue;
                return csmReference;
            }
            return null;
        }

        public CsmReference findReference(Node node) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                CsmReference csmReference = csmReferenceResolver.findReference(node);
                if (csmReference == null) continue;
                return csmReference;
            }
            return null;
        }

        public Scope fastCheckScope(CsmReference csmReference) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                Scope scope = csmReferenceResolver.fastCheckScope(csmReference);
                if (scope == Scope.UNKNOWN) continue;
                return scope;
            }
            return Scope.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        LOCAL,
        FILE_LOCAL,
        GLOBAL,
        UNKNOWN;

    }
}

