/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.syntaxerr;

import java.util.ArrayList;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class CsmErrorProvider {
    private static final boolean ENABLE = CsmErrorProvider.getBoolean("cnd.csm.errors", true);
    private static final boolean ASYNC = CsmErrorProvider.getBoolean("cnd.csm.errors.async", true);
    private static CsmErrorProvider DEFAULT = ASYNC ? new AsynchronousMerger() : new SynchronousMerger();

    public abstract void getErrors(Request var1, Response var2);

    public static final synchronized CsmErrorProvider getDefault() {
        return DEFAULT;
    }

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    private static class AsynchronousMerger
    extends BaseMerger {
        private AsynchronousMerger() {
        }

        public void getErrors(final Request request, final Response response) {
            if (ENABLE) {
                ArrayList<RequestProcessor.Task> arrayList = new ArrayList<RequestProcessor.Task>();
                for (final CsmErrorProvider csmErrorProvider : this.res.allInstances()) {
                    if (request.isCancelled()) break;
                    RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            csmErrorProvider.getErrors(request, response);
                        }
                    });
                    arrayList.add(task);
                }
                for (RequestProcessor.Task task : arrayList) {
                    task.waitFinished();
                }
            }
            response.done();
        }
    }

    private static class SynchronousMerger
    extends BaseMerger {
        private SynchronousMerger() {
        }

        public void getErrors(Request request, Response response) {
            if (ENABLE) {
                for (CsmErrorProvider csmErrorProvider : this.res.allInstances()) {
                    if (request.isCancelled()) break;
                    csmErrorProvider.getErrors(request, response);
                }
            }
            response.done();
        }
    }

    private static abstract class BaseMerger
    extends CsmErrorProvider {
        protected final Lookup.Result<CsmErrorProvider> res = Lookup.getDefault().lookupResult(CsmErrorProvider.class);
    }

    public static interface Response {
        public void addError(CsmErrorInfo var1);

        public void done();
    }

    public static interface Request {
        public CsmFile getFile();

        public boolean isCancelled();
    }
}

