/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmUsingResolver {
    private static final CsmUsingResolver EMPTY = new Empty();
    private static CsmUsingResolver defaultResolver;

    protected CsmUsingResolver() {
    }

    public static synchronized CsmUsingResolver getDefault() {
        if (defaultResolver != null) {
            return defaultResolver;
        }
        defaultResolver = (CsmUsingResolver)Lookup.getDefault().lookup(CsmUsingResolver.class);
        return defaultResolver == null ? EMPTY : defaultResolver;
    }

    public abstract Collection<CsmDeclaration> findUsedDeclarations(CsmFile var1, int var2, CsmProject var3);

    public abstract Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace var1);

    public abstract Collection<CsmNamespace> findVisibleNamespaces(CsmFile var1, int var2, CsmProject var3);

    public abstract Collection<CsmUsingDirective> findUsingDirectives(CsmNamespace var1);

    public Collection<CsmNamespace> findVisibleNamespaces(CsmNamespace csmNamespace) {
        return CsmUsingResolver.extractNamespaces(this.findUsingDirectives(csmNamespace));
    }

    public abstract Collection<CsmNamespaceAlias> findNamespaceAliases(CsmFile var1, int var2, CsmProject var3);

    public static Collection<CsmNamespace> extractNamespaces(Collection<CsmUsingDirective> collection) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        for (CsmUsingDirective csmUsingDirective : collection) {
            CsmProject csmProject;
            CsmFile csmFile;
            CsmNamespace csmNamespace = csmUsingDirective.getReferencedNamespace();
            if (csmNamespace == null || (csmFile = csmUsingDirective.getContainingFile()) == null || (csmProject = csmFile.getProject()) == null) continue;
            arrayList.addAll(CsmUsingResolver.findNamespacesInProject(csmProject, csmNamespace.getQualifiedName()));
        }
        return arrayList;
    }

    private static Collection<CsmNamespace> findNamespacesInProject(CsmProject csmProject, CharSequence charSequence) {
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        CsmNamespace csmNamespace = csmProject.findNamespace(charSequence);
        if (csmNamespace != null) {
            arrayList.add(csmNamespace);
        }
        hashSet.add(csmProject);
        arrayList.addAll(CsmUsingResolver.findNamespacesInProjects(csmProject.getLibraries(), charSequence, hashSet));
        return arrayList;
    }

    private static Collection<CsmNamespace> findNamespacesInProjects(Collection<CsmProject> collection, CharSequence charSequence, HashSet<CsmProject> hashSet) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        for (CsmProject csmProject : collection) {
            if (hashSet.contains(csmProject)) continue;
            CsmNamespace csmNamespace = csmProject.findNamespace(charSequence);
            if (csmNamespace != null) {
                arrayList.add(csmNamespace);
            }
            hashSet.add(csmProject);
            arrayList.addAll(CsmUsingResolver.findNamespacesInProjects(csmProject.getLibraries(), charSequence, hashSet));
        }
        return arrayList;
    }

    public static Collection<CsmDeclaration> extractDeclarations(Collection<CsmUsingDeclaration> collection) {
        LinkedHashMap<String, CsmDeclaration> linkedHashMap = new LinkedHashMap<String, CsmDeclaration>(collection.size());
        for (CsmUsingDeclaration csmUsingDeclaration : collection) {
            CsmDeclaration csmDeclaration = csmUsingDeclaration.getReferencedDeclaration();
            if (csmDeclaration == null) continue;
            String string = ((Object)csmUsingDeclaration.getName()).toString();
            linkedHashMap.remove(string);
            linkedHashMap.put(string, csmDeclaration);
        }
        return new ArrayList<CsmDeclaration>(linkedHashMap.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Empty
    extends CsmUsingResolver {
        Empty() {
        }

        @Override
        public Collection<CsmDeclaration> findUsedDeclarations(CsmFile csmFile, int n, CsmProject csmProject) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace csmNamespace) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmUsingDirective> findUsingDirectives(CsmNamespace csmNamespace) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespace> findVisibleNamespaces(CsmFile csmFile, int n, CsmProject csmProject) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmFile csmFile, int n, CsmProject csmProject) {
            return Collections.emptyList();
        }
    }
}

