/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.favorites.Actions;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Favorites
extends FilterNode
implements Index {
    private static Node node;
    private static Node root;

    private Favorites(Node node) {
        super(node, (Children)new Chldrn(node, false));
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return null;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz == Index.class) {
            return (T)((Node.Cookie)clazz.cast((Object)this));
        }
        return (T)super.getCookie(clazz);
    }

    public int getNodesCount() {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            return index.getNodesCount();
        }
        return 0;
    }

    public Node[] getNodes() {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            return index.getNodes();
        }
        return new Node[0];
    }

    public int indexOf(Node node) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            if (node instanceof ProjectFilterNode) {
                ProjectFilterNode projectFilterNode = (ProjectFilterNode)node;
                int n = index.indexOf(projectFilterNode.getOriginal());
                return n;
            }
            int n = index.indexOf(node);
            return n;
        }
        return -1;
    }

    public void reorder() {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.reorder();
        }
    }

    public void reorder(int[] nArray) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.reorder(nArray);
        }
    }

    public void move(int n, int n2) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.move(n, n2);
        }
    }

    public void exchange(int n, int n2) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.exchange(n, n2);
        }
    }

    public void moveUp(int n) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.moveUp(n);
        }
    }

    public void moveDown(int n) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.moveDown(n);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.addChangeListener(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.removeChangeListener(changeListener);
        }
    }

    public Image getIcon(int n) {
        return Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionSelect.png");
    }

    public Image getOpenedIcon(int n) {
        return Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionSelect.png");
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public static DataFolder getFolder() {
        try {
            FileObject fileObject = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)"Favorites");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            return dataFolder;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
        }
    }

    public static synchronized Node getNode() {
        if (node == null) {
            node = new Favorites(Favorites.getFolder().getNodeDelegate());
        }
        return node;
    }

    public static URL getHome() throws FileStateInvalidException, MalformedURLException {
        String string = System.getProperty("user.home");
        File file = new File(string);
        file = FileUtil.normalizeFile((File)file);
        return file.toURI().toURL();
    }

    static File fileForNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
    }

    public Node.Handle getHandle() {
        return new RootHandle();
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{Actions.addOnFavoritesNode()};
    }

    private static class ProjectFilterNode
    extends FilterNode {
        public ProjectFilterNode(Node node, Children children) {
            super(node, children);
        }

        public String getDisplayName() {
            if (Favorites.getNode().equals((Object)this.getParentNode())) {
                DataShadow dataShadow = (DataShadow)this.getCookie(DataShadow.class);
                if (dataShadow != null) {
                    String string = dataShadow.getName();
                    String string2 = FileUtil.getFileDisplayName((FileObject)dataShadow.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(Favorites.class, (String)"CTL_DisplayNameTemplate", (Object)string, (Object)string2);
                }
                return super.getDisplayName();
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            return this.getOriginal().getHtmlDisplayName();
        }

        protected Node getOriginal() {
            return super.getOriginal();
        }

        public boolean canDestroy() {
            boolean bl = super.canDestroy();
            DataShadow dataShadow = (DataShadow)this.getCookie(DataShadow.class);
            if (bl && this.isDeleteOriginal(dataShadow)) {
                bl = dataShadow.getOriginal().isDeleteAllowed();
            }
            return bl;
        }

        public void destroy() throws IOException {
            if (this.canDestroy()) {
                DataShadow dataShadow = (DataShadow)this.getCookie(DataShadow.class);
                DataObject dataObject = this.isDeleteOriginal(dataShadow) ? dataShadow.getOriginal() : null;
                super.destroy();
                if (dataObject != null) {
                    dataObject.delete();
                }
            }
        }

        private boolean isDeleteOriginal(DataShadow dataShadow) {
            return false;
        }

        public Action[] getActions(boolean bl) {
            File file;
            FileObject fileObject;
            Action[] actionArray = super.getActions(bl);
            boolean bl2 = false;
            DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
            if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)fileObject)) != null && file.getParent() == null) {
                bl2 = true;
            }
            if (bl2) {
                return this.createActionsForRoot(actionArray);
            }
            if (Favorites.getNode().equals((Object)this.getParentNode())) {
                fileObject = (DataShadow)this.getCookie(DataShadow.class);
                if (fileObject != null) {
                    if (fileObject.getOriginal().getPrimaryFile().isFolder()) {
                        return this.createActionsForFavoriteFolder(actionArray);
                    }
                    return this.createActionsForFavoriteFile(actionArray);
                }
            } else {
                fileObject = (DataObject)this.getCookie(DataObject.class);
                if (fileObject != null) {
                    if (fileObject.getPrimaryFile().isFolder()) {
                        return this.createActionsForFolder(actionArray);
                    }
                    return this.createActionsForFile(actionArray);
                }
            }
            return actionArray;
        }

        private Action[] createActionsForRoot(Action[] actionArray) {
            return actionArray;
        }

        private Action[] createActionsForFavoriteFolder(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.remove());
                    arrayList.add(null);
                }
                if (actionArray[i] instanceof DeleteAction) continue;
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.remove());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFavoriteFile(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.remove());
                    arrayList.add(null);
                }
                if (actionArray[i] instanceof DeleteAction) continue;
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.remove());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFolder(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.add());
                    arrayList.add(null);
                }
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.add());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFile(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.add());
                    arrayList.add(null);
                }
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.add());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }

    private static class Chldrn
    extends FilterNode.Children
    implements ChangeListener,
    Runnable {
        private ChangeListener weak;
        private boolean hideHidden;

        public Chldrn(Node node, boolean bl) {
            super(node);
            this.hideHidden = bl;
            this.weak = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
            VisibilityQuery.getDefault().addChangeListener(this.weak);
        }

        protected Node[] createNodes(Node node) {
            DataObject dataObject;
            if (this.hideHidden && (dataObject = (DataObject)node.getCookie(DataObject.class)) != null && !VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile())) {
                return null;
            }
            return new Node[]{new ProjectFilterNode(node, (Children)(node.isLeaf() ? Children.LEAF : new Chldrn(node, true)))};
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MUTEX.postWriteRequest((Runnable)this);
        }

        public void run() {
            Node[] nodeArray = this.original.getChildren().getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                this.refreshKey(nodeArray[i]);
            }
        }
    }

    private static class RootHandle
    implements Node.Handle {
        static final long serialVersionUID = 1907300072945111595L;

        private RootHandle() {
        }

        public Node getNode() {
            return Favorites.getNode();
        }
    }
}

