/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CppStringTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppStringLexer
implements Lexer<CppStringTokenId> {
    private static final int INIT = 0;
    private static final int OTHER = 1;
    private static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<CppStringTokenId> tokenFactory;
    private boolean escapedLF = false;
    private final boolean dblQuoted;
    private int state = 0;

    public CppStringLexer(LexerRestartInfo<CppStringTokenId> lexerRestartInfo, boolean bl) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        this.dblQuoted = bl;
        Integer n = (Integer)lexerRestartInfo.state();
        this.fromState(n);
    }

    public Object state() {
        return this.state;
    }

    private void fromState(Integer n) {
        this.state = n == null ? 0 : n;
    }

    public Token<CppStringTokenId> nextToken() {
        int n = this.state;
        this.state = 1;
        while (true) {
            int n2 = this.read();
            switch (n2) {
                case 76: {
                    if (n != 0) break;
                    return this.token(CppStringTokenId.PREFIX);
                }
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return null;
                }
                case 39: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return this.token(CppStringTokenId.SINGLE_QUOTE);
                }
                case 34: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return this.token(CppStringTokenId.DOUBLE_QUOTE);
                }
                case 92: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    n2 = this.read();
                    switch (n2) {
                        case 98: {
                            return this.token(CppStringTokenId.BACKSPACE);
                        }
                        case 101: {
                            return this.token(CppStringTokenId.ANSI_COLOR);
                        }
                        case 102: {
                            return this.token(CppStringTokenId.FORM_FEED);
                        }
                        case 110: {
                            return this.token(CppStringTokenId.NEWLINE);
                        }
                        case 114: {
                            return this.token(CppStringTokenId.CR);
                        }
                        case 116: {
                            return this.token(CppStringTokenId.TAB);
                        }
                        case 39: {
                            return this.token(CppStringTokenId.SINGLE_QUOTE_ESCAPE);
                        }
                        case 34: {
                            return this.token(CppStringTokenId.DOUBLE_QUOTE_ESCAPE);
                        }
                        case 92: {
                            return this.token(CppStringTokenId.BACKSLASH_ESCAPE);
                        }
                        case 117: {
                            while (117 == (n2 = this.read())) {
                            }
                            int n3 = 0;
                            while (true) {
                                if (!((n2 = Character.toLowerCase(n2)) >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102)) {
                                    this.input.backup(1);
                                    return this.token(CppStringTokenId.UNICODE_ESCAPE_INVALID);
                                }
                                if (n3 == 3) {
                                    return this.token(CppStringTokenId.UNICODE_ESCAPE);
                                }
                                n2 = this.read();
                                ++n3;
                            }
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            switch (this.read()) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    switch (this.read()) {
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: {
                                            return this.token(CppStringTokenId.OCTAL_ESCAPE);
                                        }
                                    }
                                    this.input.backup(1);
                                    return this.token(CppStringTokenId.OCTAL_ESCAPE);
                                }
                            }
                            this.input.backup(1);
                            return this.token(CppStringTokenId.OCTAL_ESCAPE);
                        }
                    }
                    this.input.backup(1);
                    return this.token(CppStringTokenId.ESCAPE_SEQUENCE_INVALID);
                }
            }
        }
    }

    protected final Token<CppStringTokenId> token(CppStringTokenId cppStringTokenId) {
        return this.token(cppStringTokenId, cppStringTokenId.fixedText(), PartType.COMPLETE);
    }

    private Token<CppStringTokenId> token(CppStringTokenId cppStringTokenId, String string, PartType partType) {
        assert (cppStringTokenId != null) : "id must be not null";
        Token token = null;
        token = string != null && !this.escapedLF ? this.tokenFactory.getFlyweightToken((TokenId)cppStringTokenId, string) : (partType != PartType.COMPLETE ? this.tokenFactory.createToken((TokenId)cppStringTokenId, this.input.readLength(), partType) : this.tokenFactory.createToken((TokenId)cppStringTokenId));
        this.escapedLF = false;
        assert (token != null) : "token must be created as result for " + (Object)((Object)cppStringTokenId);
        return token;
    }

    protected final int read() {
        boolean bl = true;
        int n = this.input.read();
        if (bl) {
            while (n == 92) {
                int n2 = this.input.read();
                switch (n2) {
                    case 13: {
                        this.input.consumeNewline();
                    }
                    case 10: {
                        this.escapedLF = true;
                        n2 = this.input.read();
                        break;
                    }
                    default: {
                        this.input.backup(1);
                        assert (n == 92) : "must be backslash " + (char)n;
                        return n;
                    }
                }
                n = n2;
            }
        }
        return n;
    }

    public void release() {
    }
}

