/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CndLexerUtilities {
    public static String C_MIME_TYPE = "text/x-c";
    public static String CPLUSPLUS_MIME_TYPE = "text/x-c++";
    public static String PREPROC_MIME_TYPE = "text/x-cpp-preprocessor";
    public static String LEXER_FILTER = "lexer-filter";
    private static Filter<CppTokenId> FILTER_STD_C;
    private static Filter<CppTokenId> FILTER_GCC_C;
    private static Filter<CppTokenId> FILTER_STD_CPP;
    private static Filter<CppTokenId> FILTER_GCC_CPP;
    private static Filter<CppTokenId> FILTER_PREPRPOCESSOR;

    private CndLexerUtilities() {
    }

    public static TokenSequence<CppTokenId> getCppTokenSequence(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        return CndLexerUtilities.getCppTokenSequence(document, n);
    }

    public static Language<CppTokenId> getLanguage(String string) {
        if (C_MIME_TYPE.equals(string)) {
            return CppTokenId.languageC();
        }
        if (CPLUSPLUS_MIME_TYPE.equals(string)) {
            return CppTokenId.languageCpp();
        }
        return null;
    }

    public static Language<CppTokenId> getLanguage(Document document) {
        Language<CppTokenId> language = (Language<CppTokenId>)document.getProperty(Language.class);
        if (language == null || language != CppTokenId.languageC() && language != CppTokenId.languageCpp()) {
            language = CndLexerUtilities.getLanguage((String)document.getProperty("mimeType"));
        }
        Language<CppTokenId> language2 = language;
        return language2;
    }

    public static TokenSequence<CppTokenId> getCppTokenSequence(Document document, int n) {
        TokenHierarchy tokenHierarchy = document != null ? TokenHierarchy.get((Document)document) : null;
        TokenSequence<CppTokenId> tokenSequence = tokenHierarchy != null ? CndLexerUtilities.getCppTokenSequence(tokenHierarchy, n) : null;
        return tokenSequence;
    }

    public static TokenSequence<CppTokenId> getCppTokenSequence(TokenHierarchy tokenHierarchy, int n) {
        if (tokenHierarchy != null) {
            for (TokenSequence tokenSequence = tokenHierarchy.tokenSequence(); tokenSequence != null && (n == 0 || tokenSequence.moveNext()); tokenSequence = tokenSequence.embedded()) {
                tokenSequence.move(n);
                if (tokenSequence.language() == CppTokenId.languageC() || tokenSequence.language() == CppTokenId.languageCpp() || tokenSequence.language() == CppTokenId.languagePreproc()) {
                    return tokenSequence;
                }
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) continue;
                return null;
            }
        }
        return null;
    }

    public static boolean isCppIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isCppIdentifierStart(int n) {
        return Character.isJavaIdentifierStart(n);
    }

    public static boolean isCppIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isCppIdentifierPart(int n) {
        return Character.isJavaIdentifierPart(n);
    }

    public static CharSequence removeEscapedLF(CharSequence charSequence, boolean bl) {
        if (!bl) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = charSequence.length() - 1;
        for (int i = 0; i <= n; ++i) {
            char c = charSequence.charAt(i);
            boolean bl2 = true;
            if (c == '\\') {
                if (i < n && charSequence.charAt(i + 1) == '\r') {
                    ++i;
                    bl2 = false;
                }
                if (i < n && charSequence.charAt(i + 1) == '\n') {
                    ++i;
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isType(String string) {
        block4: {
            try {
                if (string.contains(" ")) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(" ")) {
                        if (!CndLexerUtilities.isType(string2)) continue;
                        return true;
                    }
                    break block4;
                }
                CppTokenId cppTokenId = CppTokenId.valueOf(string.toUpperCase());
                return CndLexerUtilities.isType(cppTokenId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isType(CppTokenId cppTokenId) {
        switch (cppTokenId) {
            case AUTO: 
            case BOOL: 
            case CHAR: 
            case DOUBLE: 
            case ENUM: 
            case EXPORT: 
            case FLOAT: 
            case INLINE: 
            case _INLINE: 
            case __INLINE: 
            case __INLINE__: 
            case INT: 
            case LONG: 
            case MUTABLE: 
            case REGISTER: 
            case SHORT: 
            case SIGNED: 
            case __SIGNED: 
            case __SIGNED__: 
            case SIZEOF: 
            case TYPEDEF: 
            case TYPEID: 
            case TYPENAME: 
            case TYPEOF: 
            case __TYPEOF: 
            case __TYPEOF__: 
            case UNSIGNED: 
            case __UNSIGNED__: 
            case VOID: 
            case WCHAR_T: 
            case _BOOL: 
            case _COMPLEX: 
            case __COMPLEX__: 
            case _IMAGINARY: 
            case __IMAG__: 
            case _INT64: 
            case __INT64: 
            case __REAL__: 
            case __W64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSeparatorOrOperator(CppTokenId cppTokenId) {
        String string = cppTokenId.primaryCategory();
        return "operator".equals(string) || "separator".equals(string);
    }

    public static Filter<CppTokenId> getDefatultFilter(boolean bl) {
        return bl ? CndLexerUtilities.getStdCppFilter() : CndLexerUtilities.getStdCFilter();
    }

    public static synchronized Filter<CppTokenId> getPreprocFilter() {
        if (FILTER_PREPRPOCESSOR == null) {
            FILTER_PREPRPOCESSOR = new Filter();
            CndLexerUtilities.addPreprocKeywords(FILTER_PREPRPOCESSOR);
        }
        return FILTER_PREPRPOCESSOR;
    }

    public static synchronized Filter<CppTokenId> getStdCFilter() {
        if (FILTER_STD_C == null) {
            FILTER_STD_C = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_STD_C);
            CndLexerUtilities.addCOnlyKeywords(FILTER_STD_C);
        }
        return FILTER_STD_C;
    }

    public static synchronized Filter<CppTokenId> getGccCFilter() {
        if (FILTER_GCC_C == null) {
            FILTER_GCC_C = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_GCC_C);
            CndLexerUtilities.addCOnlyKeywords(FILTER_GCC_C);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_GCC_C);
        }
        return FILTER_GCC_C;
    }

    public static synchronized Filter<CppTokenId> getStdCppFilter() {
        if (FILTER_STD_CPP == null) {
            FILTER_STD_CPP = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_STD_CPP);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_STD_CPP);
        }
        return FILTER_STD_CPP;
    }

    public static synchronized Filter<CppTokenId> getGccCppFilter() {
        if (FILTER_GCC_CPP == null) {
            FILTER_GCC_CPP = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addGccOnlyCppOnlyKeywords(FILTER_GCC_CPP);
        }
        return FILTER_GCC_CPP;
    }

    private static void addPreprocKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.PREPROCESSOR_IF, CppTokenId.PREPROCESSOR_IFDEF, CppTokenId.PREPROCESSOR_IFNDEF, CppTokenId.PREPROCESSOR_ELSE, CppTokenId.PREPROCESSOR_ELIF, CppTokenId.PREPROCESSOR_ENDIF, CppTokenId.PREPROCESSOR_DEFINE, CppTokenId.PREPROCESSOR_UNDEF, CppTokenId.PREPROCESSOR_INCLUDE, CppTokenId.PREPROCESSOR_INCLUDE_NEXT, CppTokenId.PREPROCESSOR_LINE, CppTokenId.PREPROCESSOR_IDENT, CppTokenId.PREPROCESSOR_PRAGMA, CppTokenId.PREPROCESSOR_WARNING, CppTokenId.PREPROCESSOR_ERROR};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addCommonCCKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.AUTO, CppTokenId.BREAK, CppTokenId.CASE, CppTokenId.CHAR, CppTokenId.CONST, CppTokenId.CONTINUE, CppTokenId.DEFAULT, CppTokenId.DO, CppTokenId.DOUBLE, CppTokenId.ELSE, CppTokenId.ENUM, CppTokenId.EXTERN, CppTokenId.FLOAT, CppTokenId.FOR, CppTokenId.GOTO, CppTokenId.IF, CppTokenId.INT, CppTokenId.LONG, CppTokenId.REGISTER, CppTokenId.RETURN, CppTokenId.SHORT, CppTokenId.SIGNED, CppTokenId.SIZEOF, CppTokenId.STATIC, CppTokenId.STRUCT, CppTokenId.SWITCH, CppTokenId.TYPEDEF, CppTokenId.UNION, CppTokenId.UNSIGNED, CppTokenId.VOID, CppTokenId.VOLATILE, CppTokenId.WHILE};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addCppOnlyKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.ASM, CppTokenId.BOOL, CppTokenId.CATCH, CppTokenId.CLASS, CppTokenId.CONST_CAST, CppTokenId.DELETE, CppTokenId.DYNAMIC_CAST, CppTokenId.EXPLICIT, CppTokenId.EXPORT, CppTokenId.FINALLY, CppTokenId.FRIEND, CppTokenId.INLINE, CppTokenId.MUTABLE, CppTokenId.NAMESPACE, CppTokenId.NEW, CppTokenId.OPERATOR, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.PUBLIC, CppTokenId.REINTERPRET_CAST, CppTokenId.STATIC_CAST, CppTokenId.TEMPLATE, CppTokenId.THIS, CppTokenId.THROW, CppTokenId.TRY, CppTokenId.TYPEID, CppTokenId.TYPENAME, CppTokenId.TYPEOF, CppTokenId.USING, CppTokenId.VIRTUAL, CppTokenId.WCHAR_T, CppTokenId.TRUE, CppTokenId.FALSE};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addCOnlyKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.INLINE, CppTokenId.RESTRICT, CppTokenId._BOOL, CppTokenId._COMPLEX, CppTokenId._IMAGINARY};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addGccOnlyCommonCCKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.ASM, CppTokenId.__ALIGNOF__, CppTokenId.__ASM, CppTokenId.__ASM__, CppTokenId.__ATTRIBUTE__, CppTokenId.__COMPLEX__, CppTokenId.__CONST, CppTokenId.__CONST__, CppTokenId.__IMAG__, CppTokenId.INLINE, CppTokenId.__INLINE, CppTokenId.__REAL__, CppTokenId.__RESTRICT, CppTokenId.__SIGNED, CppTokenId.__SIGNED__, CppTokenId.TYPEOF, CppTokenId.__TYPEOF, CppTokenId.__TYPEOF__, CppTokenId.__VOLATILE, CppTokenId.__VOLATILE__, CppTokenId.__UNUSED__};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addGccOnlyCppOnlyKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.ALIGNOF, CppTokenId._ASM, CppTokenId._INLINE, CppTokenId.PASCAL, CppTokenId._PASCAL, CppTokenId.__PASCAL, CppTokenId.__UNSIGNED__, CppTokenId._CDECL, CppTokenId.__CDECL, CppTokenId._DECLSPEC, CppTokenId.__DECLSPEC, CppTokenId.__EXTENSION__, CppTokenId._FAR, CppTokenId.__FAR, CppTokenId._INT64, CppTokenId.__INT64, CppTokenId.__INTERRUPT, CppTokenId._NEAR, CppTokenId.__NEAR, CppTokenId._STDCALL, CppTokenId.__STDCALL, CppTokenId.__W64};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addToFilter(CppTokenId[] cppTokenIdArray, Filter<CppTokenId> filter) {
        for (CppTokenId cppTokenId : cppTokenIdArray) {
            assert (cppTokenId.fixedText() != null) : "id " + (Object)((Object)cppTokenId) + " must have fixed text";
            filter.addMatch(cppTokenId.fixedText(), cppTokenId);
        }
    }
}

