/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.OffsetCondition;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeContainerSupport;

public class TimeContainerRootSupport
extends TimeContainerSupport {
    protected long beginWallClockTime = -1L;
    protected Time lastSampleTime = Time.UNRESOLVED;
    protected boolean seekingBack;

    TimeContainerRootSupport() {
        this.timeContainer = this;
        new OffsetCondition(this, true, 0L);
    }

    protected void setTimeContainer(TimeContainerSupport timeContainer) {
        throw new IllegalArgumentException();
    }

    TimeContainerRootSupport getRootContainer() {
        return this;
    }

    long toWallClockTime(long localTime) {
        return this.beginWallClockTime + localTime;
    }

    void dispatchBeginEvent(Time beginTime) {
        super.dispatchBeginEvent(beginTime);
        this.beginWallClockTime = System.currentTimeMillis();
        this.beginWallClockTime -= beginTime.value;
    }

    Time getContainerSimpleDuration() {
        return Time.INDEFINITE;
    }

    Time toRootContainerSimpleTime(Time simpleTime) {
        return simpleTime;
    }

    Time toRootContainerSimpleTimeClamp(Time simpleTime) {
        return simpleTime;
    }

    Time toContainerSimpleTime(Time rootSimpleTime) {
        return rootSimpleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void seekTo(Time seekToTime) {
        if (!seekToTime.isResolved()) {
            throw new IllegalStateException();
        }
        this.seeking = true;
        this.seekingBack = !seekToTime.greaterThan(this.lastSampleTime);
        try {
            this.sample(seekToTime);
        }
        finally {
            this.seeking = false;
        }
    }

    void sample(Time currentTime) {
        super.sample(currentTime);
        this.lastSampleTime = currentTime;
    }
}

