/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.editor.lib.ColoringMap;
import org.netbeans.modules.editor.lib.KitsTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsUtil {
    public static final String TOKEN_COLORING_INITIALIZER_NAME_SUFFIX = "token-coloring-initializer";
    public static final PrintColoringEvaluator defaultPrintColoringEvaluator = new PrintColoringEvaluator();
    private static final float defaultPrintFontSize = 10.0f;

    public static List getClonedList(List list) {
        return list != null ? new ArrayList(list) : new ArrayList();
    }

    public static List getClonedList(Class clazz, String string) {
        return SettingsUtil.getClonedList((List)Settings.getValue(clazz, string));
    }

    public static List getClonedList(Map map, String string) {
        if (map != null) {
            return SettingsUtil.getClonedList((List)map.get(string));
        }
        return null;
    }

    public static Map getClonedMap(Map map) {
        return map != null ? new HashMap(map) : new HashMap();
    }

    public static Map getClonedMap(Class clazz, String string) {
        return SettingsUtil.getClonedMap((Map)Settings.getValue(clazz, string));
    }

    public static Map getClonedMap(Map map, String string) {
        if (map != null) {
            return SettingsUtil.getClonedMap((Map)map.get(string));
        }
        return null;
    }

    public static Object getValue(Class clazz, String string, Object object) {
        Object object2 = Settings.getValue(clazz, string);
        return object2 != null ? object2 : object;
    }

    public static int getInteger(Class clazz, String string, int n) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof Integer ? (Integer)object : n;
    }

    public static int getInteger(Class clazz, String string, Integer n) {
        return SettingsUtil.getInteger(clazz, string, (int)n);
    }

    public static int getPositiveInteger(Class clazz, String string, int n) {
        int n2 = SettingsUtil.getInteger(clazz, string, n);
        if (n2 <= 0) {
            n2 = n;
        }
        return n2;
    }

    public static int getPositiveInteger(Class clazz, String string, Integer n) {
        return SettingsUtil.getPositiveInteger(clazz, string, (int)n);
    }

    public static int getNonNegativeInteger(Class clazz, String string, int n) {
        int n2 = SettingsUtil.getInteger(clazz, string, n);
        if (n2 < 0) {
            n2 = n;
        }
        return n2;
    }

    public static int getNonNegativeInteger(Class clazz, String string, Integer n) {
        return SettingsUtil.getNonNegativeInteger(clazz, string, (int)n);
    }

    public static boolean getBoolean(Class clazz, String string, boolean bl) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof Boolean ? (Boolean)object : bl;
    }

    public static boolean getBoolean(Class clazz, String string, Boolean bl) {
        return SettingsUtil.getBoolean(clazz, string, (boolean)bl);
    }

    public static String getString(Class clazz, String string, String string2) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof String ? (String)object : string2;
    }

    public static Acceptor getAcceptor(Class clazz, String string, Acceptor acceptor) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof Acceptor ? (Acceptor)object : acceptor;
    }

    public static List getList(Class clazz, String string, List list) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof List ? (List)object : list;
    }

    public static List getCumulativeList(Class clazz, String string, List list) {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(clazz, string);
        if (kitAndValueArray != null && kitAndValueArray.length > 0) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < kitAndValueArray.length; ++i) {
                if (!(kitAndValueArray[i].value instanceof List)) continue;
                arrayList.addAll((List)kitAndValueArray[i].value);
            }
            return arrayList;
        }
        return list;
    }

    public static Map getMap(Class clazz, String string, Map map) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof Map ? (Map)object : map;
    }

    public static void updateListSetting(Class clazz, String string, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            List list = SettingsUtil.getClonedList(clazz, string);
            list.addAll(Arrays.asList(objectArray));
            Settings.setValue(clazz, string, list);
        }
    }

    public static void updateListSetting(Map map, String string, Object[] objectArray) {
        if (map != null && objectArray != null && objectArray.length > 0) {
            List list = SettingsUtil.getClonedList(map, string);
            list.addAll(Arrays.asList(objectArray));
            map.put(string, list);
        }
    }

    private static String getColoringSettingName(String string, boolean bl) {
        return (string + (bl ? "-print-coloring" : "-coloring")).intern();
    }

    public static Coloring getColoring(Class clazz, String string, boolean bl) {
        return (Coloring)SettingsUtil.getColoring(clazz, string, bl, true);
    }

    public static Object getColoring(Class clazz, String string, boolean bl, boolean bl2) {
        return Settings.getValue(clazz, SettingsUtil.getColoringSettingName(string, bl), bl2);
    }

    public static Coloring getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenCategory, boolean bl) {
        return (Coloring)SettingsUtil.getTokenColoring(tokenContextPath, tokenCategory, bl, true);
    }

    public static Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenCategory, boolean bl, boolean bl2) {
        return SettingsUtil.getColoring(BaseKit.class, tokenContextPath.getFullTokenName(tokenCategory), bl, bl2);
    }

    public static Object getColoring(Map map, String string, boolean bl) {
        return map.get(SettingsUtil.getColoringSettingName(string, bl));
    }

    public static void setColoring(Class clazz, String string, Object object, boolean bl) {
    }

    public static void setColoring(Class clazz, String string, Object object) {
        SettingsUtil.setColoring(clazz, string, object, false);
    }

    public static void setColoring(Class clazz, String string, Object object, Object object2) {
        SettingsUtil.setColoring(clazz, string, object, false);
    }

    public static void setColoring(Map map, String string, Object object, boolean bl) {
        map.put(SettingsUtil.getColoringSettingName(string, bl), object);
    }

    public static void setColoring(Map map, String string, Object object) {
        SettingsUtil.setColoring(map, string, object, false);
    }

    public static void setColoring(Map map, String string, Object object, Object object2) {
        SettingsUtil.setColoring(map, string, object, false);
    }

    public static Map<String, Coloring> getColoringMap(Class clazz, boolean bl, boolean bl2) {
        String string = KitsTracker.getInstance().findMimeType(clazz);
        Map map = ColoringMap.get((String)string).getMap();
        return new HashMap<String, Coloring>(map);
    }

    public static void setColoringMap(Class clazz, Map map, boolean bl) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public static Settings.Initializer getColoringMapInitializer(Class clazz, Map map, boolean bl, String string) {
        return new ColoringMapInitializer(clazz, map, bl, string);
    }

    static class ColoringMapInitializer
    extends Settings.AbstractInitializer {
        private Class kitClass;
        private HashMap baseKitMap;
        private HashMap kitClassMap;

        ColoringMapInitializer(Class clazz, Map map, boolean bl, String string) {
            super(string);
            this.kitClass = clazz;
            this.baseKitMap = new HashMap(31);
            this.kitClassMap = new HashMap(37);
            List list = SettingsUtil.getCumulativeList(clazz, "coloring-name-list", null);
            if (list != null && map != null && map.size() > 0) {
                HashSet hashSet = new HashSet(list);
                for (String string2 : map.keySet()) {
                    Object v = map.get(string2);
                    if (hashSet.contains(string2)) {
                        SettingsUtil.setColoring((Map)this.kitClassMap, string2, v, bl);
                        continue;
                    }
                    SettingsUtil.setColoring((Map)this.baseKitMap, string2, v, bl);
                }
            }
        }

        public void updateSettingsMap(Class clazz, Map map) {
            if (clazz == BaseKit.class) {
                map.putAll(this.baseKitMap);
            } else if (clazz == this.kitClass) {
                map.putAll(this.kitClassMap);
            }
        }
    }

    public static abstract class TokenColoringInitializer
    extends Settings.AbstractInitializer {
        private TokenContext tokenContext;

        public TokenColoringInitializer(TokenContext tokenContext) {
            this(tokenContext, tokenContext.getNamePrefix() + SettingsUtil.TOKEN_COLORING_INITIALIZER_NAME_SUFFIX);
        }

        public TokenColoringInitializer(TokenContext tokenContext, String string) {
            super(string);
            this.tokenContext = tokenContext;
        }

        public void updateSettingsMap(Class clazz, Map map) {
            if (clazz == BaseKit.class) {
                TokenContextPath[] tokenContextPathArray = this.tokenContext.getAllContextPaths();
                for (int i = 0; i < tokenContextPathArray.length; ++i) {
                    TokenContextPath tokenContextPath = tokenContextPathArray[i];
                    boolean bl = false;
                    do {
                        Object object;
                        TokenContext tokenContext = tokenContextPath.getContexts()[0];
                        TokenCategory[] tokenCategoryArray = tokenContext.getTokenCategories();
                        for (int j = 0; j < tokenCategoryArray.length; ++j) {
                            Object object2 = this.getTokenColoring(tokenContextPath, tokenCategoryArray[j], bl);
                            if (object2 == null) continue;
                            object = tokenContextPath.getFullTokenName(tokenCategoryArray[j]);
                            SettingsUtil.setColoring(map, (String)object, object2, bl);
                        }
                        TokenID[] tokenIDArray = tokenContext.getTokenIDs();
                        for (int j = 0; j < tokenIDArray.length; ++j) {
                            object = this.getTokenColoring(tokenContextPath, (TokenCategory)tokenIDArray[j], bl);
                            if (object == null) continue;
                            String string = tokenContextPath.getFullTokenName((TokenCategory)tokenIDArray[j]);
                            SettingsUtil.setColoring(map, string, object, bl);
                        }
                    } while (bl = !bl);
                }
            }
        }

        public abstract Object getTokenColoring(TokenContextPath var1, TokenCategory var2, boolean var3);
    }

    public static class TokenColoringEvaluator
    implements Settings.Evaluator,
    Serializable {
        private String parentFullTokenIDName;
        private Coloring coloring;
        private boolean printingSet;

        public TokenColoringEvaluator(TokenContextPath tokenContextPath, TokenCategory tokenCategory, Coloring coloring, boolean bl) {
            this(tokenContextPath.getParent().getFullTokenName(tokenCategory), coloring, bl);
        }

        public TokenColoringEvaluator(String string, Coloring coloring, boolean bl) {
            this.parentFullTokenIDName = string;
            this.coloring = coloring;
            this.printingSet = bl;
        }

        public Object getValue(Class clazz, String string) {
            Coloring coloring = SettingsUtil.getColoring(BaseKit.class, this.parentFullTokenIDName, this.printingSet);
            if (this.coloring != null && coloring != null) {
                coloring = this.coloring.apply(coloring);
            }
            return coloring;
        }
    }

    public static class ForeColorPrintColoringEvaluator
    extends PrintColoringEvaluator {
        private Color foreColor;

        public ForeColorPrintColoringEvaluator(Color color) {
            this.foreColor = color;
        }

        protected Coloring getPrintColoring(Class clazz, String string, Coloring coloring) {
            return Coloring.changeForeColor((Coloring)super.getPrintColoring(clazz, string, coloring), (Color)this.foreColor);
        }
    }

    public static class FontStylePrintColoringEvaluator
    extends PrintColoringEvaluator {
        private int fontStyle;

        public FontStylePrintColoringEvaluator(int n) {
            this.fontStyle = n;
        }

        protected Coloring getPrintColoring(Class clazz, String string, Coloring coloring) {
            Coloring coloring2 = super.getPrintColoring(clazz, string, coloring);
            Font font = coloring2.getFont();
            if (font != null) {
                coloring2 = Coloring.changeFont((Coloring)coloring2, (Font)font.deriveFont(this.fontStyle));
            }
            return coloring2;
        }
    }

    public static class PrintColoringEvaluator
    implements Settings.Evaluator {
        protected Coloring getPrintColoring(Class clazz, String string, Coloring coloring) {
            Coloring coloring2 = coloring;
            if (coloring2 != null) {
                Font font;
                float f;
                if (coloring2.getBackColor() != null) {
                    coloring2 = Coloring.changeBackColor((Coloring)coloring2, (Color)Color.white);
                }
                if (coloring2.getForeColor() != null) {
                    coloring2 = Coloring.changeForeColor((Coloring)coloring2, (Color)Color.black);
                }
                if ((f = this.getPrintFontSize()) >= 0.0f && (font = coloring2.getFont()) != null) {
                    coloring2 = Coloring.changeFont((Coloring)coloring2, (Font)font.deriveFont(f));
                }
            }
            return coloring2;
        }

        protected float getPrintFontSize() {
            return 10.0f;
        }

        public Object getValue(Class clazz, String string) {
            if (string.endsWith("-print-coloring")) {
                String string2 = string.substring(0, string.length() - "-print-coloring".length());
                Coloring coloring = SettingsUtil.getColoring(clazz, string2, false);
                return this.getPrintColoring(clazz, string2, coloring);
            }
            return null;
        }
    }
}

