/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.project.NewProjectIterator;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NameAndLocationPanel
extends BasicWizardIterator.Panel {
    private static final String PROJECT_TEMPLATES_DIR = "Templates/Project";
    private static final String DEFAULT_CATEGORY_PATH = "Templates/Project/Other";
    private NewProjectIterator.DataModel data;
    private JComboBox comCategory;
    private JComboBox comPackageName;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JLabel filler;
    private JLabel lblCategory;
    private JLabel lblDisplayName;
    private JLabel lblName;
    private JLabel lblPackageName;
    private JLabel lblProjectName;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JTextField txtDisplayName;
    private JTextField txtName;
    private JTextField txtProjectName;

    NameAndLocationPanel(WizardDescriptor wizardDescriptor, NewProjectIterator.DataModel dataModel) {
        super(wizardDescriptor);
        JTextField jTextField;
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        Color color = UIManager.getColor("Label.background");
        this.putClientProperty("NewFileWizard_Title", NameAndLocationPanel.getMessage("LBL_ProjectWizardTitle"));
        this.modifiedFilesValue.setBackground(color);
        this.createdFilesValue.setBackground(color);
        this.modifiedFilesValue.setEditable(false);
        this.createdFilesValue.setEditable(false);
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (NameAndLocationPanel.this.checkValidity()) {
                    NameAndLocationPanel.this.updateData();
                }
            }
        };
        this.txtName.getDocument().addDocumentListener(documentAdapter);
        this.txtDisplayName.getDocument().addDocumentListener(documentAdapter);
        if (this.comCategory.getEditor().getEditorComponent() instanceof JTextField) {
            jTextField = (JTextField)this.comCategory.getEditor().getEditorComponent();
            jTextField.getDocument().addDocumentListener(documentAdapter);
        }
        if (this.comPackageName.getEditor().getEditorComponent() instanceof JTextField) {
            jTextField = (JTextField)this.comPackageName.getEditor().getEditorComponent();
            jTextField.getDocument().addDocumentListener(documentAdapter);
        }
    }

    protected void storeToDataModel() {
        this.updateData();
    }

    private String getCategoryPath() {
        String string = UIUtil.getSFSPath(this.comCategory, PROJECT_TEMPLATES_DIR);
        return string == null ? DEFAULT_CATEGORY_PATH : string;
    }

    private void updateData() {
        this.data.setPackageName(this.comPackageName.getEditor().getItem().toString());
        this.data.setName(this.txtName.getText().trim());
        this.data.setDisplayName(this.txtDisplayName.getText().trim());
        this.data.setCategory(this.getCategoryPath());
        NewProjectIterator.generateFileChanges(this.data);
        CreatedModifiedFiles createdModifiedFiles = this.data.getCreatedModifiedFiles();
        this.createdFilesValue.setText(NameAndLocationPanel.generateText(createdModifiedFiles.getCreatedPaths()));
        this.modifiedFilesValue.setText(NameAndLocationPanel.generateText(createdModifiedFiles.getModifiedPaths()));
        String[] stringArray = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (stringArray.length > 0) {
            this.setError(NbBundle.getMessage(NameAndLocationPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)stringArray[0]));
        }
    }

    protected void readFromDataModel() {
        this.loadCombo();
        if (this.data.getPackageName() != null) {
            this.comPackageName.setSelectedItem(this.data.getPackageName());
        }
        this.checkValidity();
    }

    protected String getPanelName() {
        return NameAndLocationPanel.getMessage("LBL_NameLocation_Title");
    }

    private boolean checkValidity() {
        if (!this.checkPlatformValidity()) {
            return false;
        }
        if (this.txtName.getText().trim().length() == 0) {
            this.setInfo(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Empty"), false);
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.txtName.getText().trim())) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Invalid"));
            return false;
        }
        String string = this.comPackageName.getEditor().getItem().toString().trim();
        if (string.length() == 0 || !UIUtil.isValidPackageName(string)) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Package_Invalid"));
            return false;
        }
        if (!Util.isValidSFSPath(this.getCategoryPath())) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Category_Invalid"));
            return false;
        }
        this.markValid();
        return true;
    }

    private boolean checkPlatformValidity() {
        NbModuleProject nbModuleProject = (NbModuleProject)this.data.getProject().getLookup().lookup(NbModuleProject.class);
        if (nbModuleProject == null) {
            return true;
        }
        NbPlatform nbPlatform = nbModuleProject.getPlatform(false);
        if (nbPlatform == null) {
            this.setError(NameAndLocationPanel.getMessage("ERR_No_Platform"));
            return false;
        }
        ModuleEntry[] moduleEntryArray = nbPlatform.getModules();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(NewProjectIterator.MODULES));
        for (int i = 0; i < moduleEntryArray.length; ++i) {
            hashSet.remove(moduleEntryArray[i].getCodeNameBase());
        }
        if (hashSet.size() > 0) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Missing_Modules"));
            return false;
        }
        return true;
    }

    private void loadCombo() {
        this.comCategory.setModel(UIUtil.createLayerPresenterComboModel(this.data.getProject(), PROJECT_TEMPLATES_DIR));
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(NameAndLocationPanel.class, (String)string);
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblDisplayName = new JLabel();
        this.txtDisplayName = new JTextField();
        this.lblCategory = new JLabel();
        this.comCategory = new JComboBox();
        this.lblProjectName = new JLabel();
        this.txtProjectName = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.lblPackageName = new JLabel();
        this.comPackageName = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.filler = new JLabel();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.lblName.setLabelFor(this.txtName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtName, gridBagConstraints);
        this.lblDisplayName.setLabelFor(this.txtDisplayName);
        Mnemonics.setLocalizedText((JLabel)this.lblDisplayName, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.lblDisplayName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.txtDisplayName, gridBagConstraints);
        this.lblCategory.setLabelFor(this.comCategory);
        Mnemonics.setLocalizedText((JLabel)this.lblCategory, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Category"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.lblCategory, gridBagConstraints);
        this.comCategory.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.comCategory, gridBagConstraints);
        this.lblProjectName.setLabelFor(this.txtProjectName);
        Mnemonics.setLocalizedText((JLabel)this.lblProjectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.lblProjectName, gridBagConstraints);
        this.txtProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.txtProjectName, gridBagConstraints);
        this.lblPackageName.setLabelFor(this.comPackageName);
        Mnemonics.setLocalizedText((JLabel)this.lblPackageName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.lblPackageName, gridBagConstraints);
        this.comPackageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.comPackageName, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValue, gridBagConstraints);
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.modifiedFilesValue, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_NameAndLocationPanel"));
        this.comPackageName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_PackageName"));
        this.comCategory.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Category"));
        this.txtDisplayName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_DisplayName"));
        this.txtName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Name"));
        this.txtProjectName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ProjectName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
    }

    private static String generateText(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }
}

