/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;

final class DataModel
extends BasicWizardIterator.BasicDataModel {
    static final String[] PREDEFINED_COOKIE_CLASSES;
    private static final String[] HARDCODED_IMPORTS;
    private static final Map<String, String> CLASS_TO_CNB;
    private static final String NEW_LINE;
    private static final String INDENT = "    ";
    private static final String INDENT_2X = "        ";
    private CreatedModifiedFiles cmf;
    private boolean alwaysEnabled;
    private String[] cookieClasses;
    private boolean multiSelection;
    private String category;
    private boolean globalMenuItemEnabled;
    private String gmiParentMenuPath;
    private Position gmiPosition;
    private boolean gmiSeparatorAfter;
    private boolean gmiSeparatorBefore;
    private boolean toolbarEnabled;
    private String toolbar;
    private Position toolbarPosition;
    private boolean kbShortcutEnabled;
    private final Set<String> keyStrokes = new HashSet<String>();
    private boolean ftContextEnabled;
    private String ftContextType;
    private Position ftContextPosition;
    private boolean ftContextSeparatorAfter;
    private boolean ftContextSeparatorBefore;
    private boolean edContextEnabled;
    private String edContextType;
    private Position edContextPosition;
    private boolean edContextSeparatorAfter;
    private boolean edContextSeparatorBefore;
    private String className;
    private String displayName;
    private String origIconPath;
    private String largeIconPath;

    DataModel(WizardDescriptor wizardDescriptor) {
        super(wizardDescriptor);
    }

    private void regenerate() {
        Object object;
        StringBuffer stringBuffer;
        boolean bl;
        Object object2;
        String string = this.getPackageName().replace('.', '-');
        String string2 = string + '-' + this.className;
        String string3 = string2 + ".shadow";
        this.cmf = new CreatedModifiedFiles(this.getProject());
        try {
            object2 = this.getModuleInfo().getDependencyVersion("org.openide.awt");
            bl = object2.compareTo((Object)new SpecificationVersion("7.3")) >= 0;
        }
        catch (IOException iOException) {
            Logger.getLogger(DataModel.class.getName()).log(Level.INFO, null, iOException);
            bl = false;
        }
        object2 = this.getDefaultPackagePath(this.className + ".java", false);
        FileObject fileObject = CreatedModifiedFiles.getTemplate(this.alwaysEnabled ? (bl ? "actionListener.java" : "callableSystemAction.java") : "cookieAction.java");
        assert (fileObject != null);
        String string4 = "CTL_" + this.className;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("CLASS_NAME", this.className);
        hashMap2.put("PACKAGE_NAME", this.getPackageName());
        hashMap2.put("DISPLAY_NAME_KEY", string4);
        hashMap2.put("MODE", this.getSelectionMode());
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(HARDCODED_IMPORTS));
        TreeSet<Object> treeSet2 = new TreeSet<Object>();
        if (!this.alwaysEnabled) {
            stringBuffer = new StringBuffer();
            for (String hashMap3 : this.cookieClasses) {
                if (CLASS_TO_CNB.containsKey(hashMap3)) {
                    treeSet2.add(hashMap3);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(DataModel.parseClassName(hashMap3) + ".class");
            }
            hashMap2.put("COOKIE_CLASSES_BLOCK", stringBuffer.toString());
            if (this.cookieClasses.length == 1) {
                String string5 = DataModel.parseClassName(this.cookieClasses[0]);
                String string6 = Character.toLowerCase(string5.charAt(0)) + string5.substring(1);
                object = string5 + ' ' + string6 + " = activatedNodes[0].getLookup().lookup(" + string5 + ".class);\n" + INDENT_2X + "// TODO use " + string6;
            } else {
                object = "// TODO implement action body";
            }
            hashMap2.put("PERFORM_ACTION_CODE", (String)object);
        }
        treeSet.addAll(treeSet2);
        stringBuffer = new StringBuffer();
        for (String string7 : treeSet) {
            stringBuffer.append("import " + string7 + ';' + NEW_LINE);
        }
        hashMap2.put("IMPORTS", stringBuffer.toString());
        this.cmf.add(this.cmf.createFileWithSubstitutions((String)object2, fileObject, hashMap2));
        object = this.getDefaultPackagePath("Bundle.properties", true);
        this.cmf.add(this.cmf.bundleKey((String)object, string4, this.displayName));
        String string8 = null;
        if (this.origIconPath != null) {
            string8 = this.addCreateIconOperation(this.cmf, this.origIconPath);
            hashMap2.put("ICON_RESOURCE_METHOD", DataModel.generateIconResourceMethod(string8));
            hashMap2.put("INITIALIZE_METHOD", "");
        } else {
            hashMap2.put("ICON_RESOURCE_METHOD", "");
            hashMap2.put("INITIALIZE_METHOD", DataModel.generateNoIconInitializeMethod());
        }
        if (this.isToolbarEnabled() && this.largeIconPath != null) {
            this.addCreateIconOperation(this.cmf, this.largeIconPath);
        }
        String string9 = this.category + "/" + string2 + ".instance";
        if (!this.alwaysEnabled || !bl) {
            this.cmf.add(this.cmf.createLayerEntry(string9, null, null, null, null));
        } else {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("instanceCreate", "methodvalue:org.openide.awt.Actions.alwaysEnabled");
            hashMap.put("delegate", "newvalue:" + this.getPackageName() + '.' + this.className);
            hashMap.put("noIconInMenu", "false");
            if (string8 != null) {
                hashMap.put("iconBase", string8);
            }
            hashMap.put("displayName", "bundlevalue:" + this.getPackageName() + ".Bundle#" + string4);
            this.cmf.add(this.cmf.createLayerEntry(string9, null, null, this.displayName, hashMap));
        }
        this.cmf.add(this.cmf.addModuleDependency("org.openide.util"));
        if (!this.alwaysEnabled) {
            this.cmf.add(this.cmf.addModuleDependency("org.openide.nodes"));
            for (String string5 : treeSet2) {
                this.cmf.add(this.cmf.addModuleDependency(CLASS_TO_CNB.get(string5)));
            }
        }
        if (this.globalMenuItemEnabled) {
            this.generateShadowWithOrderAndSeparator(this.gmiParentMenuPath, string3, string2, string9, this.gmiSeparatorBefore, this.gmiSeparatorAfter, this.gmiPosition);
        }
        if (this.toolbarEnabled) {
            this.generateShadow(this.toolbar + "/" + string3, string9);
            this.generateOrder(this.toolbar, this.toolbarPosition.getBefore(), string3, this.toolbarPosition.getAfter());
        }
        if (this.kbShortcutEnabled) {
            String string6 = "Shortcuts";
            for (String string7 : this.keyStrokes) {
                this.generateShadow(string6 + "/" + string7 + ".shadow", string9);
            }
        }
        if (this.ftContextEnabled) {
            this.generateShadowWithOrderAndSeparator(this.ftContextType, string3, string2, string9, this.ftContextSeparatorBefore, this.ftContextSeparatorAfter, this.ftContextPosition);
        }
        if (this.edContextEnabled) {
            this.generateShadowWithOrderAndSeparator(this.edContextType, string3, string2, string9, this.edContextSeparatorBefore, this.edContextSeparatorAfter, this.edContextPosition);
        }
    }

    private void generateShadowWithOrderAndSeparator(String string, String string2, String string3, String string4, boolean bl, boolean bl2, Position position) {
        String string5;
        this.generateShadow(string + "/" + string2, string4);
        this.generateOrder(string, position.getBefore(), string2, position.getAfter());
        if (bl) {
            string5 = string3 + "-separatorBefore.instance";
            this.generateSeparator(string, string5);
            this.generateOrder(string, position.getBefore(), string5, string2);
        }
        if (bl2) {
            string5 = string3 + "-separatorAfter.instance";
            this.generateSeparator(string, string5);
            this.generateOrder(string, string2, string5, position.getAfter());
        }
    }

    private void generateOrder(String string, String string2, String string3, String string4) {
        this.cmf.add(this.cmf.orderLayerEntry(string, string2, string3, string4));
    }

    boolean classExists() {
        FileObject fileObject = this.getProject().getProjectDirectory().getFileObject(this.getDefaultPackagePath(this.className + ".java", false));
        return fileObject != null;
    }

    private void generateShadow(String string, String string2) {
        this.cmf.add(this.cmf.createLayerEntry(string, null, null, null, null));
        this.cmf.add(this.cmf.createLayerAttribute(string, "originalFile", string2));
    }

    CreatedModifiedFiles getCreatedModifiedFiles() {
        if (this.cmf == null) {
            this.regenerate();
        }
        return this.cmf;
    }

    private void reset() {
        this.cmf = null;
    }

    void setAlwaysEnabled(boolean bl) {
        this.alwaysEnabled = bl;
    }

    boolean isAlwaysEnabled() {
        return this.alwaysEnabled;
    }

    void setCookieClasses(String[] stringArray) {
        this.cookieClasses = stringArray;
    }

    void setMultiSelection(boolean bl) {
        this.multiSelection = bl;
    }

    private String getSelectionMode() {
        return this.multiSelection ? "MODE_ALL" : "MODE_EXACTLY_ONE";
    }

    void setCategory(String string) {
        this.category = string;
    }

    void setClassName(String string) {
        this.reset();
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    void setIconPath(String string) {
        this.reset();
        this.origIconPath = string;
    }

    public String getIconPath() {
        return this.origIconPath;
    }

    public void setPackageName(String string) {
        super.setPackageName(string);
        this.reset();
    }

    void setGlobalMenuItemEnabled(boolean bl) {
        this.globalMenuItemEnabled = bl;
    }

    void setGMIParentMenu(String string) {
        this.gmiParentMenuPath = string;
    }

    void setGMISeparatorAfter(boolean bl) {
        this.gmiSeparatorAfter = bl;
    }

    void setGMISeparatorBefore(boolean bl) {
        this.gmiSeparatorBefore = bl;
    }

    void setGMIPosition(Position position) {
        this.gmiPosition = position;
    }

    void setToolbarEnabled(boolean bl) {
        this.toolbarEnabled = bl;
    }

    boolean isToolbarEnabled() {
        return this.toolbarEnabled;
    }

    void setToolbar(String string) {
        this.toolbar = string;
    }

    void setToolbarPosition(Position position) {
        this.toolbarPosition = position;
    }

    void setKeyboardShortcutEnabled(boolean bl) {
        this.kbShortcutEnabled = bl;
    }

    void setKeyStroke(String string) {
        this.keyStrokes.add(string);
    }

    void setFileTypeContextEnabled(boolean bl) {
        this.ftContextEnabled = bl;
    }

    void setFTContextType(String string) {
        this.ftContextType = string;
    }

    void setFTContextPosition(Position position) {
        this.ftContextPosition = position;
    }

    void setFTContextSeparatorAfter(boolean bl) {
        this.ftContextSeparatorAfter = bl;
    }

    void setFTContextSeparatorBefore(boolean bl) {
        this.ftContextSeparatorBefore = bl;
    }

    void setEditorContextEnabled(boolean bl) {
        this.edContextEnabled = bl;
    }

    void setEdContextType(String string) {
        this.edContextType = string;
    }

    void setEdContextPosition(Position position) {
        this.edContextPosition = position;
    }

    void setEdContextSeparatorAfter(boolean bl) {
        this.edContextSeparatorAfter = bl;
    }

    void setEdContextSeparatorBefore(boolean bl) {
        this.edContextSeparatorBefore = bl;
    }

    private void generateSeparator(String string, String string2) {
        String string3 = string + "/" + string2;
        this.cmf.add(this.cmf.createLayerEntry(string3, null, null, null, null));
        this.cmf.add(this.cmf.createLayerAttribute(string3, "instanceClass", "javax.swing.JSeparator"));
    }

    static String parseClassName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    private static String generateIconResourceMethod(String string) {
        return NEW_LINE + INDENT + "@Override" + NEW_LINE + INDENT + "protected String iconResource() {" + NEW_LINE + INDENT_2X + "return \"" + string + "\";" + NEW_LINE + INDENT + "}";
    }

    private static String generateNoIconInitializeMethod() {
        return "@Override" + NEW_LINE + INDENT + "protected void initialize() {" + NEW_LINE + INDENT_2X + "super.initialize();" + NEW_LINE + INDENT_2X + "// see org.openide.util.actions.SystemAction.iconResource() Javadoc for more details" + NEW_LINE + INDENT_2X + "putValue(\"noIconInMenu\", Boolean.TRUE);" + NEW_LINE + INDENT + "}" + NEW_LINE;
    }

    public void setLargeIconPath(String string) {
        this.largeIconPath = string;
    }

    static {
        HARDCODED_IMPORTS = new String[]{"org.openide.nodes.Node", "org.openide.util.HelpCtx", "org.openide.util.NbBundle", "org.openide.util.actions.CookieAction"};
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        hashMap.put("org.openide.loaders.DataObject", "org.openide.loaders");
        hashMap.put("org.openide.cookies.EditCookie", "org.openide.nodes");
        hashMap.put("org.openide.cookies.OpenCookie", "org.openide.nodes");
        hashMap.put("org.netbeans.api.project.Project", "org.netbeans.modules.projectapi");
        hashMap.put("org.openide.cookies.EditorCookie", "org.openide.text");
        CLASS_TO_CNB = Collections.unmodifiableMap(hashMap);
        PREDEFINED_COOKIE_CLASSES = new String[5];
        CLASS_TO_CNB.keySet().toArray(PREDEFINED_COOKIE_CLASSES);
        NEW_LINE = System.getProperty("line.separator");
    }

    static final class Position {
        private String before;
        private String after;
        private String beforeName;
        private String afterName;

        Position(String string, String string2) {
            this(string, string2, null, null);
        }

        Position(String string, String string2, String string3, String string4) {
            this.before = string;
            this.after = string2;
            this.beforeName = string3;
            this.afterName = string4;
        }

        String getBefore() {
            return this.before;
        }

        String getAfter() {
            return this.after;
        }

        String getBeforeName() {
            return this.beforeName;
        }

        String getAfterName() {
            return this.afterName;
        }
    }
}

