/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.ShowJavadocAction;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

final class PlatformNode
extends AbstractNode
implements ChangeListener {
    private static final String PLATFORM_ICON = "org/netbeans/modules/apisupport/project/ui/resources/platform.gif";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/apisupport/project/ui/resources/jar.gif";
    private final PlatformProvider pp;

    private PlatformNode(PlatformProvider platformProvider) {
        super((Children)new PlatformContentChildren(), Lookups.singleton((Object)new JavadocProvider(platformProvider)));
        this.pp = platformProvider;
        this.pp.addChangeListener(this);
        this.setIconBaseWithExtension(PLATFORM_ICON);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String string;
        JavaPlatform javaPlatform = this.pp.getPlatform();
        String string2 = javaPlatform != null ? javaPlatform.getDisplayName() : ((string = this.pp.getPlatformID()) == null ? NbBundle.getMessage(PlatformNode.class, (String)"TXT_BrokenPlatform") : MessageFormat.format(NbBundle.getMessage(PlatformNode.class, (String)"FMT_BrokenPlatform"), string));
        return string2;
    }

    public String getHtmlDisplayName() {
        if (this.pp.getPlatform() == null) {
            String string = this.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            return "<font color=\"#A40000\">" + string + "</font>";
        }
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(ShowJavadocAction.class)};
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ((PlatformContentChildren)PlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    static PlatformNode create(PropertyEvaluator propertyEvaluator, String string) {
        PlatformProvider platformProvider = new PlatformProvider(propertyEvaluator, string);
        return new PlatformNode(platformProvider);
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        PlatformProvider platformProvider;

        private JavadocProvider(PlatformProvider platformProvider) {
            this.platformProvider = platformProvider;
        }

        public boolean hasJavadoc() {
            JavaPlatform javaPlatform = this.platformProvider.getPlatform();
            if (javaPlatform == null) {
                return false;
            }
            URL[] uRLArray = JavadocProvider.getJavadocRoots(javaPlatform);
            return uRLArray.length > 0;
        }

        public void showJavadoc() {
            JavaPlatform javaPlatform = this.platformProvider.getPlatform();
            if (javaPlatform != null) {
                URL[] uRLArray = JavadocProvider.getJavadocRoots(javaPlatform);
                URL uRL = ShowJavadocAction.findJavadoc("overview-summary.html", uRLArray);
                if (uRL == null) {
                    uRL = ShowJavadocAction.findJavadoc("index.html", uRLArray);
                }
                ShowJavadocAction.showJavaDoc(uRL, javaPlatform.getDisplayName());
            }
        }

        private static URL[] getJavadocRoots(JavaPlatform javaPlatform) {
            HashSet<URL> hashSet = new HashSet<URL>();
            List list = javaPlatform.getBootstrapLibraries().entries();
            for (ClassPath.Entry entry : list) {
                hashSet.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)entry.getURL()).getRoots()));
            }
            return hashSet.toArray(new URL[hashSet.size()]);
        }
    }

    private static class PlatformProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator evaluator;
        private final String platformPropName;
        private JavaPlatform platformCache;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public PlatformProvider(PropertyEvaluator propertyEvaluator, String string) {
            this.evaluator = propertyEvaluator;
            this.platformPropName = string;
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        }

        public String getPlatformID() {
            return this.evaluator.getProperty(this.platformPropName);
        }

        public JavaPlatform getPlatform() {
            if (this.platformCache == null) {
                String string = this.getPlatformID();
                this.platformCache = ModuleProperties.findJavaPlatformByLocation(string);
                if (this.platformCache != null && this.platformCache.getInstallFolders().size() == 0) {
                    this.platformCache = null;
                }
                if (ErrorManager.getDefault().isLoggable(1) && this.platformCache == null) {
                    StringBuffer stringBuffer = new StringBuffer("RequestedPlatform: " + string + " not found.\nInstalled Platforms:\n");
                    JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < javaPlatformArray.length; ++i) {
                        stringBuffer.append("Name: " + (String)javaPlatformArray[i].getProperties().get("platform.ant.name") + " Broken: " + (javaPlatformArray[i].getInstallFolders().size() == 0) + "\n");
                    }
                    ErrorManager.getDefault().log(1, stringBuffer.toString());
                }
            }
            return this.platformCache;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.platformPropName.equals(propertyChangeEvent.getPropertyName())) {
                this.platformCache = null;
                this.changeSupport.fireChange();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlatformContentChildren
    extends Children.Keys<SourceGroup> {
        PlatformContentChildren() {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sourceGroup) {
            return new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)sourceGroup))};
        }

        private List<SourceGroup> getKeys() {
            JavaPlatform javaPlatform = ((PlatformNode)this.getNode()).pp.getPlatform();
            if (javaPlatform == null) {
                return Collections.emptyList();
            }
            FileObject[] fileObjectArray = javaPlatform.getBootstrapLibraries().getRoots();
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>(fileObjectArray.length);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    ImageIcon imageIcon;
                    FileObject fileObject;
                    if ("jar".equals(fileObjectArray[i].getURL().getProtocol())) {
                        fileObject = FileUtil.getArchiveFile((FileObject)fileObjectArray[i]);
                        imageIcon = new ImageIcon(Utilities.loadImage((String)PlatformNode.ARCHIVE_ICON));
                    } else {
                        fileObject = fileObjectArray[i];
                        imageIcon = null;
                    }
                    if (!fileObject.isValid()) continue;
                    arrayList.add(new LibrariesSourceGroup(fileObjectArray[i], fileObject.getNameExt(), imageIcon, imageIcon));
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
            }
            return arrayList;
        }
    }
}

