/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.metainf;

import java.io.IOException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.metainf.ServiceNodeHandler;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

final class ServicesFileListener
implements FileChangeListener {
    private static ServicesFileListener instance;

    private ServicesFileListener() {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        Project project;
        FileObject fileObject = fileEvent.getFile();
        if (fileObject.getName().equals("services")) {
            if (fileObject.getParent().getName().equals("META-INF")) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
                fileObject.addFileChangeListener((FileChangeListener)this);
            }
        } else if (fileObject.getName().equals("META-INF") && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && project instanceof NbModuleProject && ((NbModuleProject)project).getSourceDirectory().equals(fileObject.getParent())) {
            fileObject.removeFileChangeListener((FileChangeListener)this);
            fileObject.addFileChangeListener((FileChangeListener)this);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.updateFile(fileEvent.getFile());
    }

    public void fileChanged(FileEvent fileEvent) {
        this.updateFile(fileEvent.getFile());
    }

    public void fileDeleted(FileEvent fileEvent) {
        try {
            this.removeFile(fileEvent.getFile());
        }
        catch (IOException iOException) {
            Util.err.notify();
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        try {
            this.removeFile((FileObject)fileRenameEvent.getSource());
        }
        catch (IOException iOException) {
            Util.err.notify();
        }
        this.updateFile(fileRenameEvent.getFile());
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    private ServiceNodeHandler getHandler(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 != null && fileObject2.getName().equals("services") && (fileObject2 = fileObject2.getParent()) != null && fileObject2.getName().equals("META-INF")) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            return project == null ? null : (ServiceNodeHandler)project.getLookup().lookup(ServiceNodeHandler.class);
        }
        return null;
    }

    private void updateFile(FileObject fileObject) {
        ServiceNodeHandler serviceNodeHandler = this.getHandler(fileObject);
        if (serviceNodeHandler != null) {
            serviceNodeHandler.updateFile(fileObject);
        }
    }

    public void removeFile(FileObject fileObject) throws IOException {
        ServiceNodeHandler serviceNodeHandler = this.getHandler(fileObject);
        if (serviceNodeHandler != null) {
            serviceNodeHandler.removeFile(fileObject);
        }
    }

    public static ServicesFileListener getInstance() {
        if (instance == null) {
            instance = new ServicesFileListener();
        }
        return instance;
    }
}

