/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.metainf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.metainf.AddService;
import org.netbeans.modules.apisupport.project.metainf.SUtil;
import org.netbeans.modules.apisupport.project.metainf.Service;
import org.netbeans.modules.apisupport.project.metainf.ServiceViewUpdater;
import org.netbeans.modules.apisupport.project.metainf.ServicesFileListener;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ServiceNodeHandler {
    private static final String KEY_WAIT = "wait";
    private static final String THIS_SERVICES = NbBundle.getMessage(ServiceNodeHandler.class, (String)"LBL_this_services");
    private static final String THIS_SERVICES_IN_CONTEXT = NbBundle.getMessage(ServiceNodeHandler.class, (String)"LBL_this_services_in_context");
    static final String ROOT_NODE_NAME = NbBundle.getMessage(ServiceNodeHandler.class, (String)"LBL_META_INF_services");
    TreeMap<String, List<Service>> allServicesMap;
    TreeMap<String, List<Service>> moduleServiceMap;
    int prevAllServicesCount = -1;
    int prevModuleServicesCount = -1;
    final Project project;
    final NbModuleProvider info;
    List<Service> moduleServices;
    ServiceRootChildren moduleChild;
    ServiceRootChildren allInContextChild;
    boolean registeredListener;
    private FileObject metaInfServicesFo;
    private String codeNameBase;

    public ServiceNodeHandler(Project project, NbModuleProvider nbModuleProvider) {
        this.project = project;
        this.info = nbModuleProvider;
        if (!this.registeredListener) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                public void run() {
                    ServiceNodeHandler.this.registerFileObjectListener();
                }
            });
        }
    }

    public Node createServiceRootNode() {
        return new ServiceRootNode();
    }

    private Node createServiceFolderNode(boolean bl) {
        ServiceRootChildren serviceRootChildren = new ServiceRootChildren(bl);
        ServiceFolderNode serviceFolderNode = new ServiceFolderNode((Children)serviceRootChildren);
        if (bl) {
            serviceFolderNode.setDisplayName(THIS_SERVICES);
            serviceFolderNode.setName(THIS_SERVICES);
            serviceFolderNode.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/metainf/export.png");
            this.moduleChild = serviceRootChildren;
        } else {
            serviceFolderNode.setDisplayName(THIS_SERVICES_IN_CONTEXT);
            serviceFolderNode.setName(THIS_SERVICES_IN_CONTEXT);
            serviceFolderNode.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/metainf/services.png");
            this.allInContextChild = serviceRootChildren;
        }
        return serviceFolderNode;
    }

    public void registerFileObjectListener() {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(this.info.getResourceDirectoryPath(false));
        if (fileObject != null) {
            if (!this.registeredListener) {
                this.registeredListener = true;
                FileObject fileObject2 = fileObject.getFileObject("META-INF");
                ServicesFileListener servicesFileListener = ServicesFileListener.getInstance();
                if (fileObject2 != null) {
                    fileObject2.removeFileChangeListener((FileChangeListener)servicesFileListener);
                    fileObject2.addFileChangeListener((FileChangeListener)servicesFileListener);
                    this.metaInfServicesFo = fileObject2;
                    fileObject2 = fileObject2.getFileObject("services");
                    if (fileObject2 != null) {
                        fileObject2.removeFileChangeListener((FileChangeListener)servicesFileListener);
                        fileObject2.addFileChangeListener((FileChangeListener)servicesFileListener);
                        this.metaInfServicesFo = fileObject2;
                    }
                } else {
                    fileObject.removeFileChangeListener((FileChangeListener)servicesFileListener);
                    fileObject.addFileChangeListener((FileChangeListener)servicesFileListener);
                    this.metaInfServicesFo = fileObject;
                }
            }
        } else {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.log(" project.getSourceDirectory() = null");
            errorManager.log("codenamebase = " + this.info.getCodeNameBase());
            errorManager.log("projectroot = " + this.project.getProjectDirectory().getPath());
        }
    }

    void updateFile(FileObject fileObject) {
        try {
            if (fileObject.getParent() == SUtil.getServicesFolder(this.project, false)) {
                InputStream inputStream = fileObject.getInputStream();
                Service service = Service.createService(this.info.getCodeNameBase(), fileObject.getNameExt(), inputStream);
                inputStream.close();
                ServiceViewUpdater.serviceUpdated(service, this);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFile(FileObject fileObject) throws IOException {
        if (fileObject.getParent() == SUtil.getServicesFolder(this.project, false)) {
            String string = fileObject.getNameExt();
            if (this.moduleServiceMap != null) {
                Service service = null;
                ServiceNodeHandler serviceNodeHandler = this;
                synchronized (serviceNodeHandler) {
                    List<Service> list = this.moduleServiceMap.get(string);
                    if (list != null && list.size() > 0) {
                        service = list.get(0);
                    }
                    this.moduleServiceMap.remove(string);
                    if (this.allServicesMap != null && (list = this.allServicesMap.get(string)) != null) {
                        list.remove(service);
                        if (list.isEmpty()) {
                            this.allServicesMap.remove(string);
                        }
                    }
                }
                this.updateNode(service);
            }
        }
    }

    private void updateNode(Service service) {
        String string;
        String string2 = string = service == null ? null : service.getFileName();
        if (this.moduleChild != null && this.moduleChild.fullyComputed && this.moduleServiceMap != null) {
            if (this.prevModuleServicesCount == this.moduleServiceMap.size() && string != null) {
                this.moduleChild.updateNode(string);
            } else {
                this.moduleChild.refreshKeys();
                this.prevModuleServicesCount = this.moduleServiceMap.size();
            }
        }
        if (this.allInContextChild != null && this.allInContextChild.fullyComputed && this.allServicesMap != null) {
            if (this.prevAllServicesCount == this.allServicesMap.size() && string != null) {
                this.allInContextChild.updateNode(string);
            } else {
                this.allInContextChild.refreshKeys();
                this.prevAllServicesCount = this.allServicesMap.size();
            }
        }
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ServiceNodeHandler && this.getKeyName().equals(((ServiceNodeHandler)object).getKeyName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateService(Service service) {
        ServiceNodeHandler serviceNodeHandler = this;
        synchronized (serviceNodeHandler) {
            if (this.moduleServiceMap != null) {
                List<Service> list = this.moduleServiceMap.get(service.getFileName());
                if (service.getCodebase().equals(this.info.getCodeNameBase())) {
                    if (list != null && list.size() > 0) {
                        list.remove(0);
                    } else {
                        list = new ArrayList<Service>();
                        this.moduleServiceMap.put(service.getFileName(), list);
                    }
                    list.add(service);
                }
                if (this.allServicesMap != null) {
                    list = this.allServicesMap.get(service.getFileName());
                    if (list != null && list.size() > 0) {
                        Iterator<Service> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            if (!iterator.next().getCodebase().equals(service.getCodebase())) continue;
                            iterator.remove();
                            break;
                        }
                    } else {
                        list = new ArrayList<Service>();
                        this.allServicesMap.put(service.getFileName(), list);
                    }
                    list.add(service);
                }
                this.updateNode(service);
            }
        }
    }

    Project getProject() {
        return this.project;
    }

    private String getKeyName() {
        if (this.codeNameBase == null) {
            this.codeNameBase = this.info.getCodeNameBase();
        }
        if (this.codeNameBase == null) {
            this.codeNameBase = "unknown";
        }
        return this.codeNameBase;
    }

    static class ServiceFolderNode
    extends AbstractNode {
        ServiceFolderNode(Children children) {
            super(children);
        }

        public Action[] getActions(boolean bl) {
            return new Action[0];
        }
    }

    class ServiceRootNode
    extends AbstractNode {
        ServiceRootNode() {
            super((Children)new Children.Array());
            this.setDisplayName(ROOT_NODE_NAME);
            this.setName(ROOT_NODE_NAME);
            Children.Array array = (Children.Array)this.getChildren();
            array.add(new Node[]{ServiceNodeHandler.this.createServiceFolderNode(true), ServiceNodeHandler.this.createServiceFolderNode(false)});
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/metainf/services.png");
        }

        ServiceNodeHandler getNodeHandler() {
            return ServiceNodeHandler.this;
        }

        public Action[] getActions(boolean bl) {
            return new Action[0];
        }
    }

    public final class ServiceClassNode
    extends AbstractNode {
        boolean bRemoved;

        ServiceClassNode(String string, boolean bl) {
            super(Children.LEAF);
            this.setName(string);
            this.bRemoved = bl;
            if (string.startsWith("-")) {
                this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/metainf/noinstance.png");
            } else {
                this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/metainf/instance.png");
            }
        }

        Service getService() {
            if (this.getParentNode() != null) {
                List<Service> list = ServiceNodeHandler.this.allServicesMap.get(this.getParentNode().getName());
                String string = this.getName();
                if (list != null) {
                    for (Service service : list) {
                        for (String string2 : service.getClasses()) {
                            if (!string.equals(string2)) continue;
                            return service;
                        }
                    }
                }
            }
            return null;
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{DeleteAction.get(DeleteAction.class)};
        }

        public String getHtmlDisplayName() {
            Object object;
            List<Service> list = ServiceNodeHandler.this.moduleServiceMap.get(this.getParentNode().getName());
            String string = this.getName();
            boolean bl = false;
            if (list != null) {
                object = list.iterator();
                block0: while (object.hasNext()) {
                    Service service = (Service)object.next();
                    for (String string2 : service.getClasses()) {
                        if (!string.equals(string2)) continue;
                        bl = true;
                        continue block0;
                    }
                }
            }
            Object object2 = object = bl && !this.getParentNode().getParentNode().getName().equals(THIS_SERVICES) ? "<b>" + string + "</b>" : string;
            if (this.bRemoved) {
                object = "<s>" + (String)object + "</s>";
            }
            return object;
        }

        public boolean canCopy() {
            return false;
        }

        public void destroy() throws IOException {
            Service service = this.getService();
            if (service != null) {
                Service service2 = null;
                List<Service> list = ServiceNodeHandler.this.moduleServiceMap.get(service.getFileName());
                if (list == null || list.size() == 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    service2 = new Service(service.getCodebase(), service.getFileName(), arrayList);
                } else {
                    service2 = list.get(0);
                }
                service2.removeClass(this.getName(), ServiceNodeHandler.this.project);
            }
        }
    }

    public final class ServiceNode
    extends AbstractNode {
        ServiceNode(String string, boolean bl) {
            super((Children)new ServiceNodeChildren(bl));
            this.setName(string);
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/metainf/interface.png");
        }

        public void updateChildren() {
            ((ServiceNodeChildren)this.getChildren()).nodesChanged();
            this.fireDisplayNameChange(null, null);
        }

        boolean isThisModule() {
            return this.getParentNode() == null ? false : this.getParentNode().getName().equals(THIS_SERVICES);
        }

        public String getHtmlDisplayName() {
            List<Service> list = ServiceNodeHandler.this.moduleServiceMap.get(this.getName());
            return list != null && !this.isThisModule() ? "<b>" + this.getName() + "</b>" : this.getName();
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{AddService.getInstance()};
        }

        void addService(String string, String string2) {
            List<Service> list = ServiceNodeHandler.this.allServicesMap.get(string);
            boolean bl = false;
            for (Service service : list) {
                for (String string3 : service.getClasses()) {
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ServiceNodeHandler.class, (String)"MSG_ServiceExist", (Object)string3));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
            if (!bl) {
                list = ServiceNodeHandler.this.moduleServiceMap.get(string);
                Object object = null;
                object = list != null && list.size() > 0 ? list.get(0) : new Service(this.getInfo().getCodeNameBase(), string, new ArrayList<String>());
                ((Service)object).getClasses().add(string2);
                ((Service)object).write(ServiceNodeHandler.this.project);
            }
        }

        void refreshName() {
            this.fireDisplayNameChange(null, null);
        }

        Project getProject() {
            return ServiceNodeHandler.this.project;
        }

        NbModuleProvider getInfo() {
            return (NbModuleProvider)ServiceNodeHandler.this.project.getLookup().lookup(NbModuleProvider.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServiceNodeChildren
    extends Children.Keys<ServiceClassKey> {
        private boolean isThisModule;
        private TreeMap<String, ServiceClassKey> keys;
        boolean initialized = true;

        ServiceNodeChildren(boolean bl) {
            this.isThisModule = bl;
        }

        private TreeMap<String, ServiceClassKey> getKeysMap() {
            if (this.keys == null) {
                this.keys = new TreeMap();
            }
            return this.keys;
        }

        private ServiceClassKey addKey(ServiceClassKey serviceClassKey, TreeMap<String, ServiceClassKey> treeMap) {
            TreeMap<String, ServiceClassKey> treeMap2 = this.getKeysMap();
            ServiceClassKey serviceClassKey2 = treeMap2.get(serviceClassKey.name);
            if (serviceClassKey2 == null) {
                serviceClassKey2 = serviceClassKey;
            } else if (serviceClassKey2.bRemoved != serviceClassKey.bRemoved) {
                serviceClassKey2.bRemoved = serviceClassKey.bRemoved;
                this.refreshKey(serviceClassKey2);
            }
            treeMap.put(serviceClassKey.name, serviceClassKey2);
            return serviceClassKey2;
        }

        protected void addNotify() {
            ServiceNode serviceNode = (ServiceNode)this.getNode();
            this.isThisModule = serviceNode.isThisModule();
            List<Service> list = this.isThisModule ? ServiceNodeHandler.this.moduleServiceMap.get(serviceNode.getName()) : ServiceNodeHandler.this.allServicesMap.get(serviceNode.getName());
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            TreeMap<String, ServiceClassKey> treeMap = new TreeMap<String, ServiceClassKey>();
            for (Service object : list) {
                for (String string2 : object.getClasses()) {
                    if (string2.charAt(0) == '-') {
                        arrayList2.add(string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            for (String string : arrayList) {
                Object object = new ServiceClassKey(string, false);
                if (!this.isThisModule) {
                    String string2;
                    string2 = '-' + string;
                    for (String string3 : arrayList2) {
                        if (!string3.equals(string2)) continue;
                        ((ServiceClassKey)object).bRemoved = true;
                    }
                }
                object = this.addKey((ServiceClassKey)object, treeMap);
            }
            if (this.isThisModule) {
                for (String string : arrayList2) {
                    this.addKey(new ServiceClassKey(string, false), treeMap);
                }
            }
            this.keys = treeMap;
            this.setKeys(this.getKeysMap().values());
            this.initialized = true;
        }

        protected Node[] createNodes(ServiceClassKey serviceClassKey) {
            ServiceClassKey serviceClassKey2 = serviceClassKey;
            ServiceClassNode serviceClassNode = new ServiceClassNode(serviceClassKey2.name, serviceClassKey2.bRemoved);
            return new Node[]{serviceClassNode};
        }

        synchronized void nodesChanged() {
            if (this.initialized) {
                this.addNotify();
            }
        }
    }

    class ServiceClassKey {
        String name;
        boolean bRemoved;

        ServiceClassKey(String string, boolean bl) {
            this.name = string;
            this.bRemoved = bl;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof ServiceClassKey && ((ServiceClassKey)object).name.equals(this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServiceRootChildren
    extends Children.Keys<String> {
        boolean fullyComputed = false;
        private final boolean bProjectServices;

        ServiceRootChildren(boolean bl) {
            this.bProjectServices = bl;
        }

        protected Node[] createNodes(String string) {
            if (string.equals(ServiceNodeHandler.KEY_WAIT)) {
                return new Node[]{new AbstractNode(Children.LEAF){

                    public String getName() {
                        return ServiceNodeHandler.KEY_WAIT;
                    }

                    public String getDisplayName() {
                        return NbBundle.getMessage(ServiceNodeHandler.class, (String)"LBL_ServiceNode_please_wait");
                    }

                    public Action[] getActions(boolean bl) {
                        return new Action[0];
                    }
                }};
            }
            Node node = this.getNode();
            String string2 = node.getName();
            boolean bl = string2.equals(THIS_SERVICES);
            ServiceNode serviceNode = new ServiceNode(string, bl);
            return new Node[]{serviceNode};
        }

        protected void addNotify() {
            SUtil.log("ServiceNodeHandler.addNotify()");
            super.addNotify();
            if (this.fullyComputed) {
                if (this.bProjectServices) {
                    ServiceNodeHandler.this.prevModuleServicesCount = ServiceNodeHandler.this.moduleServiceMap.keySet().size();
                    SUtil.log("setting keys");
                    this.setKeys(ServiceNodeHandler.this.moduleServiceMap.keySet());
                } else {
                    ServiceNodeHandler.this.prevAllServicesCount = ServiceNodeHandler.this.allServicesMap.keySet().size();
                    this.setKeys(ServiceNodeHandler.this.allServicesMap.keySet());
                }
            } else {
                SUtil.log("computing services keys");
                this.setKeys(new String[]{ServiceNodeHandler.KEY_WAIT});
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Set<String> set = null;
                            ServiceNodeHandler serviceNodeHandler = ServiceNodeHandler.this;
                            synchronized (serviceNodeHandler) {
                                if (ServiceNodeHandler.this.moduleServiceMap == null) {
                                    ServiceNodeHandler.this.moduleServiceMap = new TreeMap();
                                    ServiceNodeHandler.this.moduleServices = Service.getOnlyProjectServices(ServiceNodeHandler.this.project);
                                    this.sortServices(ServiceNodeHandler.this.moduleServiceMap, ServiceNodeHandler.this.moduleServices);
                                }
                                if (ServiceRootChildren.this.bProjectServices) {
                                    set = ServiceNodeHandler.this.moduleServiceMap.keySet();
                                    ServiceNodeHandler.this.prevModuleServicesCount = ServiceNodeHandler.this.moduleServiceMap.keySet().size();
                                } else {
                                    if (ServiceNodeHandler.this.allServicesMap == null) {
                                        ServiceNodeHandler.this.allServicesMap = new TreeMap();
                                        List<Service> list = ServiceViewUpdater.getAllServices(ServiceNodeHandler.this);
                                        if (list != null) {
                                            assert (ServiceNodeHandler.this.moduleServiceMap != null);
                                            this.sortServices(ServiceNodeHandler.this.allServicesMap, list);
                                        }
                                    }
                                    ServiceNodeHandler.this.prevAllServicesCount = ServiceNodeHandler.this.allServicesMap.keySet().size();
                                    set = ServiceNodeHandler.this.allServicesMap.keySet();
                                    if (!set.isEmpty()) {
                                        SUtil.log(set.iterator().next().toString());
                                    }
                                }
                            }
                            ServiceRootChildren.this.setKeys(set);
                            serviceNodeHandler = ServiceNodeHandler.this;
                            synchronized (serviceNodeHandler) {
                                ServiceRootChildren.this.fullyComputed = true;
                                SUtil.log("compute keys finished");
                            }
                        }
                        catch (IOException iOException) {
                            Util.err.notify(1, (Throwable)iOException);
                        }
                    }

                    private void sortServices(TreeMap<String, List<Service>> treeMap, List<Service> list) {
                        for (Service service : list) {
                            assert (treeMap != null);
                            List<Service> list2 = treeMap.get(service.getFileName());
                            if (list2 == null) {
                                list2 = new ArrayList<Service>();
                                treeMap.put(service.getFileName(), list2);
                            }
                            list2.add(service);
                        }
                    }
                });
            }
        }

        void refreshKeys() {
            if (this.bProjectServices) {
                this.setKeys(ServiceNodeHandler.this.moduleServiceMap.keySet());
                ServiceNodeHandler.this.prevModuleServicesCount = ServiceNodeHandler.this.moduleServiceMap.size();
            } else {
                this.setKeys(ServiceNodeHandler.this.allServicesMap.keySet());
                ServiceNodeHandler.this.prevAllServicesCount = ServiceNodeHandler.this.allServicesMap.size();
            }
        }

        public void updateNode(String string) {
            for (Node node : this.getNodes()) {
                ServiceNode serviceNode = (ServiceNode)node;
                if (!serviceNode.getName().equals(string)) continue;
                serviceNode.refreshName();
                ((ServiceNodeChildren)serviceNode.getChildren()).nodesChanged();
            }
        }

        protected void removeNotify() {
            this.setKeys(new String[0]);
            super.removeNotify();
        }
    }
}

