/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.Util;
import org.openide.filesystems.FileObject;
import org.openide.modules.Dependency;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManifestManager {
    private String codeNameBase;
    private String releaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String[] provTokens;
    private String provTokensString;
    private String[] requiredTokens;
    private String[] neededTokens;
    private String localizingBundle;
    private String layer;
    private String classPath;
    private PackageExport[] publicPackages;
    private String[] friendNames;
    private String moduleDependencies;
    private boolean deprecated;
    private Boolean autoUpdateShowInClient;
    public static final String OPENIDE_MODULE = "OpenIDE-Module";
    public static final String OPENIDE_MODULE_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    public static final String OPENIDE_MODULE_IMPLEMENTATION_VERSION = "OpenIDE-Module-Implementation-Version";
    public static final String OPENIDE_MODULE_PROVIDES = "OpenIDE-Module-Provides";
    public static final String OPENIDE_MODULE_REQUIRES = "OpenIDE-Module-Requires";
    public static final String OPENIDE_MODULE_NEEDS = "OpenIDE-Module-Needs";
    public static final String OPENIDE_MODULE_LAYER = "OpenIDE-Module-Layer";
    public static final String OPENIDE_MODULE_LOCALIZING_BUNDLE = "OpenIDE-Module-Localizing-Bundle";
    public static final String OPENIDE_MODULE_PUBLIC_PACKAGES = "OpenIDE-Module-Public-Packages";
    public static final String OPENIDE_MODULE_FRIENDS = "OpenIDE-Module-Friends";
    public static final String OPENIDE_MODULE_MODULE_DEPENDENCIES = "OpenIDE-Module-Module-Dependencies";
    public static final String CLASS_PATH = "Class-Path";
    public static final String AUTO_UPDATE_SHOW_IN_CLIENT = "AutoUpdate-Show-In-Client";
    static final PackageExport[] EMPTY_EXPORTED_PACKAGES = new PackageExport[0];
    public static final ManifestManager NULL_INSTANCE = new ManifestManager();

    private ManifestManager() {
        this.provTokens = new String[0];
        this.requiredTokens = new String[0];
        this.neededTokens = new String[0];
    }

    private ManifestManager(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, PackageExport[] packageExportArray, String[] stringArray, boolean bl, Boolean bl2, String string11) {
        this.codeNameBase = string;
        this.releaseVersion = string2;
        this.specificationVersion = string3;
        this.implementationVersion = string4;
        this.provTokensString = string5;
        this.provTokens = this.parseTokens(string5);
        this.requiredTokens = this.parseTokens(string6);
        this.neededTokens = this.parseTokens(string7);
        this.localizingBundle = string8;
        this.layer = string9;
        this.classPath = string10;
        this.publicPackages = packageExportArray == null ? EMPTY_EXPORTED_PACKAGES : packageExportArray;
        this.friendNames = stringArray;
        this.deprecated = bl;
        this.autoUpdateShowInClient = bl2;
        this.moduleDependencies = string11;
    }

    private String[] parseTokens(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManifestManager getInstance(File file, boolean bl) {
        if (file.exists()) {
            ManifestManager manifestManager;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                Manifest manifest = new Manifest(fileInputStream);
                manifestManager = ManifestManager.getInstance(manifest, bl);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Exceptions.attachMessage((Throwable)iOException, (String)("While opening: " + file));
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            ((InputStream)fileInputStream).close();
            return manifestManager;
        }
        return NULL_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManifestManager getInstanceFromJAR(File file) {
        ManifestManager manifestManager;
        if (!file.isFile()) {
            throw new IOException("No such JAR: " + file);
        }
        JarFile jarFile = new JarFile(file, false);
        try {
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new IOException("No manifest in " + file);
            }
            manifestManager = ManifestManager.getInstance(manifest, true);
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
                return NULL_INSTANCE;
            }
        }
        jarFile.close();
        return manifestManager;
    }

    public static ManifestManager getInstance(Manifest manifest, boolean bl) {
        String string;
        Attributes attributes = manifest.getMainAttributes();
        String string2 = attributes.getValue(OPENIDE_MODULE);
        String string3 = null;
        String string4 = null;
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n == -1) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            }
        }
        PackageExport[] packageExportArray = null;
        String[] stringArray = null;
        if (bl) {
            packageExportArray = EMPTY_EXPORTED_PACKAGES;
            String string5 = attributes.getValue(OPENIDE_MODULE_PUBLIC_PACKAGES);
            if (string5 != null) {
                packageExportArray = ManifestManager.parseExportedPackages(string5);
            }
            if ((string = attributes.getValue(OPENIDE_MODULE_FRIENDS)) != null && (stringArray = ManifestManager.parseFriends(string)).length > 0 && packageExportArray.length == 0) {
                throw new IllegalArgumentException("No use specifying OpenIDE-Module-Friends without any public packages: " + string);
            }
        }
        boolean bl2 = "true".equals(attributes.getValue("OpenIDE-Module-Deprecated"));
        string = attributes.getValue(AUTO_UPDATE_SHOW_IN_CLIENT);
        return new ManifestManager(string3, string4, attributes.getValue(OPENIDE_MODULE_SPECIFICATION_VERSION), attributes.getValue(OPENIDE_MODULE_IMPLEMENTATION_VERSION), attributes.getValue(OPENIDE_MODULE_PROVIDES), attributes.getValue(OPENIDE_MODULE_REQUIRES), attributes.getValue(OPENIDE_MODULE_NEEDS), attributes.getValue(OPENIDE_MODULE_LOCALIZING_BUNDLE), attributes.getValue(OPENIDE_MODULE_LAYER), attributes.getValue(CLASS_PATH), packageExportArray, stringArray, bl2, string != null ? Boolean.valueOf(string) : null, attributes.getValue(OPENIDE_MODULE_MODULE_DEPENDENCIES));
    }

    static void createManifest(FileObject fileObject, String string, String string2, String string3, String string4) throws IOException {
        EditableManifest editableManifest = new EditableManifest();
        editableManifest.setAttribute(OPENIDE_MODULE, string, null);
        editableManifest.setAttribute(OPENIDE_MODULE_SPECIFICATION_VERSION, string2, null);
        editableManifest.setAttribute(OPENIDE_MODULE_LOCALIZING_BUNDLE, string3, null);
        if (string4 != null) {
            editableManifest.setAttribute(OPENIDE_MODULE_LAYER, string4, null);
        }
        Util.storeManifest(fileObject, editableManifest);
    }

    private static PackageExport[] parseExportedPackages(String string) {
        PackageExport[] packageExportArray = null;
        if (string.trim().equals("-")) {
            packageExportArray = EMPTY_EXPORTED_PACKAGES;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            ArrayList<PackageExport> arrayList = new ArrayList<PackageExport>(Math.max(stringTokenizer.countTokens(), 1));
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (string3.endsWith(".*")) {
                    string2 = string3.substring(0, string3.length() - 2);
                    Dependency.create((int)1, (String)string2);
                    if (string2.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
                    }
                    arrayList.add(new PackageExport(string2, false));
                    continue;
                }
                if (string3.endsWith(".**")) {
                    string2 = string3.substring(0, string3.length() - 3);
                    Dependency.create((int)1, (String)string2);
                    if (string2.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
                    }
                    arrayList.add(new PackageExport(string2, true));
                    continue;
                }
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
            }
            if (arrayList.isEmpty()) {
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
            }
            packageExportArray = arrayList.toArray(new PackageExport[arrayList.size()]);
        }
        return packageExportArray;
    }

    private static String[] parseFriends(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(47) != -1) {
                throw new IllegalArgumentException("May specify only module code name bases in OpenIDE-Module-Friends, not major release versions: " + string2);
            }
            Dependency.create((int)1, (String)string2);
            hashSet.add(string2);
        }
        if (hashSet.isEmpty()) {
            throw new IllegalArgumentException("Empty OpenIDE-Module-Friends: " + string);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getProvidedTokensString() {
        return this.provTokensString;
    }

    public String[] getProvidedTokens() {
        return this.provTokens;
    }

    public String[] getRequiredTokens() {
        return this.requiredTokens;
    }

    public String[] getNeededTokens() {
        return this.neededTokens;
    }

    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    public String[] getFriends() {
        return this.friendNames;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Boolean getAutoUpdateShowInClient() {
        return this.autoUpdateShowInClient;
    }

    public Set<Dependency> getModuleDependencies() {
        if (this.moduleDependencies != null) {
            return Dependency.create((int)1, (String)this.moduleDependencies);
        }
        return Collections.emptySet();
    }

    public static final class PackageExport {
        private final String pkg;
        private final boolean recursive;

        public PackageExport(String string, boolean bl) {
            this.pkg = string;
            this.recursive = bl;
        }

        public String getPackage() {
            return this.pkg;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "/**" : "") + "]";
        }
    }
}

