/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor.pastetype;

import java.awt.Dialog;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.pastetype.DnDImportPanel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class SchemaImportPasteType
extends PasteType {
    private final WSDLModel currModel;
    private final SchemaModel schemaModel;

    public SchemaImportPasteType(WSDLModel wSDLModel, SchemaModel schemaModel) {
        this.currModel = wSDLModel;
        this.schemaModel = schemaModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable paste() throws IOException {
        String string = this.validate(this.schemaModel, this.currModel);
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)new Exception(string)));
            return null;
        }
        String string2 = NameGenerator.getInstance().generateNamespacePrefix(null, this.currModel);
        DataObject dataObject = ActionHelper.getDataObject((Model)this.schemaModel);
        Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        DnDImportPanel dnDImportPanel = new DnDImportPanel();
        dnDImportPanel.setNamespace(this.schemaModel.getSchema().getTargetNamespace());
        dnDImportPanel.setProject(project);
        dnDImportPanel.setPrefix(string2);
        dnDImportPanel.setFileName(dataObject.getPrimaryFile());
        Set set = ((AbstractDocumentComponent)this.currModel.getDefinitions()).getPrefixes().keySet();
        dnDImportPanel.setPrefixes(set);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)dnDImportPanel, NbBundle.getMessage(SchemaImportPasteType.class, (String)"LBL_ConfirmSchemaDocDrop"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(SchemaImportPasteType.class), null);
        dnDImportPanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            string2 = dnDImportPanel.getPrefix();
            Import import_ = null;
            try {
                this.currModel.startTransaction();
                Utility.addNamespacePrefix(this.schemaModel.getSchema(), this.currModel, string2);
                import_ = Utility.addSchemaImport(this.schemaModel, this.currModel);
            }
            finally {
                if (this.currModel.isIntransaction()) {
                    this.currModel.endTransaction();
                }
            }
            if (import_ != null) {
                ActionHelper.selectNode((SchemaComponent)import_, this.currModel);
            }
        }
        return null;
    }

    private String validate(SchemaModel schemaModel, WSDLModel wSDLModel) {
        if (schemaModel.getState() != Model.State.VALID) {
            return NbBundle.getMessage(SchemaImportPasteType.class, (String)"ERRMSG_SchemaIsNotValid");
        }
        if (!Utility.canImport((Model)schemaModel, wSDLModel)) {
            return NbBundle.getMessage(SchemaImportPasteType.class, (String)"ERRMSG_ProjectNotReferenceable");
        }
        String string = schemaModel.getSchema().getTargetNamespace();
        if (string == null) {
            return NbBundle.getMessage(SchemaImportPasteType.class, (String)"ERRMSG_NoNamespace");
        }
        if (schemaModel.equals(wSDLModel)) {
            return NbBundle.getMessage(SchemaImportPasteType.class, (String)"ERRMSG_SameModel");
        }
        Definitions definitions = wSDLModel.getDefinitions();
        String string2 = definitions.getTargetNamespace();
        if (string != null && !"NO_NAME_SPACE".equals(string) && string2.equals(string)) {
            return NbBundle.getMessage(SchemaImportPasteType.class, (String)"ERRMSG_SameNamespace");
        }
        Types types = definitions.getTypes();
        if (types == null) {
            return null;
        }
        List list = types.getExtensibilityElements(WSDLSchema.class);
        for (WSDLSchema wSDLSchema : list) {
            SchemaModel schemaModel2 = wSDLSchema.getSchemaModel();
            Collection collection = schemaModel2.getSchema().getSchemaReferences();
            for (SchemaModelReference schemaModelReference : collection) {
                try {
                    SchemaModel schemaModel3 = schemaModelReference.resolveReferencedModel();
                    if (!schemaModel.equals(schemaModel3)) continue;
                    return NbBundle.getMessage(SchemaImportPasteType.class, (String)"ERRMSG_AlreadyRefd");
                }
                catch (CatalogModelException catalogModelException) {
                }
            }
        }
        return null;
    }
}

