/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELQName;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.WidgetEditCookie;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.AbstractWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDHandler;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PortTypeWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFactory;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetHelper;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.PortTypeNode;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.NewAction;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleWidget
extends AbstractWidget<Role>
implements DnDHandler {
    private PortTypeWidget mPortTypeWidget;
    private LabelWidget mLabelWidget;
    private boolean leftSided;
    private int GAP = 25;
    private WidgetAction editorAction;

    public RoleWidget(Scene scene, Role role, Lookup lookup) {
        super(scene, role, lookup);
        this.setBorder(BorderFactory.createEmptyBorder((int)10, (int)0));
        this.init();
    }

    private void init() {
        this.setMinimumSize(new Dimension(225, 0));
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)this.GAP));
        this.setOpaque(true);
        this.mLabelWidget = new LabelWidget(this.getScene(), this.getName());
        this.mLabelWidget.setAlignment(LabelWidget.Alignment.CENTER);
        this.mLabelWidget.setVerticalAlignment(LabelWidget.VerticalAlignment.CENTER);
        this.mLabelWidget.setBorder(WidgetConstants.EMPTY_2PX_BORDER);
        this.editorAction = ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new TextFieldInplaceEditor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setText(Widget widget, String string) {
                String string2 = null;
                if (string == null || string.trim().length() == 0) {
                    string2 = NbBundle.getMessage(RoleWidget.class, (String)"MSG_BlankRoleName", (Object)string);
                } else if (!Utils.isValidNCName((String)string)) {
                    string2 = NbBundle.getMessage(RoleWidget.class, (String)"MSG_InvalidRoleName", (Object)string);
                }
                if (string2 != null) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                PartnerLinkType partnerLinkType = RoleWidget.this.getPartnerLinkType();
                WSDLModel wSDLModel = partnerLinkType.getModel();
                Role role = (Role)RoleWidget.this.getWSDLComponent();
                if (role != null && string != null && string.equals(role.getName())) {
                    return;
                }
                try {
                    if (wSDLModel.startTransaction()) {
                        if (role == null) {
                            role = (Role)partnerLinkType.getModel().getFactory().create((WSDLComponent)partnerLinkType, BPELQName.ROLE.getQName());
                            if (partnerLinkType.getRole1() == null) {
                                partnerLinkType.setRole1(role);
                            } else if (partnerLinkType.getRole2() == null) {
                                partnerLinkType.setRole2(role);
                            }
                        }
                        role.setName(string);
                    }
                }
                finally {
                    wSDLModel.endTransaction();
                }
                if (role != null) {
                    ActionHelper.selectNode((WSDLComponent)role);
                }
            }

            public boolean isEnabled(Widget widget) {
                PartnerLinkType partnerLinkType = RoleWidget.this.getPartnerLinkType();
                if (partnerLinkType != null) {
                    return XAMUtils.isWritable((Model)partnerLinkType.getModel());
                }
                return false;
            }

            public String getText(Widget widget) {
                Role role = (Role)RoleWidget.this.getWSDLComponent();
                if (role == null) {
                    PartnerLinkType partnerLinkType = RoleWidget.this.getPartnerLinkType();
                    String string = partnerLinkType.getName() + "Role";
                    if (partnerLinkType.getRole1() != null && partnerLinkType.getRole1().getName().equals(string) || partnerLinkType.getRole2() != null && partnerLinkType.getRole2().getName().equals(string)) {
                        string = string + "1";
                    }
                    return string;
                }
                return role.getName();
            }
        }, null);
        this.mLabelWidget.setMinimumSize(new Dimension(225, 25));
        this.addChild((Widget)this.mLabelWidget);
        this.mLabelWidget.getActions().addAction(this.editorAction);
        this.setPortType();
        if (this.getWSDLComponent() != null) {
            this.getActions().addAction(((PartnerScene)this.getScene()).getDnDAction());
        }
        this.getActions().addAction((WidgetAction)new WidgetAction.Adapter(){

            public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
                if (widgetKeyEvent.getKeyCode() == 113 || widgetKeyEvent.getKeyCode() == 10) {
                    if (RoleWidget.this.editorAction == null || RoleWidget.this.mLabelWidget == null) {
                        return WidgetAction.State.REJECTED;
                    }
                    InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)RoleWidget.this.editorAction);
                    if (editorController.openEditor((Widget)RoleWidget.this.mLabelWidget)) {
                        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
                    }
                    return WidgetAction.State.CONSUMED;
                }
                return WidgetAction.State.REJECTED;
            }
        });
        this.getLookupContent().add((Object)new WidgetEditCookie(){

            public void edit() {
                InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)RoleWidget.this.editorAction);
                editorController.openEditor((Widget)RoleWidget.this.mLabelWidget);
            }

            public void close() {
                InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)RoleWidget.this.editorAction);
                editorController.closeEditor(false);
            }
        });
    }

    protected PartnerLinkType getPartnerLinkType() {
        PartnerLinkType partnerLinkType = (PartnerLinkType)this.getLookup().lookup(PartnerLinkType.class);
        return partnerLinkType;
    }

    private String getName() {
        Role role = (Role)this.getWSDLComponent();
        if (role == null) {
            return NbBundle.getMessage(RoleWidget.class, (String)"ROLEWIDGET_PLACE_HOLDER_ROLENAME");
        }
        return role.getName();
    }

    protected void setLeftSided(boolean bl) {
        this.leftSided = bl;
        if (this.mPortTypeWidget != null) {
            this.mPortTypeWidget.setRightSided(!this.leftSided);
        }
    }

    void refreshPortTypeWidget() {
        WidgetHelper.removeWidgetFromScene(this.getScene(), this.mPortTypeWidget);
        this.setPortType();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() == this.getWSDLComponent()) {
            if (propertyChangeEvent.getPropertyName() == "name") {
                this.mLabelWidget.setLabel(this.getName());
            }
            this.getScene().validate();
        } else if (propertyChangeEvent.getPropertyName().equals("portType") && propertyChangeEvent.getSource() instanceof Definitions) {
            PortType portType = (PortType)this.mPortTypeWidget.getWSDLComponent();
            if (portType != null && !portType.isInDocumentModel() && ((Role)this.getWSDLComponent()).getAttribute("portType") != null) {
                WidgetHelper.removeWidgetFromScene(this.getScene(), this.mPortTypeWidget);
                this.setPortType();
            }
            this.getScene().validate();
        }
    }

    private PortType getPortType() {
        try {
            NamedComponentReference namedComponentReference;
            Role role = (Role)this.getWSDLComponent();
            if (role != null && (namedComponentReference = role.getPortType()) != null) {
                return (PortType)namedComponentReference.get();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private void setPortType() {
        WidgetFactory widgetFactory = WidgetFactory.getInstance();
        PortType portType = this.getPortType();
        this.mPortTypeWidget = portType != null ? (PortTypeWidget)widgetFactory.getOrCreateWidget(this.getScene(), (WSDLComponent)portType, this.getLookup(), this) : (PortTypeWidget)widgetFactory.createWidget(this.getScene(), PortType.class, this.getLookup());
        this.mPortTypeWidget.setRightSided(!this.leftSided);
        this.addChild(this.mPortTypeWidget, 1);
    }

    @Override
    public void dragExit() {
        this.mPortTypeWidget.setDefaultBorder();
    }

    @Override
    public boolean dragOver(Point point, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
        Transferable transferable = widgetDropTargetDragEvent.getTransferable();
        if (transferable != null) {
            for (Node node : Utility.getNodes(transferable)) {
                if (!(node instanceof PortTypeNode)) continue;
                this.mPortTypeWidget.setHitPointBorder();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean drop(Point point, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
        Node[] nodeArray;
        int n;
        int n2;
        Transferable transferable = widgetDropTargetDropEvent.getTransferable();
        if (transferable != null && (n2 = 0) < (n = (nodeArray = Utility.getNodes(transferable)).length)) {
            Node node = nodeArray[n2];
            if (node instanceof PortTypeNode) {
                this.mPortTypeWidget.setDefaultBorder();
                this.setPortType((PortTypeNode)node);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPortType(PortTypeNode portTypeNode) {
        PortType portType = (PortType)portTypeNode.getWSDLComponent();
        if (((Role)this.getWSDLComponent()).getModel().startTransaction()) {
            try {
                ((Role)this.getWSDLComponent()).setPortType(((Role)this.getWSDLComponent()).createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class));
            }
            finally {
                ((Role)this.getWSDLComponent()).getModel().endTransaction();
            }
        }
        ActionHelper.selectNode((WSDLComponent)portType);
    }

    @Override
    public void expandForDragAndDrop() {
    }

    @Override
    public boolean isCollapsed() {
        return false;
    }

    @Override
    protected void updateActions(List<Action> list) {
        super.updateActions(list);
        ListIterator<Action> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Action action = listIterator.next();
            if (!(action instanceof NewAction)) continue;
            listIterator.remove();
        }
    }

    @Override
    protected Shape createSelectionShape() {
        int n = 25;
        if (this.mLabelWidget != null && this.mLabelWidget.getBounds() != null) {
            n = this.mLabelWidget.getBounds().height;
        }
        return new Rectangle2D.Double(this.getBounds().x, this.getBounds().y, this.getBounds().width, n + this.mPortTypeWidget.getLabelHeight() + this.GAP - 1);
    }

    protected void paintWidget() {
        Graphics2D graphics2D = this.getGraphics();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        if (this.getWSDLComponent() != null) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(1.0f));
        } else {
            graphics2D.setColor(Color.GRAY);
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{10.0f, 5.0f, 10.0f, 5.0f}, 0.0f);
            graphics2D.setStroke(basicStroke);
        }
        if (this.getState().isSelected()) {
            graphics2D.setColor(WidgetConstants.SELECTION_COLOR);
        }
        graphics2D.draw(this.createSelectionShape());
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    PortTypeWidget getPortTypeWidget() {
        return this.mPortTypeWidget;
    }
}

