/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.CycleFocusProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.DragOverSceneLayer;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ButtonAction;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.CollaborationsWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDAction;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDHandler;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ExpandableWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.FocusableWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.MessagesWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetHelper;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerScene
extends ObjectScene
implements ComponentListener,
DnDHandler,
PropertyChangeListener {
    private ButtonAction buttonAction;
    private WidgetAction selectAction;
    private DnDAction dndAction;
    private WidgetAction focusAction;
    private final WSDLModel model;
    private MessagesWidget messagesWidget;
    private CollaborationsWidget collaborationsWidget;
    private DragOverSceneLayer dragOverLayer;
    private Font defaultFont = new JLabel().getFont();
    private SelectProvider selectProvider;
    private PartnerSceneCycleFocusProviderAndSceneListener cycleFocusProviderAndSceneListener;
    private PartnerSceneCycleFocusProvider mycycleFocusProvider;
    private List<Widget> selectedWidgets;
    private PropertyChangeListener weakModelListener;
    private ComponentListener weakComponentListener;

    public PartnerScene(WSDLModel wSDLModel) {
        this.model = wSDLModel;
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_CHILDREN_AND_ITS_PARENTS);
        this.cycleFocusProviderAndSceneListener = new PartnerSceneCycleFocusProviderAndSceneListener();
        this.mycycleFocusProvider = new PartnerSceneCycleFocusProvider();
        this.buttonAction = new ButtonAction();
        this.selectProvider = new ObjectSelectProvider();
        this.selectAction = ActionFactory.createSelectAction((SelectProvider)this.selectProvider);
        this.dndAction = new DnDAction();
        this.focusAction = ActionFactory.createCycleFocusAction((CycleFocusProvider)this.mycycleFocusProvider);
        this.getActions().addAction(ActionFactory.createWheelPanAction());
        this.getPriorActions().addAction(this.focusAction);
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)new SelectProvider(){

            public void select(Widget widget, Point point, boolean bl) {
                PartnerScene.this.getView().requestFocusInWindow();
            }

            public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
                return true;
            }

            public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
                return true;
            }
        }));
        this.getActions().addAction((WidgetAction)this.buttonAction);
        this.getActions().addAction((WidgetAction)this.dndAction);
        this.addObjectSceneListener(this.cycleFocusProviderAndSceneListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_FOCUS_CHANGED, ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.selectedWidgets = new ArrayList<Widget>();
        this.dndAction.addPriorHandler(new FileDropDnDHandler());
    }

    protected void notifyAdded() {
        super.notifyAdded();
        this.weakModelListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.model);
        this.model.addPropertyChangeListener(this.weakModelListener);
        this.weakComponentListener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)this, (Object)this.model);
        this.model.addComponentListener(this.weakComponentListener);
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        if (this.weakModelListener != null) {
            this.model.removePropertyChangeListener(this.weakModelListener);
            this.weakModelListener = null;
        }
        if (this.weakComponentListener != null) {
            this.model.removeComponentListener(this.weakComponentListener);
            this.weakComponentListener = null;
        }
    }

    public WSDLModel getModel() {
        return this.model;
    }

    public SelectProvider getSelectProvider() {
        return this.selectProvider;
    }

    public ButtonAction getButtonAction() {
        return this.buttonAction;
    }

    public WidgetAction getSelectAction() {
        return this.selectAction;
    }

    public WidgetAction getDnDAction() {
        return this.dndAction;
    }

    public MessagesWidget getMessagesWidget() {
        if (this.messagesWidget == null) {
            this.messagesWidget = new MessagesWidget((Scene)this, this.model);
        }
        return this.messagesWidget;
    }

    public CollaborationsWidget getCollaborationsWidget() {
        if (this.collaborationsWidget == null) {
            this.collaborationsWidget = new CollaborationsWidget((Scene)this, this.model);
        }
        return this.collaborationsWidget;
    }

    public DragOverSceneLayer getDragOverLayer() {
        if (this.dragOverLayer == null) {
            this.dragOverLayer = new DragOverSceneLayer((Scene)this);
        }
        return this.dragOverLayer;
    }

    public void childrenAdded(ComponentEvent componentEvent) {
    }

    public void childrenDeleted(ComponentEvent componentEvent) {
    }

    public void valueChanged(ComponentEvent componentEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.model.getDefinitions()) {
            if (propertyChangeEvent.getPropertyName().equals("message")) {
                this.getMessagesWidget().updateContent(propertyChangeEvent);
            } else if (propertyChangeEvent.getPropertyName().equals("extensibilityElement")) {
                this.getCollaborationsWidget().updateContent(propertyChangeEvent);
            }
        }
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    @Override
    public void dragExit() {
        this.collaborationsWidget.dragExit();
        this.messagesWidget.dragExit();
    }

    @Override
    public boolean dragOver(Point point, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
        boolean bl;
        boolean bl2 = this.messagesWidget != null && this.messagesWidget.isVisible();
        boolean bl3 = bl = this.collaborationsWidget != null && this.collaborationsWidget.isVisible();
        if (bl2 && bl) {
            boolean bl4 = this.collaborationsWidget.isHitAt(this.collaborationsWidget.convertSceneToLocal(new Point(100, point.y)));
            if (bl4) {
                return this.collaborationsWidget.dragOver(point, widgetDropTargetDragEvent);
            }
            return this.messagesWidget.dragOver(point, widgetDropTargetDragEvent);
        }
        if (bl2) {
            return this.messagesWidget.dragOver(point, widgetDropTargetDragEvent);
        }
        if (bl) {
            return this.collaborationsWidget.dragOver(point, widgetDropTargetDragEvent);
        }
        return false;
    }

    @Override
    public boolean drop(Point point, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
        boolean bl;
        boolean bl2 = this.messagesWidget != null && this.messagesWidget.isVisible();
        boolean bl3 = bl = this.collaborationsWidget != null && this.collaborationsWidget.isVisible();
        if (bl2 && bl) {
            boolean bl4 = this.collaborationsWidget.isHitAt(this.collaborationsWidget.convertSceneToLocal(new Point(100, point.y)));
            if (bl4) {
                return this.collaborationsWidget.drop(point, widgetDropTargetDropEvent);
            }
            return this.messagesWidget.drop(point, widgetDropTargetDropEvent);
        }
        if (bl2) {
            return this.messagesWidget.drop(point, widgetDropTargetDropEvent);
        }
        if (bl) {
            return this.collaborationsWidget.drop(point, widgetDropTargetDropEvent);
        }
        return false;
    }

    @Override
    public void expandForDragAndDrop() {
        this.messagesWidget.expandForDragAndDrop();
        this.collaborationsWidget.expandForDragAndDrop();
    }

    @Override
    public boolean isCollapsed() {
        return this.messagesWidget.isCollapsed() || this.collaborationsWidget.isCollapsed();
    }

    public void userSelectionSuggested(Set<?> set, boolean bl) {
        boolean bl2 = false;
        for (Object object : set) {
            if (this.isObject(object)) continue;
            bl2 = true;
        }
        if (!bl2) {
            super.userSelectionSuggested(set, bl);
        }
        for (Widget widget : this.getSelectedWidgets()) {
            widget.setState(widget.getState().deriveSelected(false));
        }
        this.getSelectedWidgets().clear();
        this.validate();
    }

    protected List<Widget> getSelectedWidgets() {
        return this.selectedWidgets;
    }

    private class FileDropDnDHandler
    implements DnDHandler {
        public boolean dragOver(Point point, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            PasteType pasteType;
            Node node;
            DataObject dataObject;
            Node[] nodeArray;
            Transferable transferable = widgetDropTargetDragEvent.getTransferable();
            return transferable != null && (nodeArray = Utility.getNodes(transferable)).length == 1 && (dataObject = (DataObject)(node = nodeArray[0]).getLookup().lookup(DataObject.class)).getNodeDelegate().equals((Object)node) && (pasteType = Utility.getWSDLOrSchemaPasteType(dataObject, PartnerScene.this.model, true, true)) != null;
        }

        public boolean drop(Point point, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
            PasteType pasteType;
            Node node;
            DataObject dataObject;
            Node[] nodeArray;
            Transferable transferable = widgetDropTargetDropEvent.getTransferable();
            if (transferable != null && (nodeArray = Utility.getNodes(transferable)).length == 1 && (dataObject = (DataObject)(node = nodeArray[0]).getLookup().lookup(DataObject.class)).getNodeDelegate().equals((Object)node) && (pasteType = Utility.getWSDLOrSchemaPasteType(dataObject, PartnerScene.this.model, true, true)) != null) {
                try {
                    pasteType.paste();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        public void dragExit() {
        }

        public void expandForDragAndDrop() {
        }

        public boolean isCollapsed() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PartnerSceneCycleFocusProviderAndSceneListener
    implements ObjectSceneListener {
        public void focusChanged(ObjectSceneEvent objectSceneEvent, Object object, Object object2) {
            if (object2 == null) {
                return;
            }
            ObjectScene objectScene = objectSceneEvent.getObjectScene();
            if (objectScene instanceof PartnerScene) {
                PartnerScene partnerScene = (PartnerScene)objectScene;
                List list = objectScene.findWidgets(object2);
                Widget widget = objectScene.getFocusedWidget();
                if (widget != null) {
                    Rectangle rectangle;
                    if (list.contains(widget) && (rectangle = widget.getClientArea()) != null) {
                        rectangle = partnerScene.convertSceneToView(widget.convertLocalToScene(rectangle));
                        partnerScene.getView().scrollRectToVisible(rectangle);
                    }
                    if (!objectScene.getSelectedObjects().contains(object2)) {
                        objectScene.userSelectionSuggested(Collections.singleton(object2), false);
                    }
                }
            }
        }

        public void objectAdded(ObjectSceneEvent objectSceneEvent, Object object) {
        }

        public void objectRemoved(ObjectSceneEvent objectSceneEvent, Object object) {
        }

        public void highlightingChanged(ObjectSceneEvent objectSceneEvent, Set<Object> set, Set<Object> set2) {
        }

        public void hoverChanged(ObjectSceneEvent objectSceneEvent, Object object, Object object2) {
        }

        public void objectStateChanged(ObjectSceneEvent objectSceneEvent, Object object, ObjectState objectState, ObjectState objectState2) {
        }

        public void selectionChanged(ObjectSceneEvent objectSceneEvent, Set<Object> set, Set<Object> set2) {
            ObjectScene objectScene = objectSceneEvent.getObjectScene();
            Widget widget = objectScene.getFocusedWidget();
            Object object = objectScene.getFocusedObject();
            if (widget != null && widget != objectScene.findObject(widget)) {
                if (!set2.isEmpty()) {
                    Object object2 = set2.iterator().next();
                    Widget widget2 = objectScene.findWidget(object2);
                    if (widget2 != null) {
                        WidgetHelper.makeWidgetVisible(widget2);
                    }
                    objectScene.setFocusedWidget(widget2);
                    objectScene.setFocusedObject(object2);
                }
            } else if (!set2.isEmpty() && !set2.contains(object)) {
                objectScene.setFocusedObject(set2.iterator().next());
            }
        }
    }

    public static class PartnerSceneCycleFocusProvider
    implements CycleFocusProvider {
        public boolean switchPreviousFocus(Widget widget) {
            Scene scene = widget.getScene();
            return scene instanceof PartnerScene && this.switchFocus((PartnerScene)scene, false);
        }

        public boolean switchNextFocus(Widget widget) {
            Scene scene = widget.getScene();
            return scene instanceof PartnerScene && this.switchFocus((PartnerScene)scene, true);
        }

        private boolean switchFocus(PartnerScene partnerScene, boolean bl) {
            Widget widget = partnerScene.getFocusedWidget();
            Widget widget2 = null;
            if (bl) {
                if (widget == null) {
                    widget2 = this.getFirstFocusableWidget(partnerScene);
                } else {
                    widget2 = this.getNextFocusableWidget(widget);
                    if (widget2 == null) {
                        widget2 = this.getFirstFocusableWidget(partnerScene);
                    }
                }
            } else if (widget == null) {
                widget2 = this.getLastFocusableWidget(partnerScene);
            } else {
                widget2 = this.getPreviousFocusableWidget(widget);
                if (widget2 == null) {
                    widget2 = this.getLastFocusableWidget(partnerScene);
                }
            }
            if (widget2 != null) {
                partnerScene.setFocusedWidget(widget2);
                Object object = partnerScene.findObject(widget2);
                if (object != null && partnerScene.findWidgets(object).contains(widget2)) {
                    partnerScene.setFocusedObject(object);
                } else {
                    partnerScene.userSelectionSuggested(Collections.emptySet(), false);
                    widget2.setState(widget2.getState().deriveSelected(true));
                    partnerScene.getSelectedWidgets().add(widget2);
                    partnerScene.setFocusedObject(null);
                    partnerScene.setFocusedWidget(widget2);
                }
                return true;
            }
            return false;
        }

        private Widget getFirstFocusableWidget(PartnerScene partnerScene) {
            return this.getNextFocusableWidgetInChildren((Widget)partnerScene);
        }

        private Widget getNextFocusableWidget(Widget widget) {
            Widget widget2 = this.getNextFocusableWidgetInChildren(widget);
            if (widget2 == null) {
                widget2 = this.getNextFocusableWidgetInSiblings(widget);
            }
            if (widget2 != null) {
                return widget2;
            }
            return null;
        }

        private Widget getPreviousFocusableWidget(Widget widget) {
            return this.getPreviousFocusableWidgetInSiblings(widget);
        }

        private Widget getNextFocusableWidgetInSiblings(Widget widget) {
            if (widget == null) {
                return null;
            }
            Widget widget2 = null;
            Widget widget3 = widget.getParentWidget();
            if (widget3 != null) {
                List list = widget3.getChildren();
                int n = list.indexOf(widget);
                for (int i = n + 1; i < list.size(); ++i) {
                    Widget widget4 = (Widget)list.get(i);
                    if (widget4 instanceof FocusableWidget) {
                        if (!((FocusableWidget)widget4).isFocusable()) continue;
                        return widget4;
                    }
                    widget2 = this.getNextFocusableWidget((Widget)list.get(i));
                    if (widget2 != null) break;
                }
            }
            if (widget2 == null) {
                return this.getNextFocusableWidgetInSiblings(widget3);
            }
            return widget2;
        }

        private Widget getNextFocusableWidgetInChildren(Widget widget) {
            for (Widget widget2 : widget.getChildren()) {
                FocusableWidget focusableWidget;
                if (widget2 instanceof FocusableWidget && (focusableWidget = (FocusableWidget)widget2).isFocusable()) {
                    return widget2;
                }
                focusableWidget = this.getNextFocusableWidgetInChildren(widget2);
                if (focusableWidget == null) continue;
                return focusableWidget;
            }
            return null;
        }

        private Widget getLastFocusableWidget(PartnerScene partnerScene) {
            return this.getPreviousFocusableWidgetInChildren((Widget)partnerScene);
        }

        private Widget getPreviousFocusableWidgetInSiblings(Widget widget) {
            Widget widget2 = widget.getParentWidget();
            Widget widget3 = null;
            if (widget2 != null) {
                List list = widget2.getChildren();
                int n = list.indexOf(widget);
                for (int i = n - 1; i >= 0; --i) {
                    widget3 = this.getPreviousFocusableWidgetInChildren((Widget)list.get(i));
                    if (widget3 == null) continue;
                    return widget3;
                }
                if (widget2 instanceof FocusableWidget && ((FocusableWidget)widget2).isFocusable()) {
                    return widget2;
                }
                widget3 = this.getPreviousFocusableWidgetInSiblings(widget2);
                if (widget3 != null) {
                    return widget3;
                }
            }
            return null;
        }

        private Widget getPreviousFocusableWidgetInChildren(Widget widget) {
            if (widget == null) {
                return null;
            }
            Widget widget2 = null;
            List list = widget.getChildren();
            for (int i = list.size() - 1; i >= 0; --i) {
                Widget widget3 = (Widget)list.get(i);
                widget2 = this.getPreviousFocusableWidgetInChildren(widget3);
                if (widget2 != null) {
                    return widget2;
                }
                if (!(widget3 instanceof FocusableWidget) || !((FocusableWidget)widget3).isFocusable()) continue;
                return widget3;
            }
            if (widget instanceof FocusableWidget && ((FocusableWidget)widget).isFocusable()) {
                return widget;
            }
            return null;
        }
    }

    private class ObjectSelectProvider
    implements SelectProvider {
        private ObjectSelectProvider() {
        }

        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            return true;
        }

        public void select(Widget widget, Point point, boolean bl) {
            PartnerScene.this.getView().requestFocusInWindow();
            Object object = PartnerScene.this.findObject(widget);
            if (object != null) {
                if (!PartnerScene.this.findWidgets(object).contains(widget)) {
                    return;
                }
                if (PartnerScene.this.getSelectedObjects().contains(object)) {
                    return;
                }
                PartnerScene.this.userSelectionSuggested(Collections.singleton(object), bl);
                for (Widget widget2 = widget.getParentWidget(); widget2 != null; widget2 = widget2.getParentWidget()) {
                    if (!(widget2 instanceof ExpandableWidget)) continue;
                    ((ExpandableWidget)ExpandableWidget.class.cast(widget2)).expandWidget();
                    break;
                }
                WidgetHelper.makeWidgetVisible(widget);
                PartnerScene.this.setFocusedObject(object);
                PartnerScene.this.setFocusedWidget(widget);
                Rectangle rectangle = widget.getClientArea();
                if (rectangle != null) {
                    rectangle = widget.getScene().convertSceneToView(widget.convertLocalToScene(rectangle));
                    widget.getScene().getView().scrollRectToVisible(rectangle);
                }
            } else {
                PartnerScene.this.userSelectionSuggested(Collections.emptySet(), bl);
                widget.setState(widget.getState().deriveSelected(true));
                PartnerScene.this.getSelectedWidgets().add(widget);
            }
        }
    }
}

