/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ButtonWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ExpandableWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;

public class ExpanderWidget
extends ButtonWidget
implements ActionListener {
    private static final Image IMAGE_EXPAND = new BufferedImage(12, 12, 2);
    private static final Image IMAGE_COLLAPSE = new BufferedImage(12, 12, 2);
    private static Map<Object, Boolean> expandedCache = new WeakHashMap<Object, Boolean>();
    private ExpandableWidget expandable;
    private boolean isExpanded;

    public ExpanderWidget(Scene scene, ExpandableWidget expandableWidget, boolean bl) {
        super(scene, bl ? IMAGE_COLLAPSE : IMAGE_EXPAND);
        this.expandable = expandableWidget;
        this.isExpanded = bl;
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setActionListener(this);
        this.getActions().removeAction(((PartnerScene)scene).getSelectAction());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setExpanded(!this.isExpanded);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public static boolean isExpanded(ExpandableWidget expandableWidget, boolean bl) {
        Boolean bl2 = expandedCache.get(expandableWidget.hashKey());
        return bl2 != null ? bl2 : bl;
    }

    public void setExpanded(boolean bl) {
        if (!(this.isExpanded ^ bl)) {
            return;
        }
        expandedCache.put(this.expandable.hashKey(), bl);
        this.isExpanded = bl;
        this.setIcon(this.isExpanded ? IMAGE_COLLAPSE : IMAGE_EXPAND);
        if (this.isExpanded) {
            this.expandable.expandWidget(this);
        } else {
            this.expandable.collapseWidget(this);
        }
        this.getScene().validate();
    }

    static {
        Graphics2D graphics2D = ((BufferedImage)IMAGE_EXPAND).createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f = IMAGE_EXPAND.getWidth(null);
        float f2 = IMAGE_EXPAND.getHeight(null);
        float f3 = Math.min(f, f2) * 0.5f * 0.75f;
        GeneralPath generalPath = new GeneralPath();
        float f4 = (float)((double)f3 * Math.cos(Math.toRadians(-30.0)));
        float f5 = (float)((double)f3 * Math.sin(Math.toRadians(-30.0)));
        generalPath.moveTo(f4, f5);
        generalPath.lineTo(0.0f, f3);
        generalPath.lineTo(-f4, f5);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        graphics2D.translate(f / 2.0f, f2 / 2.0f);
        graphics2D.setPaint(new Color(0x888888));
        graphics2D.fill(generalPath);
        graphics2D = ((BufferedImage)IMAGE_COLLAPSE).createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        f = IMAGE_EXPAND.getWidth(null);
        f2 = IMAGE_EXPAND.getHeight(null);
        f3 = Math.min(f, f2) * 0.5f * 0.75f;
        generalPath = new GeneralPath();
        f4 = (float)((double)f3 * Math.cos(Math.toRadians(30.0)));
        f5 = (float)((double)f3 * Math.sin(Math.toRadians(30.0)));
        generalPath.moveTo(f4, f5);
        generalPath.lineTo(0.0f, -f3);
        generalPath.lineTo(-f4, f5);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        graphics2D.translate(f / 2.0f, f2 / 2.0f);
        graphics2D.setPaint(new Color(0x888888));
        graphics2D.fill(generalPath);
    }
}

