/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.DragOverSceneLayer;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.ZoomManager;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.CollaborationsWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.MessagesWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GraphView
extends JPanel {
    private PartnerScene scene;
    private WSDLModel mModel;
    private DragOverSceneLayer mDragLayer;
    private ZoomManager zoomer;
    private CollaborationsWidget collaborationsWidget;
    private MessagesWidget messagesWidget;
    private Widget contentWidget;
    private Widget middleWidget;
    private JScrollPane panel;
    private JToggleButton showHidePLTToggle;
    private JToggleButton showHideMessageToggle;

    public GraphView(WSDLModel wSDLModel) {
        super(new BorderLayout());
        this.mModel = wSDLModel;
        this.scene = new PartnerScene(this.mModel);
        this.scene.setBackground(Color.WHITE);
        this.zoomer = new ZoomManager((Scene)this.scene);
        JComponent jComponent = this.scene.createView();
        this.collaborationsWidget = this.scene.getCollaborationsWidget();
        this.messagesWidget = this.scene.getMessagesWidget();
        this.contentWidget = new Widget((Scene)this.scene);
        this.contentWidget.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.contentWidget.addChild((Widget)this.collaborationsWidget);
        this.middleWidget = new Widget((Scene)this.scene);
        this.middleWidget.setMinimumSize(new Dimension(700, 5));
        this.middleWidget.setBackground((Paint)Color.LIGHT_GRAY);
        this.middleWidget.setOpaque(true);
        this.contentWidget.addChild(this.middleWidget);
        this.contentWidget.addChild((Widget)this.messagesWidget);
        this.contentWidget.addDependency(new Widget.Dependency(){

            public void revalidateDependency() {
                if (GraphView.this.middleWidget == null) {
                    return;
                }
                Dimension dimension = GraphView.this.middleWidget.getMinimumSize();
                dimension.height = !GraphView.this.isCollaborationsShowing() || !GraphView.this.isMessagesShowing() ? 0 : 5;
                GraphView.this.middleWidget.setMinimumSize(dimension);
                if (GraphView.this.showHidePLTToggle != null) {
                    GraphView.this.showHidePLTToggle.setSelected(GraphView.this.isCollaborationsShowing());
                }
                if (GraphView.this.showHideMessageToggle != null) {
                    GraphView.this.showHideMessageToggle.setSelected(GraphView.this.isMessagesShowing());
                }
            }
        });
        this.scene.addChild(this.contentWidget);
        this.scene.addSceneListener(new Scene.SceneListener(){

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                int n = GraphView.this.panel.getViewport().getWidth();
                Rectangle rectangle = GraphView.this.contentWidget.getBounds();
                if (n <= ((GraphView)GraphView.this).scene.getBounds().width && rectangle != null && rectangle.width != n) {
                    GraphView.this.contentWidget.setMinimumSize(new Dimension(n, 0));
                    GraphView.this.scene.validate();
                }
            }
        });
        this.mDragLayer = this.scene.getDragOverLayer();
        this.scene.addChild((Widget)this.mDragLayer);
        this.scene.validate();
        this.panel = new JScrollPane(jComponent);
        this.panel.getVerticalScrollBar().setUnitIncrement(16);
        this.panel.getHorizontalScrollBar().setUnitIncrement(16);
        this.panel.setBorder(null);
        this.add((Component)this.panel, "Center");
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                int n;
                super.ancestorResized(hierarchyEvent);
                if (hierarchyEvent.getID() == 1402 && (n = GraphView.this.panel.getViewport().getWidth()) <= ((GraphView)GraphView.this).scene.getBounds().width) {
                    GraphView.this.contentWidget.setMinimumSize(new Dimension(n, 0));
                    GraphView.this.scene.validate();
                }
            }
        });
        this.getContent().putClientProperty("print.printable", Boolean.TRUE);
    }

    public void addToolbarActions(JToolBar jToolBar) {
        this.zoomer.addToolbarActions(jToolBar);
        jToolBar.addSeparator();
        Border border = UIManager.getBorder("nb.tabbutton.border");
        this.showHidePLTToggle = new JToggleButton(new ViewCollaborationsAction());
        this.showHidePLTToggle.setSelected(this.isCollaborationsShowing());
        this.showHidePLTToggle.setText(null);
        this.showHidePLTToggle.setRolloverEnabled(true);
        if (border != null) {
            this.showHidePLTToggle.setBorder(border);
        }
        jToolBar.add(this.showHidePLTToggle);
        this.showHideMessageToggle = new JToggleButton(new ViewMessagesAction());
        this.showHideMessageToggle.setSelected(this.isMessagesShowing());
        this.showHideMessageToggle.setText(null);
        this.showHideMessageToggle.setRolloverEnabled(true);
        if (border != null) {
            this.showHideMessageToggle.setBorder(border);
        }
        jToolBar.add(this.showHideMessageToggle);
    }

    public JComponent getContent() {
        return this.scene.getView();
    }

    public ZoomManager getZoomManager() {
        return this.zoomer;
    }

    public boolean isCollaborationsShowing() {
        return this.collaborationsWidget.isVisible();
    }

    public boolean isMessagesShowing() {
        return this.messagesWidget.isVisible();
    }

    public void requestFocus() {
        super.requestFocus();
        this.scene.getView().requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.scene.getView().requestFocusInWindow();
    }

    public void setCollaborationsVisible(boolean bl) {
        this.collaborationsWidget.setVisible(bl);
        this.scene.validate();
    }

    public void setMessagesVisible(boolean bl) {
        this.messagesWidget.setVisible(bl);
        this.scene.validate();
    }

    public void showComponent(org.netbeans.modules.xml.xam.Component component) {
        this.scene.userSelectionSuggested(Collections.singleton(component), false);
    }

    private class ViewMessagesAction
    extends AbstractAction
    implements Runnable {
        public ViewMessagesAction() {
            String string = NbBundle.getMessage(ViewMessagesAction.class, (String)"IMG_ViewMessagesAction");
            Image image = Utilities.loadImage((String)string);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            String string2 = NbBundle.getMessage(ViewCollaborationsAction.class, (String)"ACSN_ViewMessagesAction");
            this.putValue("Name", string2);
            this.putValue("ShortDescription", NbBundle.getMessage(ViewMessagesAction.class, (String)"LBL_ViewMessagesAction"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventQueue.invokeLater(this);
        }

        public void run() {
            GraphView.this.setMessagesVisible(!GraphView.this.isMessagesShowing());
        }
    }

    private class ViewCollaborationsAction
    extends AbstractAction
    implements Runnable {
        public ViewCollaborationsAction() {
            String string = NbBundle.getMessage(ViewCollaborationsAction.class, (String)"IMG_ViewCollaborationsAction");
            Image image = Utilities.loadImage((String)string);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            String string2 = NbBundle.getMessage(ViewCollaborationsAction.class, (String)"ACSN_ViewCollaborationsAction");
            this.putValue("Name", string2);
            this.putValue("ShortDescription", NbBundle.getMessage(ViewCollaborationsAction.class, (String)"LBL_ViewCollaborationsAction"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventQueue.invokeLater(this);
        }

        public void run() {
            GraphView.this.setCollaborationsVisible(!GraphView.this.isCollaborationsShowing());
        }
    }
}

