/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingOperationView
extends JPanel {
    public static final String ENABLE_OK = "ENABLE_OK";
    private Operation mSelectedOperation;
    private Collection<Operation> mOperations;
    private Object[] mSelectedOperations;
    private CommonMessagePanel commonMessagePanel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public BindingOperationView(Collection<Operation> collection) {
        this.mOperations = collection;
        this.initComponents();
        this.validateAll();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.commonMessagePanel1 = new CommonMessagePanel();
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        this.jList1.setModel(new DefaultComboBoxModel(this.getAllOperationNames()));
        this.jList1.setToolTipText(NbBundle.getMessage(BindingOperationView.class, (String)"BindingOperationView.jList1.toolTipText"));
        this.jList1.setName("jList1");
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BindingOperationView.this.jList1ValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingOperationView.class, (String)"BindingOperationView.jList1.toolTipText"));
        this.commonMessagePanel1.setName("commonMessagePanel1");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.commonMessagePanel1, -1, 318, Short.MAX_VALUE).add(2, (Component)this.jScrollPane1, -1, 318, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 194, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.commonMessagePanel1, -2, 55, -2).addContainerGap()));
    }

    private void jList1ValueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        if (!jList.getValueIsAdjusting()) {
            this.mSelectedOperations = this.jList1.getSelectedValues();
            this.validateAll();
        }
    }

    public Operation getSelectedOperation() {
        return this.mSelectedOperation;
    }

    public Operation[] getSelectedOperations() {
        Operation[] operationArray = new Operation[this.mSelectedOperations.length];
        int n = 0;
        for (Object object : this.mSelectedOperations) {
            OperationDelegate operationDelegate = (OperationDelegate)object;
            operationArray[n] = operationDelegate.getOperation();
            ++n;
        }
        return operationArray;
    }

    private Vector getAllOperationNames() {
        if (this.mOperations != null) {
            PortType portType = (PortType)this.mOperations.iterator().next().getParent();
            List<Operation> list = Utility.getOverloadedOperations(portType);
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = false;
            for (Operation object : list) {
                String string = Utility.getOperationSignature(object);
                if (!hashSet.contains(string)) {
                    hashSet.add(string);
                    continue;
                }
                bl = true;
                break;
            }
            Vector vector = new Vector(this.mOperations.size());
            for (Operation operation : this.mOperations) {
                boolean bl2 = list.contains(operation);
                OperationDelegate operationDelegate = new OperationDelegate(operation, bl2);
                vector.add(operationDelegate);
            }
            if (bl) {
                this.commonMessagePanel1.setErrorMessage(NbBundle.getMessage(BindingOperationView.class, (String)"MSG_ImproperlyOverloadedOperations"));
            }
            return vector;
        }
        return null;
    }

    private void validateAll() {
        boolean bl = this.isStateValid();
        this.firePropertyChange(ENABLE_OK, !bl, bl);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.validateAll();
    }

    public boolean isStateValid() {
        return this.commonMessagePanel1.isStateValid() && this.mSelectedOperations != null && this.mSelectedOperations.length > 0;
    }

    private class OperationDelegate {
        private Operation mOperation;
        private boolean isOverLoaded;

        OperationDelegate(Operation operation, boolean bl) {
            this.mOperation = operation;
            this.isOverLoaded = bl;
        }

        public Operation getOperation() {
            return this.mOperation;
        }

        public String toString() {
            if (this.isOverLoaded) {
                return Utility.getOperationSignature(this.mOperation);
            }
            return this.mOperation.getName();
        }
    }
}

