/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.api.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.api.property.MessageProvider;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    private static final String COLON = ":";

    public static String[] getAllPortTypes(WSDLModel wSDLModel, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("");
        }
        arrayList.addAll(PropertyUtil.getAllAvailablePortTypes(wSDLModel, wSDLModel));
        for (WSDLModel wSDLModel2 : Utility.getImportedDocuments(wSDLModel)) {
            arrayList.addAll(PropertyUtil.getAllAvailablePortTypes(wSDLModel, wSDLModel2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static List<String> getAllAvailablePortTypes(WSDLModel wSDLModel, WSDLModel wSDLModel2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Definitions definitions = wSDLModel2.getDefinitions();
        for (PortType portType : definitions.getPortTypes()) {
            String string = portType.getName();
            String string2 = wSDLModel2.getDefinitions().getTargetNamespace();
            String string3 = Utility.getNamespacePrefix(string2, wSDLModel);
            if (string == null) continue;
            if (string3 != null) {
                String string4 = string3 + COLON + string;
                arrayList.add(string4);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String[] getAllMessages(WSDLModel wSDLModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(PropertyUtil.getAllAvailableMessages(wSDLModel, wSDLModel));
        Collection<WSDLModel> collection = Utility.getImportedDocuments(wSDLModel);
        if (collection != null) {
            for (WSDLModel wSDLModel2 : collection) {
                arrayList.addAll(PropertyUtil.getAllAvailableMessages(wSDLModel, wSDLModel2));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static List<String> getAllAvailableMessages(WSDLModel wSDLModel, WSDLModel wSDLModel2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Definitions definitions = wSDLModel2.getDefinitions();
        for (Message message : definitions.getMessages()) {
            String string = message.getName();
            String string2 = definitions.getTargetNamespace();
            String string3 = Utility.getNamespacePrefix(string2, wSDLModel);
            if (string == null) continue;
            if (string3 != null) {
                String string4 = string3 + COLON + string;
                arrayList.add(string4);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String[] getAllBindings(WSDLModel wSDLModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.addAll(PropertyUtil.getAllBindings(wSDLModel, wSDLModel));
        for (WSDLModel wSDLModel2 : Utility.getImportedDocuments(wSDLModel)) {
            arrayList.addAll(PropertyUtil.getAllBindings(wSDLModel, wSDLModel2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static List<String> getAllBindings(WSDLModel wSDLModel, WSDLModel wSDLModel2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Definitions definitions = wSDLModel2.getDefinitions();
        for (Binding binding : definitions.getBindings()) {
            String string = binding.getName();
            String string2 = definitions.getTargetNamespace();
            String string3 = Utility.getNamespacePrefix(string2, wSDLModel);
            if (string == null) continue;
            if (string3 != null) {
                String string4 = string3 + COLON + string;
                arrayList.add(string4);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Message getMessage(MessageProvider messageProvider, WSDLModel wSDLModel) {
        String string;
        Message message = messageProvider.getWSDLMessage();
        if (message != null) {
            return message;
        }
        String string2 = messageProvider.getMessage();
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(COLON);
        String string3 = "";
        String string4 = string2;
        if (stringArray.length > 1) {
            string3 = stringArray[0];
            string4 = stringArray[1];
        }
        if ((string = Utility.getNamespaceURI(string3, wSDLModel)) != null) {
            return (Message)wSDLModel.findComponentByName(new QName(string, string4), Message.class);
        }
        return (Message)wSDLModel.findComponentByName(string4, Message.class);
    }
}

