/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.projects.jbi.anttasks.CasaBuilder;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Endpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceUnitDescriptorEnhancer {
    private static final String DISABLE_IN_BC = "disableInBC";
    private static final String CODEGEN = "codegen";
    private static final String ENDPOINT_CONFIG_NS = "http://www.sun.com/jbi/descriptor/config-endpoint";

    public static void decorateEndpoints(Document jbiDocument, Document casaDocument) {
        NodeList consumesNodeList = jbiDocument.getElementsByTagName("consumes");
        for (int i = 0; i < consumesNodeList.getLength(); ++i) {
            Element consumes = (Element)consumesNodeList.item(i);
            ServiceUnitDescriptorEnhancer.decorateEndpointElement(jbiDocument, consumes, casaDocument);
        }
        NodeList providesNodeList = jbiDocument.getElementsByTagName("provides");
        for (int i = 0; i < providesNodeList.getLength(); ++i) {
            Element provides = (Element)providesNodeList.item(i);
            ServiceUnitDescriptorEnhancer.decorateEndpointElement(jbiDocument, provides, casaDocument);
        }
    }

    private static void decorateEndpointElement(Document jbiDocument, Element jbiEndpointElement, Document casaDocument) {
        if (casaDocument == null) {
            return;
        }
        boolean isConsumes = jbiEndpointElement.getNodeName().equals("consumes");
        Endpoint endpoint = ServiceUnitDescriptorEnhancer.getEndpointInJBI(jbiEndpointElement);
        Element casaEndpointRefElement = CasaBuilder.getEndpointRefElement(casaDocument, endpoint, isConsumes);
        if (casaEndpointRefElement != null) {
            NodeList casaEndpointChildren = casaEndpointRefElement.getChildNodes();
            for (int k = 0; k < casaEndpointChildren.getLength(); ++k) {
                Node casaEndpointChild = casaEndpointChildren.item(k);
                if (!(casaEndpointChild instanceof Element)) continue;
                Element casaEndpointExtension = (Element)casaEndpointChild;
                String extName = casaEndpointExtension.getNodeName();
                String nsValue = casaEndpointExtension.getAttribute("xmlns");
                if (CODEGEN.equals(extName) && ENDPOINT_CONFIG_NS.equals(nsValue)) {
                    String disableInBCValue = casaEndpointExtension.getAttribute(DISABLE_IN_BC);
                    if (!"true".equalsIgnoreCase(disableInBCValue)) continue;
                    jbiEndpointElement.getParentNode().removeChild(jbiEndpointElement);
                    continue;
                }
                Node clonedNode = CasaBuilder.deepCloneCasaNode(casaEndpointChild, jbiDocument);
                jbiEndpointElement.appendChild(clonedNode);
            }
        }
    }

    private static Endpoint getEndpointInJBI(Element jbiEndpointElement) {
        String endpointName = jbiEndpointElement.getAttribute("endpoint-name");
        QName serviceQName = XmlUtil.getAttributeNSName((Element)jbiEndpointElement, (String)"service-name");
        QName interfaceQName = XmlUtil.getAttributeNSName((Element)jbiEndpointElement, (String)"interface-name");
        return new Endpoint(endpointName, serviceQName, interfaceQName);
    }
}

