/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.visualweb.ejb.ui.EjbDataSourcePropertiesPanel;
import org.netbeans.modules.visualweb.ejb.ui.EjbDataSourcesSelectionPanel;
import org.netbeans.modules.visualweb.ejb.ui.ImportEjbDataSourcesHelper;
import org.netbeans.modules.visualweb.ejb.ui.ImportExportFileChooser;
import org.netbeans.modules.visualweb.ejb.ui.PortableEjbDataSource;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportEjbDataSourcesPanel
extends JPanel {
    private EjbDataSourcesSelectionPanel ejbDataSourceSelectionPanel;
    private EjbDataSourcePropertiesPanel propsPanel;
    private PortableEjbDataSource[] ejbDataSources;
    private boolean textFieldChanged = false;
    private JButton browseButton;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JPanel filePanel;
    private JPanel propertiesPanel;
    private JPanel selectionPanel;
    private JLabel title;

    public ImportEjbDataSourcesPanel() {
        this.initComponents();
        this.propsPanel = new EjbDataSourcePropertiesPanel();
        this.ejbDataSourceSelectionPanel = new EjbDataSourcesSelectionPanel(this.propsPanel);
        this.selectionPanel.add((Component)this.ejbDataSourceSelectionPanel, "Center");
        this.propertiesPanel.add((Component)this.propsPanel, "Center");
        this.fileNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ImportEjbDataSourcesPanel.this.textFieldChanged = true;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ImportEjbDataSourcesPanel.this.textFieldChanged = true;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ImportEjbDataSourcesPanel.this.textFieldChanged = true;
            }
        });
    }

    public ImportEjbDataSourcesPanel(PortableEjbDataSource[] portableEjbDataSourceArray) {
        this();
    }

    public void setImportFilePath(String string) {
        this.fileNameTextField.setText(string);
    }

    public String getImportFilePath() {
        return this.fileNameTextField.getText().trim();
    }

    public void setEjbDataSources(PortableEjbDataSource[] portableEjbDataSourceArray) {
        this.ejbDataSources = portableEjbDataSourceArray;
        this.ejbDataSourceSelectionPanel.setEjbDataSources(portableEjbDataSourceArray);
    }

    public PortableEjbDataSource[] getEjbDataSources() {
        return this.ejbDataSources;
    }

    public boolean saveChange() {
        return this.propsPanel.saveChange();
    }

    private void initComponents() {
        this.title = new JLabel();
        this.selectionPanel = new JPanel();
        this.filePanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.browseButton = new JButton();
        this.propertiesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportEjbDataSourcesPanel.class, (String)"IMPORT_EJB_DATASOURCES"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportEjbDataSourcesPanel.class, (String)"IMPORT_EJB_DATASOURCES"));
        this.title.setLabelFor(this.selectionPanel);
        this.title.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IMPORT_EJB_DATASOURCES_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.title, gridBagConstraints);
        this.title.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IMPORT_EJB_DATASOURCES_LABEL"));
        this.title.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IMPORT_EJB_DATASOURCES"));
        this.selectionPanel.setLayout(new BorderLayout());
        this.selectionPanel.setBorder(new EmptyBorder(new Insets(5, 10, 10, 10)));
        this.selectionPanel.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.selectionPanel, gridBagConstraints);
        this.filePanel.setLayout(new BorderLayout(5, 1));
        this.filePanel.setBorder(new EmptyBorder(new Insets(5, 10, 10, 10)));
        this.fileNameLabel.setDisplayedMnemonic(NbBundle.getMessage(ImportEjbDataSourcesPanel.class, (String)"FILE_NAME_MNEMONIC").charAt(0));
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("FILE_NAME"));
        this.filePanel.add((Component)this.fileNameLabel, "West");
        this.fileNameLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IMPORT_FILE_NAME_DESC"));
        this.fileNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportEjbDataSourcesPanel.this.fileNameTextFieldActionPerformed(actionEvent);
            }
        });
        this.filePanel.add((Component)this.fileNameTextField, "Center");
        this.fileNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IMPORT_FILE_NAME_DESC"));
        this.browseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("BROWSE_IMPORT_FILE_BUTTON_MNEMONIC").charAt(0));
        this.browseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("BROWSE_IMPORT_FILE_BUTTON_LABEL"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportEjbDataSourcesPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.filePanel.add((Component)this.browseButton, "East");
        this.browseButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("BROWSE_IMPORT_FILE_BUTTON_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.add((Component)this.filePanel, gridBagConstraints);
        this.propertiesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 17, 0, 12);
        this.add((Component)this.propertiesPanel, gridBagConstraints);
    }

    private void fileNameTextFieldActionPerformed(ActionEvent actionEvent) {
        if (!new File(this.getImportFilePath()).exists()) {
            String string = NbBundle.getMessage(ImportEjbDataSourcesPanel.class, (String)"IMPORT_FILE_NOT_FOUND", (Object)this.getImportFilePath());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (!this.textFieldChanged) {
            return;
        }
        this.textFieldChanged = false;
        ImportExportFileChooser.setCurrentFilePath(this.getImportFilePath());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                PortableEjbDataSource[] portableEjbDataSourceArray = ImportEjbDataSourcesHelper.readDataSourceImports(ImportEjbDataSourcesPanel.this.getImportFilePath());
                if (portableEjbDataSourceArray == null) {
                    return;
                }
                ImportEjbDataSourcesPanel.this.setEjbDataSources(portableEjbDataSourceArray);
            }
        });
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        ImportExportFileChooser importExportFileChooser = new ImportExportFileChooser(this);
        String string = importExportFileChooser.getImportFile();
        if (string != null) {
            if (!new File(string).exists()) {
                String string2 = NbBundle.getMessage(ImportEjbDataSourcesPanel.class, (String)"IMPORT_FILE_NOT_FOUND", (Object)string);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            ImportExportFileChooser.setCurrentFilePath(string);
            this.fileNameTextField.setText(string);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    PortableEjbDataSource[] portableEjbDataSourceArray = ImportEjbDataSourcesHelper.readDataSourceImports(ImportEjbDataSourcesPanel.this.getImportFilePath());
                    if (portableEjbDataSourceArray == null) {
                        return;
                    }
                    ImportEjbDataSourcesPanel.this.setEjbDataSources(portableEjbDataSourceArray);
                }
            });
        }
    }
}

