/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbContainerVendor;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.ui.AddEjbGroupDialog;
import org.netbeans.modules.visualweb.ejb.ui.ClientJarFileListModel;
import org.netbeans.modules.visualweb.ejb.ui.JarFileFilter;
import org.netbeans.modules.visualweb.extension.openide.awt.JFileChooser_RAVE;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class EjbGroupPanel
extends JPanel {
    private static File DEFAULT_CURRENT_JAR_DIR_FILE = InstalledFileLocator.getDefault().locate("samples/ejb/client-jars", null, false);
    private boolean isNewCreation = true;
    private final ArrayList<ChangeListener> listeners = new ArrayList();
    private JButton addClientJarButton;
    private JPanel cleintJarButtonPanel;
    private JScrollPane clientJarScrollPane;
    private JLabel clientJarsLabel;
    private JList clientJarsList;
    private JComboBox containerTypeCombo;
    private JLabel containerTypeLabel;
    private JButton ddLocButton;
    private JLabel ddLocLabel1;
    private JLabel ddLocLabel2;
    private JTextField ddLocTextField;
    private JLabel groupNameLabel;
    private JTextField groupNameTextField;
    private JLabel iiopPortLabel;
    private JTextField iiopPortTextField;
    private JButton removeClientJarButton;
    private JLabel serverHostLabel;
    private JTextField serverHostTextField;

    public EjbGroupPanel(EjbGroup ejbGroup) {
        this.initComponents();
        this.setName(NbBundle.getMessage(EjbGroupPanel.class, (String)"ADD_EJB_GROUP"));
        this.containerTypeCombo.setModel(new DefaultComboBoxModel<String>(EjbContainerVendor.getContainerTypeNames()));
        ClientJarFileListModel clientJarFileListModel = new ClientJarFileListModel();
        this.groupNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                for (ChangeListener changeListener : EjbGroupPanel.this.listeners) {
                    changeListener.stateChanged(new ChangeEvent(EjbGroupPanel.this));
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                for (ChangeListener changeListener : EjbGroupPanel.this.listeners) {
                    changeListener.stateChanged(new ChangeEvent(EjbGroupPanel.this));
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                for (ChangeListener changeListener : EjbGroupPanel.this.listeners) {
                    changeListener.stateChanged(new ChangeEvent(EjbGroupPanel.this));
                }
            }
        });
        if (ejbGroup == null) {
            String string = EjbDataModel.getInstance().getAUniqueName("DeployedEjbApp");
            this.groupNameTextField.setText(string);
        } else {
            this.isNewCreation = false;
            this.groupNameTextField.setText(ejbGroup.getName());
            this.serverHostTextField.setText(ejbGroup.getServerHost());
            this.iiopPortTextField.setText(Integer.toString(ejbGroup.getIIOPPort()));
            this.containerTypeCombo.setSelectedItem(ejbGroup.getAppServerVendor());
            this.ddLocTextField.setText(ejbGroup.getDDLocationFile());
            Iterator iterator = ejbGroup.getClientJarFiles().iterator();
            while (iterator.hasNext()) {
                clientJarFileListModel.addJarFile((String)iterator.next());
            }
            this.removeClientJarButton.setEnabled(true);
        }
        this.clientJarsList.setModel(clientJarFileListModel);
    }

    public EjbGroupPanel() {
        this((EjbGroup)null);
    }

    public String getGroupName() {
        return this.groupNameTextField.getText().trim();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public ArrayList getClientJars() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.clientJarsList.getModel().getSize(); ++i) {
            arrayList.add(this.clientJarsList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    public String getDDLocationFile() {
        if (this.ddLocTextField.getText() != null && this.ddLocTextField.getText().trim().length() != 0) {
            return this.ddLocTextField.getText().trim();
        }
        return null;
    }

    public String getContainerType() {
        return (String)this.containerTypeCombo.getSelectedItem();
    }

    public String getServerHost() {
        return this.serverHostTextField.getText().trim();
    }

    public String getIIOPPort() {
        return this.iiopPortTextField.getText().trim();
    }

    public boolean validateData(StringBuffer stringBuffer) {
        boolean bl = true;
        if (this.getGroupName() == null || this.getGroupName().length() == 0) {
            if (bl) {
                this.groupNameTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"EMPTY_GROUP_NAME"));
            stringBuffer.append("\n");
        } else if (!this.isNewCreation && EjbDataModel.getInstance().getEjbGroup(this.getGroupName()) != null) {
            if (bl) {
                this.groupNameTextField.requestFocus();
                this.groupNameTextField.selectAll();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"NAME_NOT_UNIQUE", (Object)("'" + this.getGroupName() + "'")));
            stringBuffer.append("\n");
        }
        if (this.getContainerType() == null || this.getContainerType().length() == 0) {
            if (bl) {
                this.containerTypeCombo.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"EMPTY_APP_SERVER"));
            stringBuffer.append("\n");
        }
        if (this.getServerHost() == null || this.getServerHost().length() == 0) {
            if (bl) {
                this.serverHostTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"EMPTY_SERVER_HOST"));
            stringBuffer.append("\n");
        } else if (this.getServerHost().indexOf(32) != -1) {
            if (bl) {
                this.serverHostTextField.requestFocus();
                this.serverHostTextField.selectAll();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"SPACES_IN_SERVER_HOST", (Object)("'" + this.getServerHost() + "'")));
            stringBuffer.append("\n");
        }
        if (this.getIIOPPort() == null || this.getIIOPPort().length() == 0) {
            if (bl) {
                this.iiopPortTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"EMPTY_IIOP_PORT"));
            stringBuffer.append("\n");
        } else {
            try {
                int n = Integer.parseInt(this.getIIOPPort());
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    this.iiopPortTextField.requestFocus();
                    this.iiopPortTextField.selectAll();
                    bl = false;
                }
                stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"IIOP_PORT_NOT_NUMBER"));
                stringBuffer.append("\n");
            }
        }
        if (this.getClientJars() == null || this.getClientJars().size() == 0) {
            if (bl) {
                this.clientJarsList.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"EMPTY_CLIENT_JAR"));
            stringBuffer.append("\n");
        } else {
            for (String string : this.getClientJars()) {
                if (new File(string).exists()) continue;
                if (bl) {
                    this.clientJarsList.requestFocus();
                    bl = false;
                }
                stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"CLIENT_JAR_NOT_EXIST", (Object)string));
                stringBuffer.append("\n");
            }
        }
        if (this.getDDLocationFile() != null && this.getDDLocationFile().length() != 0 && !new File(this.getDDLocationFile()).exists()) {
            if (bl) {
                this.ddLocTextField.requestFocus();
                this.ddLocTextField.selectAll();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"DD_FILE_NOT_EXIST", (Object)this.getDDLocationFile()));
            stringBuffer.append("\n");
        }
        return bl;
    }

    private void initComponents() {
        this.groupNameLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.containerTypeLabel = new JLabel();
        this.containerTypeCombo = new JComboBox();
        this.serverHostLabel = new JLabel();
        this.serverHostTextField = new JTextField();
        this.iiopPortLabel = new JLabel();
        this.iiopPortTextField = new JTextField();
        this.ddLocLabel1 = new JLabel();
        this.ddLocLabel2 = new JLabel();
        this.ddLocTextField = new JTextField();
        this.ddLocButton = new JButton();
        this.clientJarsLabel = new JLabel();
        this.clientJarScrollPane = new JScrollPane();
        this.clientJarsList = new JList();
        this.cleintJarButtonPanel = new JPanel();
        this.addClientJarButton = new JButton();
        this.removeClientJarButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(510, 292));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EjbGroupPanel.class, (String)"ADD_EJB_GROUP"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EjbGroupPanel.class, (String)"ADD_EJB_GROUP"));
        this.groupNameLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"EJB_GROUP_NAME_MNEMONIC").charAt(0));
        this.groupNameLabel.setLabelFor(this.groupNameTextField);
        this.groupNameLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_LABEL"));
        this.groupNameLabel.setPreferredSize(new Dimension(20, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.groupNameLabel, gridBagConstraints);
        this.groupNameLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_DESC"));
        this.groupNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.groupNameTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 159;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 2, 0);
        this.add((Component)this.groupNameTextField, gridBagConstraints);
        this.groupNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_DESC"));
        this.containerTypeLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"APP_SERVER_LABEL1_MNEMONIC").charAt(0));
        this.containerTypeLabel.setLabelFor(this.containerTypeCombo);
        this.containerTypeLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("APP_SERVER_LABEL1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.containerTypeLabel, gridBagConstraints);
        this.containerTypeLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("APP_SERVER_DESC"));
        this.containerTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.containerTypeComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 159;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.containerTypeCombo, gridBagConstraints);
        this.containerTypeCombo.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("APP_SERVER_DESC"));
        this.serverHostLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"SERVER_HOST_MNEMONIC").charAt(0));
        this.serverHostLabel.setLabelFor(this.serverHostTextField);
        this.serverHostLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 49;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.serverHostLabel, gridBagConstraints);
        this.serverHostLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_DESC"));
        this.serverHostTextField.setText("localhost");
        this.serverHostTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.serverHostTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 159;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.serverHostTextField, gridBagConstraints);
        this.serverHostTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_DESC"));
        this.iiopPortLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"IIOP_PORT_MNEMONIC").charAt(0));
        this.iiopPortLabel.setLabelFor(this.iiopPortTextField);
        this.iiopPortLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 36;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.iiopPortLabel, gridBagConstraints);
        this.iiopPortLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_DESC"));
        this.iiopPortTextField.setText("3700");
        this.iiopPortTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.iiopPortTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 159;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.iiopPortTextField, gridBagConstraints);
        this.iiopPortTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_DESC"));
        this.ddLocLabel1.setDisplayedMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"DEPLOYMENT_DESCRIPTOR_LOCATION_MNEMONIC").charAt(0));
        this.ddLocLabel1.setLabelFor(this.ddLocTextField);
        this.ddLocLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("DEPLOYMENT_DESCRIPTOR_LOCATION_LABEL1"));
        this.ddLocLabel1.setDoubleBuffered(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.ddLocLabel1, gridBagConstraints);
        this.ddLocLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("DEPLOYMENT_DESCRIPTOR_LOCATION_DESC"));
        this.ddLocLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("DEPLOYMENT_DESCRIPTOR_LOCATION_LABEL2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.ddLocLabel2, gridBagConstraints);
        this.ddLocTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.ddLocTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.ddLocTextField, gridBagConstraints);
        this.ddLocTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("DEPLOYMENT_DESCRIPTOR_LOCATION_DESC"));
        this.ddLocButton.setMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"BROWSE_DD_BUTTON_MNEMONIC").charAt(0));
        this.ddLocButton.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("BROWSE_DD_BUTTON_LABEL"));
        this.ddLocButton.setActionCommand("Select");
        this.ddLocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.ddLocButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(12, 12, 0, 10);
        this.add((Component)this.ddLocButton, gridBagConstraints);
        this.ddLocButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("BROWSE_DD_BUTTON_DESC"));
        this.clientJarsLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"CLIENT_JAR_FILE_MNEMONIC").charAt(0));
        this.clientJarsLabel.setLabelFor(this.clientJarsList);
        this.clientJarsLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CLIENT_JAR_FILE_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipadx = 53;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.clientJarsLabel, gridBagConstraints);
        this.clientJarsLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CLIENT_JAR_DESC"));
        this.clientJarScrollPane.setMinimumSize(new Dimension(260, 60));
        this.clientJarScrollPane.setPreferredSize(new Dimension(260, 60));
        this.clientJarsList.setMaximumSize(new Dimension(500, 500));
        this.clientJarsList.setMinimumSize(new Dimension(260, 132));
        this.clientJarsList.setPreferredSize(new Dimension(100, 50));
        this.clientJarScrollPane.setViewportView(this.clientJarsList);
        this.clientJarsList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CLIENT_JAR_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.clientJarScrollPane, gridBagConstraints);
        this.cleintJarButtonPanel.setLayout(new GridLayout(2, 1, 0, 5));
        this.addClientJarButton.setMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"ADD_CLIENT_JAR_BUTTON_MNEMONIC").charAt(0));
        this.addClientJarButton.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("ADD_CLIENT_JAR_BUTTON_LABEL"));
        this.addClientJarButton.setActionCommand("Add");
        this.addClientJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.addClientJarButtonActionPerformed(actionEvent);
            }
        });
        this.cleintJarButtonPanel.add(this.addClientJarButton);
        this.addClientJarButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("ADD_CLIENT_JAR_BUTTON_DESC"));
        this.removeClientJarButton.setMnemonic(NbBundle.getMessage(EjbGroupPanel.class, (String)"REMOVE_CLIENT_JAR_BUTTON_MNEMONIC").charAt(0));
        this.removeClientJarButton.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("REMOVE_CLIENT_JAR_BUTTON_LABEL"));
        this.removeClientJarButton.setEnabled(false);
        this.removeClientJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbGroupPanel.this.removeClientJarButtonActionPerformed(actionEvent);
            }
        });
        this.cleintJarButtonPanel.add(this.removeClientJarButton);
        this.removeClientJarButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("REMOVE_CLIENT_JAR_BUTTON_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 10);
        this.add((Component)this.cleintJarButtonPanel, gridBagConstraints);
    }

    private void removeClientJarButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.clientJarsList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ClientJarFileListModel)this.clientJarsList.getModel()).removeElement(objectArray[i]);
        }
        if (this.clientJarsList.getModel().getSize() > 0) {
            this.removeClientJarButton.setEnabled(true);
        } else {
            this.removeClientJarButton.setEnabled(false);
        }
    }

    private void addClientJarButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = JFileChooser_RAVE.getJFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileFilter(new JarFileFilter(true));
        jFileChooser.setFileSelectionMode(0);
        File file = DEFAULT_CURRENT_JAR_DIR_FILE;
        jFileChooser.setCurrentDirectory(file);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ClientJarFileListModel clientJarFileListModel = (ClientJarFileListModel)this.clientJarsList.getModel();
                clientJarFileListModel.addJarFile(fileArray[i].getPath());
                if (i != 0) continue;
                DEFAULT_CURRENT_JAR_DIR_FILE = fileArray[i].getParentFile();
            }
        }
        if (this.clientJarsList.getModel().getSize() > 0) {
            this.removeClientJarButton.setEnabled(true);
        } else {
            this.removeClientJarButton.setEnabled(false);
        }
    }

    private void ddLocButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new JarFileFilter(false));
        jFileChooser.setFileSelectionMode(0);
        File file = null;
        if (this.getDDLocationFile() != null && this.getDDLocationFile().length() != 0) {
            file = new File(this.getDDLocationFile());
        }
        if (file == null) {
            file = DEFAULT_CURRENT_JAR_DIR_FILE;
        }
        jFileChooser.setCurrentDirectory(file);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.ddLocTextField.setText(file2.getAbsolutePath());
            DEFAULT_CURRENT_JAR_DIR_FILE = file2.getParentFile();
        }
    }

    private void ddLocTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void iiopPortTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void serverHostTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void containerTypeComboActionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        int n = EjbContainerVendor.getDefaultPort(string);
        this.iiopPortTextField.setText(Integer.toString(n));
    }

    private void groupNameTextFieldActionPerformed(ActionEvent actionEvent) {
    }
}

