/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.load.EjbLoader;
import org.netbeans.modules.visualweb.ejb.ui.ConfigureMethodsPanel;
import org.netbeans.modules.visualweb.ejb.ui.EjbGroupPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddEjbGroupDialog {
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_HELP_DISPLAYED = "WizardPanel_helpDisplayed";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private EjbWizardDescriptor wizardDescriptor;
    private Dialog dialog;
    private EjbGroupPanel addPanel = new EjbGroupPanel();
    private ConfigureMethodsPanel configureMethodsPanel;
    private EjbGroup ejbGroup;
    private EjbLoader ejbLoader;
    private boolean valid = true;
    private AddEjbsWizardPanel addWizardPanel = new AddEjbsWizardPanel();
    private ConfigureMethodWizardPanel configWizardPanel;

    public AddEjbGroupDialog() {
        this.addPanel.addChangeListener(this.addWizardPanel);
        this.configWizardPanel = new ConfigureMethodWizardPanel();
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{this.addWizardPanel, this.configWizardPanel};
        this.wizardDescriptor = new EjbWizardDescriptor(panelArray);
        this.wizardDescriptor.putProperty(PROP_AUTO_WIZARD_STYLE, Boolean.TRUE);
        this.wizardDescriptor.putProperty(PROP_CONTENT_DISPLAYED, Boolean.TRUE);
        this.wizardDescriptor.putProperty(PROP_CONTENT_NUMBERED, Boolean.TRUE);
        this.wizardDescriptor.putProperty(PROP_CONTENT_DATA, new String[]{NbBundle.getMessage(AddEjbGroupDialog.class, (String)"ADD_EJB_GROUP"), NbBundle.getMessage(AddEjbGroupDialog.class, (String)"CONFIGURE_METHODS")});
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.dialog.setTitle(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"ADD_EJB_GROUP"));
        this.dialog.setResizable(true);
        this.dialog.pack();
    }

    public void showDialog() {
        this.dialog.setVisible(true);
    }

    private String loadingEjbGroup() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.addPanel.validateData(stringBuffer)) {
            return stringBuffer.toString();
        }
        this.ejbGroup = new EjbGroup();
        this.ejbGroup.setName(this.addPanel.getGroupName());
        this.ejbGroup.setClientJarFiles(this.addPanel.getClientJars());
        this.ejbGroup.setAppServerVendor(this.addPanel.getContainerType());
        this.ejbGroup.setServerHost(this.addPanel.getServerHost());
        this.ejbGroup.setIIOPPort(Integer.parseInt(this.addPanel.getIIOPPort()));
        this.ejbGroup.setDDLocationFile(this.addPanel.getDDLocationFile());
        String string = this.checkClientJarInfo(this.ejbGroup);
        if (string != null) {
            return string;
        }
        try {
            this.ejbLoader = new EjbLoader(this.ejbGroup);
            this.ejbLoader.load();
            return null;
        }
        catch (EjbLoadException ejbLoadException) {
            String string2 = ejbLoadException.getMessage();
            if (ejbLoadException.getExceptionType() == 2) {
                string2 = NbBundle.getMessage(AddEjbGroupDialog.class, (String)"FAILED_TO_LOAD_EJBS", (Object)this.ejbGroup.getName());
            }
            return string2;
        }
    }

    private boolean createEjbGroup() {
        try {
            this.ejbLoader.createWrapperClientBeans();
            EjbDataModel.getInstance().addEjbGroup(this.ejbGroup);
            return true;
        }
        catch (EjbLoadException ejbLoadException) {
            String string = ejbLoadException.getMessage();
            if (ejbLoadException.getExceptionType() == 2) {
                string = NbBundle.getMessage(AddEjbGroupDialog.class, (String)"FAILED_TO_LOAD_EJBS", (Object)this.ejbGroup.getName());
            }
            if (ejbLoadException.getExceptionType() != 3) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return false;
        }
    }

    private String checkClientJarInfo(EjbGroup ejbGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : ejbGroup.getClientJarFileNames()) {
            EjbGroup ejbGroup2 = EjbDataModel.getInstance().findEjbGroupForJar(string);
            if (ejbGroup2 == null || ejbGroup2.getAppServerVendor().equals(ejbGroup.getAppServerVendor()) && ejbGroup2.getServerHost().equals(ejbGroup.getServerHost()) && ejbGroup2.getIIOPPort() == ejbGroup.getIIOPPort()) continue;
            stringBuffer.append(NbBundle.getMessage(AddEjbGroupDialog.class, (String)"MISMATCH_INFO_JAR", (Object)string, (Object)ejbGroup2.getName()));
            stringBuffer.append("\n");
        }
        if (stringBuffer.length() != 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private boolean checkColElemClasses() {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EjbInfo ejbInfo : this.ejbGroup.getSessionBeans()) {
            for (MethodInfo methodInfo : ejbInfo.getMethods()) {
                if (!methodInfo.isBusinessMethod() || methodInfo.isBusinessMethod() && !methodInfo.getReturnType().isCollection() || methodInfo.getReturnType().getElemClassName() != null) continue;
                arrayList.add(methodInfo.getName());
                bl = false;
            }
        }
        if (!bl) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("One or more collection element types are not specified: " + arrayList.toString()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return bl;
    }

    private class ConfigureMethodWizardPanel
    implements WizardDescriptor.ValidatingPanel,
    WizardDescriptor.FinishablePanel {
        public void addChangeListener(ChangeListener changeListener) {
        }

        public Component getComponent() {
            AddEjbGroupDialog.this.configureMethodsPanel = new ConfigureMethodsPanel(AddEjbGroupDialog.this.ejbGroup);
            AddEjbGroupDialog.this.configureMethodsPanel.putClientProperty(AddEjbGroupDialog.PROP_CONTENT_SELECTED_INDEX, new Integer(1));
            return AddEjbGroupDialog.this.configureMethodsPanel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object object) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void storeSettings(Object object) {
        }

        public void validate() throws WizardValidationException {
            AddEjbGroupDialog.this.configureMethodsPanel.getMethodDetailPanel().updateColElemClassName();
            AddEjbGroupDialog.this.configureMethodsPanel.getMethodDetailPanel().stopLastCellEditing();
            if (!AddEjbGroupDialog.this.checkColElemClasses()) {
                throw new WizardValidationException((JComponent)AddEjbGroupDialog.this.addPanel, "not valid", "not valid");
            }
            if (!AddEjbGroupDialog.this.createEjbGroup()) {
                throw new WizardValidationException((JComponent)AddEjbGroupDialog.this.addPanel, "not valid", "not valid");
            }
        }

        public boolean isFinishPanel() {
            return true;
        }
    }

    private class AddEjbsWizardPanel
    implements WizardDescriptor.ValidatingPanel,
    ChangeListener {
        private boolean valid = true;

        public void addChangeListener(ChangeListener changeListener) {
        }

        public Component getComponent() {
            AddEjbGroupDialog.this.addPanel.putClientProperty(AddEjbGroupDialog.PROP_CONTENT_SELECTED_INDEX, new Integer(0));
            return AddEjbGroupDialog.this.addPanel;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("projrave_ejb_howtoejbs_ejb_add_to_IDE");
        }

        public boolean isValid() {
            String string = AddEjbGroupDialog.this.addPanel.getGroupName();
            return string != null && EjbDataModel.getInstance().getEjbGroup(string) == null;
        }

        public void readSettings(Object object) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void storeSettings(Object object) {
        }

        public void validate() throws WizardValidationException {
            if (!this.isValid()) {
                String string = AddEjbGroupDialog.this.addPanel.getGroupName() != null ? AddEjbGroupDialog.this.addPanel.getGroupName() : "";
                String string2 = NbBundle.getMessage(AddEjbGroupDialog.class, (String)"NAME_NOT_UNIQUE", (Object)string);
                throw new WizardValidationException((JComponent)AddEjbGroupDialog.this.addPanel, string2, string2);
            }
            String string = AddEjbGroupDialog.this.loadingEjbGroup();
            if (string != null) {
                throw new WizardValidationException((JComponent)AddEjbGroupDialog.this.addPanel, NbBundle.getMessage(AddEjbGroupDialog.class, (String)"IMPORT_SET_ERROR"), string);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.isValid()) {
                this.valid = false;
                AddEjbGroupDialog.this.wizardDescriptor.updateNavigatingState();
                String string = AddEjbGroupDialog.this.addPanel.getGroupName() != null ? AddEjbGroupDialog.this.addPanel.getGroupName() : "";
                String string2 = NbBundle.getMessage(AddEjbGroupDialog.class, (String)"NAME_NOT_UNIQUE", (Object)string);
                AddEjbGroupDialog.this.wizardDescriptor.putProperty("WizardPanel_errorMessage", string2);
            } else if (!this.valid) {
                this.valid = true;
                AddEjbGroupDialog.this.wizardDescriptor.updateNavigatingState();
                AddEjbGroupDialog.this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            }
        }
    }

    private static class EjbWizardDescriptor
    extends WizardDescriptor {
        public EjbWizardDescriptor(WizardDescriptor.Panel[] panelArray) {
            super(panelArray);
        }

        public void updateNavigatingState() {
            super.updateState();
        }
    }
}

