/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbContainerVendor;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodReturn;
import org.netbeans.modules.visualweb.ejb.load.ClientBeanGenerator;
import org.netbeans.modules.visualweb.ejb.load.ClientBeanWrapperCompiler;
import org.netbeans.modules.visualweb.ejb.load.ClientBeanWrapperJarGenerator;
import org.netbeans.modules.visualweb.ejb.load.DataProviderGenerator;
import org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.load.EjbLoaderHelper;
import org.netbeans.modules.visualweb.ejb.load.EjbMethodFilter;
import org.netbeans.modules.visualweb.ejb.load.StdDeploymentDescriptorParser;
import org.netbeans.modules.visualweb.ejb.load.SunDeploymentDescriptorParser;
import org.netbeans.modules.visualweb.ejb.load.WeblogicDeploymentDescriptorParser;
import org.netbeans.modules.visualweb.ejb.load.WebsphereDeploymentDescriptorParser;
import org.netbeans.modules.visualweb.ejb.ui.ConfigureMethodsDialog;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.xml.sax.helpers.DefaultHandler;

public class EjbLoader {
    public static final String CLIENT_WRAPPER_PACKAGE_NAME = "org.netbeans.modules.visualweb.ejb";
    public static final String dataproviderJar = InstalledFileLocator.getDefault().locate("modules/ext/dataprovider.jar", null, false).getAbsolutePath();
    public static final String designTimeJar = InstalledFileLocator.getDefault().locate("modules/ext/designtime.jar", null, false).getAbsolutePath();
    public static final String designTimeBaseJar = InstalledFileLocator.getDefault().locate("modules/ext/designtime-base.jar", null, false).getAbsolutePath();
    public static final String propEditorsJar = InstalledFileLocator.getDefault().locate("modules/ext/editors.jar", null, false).getAbsolutePath();
    private EjbGroup ejbGroup;
    private URLClassLoader classloader;
    private String warningMsg;

    public EjbLoader(EjbGroup ejbGroup) {
        this.ejbGroup = ejbGroup;
    }

    public void load() throws EjbLoadException {
        DeploymentDescriptorExtractor deploymentDescriptorExtractor;
        Map map;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.ejbGroup.getClientJarFiles());
        if (this.ejbGroup.getDDLocationFile() != null) {
            arrayList.add(this.ejbGroup.getDDLocationFile());
        }
        if ((map = (deploymentDescriptorExtractor = new DeploymentDescriptorExtractor(arrayList)).getDeploymentDescriptors()).isEmpty()) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbLoader").log(16, "NO EJB deployment descriptors found");
            String string = EjbContainerVendor.getVendorDDFileName(this.ejbGroup.getAppServerVendor());
            String string2 = NbBundle.getMessage(EjbLoader.class, (String)"NO_DEPLOYMENT_DESCRIPTOR", (Object)string);
            throw new EjbLoadException(1, string2);
        }
        this.validateAppServerSelection(map);
        this.classloader = EjbLoaderHelper.getEjbGroupClassLoader(this.ejbGroup);
        this.setAllClazz(deploymentDescriptorExtractor.getAllClazz());
        this.populateBeanInfo(map);
        if (this.ejbGroup.getSessionBeans() == null || this.ejbGroup.getSessionBeans().isEmpty()) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbLoader").log(65536, "NO session EJBs found");
            String string = NbBundle.getMessage(EjbLoader.class, (String)"NO_SESSION_EJBS_FOUND");
            if (this.warningMsg != null) {
                string = string + " " + this.warningMsg;
            }
            throw new EjbLoadException(1, string);
        }
        if (this.warningMsg != null) {
            throw new EjbLoadException(3, this.warningMsg);
        }
    }

    public boolean reload() throws EjbLoadException {
        this.checkFileExistence();
        List<EjbInfo> list = this.ejbGroup.getSessionBeans();
        this.ejbGroup.setSessionBeans(null);
        this.ejbGroup.setEntityBeans(null);
        this.ejbGroup.setMDBs(null);
        this.ejbGroup.setAllClazz(new HashSet());
        this.load();
        if (this.ejbGroup.hasAnyConfigurableMethod()) {
            List<EjbInfo> list2 = this.ejbGroup.getSessionBeans();
            this.copyOverUserInputs(list, list2);
            ConfigureMethodsDialog configureMethodsDialog = new ConfigureMethodsDialog(this.ejbGroup, true);
            configureMethodsDialog.showDialog();
            if (configureMethodsDialog.isCancelled()) {
                return false;
            }
            this.ejbGroup = configureMethodsDialog.getEjbGroup();
            return true;
        }
        this.createWrapperClientBeans();
        return true;
    }

    private void copyOverUserInputs(Collection collection, Collection collection2) {
        HashMap<String, EjbInfo> hashMap = new HashMap<String, EjbInfo>();
        for (EjbInfo ejbInfo : collection) {
            hashMap.put(ejbInfo.getJNDIName(), ejbInfo);
        }
        for (EjbInfo ejbInfo : collection2) {
            EjbInfo ejbInfo2 = (EjbInfo)hashMap.get(ejbInfo.getJNDIName());
            if (ejbInfo2 == null) continue;
            this.copyOverMethodConfiguration(ejbInfo2.getMethods(), ejbInfo.getMethods());
        }
    }

    private void copyOverMethodConfiguration(ArrayList arrayList, ArrayList arrayList2) {
        HashMap<String, MethodInfo> hashMap = new HashMap<String, MethodInfo>();
        for (MethodInfo methodInfo : arrayList) {
            hashMap.put(methodInfo.getSignature(), methodInfo);
        }
        for (MethodInfo methodInfo : arrayList2) {
            MethodInfo methodInfo2;
            if (!methodInfo.isMethodConfigurable() || (methodInfo2 = (MethodInfo)hashMap.get(methodInfo.getSignature())) == null) continue;
            ArrayList arrayList3 = methodInfo.getParameters();
            ArrayList arrayList4 = methodInfo2.getParameters();
            for (int i = 0; i < arrayList3.size(); ++i) {
                MethodParam methodParam = (MethodParam)arrayList3.get(i);
                MethodParam methodParam2 = (MethodParam)arrayList4.get(i);
                methodParam.setName(methodParam2.getName());
            }
            if (!methodInfo.getReturnType().isCollection()) continue;
            MethodReturn methodReturn = methodInfo.getReturnType();
            methodReturn.setElemClassName(methodInfo2.getReturnType().getElemClassName());
        }
    }

    public EjbGroup getEjbGroup() {
        return this.ejbGroup;
    }

    private void setAllClazz(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf(36) == -1) continue;
            iterator.remove();
        }
        this.ejbGroup.setAllClazz(set);
    }

    private void populateBeanInfo(Map map) throws EjbLoadException {
        this.parseStdXmls(map.keySet());
        Map map2 = this.parseVendorXmls(map.values());
        for (EjbInfo ejbInfo : this.ejbGroup.getSessionBeans()) {
            String string = null;
            string = this.ejbGroup.isWebsphereAppServer() ? (String)map2.get(ejbInfo.getBeanId()) : (String)map2.get(ejbInfo.getEjbName());
            ejbInfo.setJNDIName(string);
            ejbInfo.setWebEjbRef(string);
        }
        this.populateBusinessMethods();
    }

    private void parseStdXmls(Collection collection) throws EjbLoadException {
        Object object;
        ArrayList arrayList = new ArrayList();
        for (String string : collection) {
            object = new StdDeploymentDescriptorParser(string);
            this.ejbGroup.addSessionBeans(((StdDeploymentDescriptorParser)object).parse());
            if (((StdDeploymentDescriptorParser)object).getSkippedEjbs() == null) continue;
            arrayList.addAll(((StdDeploymentDescriptorParser)object).getSkippedEjbs());
        }
        if (!arrayList.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object.next());
            }
            this.warningMsg = arrayList.size() == 1 ? NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"SKIP_NO_PACKAGE_EJB_SINGLE", (Object)stringBuffer.toString()) : NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"SKIP_NO_PACKAGE_EJBS", (Object)stringBuffer.toString());
        }
    }

    private Map parseVendorXmls(Collection collection) throws EjbLoadException {
        HashMap hashMap = new HashMap();
        for (String string : collection) {
            DefaultHandler defaultHandler;
            if (this.ejbGroup.isSunAppServer()) {
                defaultHandler = new SunDeploymentDescriptorParser(string);
                hashMap.putAll(((SunDeploymentDescriptorParser)defaultHandler).parse());
                continue;
            }
            if (this.ejbGroup.isWebLogicAppServer()) {
                defaultHandler = new WeblogicDeploymentDescriptorParser(string);
                hashMap.putAll(((WeblogicDeploymentDescriptorParser)defaultHandler).parse());
                continue;
            }
            if (!this.ejbGroup.isWebsphereAppServer()) continue;
            defaultHandler = new WebsphereDeploymentDescriptorParser(string);
            hashMap.putAll(((WebsphereDeploymentDescriptorParser)defaultHandler).parse());
        }
        return hashMap;
    }

    private void populateBusinessMethods() throws EjbLoadException {
        List<EjbInfo> list = this.ejbGroup.getSessionBeans();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EjbInfo ejbInfo = (EjbInfo)iterator.next();
            ArrayList arrayList = new ArrayList();
            String string = ejbInfo.getCompInterfaceName();
            try {
                arrayList.addAll(this.getBuzMethodInfos(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                iterator.remove();
                continue;
            }
            String string2 = ejbInfo.getHomeInterfaceName();
            arrayList.addAll(this.getCreateMethodInfos(string2));
            ejbInfo.setMethods(arrayList);
        }
        this.ejbGroup.setSessionBeans(list);
    }

    private ArrayList getBuzMethodInfos(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string, true, this.classloader);
            Method[] methodArray = clazz.getMethods();
            ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
            for (int i = 0; i < methodArray.length; ++i) {
                if (EjbMethodFilter.isEjbSpecMethod(methodArray[i])) continue;
                String string2 = methodArray[i].getName();
                MethodReturn methodReturn = this.createMethodReturn(methodArray[i].getReturnType());
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                ArrayList<MethodParam> arrayList2 = new ArrayList<MethodParam>();
                for (int j = 0; j < classArray.length; ++j) {
                    arrayList2.add(new MethodParam("arg" + j, Util.getTypeName(classArray[j])));
                }
                Class<?>[] classArray2 = methodArray[i].getExceptionTypes();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (int j = 0; j < classArray2.length; ++j) {
                    arrayList3.add(classArray2[j].getName());
                }
                arrayList.add(new MethodInfo(string2, string2, arrayList2, methodReturn, arrayList3));
            }
            return arrayList;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbLoader").log(1, "Remote interface (" + string + ") is not found in the client jars. Skipped.");
            throw classNotFoundException;
        }
    }

    private ArrayList getCreateMethodInfos(String string) throws EjbLoadException {
        try {
            Class<?> clazz = Class.forName(string, true, this.classloader);
            Method[] methodArray = clazz.getMethods();
            ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals("create")) continue;
                String string2 = methodArray[i].getName();
                MethodReturn methodReturn = this.createMethodReturn(methodArray[i].getReturnType());
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                ArrayList<MethodParam> arrayList2 = new ArrayList<MethodParam>();
                for (int j = 0; j < classArray.length; ++j) {
                    arrayList2.add(new MethodParam("arg" + j, classArray[j].getName()));
                }
                Class<?>[] classArray2 = methodArray[i].getExceptionTypes();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (int j = 0; j < classArray2.length; ++j) {
                    arrayList3.add(classArray2[j].getName());
                }
                arrayList.add(new MethodInfo(false, string2, string2, arrayList2, methodReturn, arrayList3));
            }
            return arrayList;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = "Error occurred when trying to get the method information. Cannot find class " + string;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbLoader").log(65536, string3);
            classNotFoundException.printStackTrace();
            throw new EjbLoadException(classNotFoundException.getMessage());
        }
    }

    private MethodReturn createMethodReturn(Class clazz) {
        MethodReturn methodReturn = new MethodReturn();
        if (Collection.class.isAssignableFrom(clazz)) {
            methodReturn.setIsCollection(true);
        } else {
            methodReturn.setIsCollection(false);
        }
        methodReturn.setClassName(Util.getTypeName(clazz));
        return methodReturn;
    }

    public void createWrapperClientBeans() throws EjbLoadException {
        Object object;
        Object object2;
        String string = this.getWrapperBeanSrcDir();
        if (this.classloader == null) {
            this.classloader = EjbLoaderHelper.getEjbGroupClassLoader(this.ejbGroup);
        }
        ArrayList arrayList = new ArrayList();
        for (EjbInfo cloneable2 : this.ejbGroup.getSessionBeans()) {
            object2 = new ClientBeanGenerator(cloneable2, this.classloader);
            arrayList.addAll(((ClientBeanGenerator)object2).generateClasses(string));
        }
        this.generateDPClasses(arrayList);
        ClientBeanWrapperCompiler clientBeanWrapperCompiler = new ClientBeanWrapperCompiler();
        ArrayList<String> arrayList2 = new ArrayList<String>(this.ejbGroup.getClientJarFiles());
        object2 = EjbLoaderHelper.getJavaEEClasspathEntries();
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object = (File)object3.next();
            String string2 = ((File)object).getAbsolutePath();
            arrayList2.add(string2);
        }
        arrayList2.add(dataproviderJar);
        arrayList2.add(designTimeJar);
        arrayList2.add(designTimeBaseJar);
        arrayList2.add(propEditorsJar);
        clientBeanWrapperCompiler.compile(string, arrayList, arrayList2);
        if (this.ejbGroup.getClientWrapperBeanJar() == null) {
            object3 = this.ejbGroup.getName().replaceAll(" ", "_") + "ClientWrapper.jar";
            object = string + File.separator + (String)object3;
            this.ejbGroup.setClientWrapperBeanJar((String)object);
        }
        if (this.ejbGroup.getDesignInfoJar() == null) {
            object3 = this.ejbGroup.getName().replaceAll(" ", "_") + "DesignTime.jar";
            object = string + File.separator + (String)object3;
            this.ejbGroup.setDesignInfoJar((String)object);
        }
        ClientBeanWrapperJarGenerator.jarThemUp(this.ejbGroup.getName(), this.ejbGroup, arrayList);
    }

    private void generateDPClasses(ArrayList arrayList) throws EjbLoadException {
        for (EjbInfo ejbInfo : this.ejbGroup.getSessionBeans()) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (MethodInfo methodInfo : ejbInfo.getMethods()) {
                if (!methodInfo.isBusinessMethod() || methodInfo.getReturnType().isVoid()) continue;
                String string = methodInfo.getName();
                Integer n = (Integer)hashMap.get(methodInfo.getName());
                if (n == null) {
                    n = new Integer(1);
                } else {
                    n = new Integer(n + 1);
                    string = string + n;
                }
                hashMap.put(methodInfo.getName(), n);
                methodInfo.setDataProvider(Util.getClassName(ejbInfo.getCompInterfaceName()) + Util.capitalize(string));
                DataProviderGenerator dataProviderGenerator = new DataProviderGenerator(ejbInfo.getBeanWrapperName(), methodInfo, this.classloader);
                arrayList.addAll(dataProviderGenerator.generateClasses(this.getWrapperBeanSrcDir()));
            }
        }
    }

    private String getWrapperBeanSrcDir() {
        File file = new File(Util.getEjbStateDir(), "ejb-datasource");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    private void validateAppServerSelection(Map map) throws EjbLoadException {
        String string = (String)map.values().iterator().next();
        boolean bl = false;
        if (this.ejbGroup.isSunAppServer() && string.indexOf("sun-ejb-jar") == -1 || this.ejbGroup.isWebLogicAppServer() && string.indexOf("weblogic-ejb-jar") == -1 || this.ejbGroup.isWebsphereAppServer() && string.indexOf("ibm-ejb-jar-bnd") == -1) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbLoader").log(65536, "Incorrect application server selected for EJB set: " + this.ejbGroup.getName());
            throw new EjbLoadException(1, NbBundle.getMessage(EjbLoader.class, (String)"WRONG_APP_SERVER_TYPE", (Object)this.ejbGroup.getAppServerVendor()));
        }
    }

    private void checkFileExistence() throws EjbLoadException {
        if (this.ejbGroup.getClientJarFiles() != null) {
            for (String string : this.ejbGroup.getClientJarFiles()) {
                if (new File(string).exists()) continue;
                String string2 = NbBundle.getMessage(EjbLoader.class, (String)"RELOAD_ERROR_FILE_NOT_FOUND", (Object)this.ejbGroup.getName(), (Object)string);
                throw new EjbLoadException(1, string2);
            }
        }
        if (this.ejbGroup.getDDLocationFile() != null && !new File(this.ejbGroup.getDDLocationFile()).exists()) {
            String string = NbBundle.getMessage(EjbLoader.class, (String)"RELOAD_ERROR_FILE_NOT_FOUND", (Object)this.ejbGroup.getName(), (Object)this.ejbGroup.getDDLocationFile());
            throw new EjbLoadException(1, string);
        }
    }
}

