/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.load.ClassDescriptor;
import org.netbeans.modules.visualweb.ejb.load.DataProviderBeanInfoGenerator;
import org.netbeans.modules.visualweb.ejb.load.DataProviderDesignInfoGenerator;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.util.Util;

public class DataProviderGenerator {
    private static String[] PRIMITIVE_TYPES = new String[]{"char", "byte", "short", "int", "long", "float", "double", "boolean"};
    private static String[] PRIMITIVE_WRAPPERS = new String[]{"java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean"};
    private String packageName;
    private String clientWrapperClassName;
    private MethodInfo methodInfo;
    private URLClassLoader classLoader;

    public DataProviderGenerator() {
    }

    public DataProviderGenerator(String string, MethodInfo methodInfo, URLClassLoader uRLClassLoader) {
        int n = string.lastIndexOf(46);
        this.packageName = string.substring(0, n);
        this.clientWrapperClassName = Util.getClassName(string);
        this.methodInfo = methodInfo;
        this.classLoader = uRLClassLoader;
    }

    public Collection generateClasses(String string) throws EjbLoadException {
        int n;
        ClassDescriptor[] classDescriptorArray = this.generateBeanClass(string, this.packageName);
        String string2 = classDescriptorArray[0].getPackageName() + "." + classDescriptorArray[0].getClassName();
        if (classDescriptorArray[0].getPackageName() == null || classDescriptorArray[0].getPackageName().length() == 0) {
            string2 = classDescriptorArray[0].getClassName();
        }
        DataProviderBeanInfoGenerator dataProviderBeanInfoGenerator = new DataProviderBeanInfoGenerator(string2, this.methodInfo, this.clientWrapperClassName);
        ClassDescriptor classDescriptor = dataProviderBeanInfoGenerator.generateClass(string);
        DataProviderDesignInfoGenerator dataProviderDesignInfoGenerator = new DataProviderDesignInfoGenerator(this.clientWrapperClassName, string2, this.methodInfo);
        ClassDescriptor[] classDescriptorArray2 = dataProviderDesignInfoGenerator.generateClass(string);
        ArrayList<ClassDescriptor> arrayList = new ArrayList<ClassDescriptor>();
        for (n = 0; n < classDescriptorArray.length; ++n) {
            arrayList.add(classDescriptorArray[n]);
        }
        arrayList.add(classDescriptor);
        for (n = 0; n < classDescriptorArray2.length; ++n) {
            arrayList.add(classDescriptorArray2[n]);
        }
        return arrayList;
    }

    public ClassDescriptor[] generateBeanClass(String string, String string2) throws EjbLoadException {
        File file = null;
        try {
            Object object;
            int n;
            Object object2;
            int n2;
            String string3 = this.methodInfo.getDataProvider();
            this.methodInfo.setDataProvider(string2 + "." + string3);
            String string4 = string2.replace('.', File.separatorChar);
            File file2 = new File(string + File.separator + string4);
            if (!file2.exists() && !file2.mkdirs()) {
                System.out.println(".....failed to make dir" + string + File.separator + string4);
            }
            String string5 = string3 + ".java";
            file = new File(file2, string5);
            file.createNewFile();
            ClassDescriptor classDescriptor = new ClassDescriptor(string3, string2, file.getAbsolutePath(), string4 + File.separator + string5);
            ClassDescriptor classDescriptor2 = new ClassDescriptor(string3 + "$ResultBean", string2, new File(file2, string3 + "$ResultBean.class").getAbsolutePath(), string4 + File.separator + string3 + "$ResultBean.class", true);
            String string6 = string2 + "." + string3;
            String string7 = string2 + "." + this.clientWrapperClassName;
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            if (string2 != null && string2.length() != 0) {
                printWriter.println("package " + string2 + ";");
                printWriter.println();
            }
            printWriter.println("/**");
            printWriter.println(" * Source code created on " + new Date());
            printWriter.println(" */");
            printWriter.println();
            String string8 = "com.sun.data.provider.impl.MethodResultTableDataProvider";
            printWriter.println("public class " + string3 + " extends " + string8 + " {");
            printWriter.println();
            String string9 = Util.decapitalize(this.clientWrapperClassName);
            printWriter.println("    protected " + string7 + " " + string9 + ";");
            printWriter.println("    // Properties. One per method parameter.");
            ArrayList arrayList = this.methodInfo.getParameters();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object2 = (MethodParam)arrayList.get(n2);
                printWriter.println("    protected " + ((MethodParam)object2).getType() + " " + ((MethodParam)object2).getName() + ";");
            }
            printWriter.println();
            printWriter.println("    // The EJB wrapper object");
            printWriter.println("    public " + string3 + "() {");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + string7 + " get" + this.clientWrapperClassName + "() {");
            printWriter.println("        return  this." + string9 + ";");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public void set" + this.clientWrapperClassName + "( " + this.clientWrapperClassName + " " + string9 + " ) { ");
            printWriter.println("        this." + string9 + " = " + string9 + ";");
            n2 = 0;
            if (this.methodInfo.getReturnType().isPrimitive() && !this.methodInfo.getReturnType().isCollection()) {
                n2 = 1;
                printWriter.println("        super.setDataClassInstance( this );");
                printWriter.println("        try { ");
                printWriter.println("            originalDataMethod = " + string7 + ".class.getMethod(");
                printWriter.println("                    \"" + this.methodInfo.getName() + "\", new Class[] {" + this.getMethodParamTypes() + "} );");
                printWriter.println("            super.setDataMethod( getWrapperMethod() ); ");
                printWriter.println("        }catch (java.lang.NoSuchMethodException ne) {");
                printWriter.println("            ne.printStackTrace();");
                printWriter.println("        }");
            } else {
                printWriter.println("        super.setDataClassInstance( " + string9 + ");");
                if (this.methodInfo.getReturnType().isCollection()) {
                    object2 = this.methodInfo.getReturnType().getElemClassName();
                    printWriter.println("        try {");
                    printWriter.println("            Class elemType = Class.forName( \"" + (String)object2 + "\");");
                    printWriter.println("            super.setCollectionElementType( elemType );");
                    printWriter.println("        } catch( java.lang.ClassNotFoundException ne ) {");
                    printWriter.println("            ne.printStackTrace();");
                    printWriter.println("        }");
                    printWriter.println();
                }
                printWriter.println("        try { ");
                printWriter.println("            super.setDataMethod( " + string7 + ".class.getMethod(");
                printWriter.println("                \"" + this.methodInfo.getName() + "\", new Class[] {" + this.getMethodParamTypes() + "} ) );");
                printWriter.println("        } catch( java.lang.NoSuchMethodException ne ) { ");
                printWriter.println("            ne.printStackTrace();");
                printWriter.println("        }");
            }
            printWriter.println("    }");
            printWriter.println();
            for (n = 0; n < arrayList.size(); ++n) {
                MethodParam methodParam = (MethodParam)arrayList.get(n);
                printWriter.println("    public " + methodParam.getType() + " get" + Util.capitalize(methodParam.getName()) + "() {");
                printWriter.println("        return " + methodParam.getName() + ";");
                printWriter.println("    }");
                printWriter.println();
                printWriter.println("    public void set" + Util.capitalize(methodParam.getName()) + "( " + methodParam.getType() + " " + methodParam.getName() + " ) { ");
                printWriter.println("        this." + methodParam.getName() + " = " + methodParam.getName() + ";");
                printWriter.println("    }");
                printWriter.println();
            }
            printWriter.println();
            if (n2 != 0) {
                printWriter.println("    private java.lang.Object[] getOriginalDataMethodArguments() {");
            } else {
                printWriter.println("    public java.lang.Object[] getDataMethodArguments() {");
            }
            n = this.methodInfo.getParameters() == null ? 0 : this.methodInfo.getParameters().size();
            printWriter.println("        try { ");
            printWriter.println("            java.lang.Object[] values = new java.lang.Object[" + n + "];");
            printWriter.println();
            for (int i = 0; i < n; ++i) {
                object = (MethodParam)this.methodInfo.getParameters().get(i);
                printWriter.println("            values[" + i + "] = " + this.convertPrimitiveType(((MethodParam)object).getName(), ((MethodParam)object).getType()) + ";");
            }
            printWriter.println("            return values;");
            printWriter.println("        } catch( java.lang.Exception e ) { ");
            printWriter.println("            e.printStackTrace();");
            printWriter.println("            return null; ");
            printWriter.println("        }");
            printWriter.println();
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public com.sun.data.provider.FieldKey[] getFieldKeys() throws com.sun.data.provider.DataProviderException {");
            printWriter.println("        com.sun.data.provider.FieldKey[] fieldKeys = super.getFieldKeys(); ");
            printWriter.println("        java.util.ArrayList finalKeys = new java.util.ArrayList(); ");
            printWriter.println("        for( int i = 0; i < fieldKeys.length; i ++ ) { ");
            printWriter.println("            if( !fieldKeys[i].getFieldId().equals( \"class\" ) )");
            printWriter.println("                finalKeys.add( fieldKeys[i] ); ");
            printWriter.println("        } ");
            printWriter.println("        return (com.sun.data.provider.FieldKey[])finalKeys.toArray( new com.sun.data.provider.FieldKey[0] ); ");
            printWriter.println("    } ");
            if (n2 != 0) {
                String string10 = this.methodInfo.getReturnType().getClassName();
                object = string6 + ".ResultBean";
                printWriter.println("");
                printWriter.println("    private java.lang.reflect.Method originalDataMethod; ");
                printWriter.println("");
                printWriter.println("    public " + (String)object + " invokeMethod() {");
                printWriter.println("        try { ");
                printWriter.println("            " + string10 + " result = (" + string10 + ")originalDataMethod.invoke(" + string9 + ", getOriginalDataMethodArguments()); ");
                printWriter.println("            " + (String)object + " methodResult = new " + (String)object + "(); ");
                printWriter.println("            methodResult.setMethodResult(result); ");
                printWriter.println("            return methodResult; ");
                printWriter.println("        }catch (java.lang.Exception ex) { ");
                printWriter.println("            ex.printStackTrace(); ");
                printWriter.println("            return null; ");
                printWriter.println("        }");
                printWriter.println("    } ");
                printWriter.println("");
                printWriter.println("    private java.lang.reflect.Method getWrapperMethod() throws java.lang.NoSuchMethodException {");
                printWriter.println("        return this.getClass().getMethod(\"invokeMethod\", new java.lang.Class[0]); ");
                printWriter.println("    } ");
                printWriter.println("");
                printWriter.println("    public static final class ResultBean { ");
                printWriter.println("        private " + string10 + " methodResult; ");
                printWriter.println("");
                printWriter.println("        public ResultBean() { ");
                printWriter.println("        } ");
                printWriter.println("");
                printWriter.println("        public " + string10 + " getMethodResult() { ");
                printWriter.println("            return this.methodResult; ");
                printWriter.println("        }");
                printWriter.println("");
                printWriter.println("        public void setMethodResult(" + string10 + " result) { ");
                printWriter.println("            this.methodResult = result; ");
                printWriter.println("        } ");
                printWriter.println("    } ");
            }
            printWriter.println("}");
            printWriter.flush();
            printWriter.close();
            if (n2 != 0) {
                return new ClassDescriptor[]{classDescriptor, classDescriptor2};
            }
            return new ClassDescriptor[]{classDescriptor};
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new EjbLoadException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new EjbLoadException(iOException.getMessage());
        }
    }

    private String convertPrimitiveType(String string, String string2) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            String string3 = PRIMITIVE_TYPES[i];
            if (string2 == null || !string3.equals(string2.trim())) continue;
            return PRIMITIVE_WRAPPERS[i] + ".valueOf(this." + string + ")";
        }
        return "this." + string;
    }

    private String getMethodParamTypes() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (this.methodInfo.getParameters() != null) {
            for (MethodParam methodParam : this.methodInfo.getParameters()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(methodParam.getType());
                stringBuffer.append(".class");
            }
        }
        return stringBuffer.toString();
    }

    private void addMethodComment(PrintWriter printWriter, String string) {
        printWriter.println("    /**");
        printWriter.println("     *" + string);
        printWriter.println("     */");
    }

    private boolean isIndexedDataProvider() {
        if (this.methodInfo.getReturnType().isCollection()) {
            return true;
        }
        return this.methodInfo.getReturnType().getClassName().indexOf("[]") != -1;
    }
}

