/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.load.ClassDescriptor;
import org.netbeans.modules.visualweb.ejb.load.ClientBeanInfoGenerator;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.openide.ErrorManager;

public class ClientBeanGenerator {
    private EjbInfo ejbInfo;
    private boolean autoInit = true;
    private URLClassLoader classLoader;
    private ArrayList virtualProperties;

    public ClientBeanGenerator(EjbInfo ejbInfo, URLClassLoader uRLClassLoader) {
        this.ejbInfo = ejbInfo;
        this.classLoader = uRLClassLoader;
        this.virtualProperties = new ArrayList();
    }

    public Collection generateClasses(String string) throws EjbLoadException {
        ClassDescriptor classDescriptor = this.generateBeanClasse(string);
        String string2 = classDescriptor.getPackageName() + "." + classDescriptor.getClassName();
        if (classDescriptor.getPackageName() == null || classDescriptor.getPackageName().length() == 0) {
            string2 = classDescriptor.getClassName();
        }
        this.ejbInfo.setBeanWrapperName(string2);
        ClientBeanInfoGenerator clientBeanInfoGenerator = new ClientBeanInfoGenerator(this.ejbInfo.getJNDIName(), string2, this.virtualProperties);
        ClassDescriptor classDescriptor2 = clientBeanInfoGenerator.generateClass(string);
        String string3 = classDescriptor2.getPackageName() + "." + classDescriptor2.getClassName();
        if (classDescriptor2.getPackageName() == null || classDescriptor2.getPackageName().length() == 0) {
            string3 = classDescriptor2.getClassName();
        }
        this.ejbInfo.setBeanInfoWrapperName(string3);
        ArrayList<ClassDescriptor> arrayList = new ArrayList<ClassDescriptor>();
        arrayList.add(classDescriptor);
        arrayList.add(classDescriptor2);
        return arrayList;
    }

    private ClassDescriptor generateBeanClasse(String string) throws EjbLoadException {
        File file = null;
        try {
            int n = this.ejbInfo.getCompInterfaceName().lastIndexOf(46);
            String string2 = this.ejbInfo.getCompInterfaceName().substring(n + 1);
            if (n == -1) {
                n = 0;
            }
            String string3 = this.ejbInfo.getCompInterfaceName().substring(0, n) + "." + string2.toLowerCase();
            String string4 = this.ejbInfo.getHomeInterfaceName().substring(this.ejbInfo.getHomeInterfaceName().lastIndexOf(46) + 1);
            String string5 = string2 + "Client";
            String string6 = string3.replace('.', File.separatorChar);
            File file2 = new File(string + File.separator + string6);
            if (!file2.exists() && !file2.mkdirs()) {
                System.out.println(".....failed to make dir" + string + File.separator + string6);
            }
            String string7 = string5 + ".java";
            file = new File(file2, string7);
            file.createNewFile();
            ClassDescriptor classDescriptor = new ClassDescriptor(string5, string3, file.getAbsolutePath(), string6 + File.separator + string7);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            if (string3 != null && string3.length() != 0) {
                printWriter.println("package " + string3 + ";");
                printWriter.println();
            }
            printWriter.println("/**");
            printWriter.println(" * Source code created on " + new Date());
            printWriter.println(" */");
            printWriter.println();
            if (this.ejbInfo.getCompInterfaceName().indexOf(46) != -1) {
                printWriter.println("import " + this.ejbInfo.getCompInterfaceName() + ";");
            }
            if (this.ejbInfo.getHomeInterfaceName().indexOf(46) != -1) {
                printWriter.println("import " + this.ejbInfo.getHomeInterfaceName() + ";");
            }
            printWriter.println();
            printWriter.println("public class " + string5 + " implements java.io.Serializable {");
            printWriter.println();
            String string8 = string2.toLowerCase();
            String string9 = string4.toLowerCase();
            printWriter.println("    private " + string2 + " " + string8 + ";");
            printWriter.println("    private " + string4 + " " + string9 + ";");
            printWriter.println("    private boolean initialized = false;");
            printWriter.println();
            printWriter.println("    public " + string5 + "() {");
            printWriter.println("    }");
            printWriter.println();
            this.createInitMethod(printWriter, string9, string4, string8);
            for (MethodInfo methodInfo : this.ejbInfo.getMethods()) {
                if (!methodInfo.isBusinessMethod()) continue;
                this.virtualPropertyOrNot(methodInfo);
                printWriter.println("    /**");
                printWriter.println("     * @see " + this.javaDocMethod(this.ejbInfo.getCompInterfaceName(), methodInfo));
                printWriter.println("     */");
                printWriter.println("    " + this.methodSignature(methodInfo) + " {");
                printWriter.println("        if( java.beans.Beans.isDesignTime() ) { ");
                if (methodInfo.getReturnType().getClassName().equals("void")) {
                    printWriter.println("            return;");
                } else {
                    printWriter.println("            return " + this.fakeReturnValue(methodInfo) + ";");
                }
                printWriter.println("        }");
                printWriter.println();
                if (this.autoInit) {
                    printWriter.println("        create();");
                } else {
                    printWriter.println("        if( initialized == false ) { ");
                    printWriter.println("            throw new java.lang.RuntimeException( \"Bean not initialized\" );");
                    printWriter.println("        }");
                }
                printWriter.println("        " + this.invokeMethodStatement(string8, methodInfo) + ";");
                printWriter.println("    }");
                printWriter.println();
            }
            printWriter.println("}");
            printWriter.flush();
            printWriter.close();
            return classDescriptor;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string10 = "Error occurred when trying to generate the wrapper bean class for EJB " + this.ejbInfo.getJNDIName() + ". Could not find file " + file.getAbsolutePath();
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.ClientBeanGenerator").log(string10);
            fileNotFoundException.printStackTrace();
            throw new EjbLoadException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            String string11 = "Error occurred when trying to generate the wrapper bean class for EJB " + this.ejbInfo.getJNDIName() + ". Could not create file " + file.getAbsolutePath();
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.ClientBeanGenerator").log(string11);
            iOException.printStackTrace();
            throw new EjbLoadException(iOException.getMessage());
        }
    }

    private void virtualPropertyOrNot(MethodInfo methodInfo) {
        String string = methodInfo.getName();
        if (string.startsWith("get") && !methodInfo.getReturnType().getClassName().equals("void") && methodInfo.getParameters().size() == 0) {
            this.virtualProperties.add(string.substring(3));
        }
    }

    private void createInitMethod(PrintWriter printWriter, String string, String string2, String string3) {
        for (MethodInfo methodInfo : this.ejbInfo.getMethods()) {
            if (methodInfo.isBusinessMethod()) continue;
            ArrayList arrayList = methodInfo.getParameters();
            if (arrayList.size() != 0) {
                this.autoInit = false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < arrayList.size(); ++i) {
                MethodParam methodParam = (MethodParam)arrayList.get(i);
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(methodParam.getType());
                stringBuffer.append(" ");
                stringBuffer.append(methodParam.getName());
            }
            printWriter.println("    /**");
            printWriter.println("     * @see " + this.javaDocMethod(this.ejbInfo.getHomeInterfaceName(), methodInfo));
            printWriter.println("     */");
            printWriter.println("    public void create(" + stringBuffer + ") throws javax.naming.NamingException, java.rmi.RemoteException, javax.ejb.CreateException {");
            printWriter.println("        if( !java.beans.Beans.isDesignTime() && !initialized ) { ");
            printWriter.println("            javax.naming.InitialContext ctx = new javax.naming.InitialContext();");
            printWriter.println("            Object objRef = ctx.lookup( \"java:comp/env/" + this.ejbInfo.getWebEjbRef() + "\" );");
            printWriter.println("            " + string + " = (" + string2 + ")javax.rmi.PortableRemoteObject.narrow( objRef, " + string2 + ".class );");
            printWriter.println("            " + string3 + " = " + this.invokeMethod(string, methodInfo) + ";");
            printWriter.println("            initialized = true;");
            printWriter.println("        }");
            printWriter.println("    }");
            printWriter.println();
        }
    }

    private String fakeReturnValue(MethodInfo methodInfo) throws EjbLoadException {
        String string = "null";
        String string2 = methodInfo.getReturnType().getClassName();
        if (string2.equals("int") || string2.equals("long") || string2.equals("double") || string2.equals("float") || string2.equals("short") || string2.equals("byte")) {
            return "0";
        }
        if (string2.equals("boolean")) {
            return "false";
        }
        if (string2.equals("char")) {
            return "'A'";
        }
        if (string2.indexOf("[]") != -1) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2, true, this.classLoader);
            if (clazz == String.class) {
                return "\"ABC\"";
            }
            if (clazz == Collection.class) {
                return "new java.util.ArrayList()";
            }
            if (clazz == Set.class) {
                return "new java.util.HashSet()";
            }
            return "null";
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = "Error occurred when trying to generate wrapper bean class for EJB " + this.ejbInfo.getJNDIName() + ". Could not find class " + methodInfo.getReturnType().getClassName();
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.ClientBeanGenerator").log(65536, string3);
            classNotFoundException.printStackTrace();
            throw new EjbLoadException(classNotFoundException.getMessage());
        }
    }

    private String javaDocMethod(String string, MethodInfo methodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "#");
        stringBuffer.append(methodInfo.getName());
        stringBuffer.append("(");
        ArrayList arrayList = methodInfo.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodParam methodParam = (MethodParam)arrayList.get(i);
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(methodParam.getType());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String methodSignature(MethodInfo methodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public ");
        stringBuffer.append(methodInfo.getReturnType().getClassName());
        stringBuffer.append(" ");
        stringBuffer.append(methodInfo.getName());
        stringBuffer.append("(");
        ArrayList arrayList = methodInfo.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodParam methodParam = (MethodParam)arrayList.get(i);
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(methodParam.getType());
            stringBuffer.append(" ");
            stringBuffer.append(methodParam.getName());
        }
        stringBuffer.append(")");
        ArrayList arrayList2 = methodInfo.getExceptions();
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            stringBuffer.append(" throws ");
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)arrayList2.get(i));
            }
        }
        if (this.autoInit) {
            stringBuffer.append(",");
            stringBuffer.append("javax.naming.NamingException, javax.ejb.CreateException");
        }
        return stringBuffer.toString();
    }

    private String invokeMethodStatement(String string, MethodInfo methodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!methodInfo.getReturnType().getClassName().equals("void")) {
            stringBuffer.append("return ");
        }
        stringBuffer.append("this.");
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(methodInfo.getName());
        stringBuffer.append("(");
        ArrayList arrayList = methodInfo.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodParam methodParam = (MethodParam)arrayList.get(i);
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(methodParam.getName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String invokeMethod(String string, MethodInfo methodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("this.");
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(methodInfo.getName());
        stringBuffer.append("(");
        ArrayList arrayList = methodInfo.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodParam methodParam = (MethodParam)arrayList.get(i);
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(methodParam.getName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        Integer n = new Integer(0);
        Class<?> clazz = n.getClass();
    }
}

