/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfpath.platform.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.platform.JavaPlatform;
import org.netbeans.modules.gsfpath.api.platform.JavaPlatformManager;
import org.netbeans.modules.gsfpath.api.queries.SourceForBinaryQuery;
import org.netbeans.modules.gsfpath.spi.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class PlatformSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private static final String JAR_FILE = "jar:file:";
    private static final String RTJAR_PATH = "/jre/lib/rt.jar!/";
    private static final String SRC_ZIP = "/src.zip";
    private Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        SourceForBinaryQuery.Result result = this.cache.get(uRL);
        if (result != null) {
            return result;
        }
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        for (JavaPlatform javaPlatform : javaPlatformManager.getInstalledPlatforms()) {
            for (ClassPath.Entry entry : javaPlatform.getBootstrapLibraries().entries()) {
                if (!entry.getURL().equals(uRL)) continue;
                result = new Result(javaPlatform);
                this.cache.put(uRL, result);
                return result;
            }
        }
        String string = uRL.toExternalForm();
        if (string.startsWith(JAR_FILE) && string.endsWith(RTJAR_PATH)) {
            String string2 = string.substring(4, string.length() - RTJAR_PATH.length()) + SRC_ZIP;
            try {
                JavaPlatform javaPlatform;
                URL uRL2 = FileUtil.getArchiveRoot((URL)new URL(string2));
                javaPlatform = URLMapper.findFileObject((URL)uRL2);
                if (javaPlatform != null) {
                    return new UnregisteredPlatformResult((FileObject)javaPlatform);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return null;
    }

    private static class UnregisteredPlatformResult
    implements SourceForBinaryQuery.Result {
        private FileObject srcRoot;

        private UnregisteredPlatformResult(FileObject fileObject) {
            assert (fileObject != null);
            this.srcRoot = fileObject;
        }

        public FileObject[] getRoots() {
            FileObject[] fileObjectArray;
            if (this.srcRoot.isValid()) {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = this.srcRoot;
            } else {
                fileObjectArray = new FileObject[]{};
            }
            return fileObjectArray;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private JavaPlatform platform;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public Result(JavaPlatform javaPlatform) {
            this.platform = javaPlatform;
            this.platform.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)javaPlatform));
        }

        public FileObject[] getRoots() {
            ClassPath classPath = this.platform.getSourceFolders();
            return classPath.getRoots();
        }

        public void addChangeListener(ChangeListener changeListener) {
            assert (changeListener != null) : "Listener can not be null";
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            assert (changeListener != null) : "Listener can not be null";
            this.cs.removeChangeListener(changeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("sourceFolders".equals(propertyChangeEvent.getPropertyName())) {
                this.cs.fireChange();
            }
        }
    }
}

