/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.simple.extend.URLUTF8Encoder;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.FormFieldState;

public abstract class FormField {
    private XhtmlForm _parentForm;
    private Element _element;
    private FormFieldState _originalState;
    private JComponent _component;

    public FormField(Element e, XhtmlForm form) {
        this._element = e;
        this._parentForm = form;
        this.initialize();
    }

    protected Element getElement() {
        return this._element;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public XhtmlForm getParentForm() {
        return this._parentForm;
    }

    public void reset() {
        this.applyOriginalState();
    }

    protected UserAgentCallback getUserAgentCallback() {
        return this._parentForm.getUserAgentCallback();
    }

    protected FormFieldState getOriginalState() {
        if (this._originalState == null) {
            this._originalState = this.loadOriginalState();
        }
        return this._originalState;
    }

    protected boolean hasAttribute(String attributeName) {
        return this.getElement().hasAttribute(attributeName);
    }

    protected String getAttribute(String attributeName) {
        return this.getElement().getAttribute(attributeName);
    }

    private void initialize() {
        this._component = this.create();
        if (this._component != null) {
            this._component.setSize(this._component.getPreferredSize());
            if (this._element.hasAttribute("disabled") && this._element.getAttribute("disabled").equals("disabled")) {
                this._component.setEnabled(false);
            }
        }
        this.applyOriginalState();
    }

    public abstract JComponent create();

    protected FormFieldState loadOriginalState() {
        return FormFieldState.fromString("");
    }

    protected void applyOriginalState() {
    }

    public boolean includeInSubmission(JComponent source) {
        return true;
    }

    public String[] getFormDataStrings() {
        if (!this.hasAttribute("name")) {
            return new String[0];
        }
        String name = this.getAttribute("name");
        String[] values = this.getFieldValues();
        for (int i = 0; i < values.length; ++i) {
            values[i] = URLUTF8Encoder.encode(name) + "=" + URLUTF8Encoder.encode(values[i]);
        }
        return values;
    }

    protected abstract String[] getFieldValues();
}

