/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.wizard.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xslt.project.wizard.element.Panel;
import org.netbeans.modules.xslt.project.wizard.element.PanelOperation;
import org.netbeans.modules.xslt.project.wizard.element.PanelUtil;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PanelProxy<T>
extends Panel<T> {
    private int myXslFileUsagesCounter = 0;
    private PanelOperation<T> myOperationImplement;
    private PanelOperation<T> myOperationCall;
    private JCheckBox myRequestBox;
    private JCheckBox myReplyBox;
    private JTextField myRequestText;
    private JTextField myReplyText;
    private JButton myReplyFileBrowseButton;
    private JTextField myRequestFile;
    private JButton myRequestFileBrowseButton;
    private JTextField myReplyFile;

    PanelProxy(Project project, Panel<T> panel, WSDLModel wSDLModel, WSDLModel wSDLModel2) {
        super(project, panel);
        this.myOperationImplement = new PanelOperation(project, this, wSDLModel, null, true, true);
        this.myOperationCall = new PanelOperation(project, this, wSDLModel2, null, true, false);
    }

    @Override
    protected String getComponentName() {
        return NAME_XSLT;
    }

    @Override
    protected String getError() {
        String string = this.addExtension(this.myReplyFile.getText().trim());
        if (!PanelUtil.isValidFileName(string)) {
            return this.i18n("ERR_WrongFileName", string);
        }
        FileObject fileObject = this.getFolder().getFileObject(string);
        string = this.addExtension(this.myRequestFile.getText().trim());
        if (this.myReplyBox.isSelected() && !PanelUtil.isValidFileName(string)) {
            return this.i18n("ERR_WrongFileName", string);
        }
        fileObject = this.getFolder().getFileObject(string);
        return this.getError(this.myOperationImplement.getError(), this.myOperationCall.getError());
    }

    @Override
    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        this.myOperationImplement.storeSettings(object);
        this.myOperationCall.storeSettings(object);
        wizardDescriptor.putProperty("input.file", (Object)this.addExtension(this.myRequestFile.getText().trim()));
        wizardDescriptor.putProperty("output.file", (Object)this.addExtension(this.myReplyFile.getText().trim()));
        if (this.myReplyBox.isSelected()) {
            wizardDescriptor.putProperty("choice", (Object)"choice.filter.request.reply");
        } else {
            wizardDescriptor.putProperty("choice", (Object)"choice.filter.one.way");
        }
    }

    @Override
    protected void createPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 0;
        jPanel2.add((Component)UI.createSeparator((String)this.i18n("LBL_We_Implement")), gridBagConstraints2);
        this.myOperationImplement.createPanel(jPanel2, gridBagConstraints2);
        jPanel2.add((Component)UI.createSeparator((String)this.i18n("LBL_We_Call")), gridBagConstraints2);
        this.myOperationCall.createPanel(jPanel2, gridBagConstraints2);
        int n = this.getXslFileNumber(1);
        int n2 = this.getXslFileNumber(n + 1);
        jPanel2.add((Component)this.createTransformRequestPanel(this.getXslFileName(n)), gridBagConstraints2);
        jPanel2.add((Component)this.createTransformReplyPanel(this.getXslFileName(n2)), gridBagConstraints2);
        this.update();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.getAccessibleContext().setAccessibleDescription(this.i18n("ACSD_LBL_NewBridgeService3"));
    }

    @Override
    protected void update() {
        if (this.myRequestBox == null || this.myReplyBox == null) {
            return;
        }
        this.myOperationImplement.setEnabled(this.myRequestBox.isSelected());
        this.myOperationCall.setEnabled(this.myReplyBox.isSelected());
        this.myRequestFile.setEnabled(this.myRequestBox.isSelected());
        this.myRequestFileBrowseButton.setEnabled(this.myRequestBox.isSelected());
        this.myReplyFile.setEnabled(this.myReplyBox.isSelected());
        this.myReplyFileBrowseButton.setEnabled(this.myReplyBox.isSelected());
        this.myOperationImplement.setRequirement(this.myRequestBox.isSelected(), this.myReplyBox.isSelected());
        this.myOperationCall.setRequirement(this.myRequestBox.isSelected(), this.myReplyBox.isSelected());
        this.updateText(this.myRequestText, true, (Operation)this.myOperationImplement.getResult(), (Operation)this.myOperationCall.getResult());
        this.updateText(this.myReplyText, false, (Operation)this.myOperationCall.getResult(), (Operation)this.myOperationImplement.getResult());
    }

    private void updateText(JTextField jTextField, boolean bl, Operation operation, Operation operation2) {
        this.updateText(jTextField, this.getType(operation, bl), this.getType(operation2, bl));
    }

    private void updateText(JTextField jTextField, String string, String string2) {
        jTextField.setText(this.i18n("LBL_From_To", string, string2));
    }

    private String getType(Operation operation, boolean bl) {
        if (operation == null) {
            return "";
        }
        if (bl) {
            return this.getType((OperationParameter)operation.getInput());
        }
        return this.getType((OperationParameter)operation.getOutput());
    }

    private JPanel createTransformRequestPanel(String string) {
        this.myRequestBox = UI.createCheckBox((Action)new UI.ButtonAction(this.i18n("LBL_Transform_Request")){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProxy.this.update();
            }
        });
        this.myRequestBox.setEnabled(false);
        this.myRequestBox.setSelected(true);
        this.myRequestText = new JTextField();
        UI.a11y((Component)this.myRequestText, (String)"ACSN_LBL_Transform_Request", (String)"ACSD_LBL_Transform_Request");
        this.myRequestFile = new JTextField(string);
        this.myRequestFileBrowseButton = this.createBrowseButton(this.myRequestFile);
        return this.createTransformPanel(this.myRequestBox, this.myRequestText, this.myRequestFile, this.myRequestFileBrowseButton);
    }

    private JPanel createTransformReplyPanel(String string) {
        this.myReplyBox = UI.createCheckBox((Action)new UI.ButtonAction(this.i18n("LBL_Transform_Reply")){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProxy.this.update();
            }
        });
        UI.a11y((Component)this.myReplyBox, (String)"ACSN_LBL_Transform_Reply", (String)"ACSD_LBL_Transform_Reply");
        this.myReplyBox.setEnabled(true);
        this.myReplyBox.setSelected(false);
        this.myReplyText = new JTextField();
        UI.a11y((Component)this.myReplyText, (String)"ACSN_LBL_Transform_Reply", (String)"ACSD_LBL_Transform_Reply");
        this.myReplyFile = new JTextField(string);
        this.myReplyFileBrowseButton = this.createBrowseButton(this.myReplyFile, "LBL_Browse2");
        return this.createTransformPanel(this.myReplyBox, this.myReplyText, this.myReplyFile, this.myReplyFileBrowseButton);
    }

    private JPanel createTransformPanel(JCheckBox jCheckBox, JTextField jTextField, JTextField jTextField2, JButton jButton) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 8, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jTextField.setEnabled(false);
        jPanel.add((Component)jTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 25, 2, 8);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = UI.createLabel((String)this.i18n(this.getNextXslFileLabel()));
        UI.a11y((Component)jLabel, (String)"ACSN_LBL_XSL_File", (String)"ACSD_LBL_XSL_File");
        jLabel.setLabelFor(jTextField2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 2, 0);
        jPanel.add((Component)jTextField2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private String getNextXslFileLabel() {
        ++this.myXslFileUsagesCounter;
        return this.myXslFileUsagesCounter > 1 ? "LBL_XSL_File3" : "LBL_XSL_File";
    }
}

