/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.Vector;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.IStack;
import org.w3c.tidy.MutableBoolean;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.MutableObject;
import org.w3c.tidy.Node;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamIn;
import org.w3c.tidy.Style;

public class Lexer {
    public StreamIn in;
    public PrintWriter errout;
    public short badAccess;
    public short badLayout;
    public short badChars;
    public short badForm;
    public short warnings;
    public short errors;
    public int lines;
    public int columns;
    public boolean waswhite;
    public boolean pushed;
    public boolean insertspace;
    public boolean excludeBlocks;
    public boolean exiled;
    public boolean isvoyager;
    public short versions;
    public int doctype;
    public boolean badDoctype;
    public int txtstart;
    public int txtend;
    public short state;
    public Node token;
    public byte[] lexbuf;
    public int lexlength;
    public int lexsize;
    public Node inode;
    public int insert;
    public Stack istack;
    public int istackbase;
    public Style styles;
    public Configuration configuration;
    protected int seenBodyEndTag;
    private Vector nodeList;
    public static final short IgnoreWhitespace = 0;
    public static final short MixedContent = 1;
    public static final short Preformatted = 2;
    public static final short IgnoreMarkup = 3;
    private static final short DIGIT = 1;
    private static final short LETTER = 2;
    private static final short NAMECHAR = 4;
    private static final short WHITE = 8;
    private static final short NEWLINE = 16;
    private static final short LOWERCASE = 32;
    private static final short UPPERCASE = 64;
    private static final short LEX_CONTENT = 0;
    private static final short LEX_GT = 1;
    private static final short LEX_ENDTAG = 2;
    private static final short LEX_STARTTAG = 3;
    private static final short LEX_COMMENT = 4;
    private static final short LEX_DOCTYPE = 5;
    private static final short LEX_PROCINSTR = 6;
    private static final short LEX_ENDCOMMENT = 7;
    private static final short LEX_CDATA = 8;
    private static final short LEX_SECTION = 9;
    private static final short LEX_ASP = 10;
    private static final short LEX_JSTE = 11;
    private static final short LEX_PHP = 12;
    private static short[] lexmap = new short[128];
    private static final String voyager_loose = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private static final String voyager_strict = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
    private static final String voyager_frameset = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
    private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static W3CVersionInfo[] W3CVersion;

    public Lexer(StreamIn in, Configuration configuration) {
        this.in = in;
        this.lines = 1;
        this.columns = 1;
        this.state = 0;
        this.badAccess = 0;
        this.badLayout = 0;
        this.badChars = 0;
        this.badForm = 0;
        this.warnings = 0;
        this.errors = 0;
        this.waswhite = false;
        this.pushed = false;
        this.insertspace = false;
        this.exiled = false;
        this.isvoyager = false;
        this.versions = (short)479;
        this.doctype = 0;
        this.badDoctype = false;
        this.txtstart = 0;
        this.txtend = 0;
        this.token = null;
        this.lexbuf = null;
        this.lexlength = 0;
        this.lexsize = 0;
        this.inode = null;
        this.insert = -1;
        this.istack = new Stack();
        this.istackbase = 0;
        this.styles = null;
        this.configuration = configuration;
        this.seenBodyEndTag = 0;
        this.nodeList = new Vector();
    }

    public Node newNode() {
        Node node = new Node();
        this.nodeList.addElement(node);
        return node;
    }

    public Node newNode(short type, byte[] textarray, int start, int end) {
        Node node = new Node(type, textarray, start, end);
        this.nodeList.addElement(node);
        return node;
    }

    public Node newNode(short type, byte[] textarray, int start, int end, String element) {
        Node node = new Node(type, textarray, start, end, element, this.configuration.tt);
        this.nodeList.addElement(node);
        return node;
    }

    public Node cloneNode(Node node) {
        Node cnode = (Node)node.clone();
        this.nodeList.addElement(cnode);
        AttVal att = cnode.attributes;
        while (att != null) {
            if (att.asp != null) {
                this.nodeList.addElement(att.asp);
            }
            if (att.php != null) {
                this.nodeList.addElement(att.php);
            }
            att = att.next;
        }
        return cnode;
    }

    public AttVal cloneAttributes(AttVal attrs) {
        AttVal cattrs;
        AttVal att = cattrs = (AttVal)attrs.clone();
        while (att != null) {
            if (att.asp != null) {
                this.nodeList.addElement(att.asp);
            }
            if (att.php != null) {
                this.nodeList.addElement(att.php);
            }
            att = att.next;
        }
        return cattrs;
    }

    protected void updateNodeTextArrays(byte[] oldtextarray, byte[] newtextarray) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            Node node = (Node)this.nodeList.elementAt(i);
            if (node.textarray != oldtextarray) continue;
            node.textarray = newtextarray;
        }
    }

    public Node newLineNode() {
        Node node = this.newNode();
        node.textarray = this.lexbuf;
        node.start = this.lexsize;
        this.addCharToLexer(10);
        node.end = this.lexsize;
        return node;
    }

    public static byte[] getBytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("string to UTF-8 conversion failed: " + e.getMessage());
        }
    }

    public static String getString(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 to string conversion failed: " + e.getMessage());
        }
    }

    public boolean endOfInput() {
        return this.in.isEndOfStream();
    }

    public void addByte(int c) {
        if (this.lexsize + 1 >= this.lexlength) {
            while (this.lexsize + 1 >= this.lexlength) {
                if (this.lexlength == 0) {
                    this.lexlength = 8192;
                    continue;
                }
                this.lexlength *= 2;
            }
            byte[] temp = this.lexbuf;
            this.lexbuf = new byte[this.lexlength];
            if (temp != null) {
                System.arraycopy(temp, 0, this.lexbuf, 0, temp.length);
                this.updateNodeTextArrays(temp, this.lexbuf);
            }
        }
        this.lexbuf[this.lexsize++] = (byte)c;
        this.lexbuf[this.lexsize] = 0;
    }

    public void changeChar(byte c) {
        if (this.lexsize > 0) {
            this.lexbuf[this.lexsize - 1] = c;
        }
    }

    public void addCharToLexer(int c) {
        if (c < 128) {
            this.addByte(c);
        } else if (c <= 2047) {
            this.addByte(0xC0 | c >> 6);
            this.addByte(0x80 | c & 0x3F);
        } else if (c <= 65535) {
            this.addByte(0xE0 | c >> 12);
            this.addByte(0x80 | c >> 6 & 0x3F);
            this.addByte(0x80 | c & 0x3F);
        } else if (c <= 0x1FFFFF) {
            this.addByte(0xF0 | c >> 18);
            this.addByte(0x80 | c >> 12 & 0x3F);
            this.addByte(0x80 | c >> 6 & 0x3F);
            this.addByte(0x80 | c & 0x3F);
        } else {
            this.addByte(0xF8 | c >> 24);
            this.addByte(0x80 | c >> 18 & 0x3F);
            this.addByte(0x80 | c >> 12 & 0x3F);
            this.addByte(0x80 | c >> 6 & 0x3F);
            this.addByte(0x80 | c & 0x3F);
        }
    }

    public void addStringToLexer(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.addCharToLexer(str.charAt(i));
        }
    }

    public void parseEntity(short mode) {
        int c;
        boolean first = true;
        boolean semicolon = false;
        boolean numeric = false;
        int start = this.lexsize - 1;
        int startcol = this.in.curcol - 1;
        while ((c = this.in.readChar()) != -1) {
            if (c == 59) {
                semicolon = true;
                break;
            }
            if (first && c == 35) {
                this.addCharToLexer(c);
                first = false;
                numeric = true;
                continue;
            }
            first = false;
            short map = Lexer.MAP((char)c);
            if (numeric && (c == 120 || (map & 1) != 0)) {
                this.addCharToLexer(c);
                continue;
            }
            if (!numeric && (map & 4) != 0) {
                this.addCharToLexer(c);
                continue;
            }
            this.in.ungetChar(c);
            break;
        }
        String str = Lexer.getString(this.lexbuf, start, this.lexsize - start);
        int ch = EntityTable.getDefaultEntityTable().entityCode(str);
        if (ch <= 0) {
            this.lines = this.in.curline;
            this.columns = startcol;
            if (this.lexsize > start + 1) {
                Report.entityError(this, (short)2, str, ch);
                if (semicolon) {
                    this.addCharToLexer(59);
                }
            } else {
                Report.entityError(this, (short)3, str, ch);
            }
        } else {
            if (c != 59) {
                this.lines = this.in.curline;
                this.columns = startcol;
                Report.entityError(this, (short)1, str, c);
            }
            this.lexsize = start;
            if (ch == 160 && (mode & 2) != 0) {
                ch = 32;
            }
            this.addCharToLexer(ch);
            if (ch == 38 && !this.configuration.QuoteAmpersand) {
                this.addCharToLexer(97);
                this.addCharToLexer(109);
                this.addCharToLexer(112);
                this.addCharToLexer(59);
            }
        }
    }

    public char parseTagName() {
        boolean wasColon;
        int c = this.lexbuf[this.txtstart];
        short map = Lexer.MAP((char)c);
        boolean bl = wasColon = c == 58;
        if (!this.configuration.inputJspMode && !this.configuration.XmlTags && (map & 0x40) != 0) {
            this.lexbuf[this.txtstart] = (byte)(c += 32);
        }
        while ((c = this.in.readChar()) != -1 && ((map = Lexer.MAP((char)c)) & 4) != 0) {
            if (c == 58) {
                wasColon = true;
            }
            if (!this.configuration.inputJspMode && !this.configuration.XmlTags && (map & 0x40) != 0) {
                c += 32;
            }
            this.addCharToLexer(c);
        }
        this.txtend = this.lexsize;
        if (!this.configuration.XmlTags && !wasColon) {
            this.lowercaseBuf();
        }
        return (char)c;
    }

    private void lowercaseBuf() {
        byte c;
        for (int i = this.txtstart; i < this.txtend && (c = this.lexbuf[i]) < 128; ++i) {
            short map = Lexer.MAP((char)c);
            if ((map & 0x40) == 0) continue;
            this.lexbuf[i] = c = (byte)(c + 32);
        }
    }

    public void addStringLiteral(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.addCharToLexer(str.charAt(i));
        }
    }

    public short HTMLVersion() {
        short versions = this.versions;
        if ((versions & 1) != 0) {
            return 1;
        }
        if ((versions & 2) != 0) {
            return 2;
        }
        if ((versions & 4) != 0) {
            return 4;
        }
        if ((versions & 8) != 0) {
            return 8;
        }
        if ((versions & 0x10) != 0) {
            return 16;
        }
        return 0;
    }

    public String HTMLVersionName() {
        short guessed = this.apparentVersion();
        for (int j = 0; j < W3CVersion.length; ++j) {
            if (guessed != Lexer.W3CVersion[j].code) continue;
            if (this.isvoyager) {
                return Lexer.W3CVersion[j].voyagerName;
            }
            return Lexer.W3CVersion[j].name;
        }
        return null;
    }

    public boolean addGenerator(Node root) {
        if (this.configuration.outputJspMode) {
            return false;
        }
        Node head = root.findHEAD(this.configuration.tt);
        if (head != null) {
            Node node = head.content;
            while (node != null) {
                AttVal attval;
                if (node.tag == this.configuration.tt.tagMeta && (attval = node.getAttrByName("name")) != null && attval.value != null && Lexer.wstrcasecmp(attval.value, "generator") == 0 && (attval = node.getAttrByName("content")) != null && attval.value != null && attval.value.length() >= 9 && Lexer.wstrcasecmp(attval.value.substring(0, 9), "HTML Tidy") == 0) {
                    return false;
                }
                node = node.next;
            }
            node = this.inferredTag("meta");
            node.addAttribute("content", "HTML Tidy, see www.w3.org");
            node.addAttribute("name", "generator");
            Node.insertNodeAtStart(head, node);
            return true;
        }
        return false;
    }

    private static boolean findBadSubString(String s, String p, int len) {
        int n = s.length();
        int i = 0;
        while (n < len) {
            String ps = p.substring(i, i + n);
            if (Lexer.wstrcasecmp(s, ps) == 0) {
                return !ps.equals(s.substring(0, n));
            }
            ++i;
            --len;
        }
        return false;
    }

    public boolean checkDocTypeKeyWords(Node doctype) {
        int len = doctype.end - doctype.start;
        String s = Lexer.getString(this.lexbuf, doctype.start, len);
        return !Lexer.findBadSubString("SYSTEM", s, len) && !Lexer.findBadSubString("PUBLIC", s, len) && !Lexer.findBadSubString("//DTD", s, len) && !Lexer.findBadSubString("//W3C", s, len) && !Lexer.findBadSubString("//EN", s, len);
    }

    public short findGivenVersion(Node doctype) {
        String str1 = Lexer.getString(this.lexbuf, doctype.start, 5);
        if (Lexer.wstrcasecmp(str1, "html ") != 0) {
            return 0;
        }
        if (!this.checkDocTypeKeyWords(doctype)) {
            Report.warning(this, doctype, null, (short)32);
        }
        if (Lexer.wstrcasecmp(str1 = Lexer.getString(this.lexbuf, doctype.start + 5, 7), "SYSTEM ") == 0) {
            if (!str1.substring(0, 6).equals("SYSTEM")) {
                System.arraycopy(Lexer.getBytes("SYSTEM"), 0, this.lexbuf, doctype.start + 5, 6);
            }
            return 0;
        }
        if (Lexer.wstrcasecmp(str1, "PUBLIC ") == 0) {
            if (!str1.substring(0, 6).equals("PUBLIC")) {
                System.arraycopy(Lexer.getBytes("PUBLIC "), 0, this.lexbuf, doctype.start + 5, 6);
            }
        } else {
            this.badDoctype = true;
        }
        for (int i = doctype.start; i < doctype.end; ++i) {
            int j;
            if (this.lexbuf[i] != 34) continue;
            str1 = Lexer.getString(this.lexbuf, i + 1, 12);
            String str2 = Lexer.getString(this.lexbuf, i + 1, 13);
            if (str1.equals("-//W3C//DTD ")) {
                int j2;
                for (j2 = i + 13; j2 < doctype.end && this.lexbuf[j2] != 47; ++j2) {
                }
                int len = j2 - i - 13;
                String p = Lexer.getString(this.lexbuf, i + 13, len);
                for (j2 = 1; j2 < W3CVersion.length; ++j2) {
                    String s = Lexer.W3CVersion[j2].name;
                    if (len != s.length() || !s.equals(p)) continue;
                    return Lexer.W3CVersion[j2].code;
                }
                break;
            }
            if (!str2.equals("-//IETF//DTD ")) break;
            for (j = i + 14; j < doctype.end && this.lexbuf[j] != 47; ++j) {
            }
            int len = j - i - 14;
            String p = Lexer.getString(this.lexbuf, i + 14, len);
            String s = Lexer.W3CVersion[0].name;
            if (len != s.length() || !s.equals(p)) break;
            return Lexer.W3CVersion[0].code;
        }
        return 0;
    }

    public void fixHTMLNameSpace(Node root, String profile) {
        Node node = root.content;
        while (node != null && node.tag != this.configuration.tt.tagHtml) {
            node = node.next;
        }
        if (node != null) {
            AttVal prev = null;
            AttVal attr = node.attributes;
            while (attr != null && !attr.attribute.equals("xmlns")) {
                prev = attr;
                attr = attr.next;
            }
            if (attr != null) {
                if (!attr.value.equals(profile)) {
                    Report.warning(this, node, null, (short)28);
                    attr.value = profile;
                }
            } else {
                attr = new AttVal(node.attributes, null, 34, "xmlns", profile);
                attr.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attr);
                node.attributes = attr;
            }
        }
    }

    public boolean setXHTMLDocType(Node root) {
        String fpi = " ";
        String sysid = "";
        String namespace = XHTML_NAMESPACE;
        Node doctype = root.findDocType();
        if (this.configuration.outputJspMode || this.configuration.docTypeMode == 0) {
            if (doctype != null) {
                Node.discardElement(doctype);
            }
            return true;
        }
        if (this.configuration.docTypeMode == 1) {
            if ((this.versions & 4) != 0) {
                fpi = "-//W3C//DTD XHTML 1.0 Strict//EN";
                sysid = voyager_strict;
            } else if ((this.versions & 0x1A) != 0) {
                fpi = "-//W3C//DTD XHTML 1.0 Transitional//EN";
                sysid = voyager_loose;
            } else if ((this.versions & 0x10) != 0) {
                fpi = "-//W3C//DTD XHTML 1.0 Frameset//EN";
                sysid = voyager_frameset;
            } else {
                fpi = "-//W3C//DTD XHTML 1.0 Transitional//EN";
                sysid = voyager_loose;
            }
        } else if (this.configuration.docTypeMode == 2) {
            fpi = "-//W3C//DTD XHTML 1.0 Strict//EN";
            sysid = voyager_strict;
        } else if (this.configuration.docTypeMode == 3) {
            fpi = "-//W3C//DTD XHTML 1.0 Transitional//EN";
            sysid = voyager_loose;
        }
        this.fixHTMLNameSpace(root, namespace);
        if (doctype == null) {
            doctype = this.newNode((short)1, this.lexbuf, 0, 0);
            doctype.next = root.content;
            doctype.parent = root;
            doctype.prev = null;
            root.content = doctype;
        }
        if (this.configuration.docTypeMode == 4 && this.configuration.docTypeStr != null) {
            fpi = this.configuration.docTypeStr;
            sysid = "";
        }
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("html PUBLIC ");
        if (fpi.charAt(0) == '\"') {
            this.addStringLiteral(fpi);
        } else {
            this.addStringLiteral("\"");
            this.addStringLiteral(fpi);
            this.addStringLiteral("\"");
        }
        if (sysid.length() + 6 >= this.configuration.wraplen) {
            this.addStringLiteral("\n\"");
        } else {
            this.addStringLiteral("\n    \"");
        }
        this.addStringLiteral(sysid);
        this.addStringLiteral("\"");
        this.txtend = this.lexsize;
        doctype.start = this.txtstart;
        doctype.end = this.txtend;
        return false;
    }

    public short apparentVersion() {
        switch (this.doctype) {
            case 0: {
                return this.HTMLVersion();
            }
            case 1: {
                if ((this.versions & 1) == 0) break;
                return 1;
            }
            case 2: {
                if ((this.versions & 2) == 0) break;
                return 2;
            }
            case 4: {
                if ((this.versions & 4) == 0) break;
                return 4;
            }
            case 8: {
                if ((this.versions & 8) == 0) break;
                return 8;
            }
            case 16: {
                if ((this.versions & 0x10) == 0) break;
                return 16;
            }
        }
        Report.warning(this, null, null, (short)23);
        return this.HTMLVersion();
    }

    public boolean fixDocType(Node root) {
        short guessed = 4;
        if (this.badDoctype) {
            Report.warning(this, null, null, (short)30);
        }
        if (this.configuration.XmlOut) {
            return true;
        }
        Node doctype = root.findDocType();
        if (this.configuration.docTypeMode == 0) {
            if (doctype != null) {
                Node.discardElement(doctype);
            }
            return true;
        }
        if (this.configuration.docTypeMode == 2) {
            Node.discardElement(doctype);
            doctype = null;
            guessed = 4;
        } else if (this.configuration.docTypeMode == 3) {
            Node.discardElement(doctype);
            doctype = null;
            guessed = 8;
        } else if (this.configuration.docTypeMode == 1) {
            if (doctype != null) {
                if (this.doctype == 0) {
                    return false;
                }
                switch (this.doctype) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if ((this.versions & 1) == 0) break;
                        return true;
                    }
                    case 2: {
                        if ((this.versions & 2) == 0) break;
                        return true;
                    }
                    case 4: {
                        if ((this.versions & 4) == 0) break;
                        return true;
                    }
                    case 8: {
                        if ((this.versions & 8) == 0) break;
                        return true;
                    }
                    case 16: {
                        if ((this.versions & 0x10) == 0) break;
                        return true;
                    }
                }
            }
            guessed = this.HTMLVersion();
        }
        if (guessed == 0) {
            return false;
        }
        if (this.configuration.XmlOut || this.configuration.XmlTags || this.isvoyager) {
            if (doctype != null) {
                Node.discardElement(doctype);
            }
            for (int i = 0; i < W3CVersion.length; ++i) {
                if (guessed != Lexer.W3CVersion[i].code) continue;
                this.fixHTMLNameSpace(root, Lexer.W3CVersion[i].profile);
                break;
            }
            return true;
        }
        if (doctype == null) {
            doctype = this.newNode((short)1, this.lexbuf, 0, 0);
            doctype.next = root.content;
            doctype.parent = root;
            doctype.prev = null;
            root.content = doctype;
        }
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("html PUBLIC ");
        if (this.configuration.docTypeMode == 4 && this.configuration.docTypeStr != null) {
            this.addStringLiteral(this.configuration.docTypeStr);
        } else if (guessed == 1) {
            this.addStringLiteral("\"-//IETF//DTD HTML 2.0//EN\"");
        } else {
            this.addStringLiteral("\"-//W3C//DTD ");
            for (int i = 0; i < W3CVersion.length; ++i) {
                if (guessed != Lexer.W3CVersion[i].code) continue;
                this.addStringLiteral(Lexer.W3CVersion[i].name);
                break;
            }
            this.addStringLiteral("//EN\"");
        }
        this.txtend = this.lexsize;
        doctype.start = this.txtstart;
        doctype.end = this.txtend;
        return true;
    }

    public boolean fixXMLPI(Node root) {
        int s;
        if (root.content != null && root.content.type == 3 && this.lexbuf[s = root.content.start] == 120 && this.lexbuf[s + 1] == 109 && this.lexbuf[s + 2] == 108) {
            return true;
        }
        Node xml = this.newNode((short)3, this.lexbuf, 0, 0);
        xml.next = root.content;
        if (root.content != null) {
            root.content.prev = xml;
            xml.next = root.content;
        }
        root.content = xml;
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("xml version=\"1.0\"");
        if (this.configuration.CharEncoding == 2) {
            this.addStringLiteral(" encoding=\"ISO-8859-1\"");
        }
        this.txtend = this.lexsize;
        xml.start = this.txtstart;
        xml.end = this.txtend;
        return false;
    }

    public Node inferredTag(String name) {
        Node node = this.newNode((short)5, this.lexbuf, this.txtstart, this.txtend, name);
        node.implicit = true;
        return node;
    }

    public static boolean expectsContent(Node node) {
        if (node.type != 5) {
            return false;
        }
        if (node.tag == null) {
            return true;
        }
        return (node.tag.model & 1) == 0;
    }

    public Node getCDATA(Node container) {
        int c;
        boolean endtag = false;
        this.lines = this.in.curline;
        this.columns = this.in.curcol;
        this.waswhite = false;
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        int lastc = 0;
        int start = -1;
        while ((c = this.in.readChar()) != -1) {
            if (c == 47 && lastc == 60) {
                if (endtag) {
                    this.lines = this.in.curline;
                    this.columns = this.in.curcol - 3;
                    Report.warning(this, null, null, (short)27);
                }
                start = this.lexsize + 1;
                endtag = true;
            } else if (c == 62 && start >= 0) {
                String str;
                int len = this.lexsize - start;
                if (len == container.element.length() && Lexer.wstrcasecmp(str = Lexer.getString(this.lexbuf, start, len), container.element) == 0) {
                    this.txtend = start - 2;
                    break;
                }
                this.lines = this.in.curline;
                this.columns = this.in.curcol - 3;
                Report.warning(this, null, null, (short)27);
                if (ParserImpl.isJavaScript(container)) {
                    for (int i = this.lexsize; i > start - 1; --i) {
                        this.lexbuf[i] = this.lexbuf[i - 1];
                    }
                    this.lexbuf[start - 1] = 92;
                }
                start = -1;
            } else if (c == 13) {
                c = this.in.readChar();
                if (c != 10) {
                    this.in.ungetChar(c);
                }
                c = 10;
            }
            this.addCharToLexer(c);
            this.txtend = ++this.lexsize;
            lastc = c;
        }
        if (c == -1) {
            Report.warning(this, container, null, (short)1);
        }
        if (this.txtend > this.txtstart) {
            this.txtend = this.removeCDATAMark(this.lexbuf, this.txtstart, this.txtend);
            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
            return this.token;
        }
        return null;
    }

    private int removeCDATAMark(byte[] lexbuf, int txtstart, int txtend) {
        String s = new String(lexbuf, txtstart, txtend - txtstart);
        s = s.replaceAll("<!\\[CDATA\\[", "");
        byte[] b = (s = s.replaceAll("\\]\\]>", "")).getBytes();
        if (b.length < txtend - txtstart) {
            System.arraycopy(b, 0, lexbuf, txtstart, b.length);
            return txtstart + b.length;
        }
        return txtend;
    }

    public void ungetToken() {
        this.pushed = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Node getToken(short mode) {
        int c;
        block88: {
            block89: {
                c = 0;
                int badcomment = 0;
                MutableBoolean isempty = new MutableBoolean();
                if (this.pushed && (this.token.type != 4 || this.insert == -1 && this.inode == null)) {
                    this.pushed = false;
                    return this.token;
                }
                if (this.insert != -1) return this.insertedToken();
                if (this.inode != null) {
                    return this.insertedToken();
                }
                this.lines = this.in.curline;
                this.columns = this.in.curcol;
                this.waswhite = false;
                this.txtstart = this.lexsize;
                this.txtend = this.lexsize;
                block14: while (true) {
                    block90: {
                        block91: {
                            short map;
                            if ((c = this.in.readChar()) == -1) {
                                if (this.state != 0) break block88;
                                break block89;
                            }
                            if (this.insertspace && mode != 0) {
                                this.addCharToLexer(32);
                                this.waswhite = true;
                                this.insertspace = false;
                            }
                            if (c == 13) {
                                c = this.in.readChar();
                                if (c != 10) {
                                    this.in.ungetChar(c);
                                }
                                c = 10;
                            }
                            this.addCharToLexer(c);
                            switch (this.state) {
                                case 0: {
                                    map = Lexer.MAP((char)c);
                                    if ((map & 8) != 0 && mode == 0 && this.lexsize == this.txtstart + 1) {
                                        --this.lexsize;
                                        this.waswhite = false;
                                        this.lines = this.in.curline;
                                        this.columns = this.in.curcol;
                                        continue block14;
                                    }
                                    if (c == 60) {
                                        this.state = 1;
                                        continue block14;
                                    }
                                    if ((map & 8) != 0) {
                                        if (this.waswhite) {
                                            if (mode == 2 || mode == 3) continue block14;
                                            --this.lexsize;
                                            this.lines = this.in.curline;
                                            this.columns = this.in.curcol;
                                            continue block14;
                                        }
                                        this.waswhite = true;
                                        int lastc = c;
                                        if (mode == 2 || mode == 3 || c == 32) continue block14;
                                        this.changeChar((byte)32);
                                        continue block14;
                                    }
                                    if (c == 38 && mode != 3) {
                                        this.parseEntity(mode);
                                    }
                                    if (mode == 0) {
                                        mode = 1;
                                    }
                                    this.waswhite = false;
                                    continue block14;
                                }
                                case 1: {
                                    if (c == 47) {
                                        c = this.in.readChar();
                                        if (c == -1) {
                                            this.in.ungetChar(c);
                                            continue block14;
                                        }
                                        this.addCharToLexer(c);
                                        map = Lexer.MAP((char)c);
                                        if ((map & 2) != 0) {
                                            this.lexsize -= 3;
                                            this.txtend = this.lexsize;
                                            this.in.ungetChar(c);
                                            this.state = (short)2;
                                            this.lexbuf[this.lexsize] = 0;
                                            this.in.curcol -= 2;
                                            if (this.txtend <= this.txtstart) continue block14;
                                            if (mode == 0 && this.lexbuf[this.lexsize - 1] == 32) {
                                                --this.lexsize;
                                                this.txtend = this.lexsize;
                                            }
                                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                            return this.token;
                                        }
                                        this.waswhite = false;
                                        this.state = 0;
                                        continue block14;
                                    }
                                    if (mode == 3) {
                                        this.waswhite = false;
                                        this.state = 0;
                                        continue block14;
                                    }
                                    if (c == 33) {
                                        c = this.in.readChar();
                                        if (c == 45) {
                                            c = this.in.readChar();
                                            if (c == 45) {
                                                this.state = (short)4;
                                                this.lexsize -= 2;
                                                this.txtend = this.lexsize;
                                                if (this.txtend > this.txtstart) {
                                                    this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                    return this.token;
                                                }
                                                this.txtstart = this.lexsize;
                                                continue block14;
                                            }
                                            Report.warning(this, null, null, (short)24);
                                            break block90;
                                        } else {
                                            if (c == 100 || c == 68) {
                                                this.state = (short)5;
                                                this.lexsize -= 2;
                                                this.txtend = this.lexsize;
                                                mode = 0;
                                                break;
                                            }
                                            if (c == 91) {
                                                this.lexsize -= 2;
                                                this.state = (short)9;
                                                this.txtend = this.lexsize;
                                                if (this.txtend > this.txtstart) {
                                                    this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                    return this.token;
                                                }
                                                this.txtstart = this.lexsize;
                                                continue block14;
                                            }
                                        }
                                        break block90;
                                    } else {
                                        if (c == 63) {
                                            this.lexsize -= 2;
                                            this.state = (short)6;
                                            this.txtend = this.lexsize;
                                            if (this.txtend > this.txtstart) {
                                                this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                return this.token;
                                            }
                                            this.txtstart = this.lexsize;
                                            continue block14;
                                        }
                                        if (c == 37) {
                                            this.lexsize -= 2;
                                            this.state = (short)10;
                                            this.txtend = this.lexsize;
                                            if (this.txtend > this.txtstart) {
                                                this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                return this.token;
                                            }
                                            this.txtstart = this.lexsize;
                                            continue block14;
                                        }
                                        if (c == 35) {
                                            this.lexsize -= 2;
                                            this.state = (short)11;
                                            this.txtend = this.lexsize;
                                            if (this.txtend > this.txtstart) {
                                                this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                return this.token;
                                            }
                                            this.txtstart = this.lexsize;
                                            continue block14;
                                        }
                                        map = Lexer.MAP((char)c);
                                        if ((map & 2) != 0) {
                                            this.in.ungetChar(c);
                                            this.lexsize -= 2;
                                            this.txtend = this.lexsize;
                                            this.state = (short)3;
                                            if (this.txtend <= this.txtstart) continue block14;
                                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                            return this.token;
                                        }
                                        this.state = 0;
                                        this.waswhite = false;
                                        continue block14;
                                    }
                                }
                                case 2: {
                                    this.txtstart = this.lexsize - 1;
                                    this.in.curcol += 2;
                                    c = this.parseTagName();
                                    this.token = this.newNode((short)6, this.lexbuf, this.txtstart, this.txtend, Lexer.getString(this.lexbuf, this.txtstart, this.txtend - this.txtstart));
                                    this.lexsize = this.txtstart;
                                    this.txtend = this.txtstart;
                                    while (c != 62 && (c = this.in.readChar()) != -1) {
                                    }
                                    if (c != -1) {
                                        this.state = 0;
                                        this.waswhite = false;
                                        return this.token;
                                    }
                                    this.in.ungetChar(c);
                                    continue block14;
                                }
                                case 3: {
                                    this.txtstart = this.lexsize - 1;
                                    c = this.parseTagName();
                                    isempty.value = false;
                                    AttVal attributes = null;
                                    this.token = this.newNode(isempty.value ? (short)7 : 5, this.lexbuf, this.txtstart, this.txtend, Lexer.getString(this.lexbuf, this.txtstart, this.txtend - this.txtstart));
                                    if (c != 62) {
                                        if (c == 47) {
                                            this.in.ungetChar(c);
                                        }
                                        attributes = this.parseAttrs(isempty);
                                    }
                                    if (isempty.value) {
                                        this.token.type = (short)7;
                                    }
                                    this.token.attributes = attributes;
                                    this.lexsize = this.txtstart;
                                    this.txtend = this.txtstart;
                                    if (Lexer.expectsContent(this.token) || this.token.tag == this.configuration.tt.tagBr) {
                                        c = this.in.readChar();
                                        if (c == 13) {
                                            c = this.in.readChar();
                                            if (c != 10) {
                                                this.in.ungetChar(c);
                                            }
                                        } else if (c != 10 && c != 12) {
                                            this.in.ungetChar(c);
                                        }
                                        this.waswhite = true;
                                    } else {
                                        this.waswhite = false;
                                    }
                                    this.state = 0;
                                    if (this.token.tag == null) {
                                        if (this.configuration.inputJspMode && this.token.element != null && this.token.element.indexOf(":") != -1) {
                                            this.configuration.tt.defineInlineTag(this.token.element);
                                            this.token.tag = this.configuration.tt.lookup(this.token.element);
                                            return this.token;
                                        }
                                        Report.error(this, null, this.token, (short)17);
                                        return this.token;
                                    }
                                    if (this.configuration.XmlTags) return this.token;
                                    this.versions = (short)(this.versions & this.token.tag.versions);
                                    if (!((this.token.tag.versions & 0x1C0) == 0 || this.configuration.MakeClean || this.token.tag != this.configuration.tt.tagNobr && this.token.tag != this.configuration.tt.tagWbr)) {
                                        Report.warning(this, null, this.token, (short)16);
                                    }
                                    if (this.token.tag.chkattrs != null) {
                                        this.token.checkUniqueAttributes(this);
                                        this.token.tag.chkattrs.check(this, this.token);
                                        return this.token;
                                    }
                                    this.token.checkAttributes(this);
                                    return this.token;
                                }
                                case 4: {
                                    if (c != 45) continue block14;
                                    c = this.in.readChar();
                                    this.addCharToLexer(c);
                                    if (c != 45) continue block14;
                                    do {
                                        if ((c = this.in.readChar()) == 62) {
                                            if (badcomment != 0) {
                                                Report.warning(this, null, null, (short)24);
                                            }
                                            this.txtend = this.lexsize - 2;
                                            this.lexbuf[this.lexsize] = 0;
                                            this.state = 0;
                                            this.waswhite = false;
                                            this.token = this.newNode((short)2, this.lexbuf, this.txtstart, this.txtend);
                                            c = this.in.readChar();
                                            if (c == 13 && (c = this.in.readChar()) != 10) {
                                                this.token.linebreak = true;
                                            }
                                            if (c != 10) break block14;
                                            this.token.linebreak = true;
                                            return this.token;
                                        }
                                        if (badcomment == 0) {
                                            this.lines = this.in.curline;
                                            this.columns = this.in.curcol - 3;
                                        }
                                        ++badcomment;
                                        if (this.configuration.FixComments) {
                                            this.lexbuf[this.lexsize - 2] = 61;
                                        }
                                        this.addCharToLexer(c);
                                    } while (c == 45);
                                    this.lexbuf[this.lexsize - 2] = 61;
                                    continue block14;
                                }
                                case 5: {
                                    map = Lexer.MAP((char)c);
                                    if ((map & 8) != 0) {
                                        if (this.waswhite) {
                                            --this.lexsize;
                                        }
                                        this.waswhite = true;
                                    } else {
                                        this.waswhite = false;
                                    }
                                    if (c != 62) continue block14;
                                    --this.lexsize;
                                    this.txtend = this.lexsize;
                                    this.lexbuf[this.lexsize] = 0;
                                    this.state = 0;
                                    this.waswhite = false;
                                    this.token = this.newNode((short)1, this.lexbuf, this.txtstart, this.txtend);
                                    this.doctype = this.findGivenVersion(this.token);
                                    return this.token;
                                }
                                case 6: {
                                    if (this.lexsize - this.txtstart == 3 && Lexer.getString(this.lexbuf, this.txtstart, 3).equals("php")) {
                                        this.state = (short)12;
                                        continue block14;
                                    }
                                    if (this.configuration.XmlPIs) {
                                        if (c != 63) continue block14;
                                        c = this.in.readChar();
                                        if (c == -1) {
                                            Report.warning(this, null, null, (short)31);
                                            this.in.ungetChar(c);
                                            continue block14;
                                        }
                                        this.addCharToLexer(c);
                                    }
                                    if (c != 62) continue block14;
                                    --this.lexsize;
                                    this.txtend = this.lexsize;
                                    this.lexbuf[this.lexsize] = 0;
                                    this.state = 0;
                                    this.waswhite = false;
                                    this.token = this.newNode((short)3, this.lexbuf, this.txtstart, this.txtend);
                                    return this.token;
                                }
                                case 10: {
                                    if (c != 37) continue block14;
                                    c = this.in.readChar();
                                    if (c == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)10, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(c);
                                    continue block14;
                                }
                                case 11: {
                                    if (c != 35) continue block14;
                                    c = this.in.readChar();
                                    if (c == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)11, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(c);
                                    continue block14;
                                }
                                case 12: {
                                    if (c != 63) continue block14;
                                    c = this.in.readChar();
                                    if (c == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)12, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(c);
                                    continue block14;
                                }
                                case 9: {
                                    if (c == 91 && this.lexsize == this.txtstart + 6 && Lexer.getString(this.lexbuf, this.txtstart, 6).equals("CDATA[")) {
                                        this.state = (short)8;
                                        this.lexsize -= 6;
                                        continue block14;
                                    }
                                    if (c != 93) continue block14;
                                    c = this.in.readChar();
                                    if (c == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)9, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(c);
                                    continue block14;
                                }
                                case 8: {
                                    if (c != 93) continue block14;
                                    c = this.in.readChar();
                                    if (c != 93) {
                                        this.in.ungetChar(c);
                                        continue block14;
                                    }
                                    c = this.in.readChar();
                                    if (c == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)8, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(c);
                                    continue block14;
                                }
                                default: {
                                    continue block14;
                                }
                            }
                            do {
                                if ((c = this.in.readChar()) != -1 && c != 62) continue;
                                this.in.ungetChar(c);
                                break block91;
                            } while (((map = Lexer.MAP((char)c)) & 8) == 0);
                            do {
                                if ((c = this.in.readChar()) != -1 && c != 62) continue;
                                this.in.ungetChar(c);
                                break block91;
                            } while (((map = Lexer.MAP((char)c)) & 8) != 0);
                            this.in.ungetChar(c);
                        }
                        if (this.txtend > this.txtstart) {
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.txtstart = this.lexsize;
                        continue;
                    }
                    while ((c = this.in.readChar()) != 62) {
                        if (c != -1) continue;
                        this.in.ungetChar(c);
                        break;
                    }
                    this.lexsize -= 2;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                }
                this.in.ungetChar(c);
                return this.token;
            }
            this.txtend = this.lexsize;
            if (this.txtend <= this.txtstart) return null;
            this.in.ungetChar(c);
            if (this.lexbuf[this.lexsize - 1] == 32) {
                --this.lexsize;
                this.txtend = this.lexsize;
            }
            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
            return this.token;
        }
        if (this.state != 4) return null;
        if (c == -1) {
            Report.warning(this, null, null, (short)24);
        }
        this.txtend = this.lexsize;
        this.lexbuf[this.lexsize] = 0;
        this.state = 0;
        this.waswhite = false;
        this.token = this.newNode((short)2, this.lexbuf, this.txtstart, this.txtend);
        return this.token;
    }

    public Node parseAsp() {
        Node asp = null;
        this.txtstart = this.lexsize;
        while (true) {
            int c = this.in.readChar();
            this.addCharToLexer(c);
            if (c != 37) continue;
            c = this.in.readChar();
            this.addCharToLexer(c);
            if (c == 62) break;
        }
        this.lexsize -= 2;
        this.txtend = this.lexsize;
        if (this.txtend > this.txtstart) {
            asp = this.newNode((short)10, this.lexbuf, this.txtstart, this.txtend);
        }
        this.txtstart = this.txtend;
        return asp;
    }

    public Node parsePhp() {
        Node php = null;
        this.txtstart = this.lexsize;
        while (true) {
            int c = this.in.readChar();
            this.addCharToLexer(c);
            if (c != 63) continue;
            c = this.in.readChar();
            this.addCharToLexer(c);
            if (c == 62) break;
        }
        this.lexsize -= 2;
        this.txtend = this.lexsize;
        if (this.txtend > this.txtstart) {
            php = this.newNode((short)12, this.lexbuf, this.txtstart, this.txtend);
        }
        this.txtstart = this.txtend;
        return php;
    }

    public String parseAttribute(MutableBoolean isempty, MutableObject asp, MutableObject php) {
        short map;
        int start = 0;
        int c = 0;
        asp.setObject(null);
        php.setObject(null);
        while (true) {
            if ((c = this.in.readChar()) == 47) {
                c = this.in.readChar();
                if (c == 62) {
                    isempty.value = true;
                    return null;
                }
                this.in.ungetChar(c);
                c = 47;
                break;
            }
            if (c == 62) {
                return null;
            }
            if (c == 60) {
                c = this.in.readChar();
                if (c == 37) {
                    asp.setObject(this.parseAsp());
                    return null;
                }
                if (c == 63) {
                    php.setObject(this.parsePhp());
                    return null;
                }
                this.in.ungetChar(c);
                Report.attrError(this, this.token, null, (short)5);
                return null;
            }
            if (c == 34 || c == 39) {
                Report.attrError(this, this.token, null, (short)10);
                continue;
            }
            if (c == -1) {
                Report.attrError(this, this.token, null, (short)31);
                this.in.ungetChar(c);
                return null;
            }
            map = Lexer.MAP((char)c);
            if ((map & 8) == 0) break;
        }
        start = this.lexsize;
        while (true) {
            if (c == 61 || c == 62) {
                this.in.ungetChar(c);
                break;
            }
            if (c == 60 || c == -1) {
                this.in.ungetChar(c);
                break;
            }
            map = Lexer.MAP((char)c);
            if ((map & 8) != 0) break;
            if (!this.configuration.inputJspMode && !this.configuration.XmlTags && (map & 0x40) != 0) {
                c += 32;
            }
            this.addCharToLexer(c);
            c = this.in.readChar();
        }
        int len = this.lexsize - start;
        String attr = len > 0 ? Lexer.getString(this.lexbuf, start, len) : null;
        this.lexsize = start;
        return attr;
    }

    public int parseServerInstruction() {
        int delim = 34;
        boolean isrule = false;
        int c = this.in.readChar();
        this.addCharToLexer(c);
        if (c == 37 || c == 63 || c == 64) {
            isrule = true;
        }
        while ((c = this.in.readChar()) != -1) {
            short map;
            if (c == 62) {
                if (isrule) {
                    this.addCharToLexer(c);
                    break;
                }
                this.in.ungetChar(c);
                break;
            }
            if (!isrule && ((map = Lexer.MAP((char)c)) & 8) != 0) break;
            this.addCharToLexer(c);
            if (c == 34) {
                do {
                    c = this.in.readChar();
                    this.addCharToLexer(c);
                } while (c != 34);
                delim = 39;
                continue;
            }
            if (c != 39) continue;
            do {
                c = this.in.readChar();
                this.addCharToLexer(c);
            } while (c != 39);
        }
        return delim;
    }

    public String parseValue(String name, boolean foldCase, MutableBoolean isempty, MutableInteger pdelim) {
        short map;
        int len = 0;
        boolean seen_gt = false;
        boolean munge = true;
        int c = 0;
        int delim = 0;
        pdelim.value = 34;
        if (this.configuration.LiteralAttribs) {
            munge = false;
        }
        do {
            if ((c = this.in.readChar()) != -1) continue;
            this.in.ungetChar(c);
            break;
        } while (((map = Lexer.MAP((char)c)) & 8) != 0);
        if (c != 61) {
            this.in.ungetChar(c);
            return null;
        }
        do {
            if ((c = this.in.readChar()) != -1) continue;
            this.in.ungetChar(c);
            break;
        } while (((map = Lexer.MAP((char)c)) & 8) != 0);
        if (c == 34 || c == 39) {
            delim = c;
        } else {
            if (c == 60) {
                int start = this.lexsize;
                this.addCharToLexer(c);
                pdelim.value = this.parseServerInstruction();
                len = this.lexsize - start;
                this.lexsize = start;
                return len > 0 ? Lexer.getString(this.lexbuf, start, len) : null;
            }
            this.in.ungetChar(c);
        }
        int quotewarning = 0;
        int start = this.lexsize;
        c = 0;
        while (true) {
            int lastc = c;
            c = this.in.readChar();
            if (c == -1) {
                Report.attrError(this, this.token, null, (short)31);
                this.in.ungetChar(c);
                break;
            }
            if (delim == 0) {
                if (c == 62) {
                    this.in.ungetChar(c);
                    break;
                }
                if (c == 34 || c == 39) {
                    Report.attrError(this, this.token, null, (short)10);
                    break;
                }
                if (c == 60) {
                    Report.attrError(this, this.token, null, (short)5);
                }
                if (c == 47) {
                    c = this.in.readChar();
                    if (c == 62 && !AttributeTable.getDefaultAttributeTable().isUrl(name)) {
                        isempty.value = true;
                        this.in.ungetChar(c);
                        break;
                    }
                    this.in.ungetChar(c);
                    c = 47;
                }
            } else {
                if (c == delim) break;
                if (c == 13) {
                    c = this.in.readChar();
                    if (c != 10) {
                        this.in.ungetChar(c);
                    }
                    c = 10;
                }
                if (c == 10 || c == 60 || c == 62) {
                    ++quotewarning;
                }
                if (c == 62) {
                    seen_gt = true;
                }
            }
            if (c == 38) {
                this.addCharToLexer(c);
                this.parseEntity((short)0);
                continue;
            }
            if (c == 92 && (c = this.in.readChar()) != 10) {
                this.in.ungetChar(c);
                c = 92;
            }
            if (((map = Lexer.MAP((char)c)) & 8) != 0) {
                if (delim == 0) break;
                if (munge) {
                    c = 32;
                    if (lastc == 32) {
                        continue;
                    }
                }
            } else if (foldCase && (map & 0x40) != 0) {
                c += 32;
            }
            this.addCharToLexer(c);
        }
        if (!(quotewarning <= 10 || !seen_gt || !munge || AttributeTable.getDefaultAttributeTable().isScript(name) || AttributeTable.getDefaultAttributeTable().isUrl(name) && Lexer.getString(this.lexbuf, start, 11).equals("javascript:"))) {
            Report.error(this, null, null, (short)11);
        }
        len = this.lexsize - start;
        this.lexsize = start;
        String value = len > 0 || delim != 0 ? Lexer.getString(this.lexbuf, start, len) : null;
        pdelim.value = delim != 0 ? delim : 34;
        return value;
    }

    public static boolean isValidAttrName(String attr) {
        char c = attr.charAt(0);
        short map = Lexer.MAP(c);
        if ((map & 2) == 0) {
            return false;
        }
        for (int i = 1; i < attr.length(); ++i) {
            c = attr.charAt(i);
            map = Lexer.MAP(c);
            if ((map & 4) != 0) continue;
            return false;
        }
        return true;
    }

    public AttVal parseAttrs(MutableBoolean isempty) {
        MutableInteger delim = new MutableInteger();
        MutableObject asp = new MutableObject();
        MutableObject php = new MutableObject();
        AttVal list = null;
        while (!this.endOfInput()) {
            AttVal av;
            String attribute = this.parseAttribute(isempty, asp, php);
            if (attribute == null) {
                if (asp.getObject() != null) {
                    list = av = new AttVal(list, null, (Node)asp.getObject(), null, 0, null, null);
                    continue;
                }
                if (php.getObject() == null) break;
                list = av = new AttVal(list, null, null, (Node)php.getObject(), 0, null, null);
                continue;
            }
            String value = this.parseValue(attribute, false, isempty, delim);
            if (attribute != null && Lexer.isValidAttrName(attribute)) {
                av = new AttVal(list, null, null, null, delim.value, attribute, value);
                av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
                list = av;
                continue;
            }
            av = new AttVal(null, null, null, null, 0, attribute, value);
            Report.attrError(this, this.token, value, (short)4);
        }
        return list;
    }

    public void pushInline(Node node) {
        if (node.implicit) {
            return;
        }
        if (node.tag == null) {
            return;
        }
        if ((node.tag.model & 0x10) == 0) {
            return;
        }
        if ((node.tag.model & 0x800) != 0) {
            return;
        }
        if (node.tag != this.configuration.tt.tagFont && this.isPushed(node)) {
            return;
        }
        IStack is = new IStack();
        is.tag = node.tag;
        is.element = node.element;
        if (node.attributes != null) {
            is.attributes = this.cloneAttributes(node.attributes);
        }
        this.istack.push(is);
    }

    public void popInline(Node node) {
        if (node != null) {
            if (node.tag == null) {
                return;
            }
            if ((node.tag.model & 0x10) == 0) {
                return;
            }
            if ((node.tag.model & 0x800) != 0) {
                return;
            }
            if (node.tag == this.configuration.tt.tagA) {
                while (this.istack.size() > 0) {
                    IStack is = (IStack)this.istack.pop();
                    if (is.tag != this.configuration.tt.tagA) continue;
                }
                if (this.insert >= this.istack.size()) {
                    this.insert = -1;
                }
                return;
            }
        }
        if (this.istack.size() > 0) {
            IStack is = (IStack)this.istack.pop();
            if (this.insert >= this.istack.size()) {
                this.insert = -1;
            }
        }
    }

    public boolean isPushed(Node node) {
        for (int i = this.istack.size() - 1; i >= 0; --i) {
            IStack is = (IStack)this.istack.elementAt(i);
            if (is.tag != node.tag) continue;
            return true;
        }
        return false;
    }

    public int inlineDup(Node node) {
        int n = this.istack.size() - this.istackbase;
        if (n > 0) {
            this.insert = this.istackbase;
            this.inode = node;
        }
        return n;
    }

    public Node insertedToken() {
        if (this.insert == -1) {
            Node node = this.inode;
            this.inode = null;
            return node;
        }
        if (this.inode == null) {
            this.lines = this.in.curline;
            this.columns = this.in.curcol;
        }
        Node node = this.newNode((short)5, this.lexbuf, this.txtstart, this.txtend);
        node.implicit = true;
        IStack is = (IStack)this.istack.elementAt(this.insert);
        node.element = is.element;
        node.tag = is.tag;
        if (is.attributes != null) {
            node.attributes = this.cloneAttributes(is.attributes);
        }
        int n = this.insert;
        this.insert = ++n < this.istack.size() ? n : -1;
        return node;
    }

    public static int wstrcasecmp(String s1, String s2) {
        return s1.equalsIgnoreCase(s2) ? 0 : 1;
    }

    public static int wstrcaselexcmp(String s1, String s2) {
        char c;
        int i;
        for (i = 0; i < s1.length() && i < s2.length() && Lexer.toLower(c = s1.charAt(i)) == Lexer.toLower(s2.charAt(i)); ++i) {
        }
        if (i == s1.length() && i == s2.length()) {
            return 0;
        }
        if (i == s1.length()) {
            return -1;
        }
        if (i == s2.length()) {
            return 1;
        }
        return s1.charAt(i) > s2.charAt(i) ? 1 : -1;
    }

    public static boolean wsubstr(String s1, String s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        for (int i = 0; i <= len1 - len2; ++i) {
            if (!s2.equalsIgnoreCase(s1.substring(i))) continue;
            return true;
        }
        return false;
    }

    public boolean canPrune(Node element) {
        if (element.type == 4) {
            return true;
        }
        if (element.content != null) {
            return false;
        }
        if (element.tag == this.configuration.tt.tagA && element.attributes != null) {
            return false;
        }
        if (element.tag == this.configuration.tt.tagP && !this.configuration.DropEmptyParas) {
            return false;
        }
        if (element.tag == null) {
            return false;
        }
        if ((element.tag.model & 0x200) != 0) {
            return false;
        }
        if (element.tag == this.configuration.tt.tagApplet) {
            return false;
        }
        if (element.tag == this.configuration.tt.tagObject) {
            return false;
        }
        return element.attributes == null || element.getAttrByName("id") == null && element.getAttrByName("name") == null;
    }

    public void fixId(Node node) {
        AttVal name = node.getAttrByName("name");
        AttVal id = node.getAttrByName("id");
        if (name != null) {
            if (id != null) {
                if (!id.value.equals(name.value)) {
                    Report.attrError(this, node, "name", (short)11);
                }
            } else if (this.configuration.XmlOut) {
                node.addAttribute("id", name.value);
            }
        }
    }

    public void deferDup() {
        this.insert = -1;
        this.inode = null;
    }

    private static void mapStr(String str, short code) {
        for (int i = 0; i < str.length(); ++i) {
            char j;
            char c = j = str.charAt(i);
            lexmap[c] = (short)(lexmap[c] | code);
        }
    }

    private static short MAP(char c) {
        return c < '\u0080' ? lexmap[c] : (short)0;
    }

    private static boolean isWhite(char c) {
        short m = Lexer.MAP(c);
        return (m & 8) != 0;
    }

    private static boolean isDigit(char c) {
        short m = Lexer.MAP(c);
        return (m & 1) != 0;
    }

    private static boolean isLetter(char c) {
        short m = Lexer.MAP(c);
        return (m & 2) != 0;
    }

    private static char toLower(char c) {
        short m = Lexer.MAP(c);
        if ((m & 0x40) != 0) {
            c = (char)(c + 97 - 65);
        }
        return c;
    }

    private static char toUpper(char c) {
        short m = Lexer.MAP(c);
        if ((m & 0x20) != 0) {
            c = (char)(c + 65 - 97);
        }
        return c;
    }

    public static char foldCase(char c, boolean tocaps, boolean xmlTags) {
        if (!xmlTags) {
            short m = Lexer.MAP(c);
            if (tocaps) {
                if ((m & 0x20) != 0) {
                    c = (char)(c + 65 - 97);
                }
            } else if ((m & 0x40) != 0) {
                c = (char)(c + 97 - 65);
            }
        }
        return c;
    }

    static {
        Lexer.mapStr("\r\n\f", (short)24);
        Lexer.mapStr(" \t", (short)8);
        Lexer.mapStr("-.:_", (short)4);
        Lexer.mapStr("0123456789", (short)5);
        Lexer.mapStr("abcdefghijklmnopqrstuvwxyz", (short)38);
        Lexer.mapStr("ABCDEFGHIJKLMNOPQRSTUVWXYZ", (short)70);
        W3CVersion = new W3CVersionInfo[]{new W3CVersionInfo("HTML 4.01", "XHTML 1.0 Strict", voyager_strict, 4), new W3CVersionInfo("HTML 4.01 Transitional", "XHTML 1.0 Transitional", voyager_loose, 8), new W3CVersionInfo("HTML 4.01 Frameset", "XHTML 1.0 Frameset", voyager_frameset, 16), new W3CVersionInfo("HTML 4.0", "XHTML 1.0 Strict", voyager_strict, 4), new W3CVersionInfo("HTML 4.0 Transitional", "XHTML 1.0 Transitional", voyager_loose, 8), new W3CVersionInfo("HTML 4.0 Frameset", "XHTML 1.0 Frameset", voyager_frameset, 16), new W3CVersionInfo("HTML 3.2", "XHTML 1.0 Transitional", voyager_loose, 2), new W3CVersionInfo("HTML 2.0", "XHTML 1.0 Strict", voyager_strict, 1)};
    }

    private static class W3CVersionInfo {
        String name;
        String voyagerName;
        String profile;
        short code;

        public W3CVersionInfo(String name, String voyagerName, String profile, short code) {
            this.name = name;
            this.voyagerName = voyagerName;
            this.profile = profile;
            this.code = code;
        }
    }
}

