/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.nodes.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.datatype.CustomDatatype;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.abe.nodes.ABEAbstractNode;
import org.netbeans.modules.xml.schema.abe.nodes.ABENodeFactory;
import org.netbeans.modules.xml.schema.abe.nodes.ContentModelNode;
import org.netbeans.modules.xml.schema.abe.nodes.CustomDatatypeNode;
import org.netbeans.modules.xml.schema.abe.nodes.DatatypeNode;
import org.netbeans.modules.xml.schema.abe.nodes.GlobalContentModelsNode;
import org.netbeans.modules.xml.schema.abe.nodes.PrimitiveSimpleTypesNode;
import org.netbeans.modules.xml.schema.abe.nodes.SimpleTypesNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AXIComponentSelectionPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    static final long serialVersionUID = 1L;
    public static final String PROPERTY_SELECTION = "selectionChanged";
    private transient Object currentSelection;
    private transient String typeDisplayName;
    private Collection<? extends AXIComponent> exclude;
    private BeanTreeView typeView;
    private ExplorerManager explorerManager;
    private List<Class> filterTypes;
    private JPanel cvPanel;
    private JPanel jPanel1;
    private JTextField nameTxt;
    private JLabel selectedLbl;

    public AXIComponentSelectionPanel(AXIModel aXIModel, String string, List<Class> list, Object object, Collection<? extends AXIComponent> collection) {
        this.currentSelection = object;
        this.typeDisplayName = string;
        this.filterTypes = list;
        this.exclude = collection == null ? Collections.emptyList() : collection;
        this.initComponents();
        this.initialize(aXIModel);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.selectedLbl = new JLabel();
        this.nameTxt = new JTextField();
        this.cvPanel = new JPanel();
        this.selectedLbl.setText(NbBundle.getMessage(AXIComponentSelectionPanel.class, (String)"LBL_Currently_Selected", (Object[])new Object[]{this.typeDisplayName}));
        this.nameTxt.setEditable(false);
        this.nameTxt.setText(this.getCurrentSelectionName());
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.selectedLbl).addPreferredGap(0).add((Component)this.nameTxt, -1, 186, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameTxt, -2, -1, -2).add((Component)this.selectedLbl, -1, 15, Short.MAX_VALUE)).addContainerGap()));
        this.cvPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.cvPanel, -1, 301, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.cvPanel, -1, 329, Short.MAX_VALUE).addContainerGap()));
    }

    private void initialize(final AXIModel aXIModel) {
        ABENodeFactory aBENodeFactory = new ABENodeFactory(aXIModel, Lookup.EMPTY);
        Node node = aBENodeFactory.createRootNode(this.filterTypes);
        this.typeView = new BeanTreeView();
        this.typeView.setPopupAllowed(false);
        this.typeView.setSelectionMode(0);
        this.typeView.setRootVisible(false);
        this.cvPanel.add((Component)this.typeView, "Center");
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext(node);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AXIComponentSelectionPanel.this.selectCurrentSelection(aXIModel);
            }
        });
    }

    private void selectCurrentSelection(AXIModel aXIModel) {
        Node node;
        if (this.currentSelection != null && (node = this.findNode(this.explorerManager.getRootContext(), this.currentSelection, aXIModel)) != null) {
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
            if (nodeArray.length > 0) {
                if (nodeArray[0] instanceof ABEAbstractNode) {
                    this.setCurrentSelection(((ABEAbstractNode)nodeArray[0]).getAXIComponent());
                    return;
                }
                if (nodeArray[0] instanceof DatatypeNode) {
                    this.setCurrentSelection(((DatatypeNode)nodeArray[0]).getType());
                    return;
                }
                if (nodeArray[0] instanceof PrimitiveSimpleTypesNode.TypeNode) {
                    this.setCurrentSelection(((PrimitiveSimpleTypesNode.TypeNode)nodeArray[0]).getType());
                    return;
                }
            }
            this.setCurrentSelection(null);
        }
    }

    private void setCurrentSelection(Object object) {
        if (object instanceof AXIType) {
            Object object2 = this.currentSelection;
            this.currentSelection = object == null || this.exclude.contains(object) ? null : object;
            this.nameTxt.setText(this.getCurrentSelectionName());
            this.firePropertyChange(PROPERTY_SELECTION, object2, this.currentSelection);
        }
    }

    public Object getCurrentSelection() {
        return this.currentSelection;
    }

    public String getCurrentSelectionName() {
        if (this.currentSelection instanceof AXIType) {
            return ((AXIType)this.currentSelection).getName();
        }
        return "";
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private Node findNode(Node node, Object object, AXIModel aXIModel) {
        Node[] nodeArray;
        for (Node node2 : nodeArray = node.getChildren().getNodes()) {
            Node[] nodeArray2;
            String string;
            if (node2 instanceof PrimitiveSimpleTypesNode && object instanceof Datatype) {
                string = ((Datatype)object).getName();
                for (Node node3 : nodeArray2 = node2.getChildren().getNodes()) {
                    if (!((PrimitiveSimpleTypesNode.TypeNode)node3).getName().equals(string)) continue;
                    return node3;
                }
                continue;
            }
            if (node2 instanceof SimpleTypesNode && object instanceof CustomDatatype) {
                string = ((CustomDatatype)object).getName();
                for (Node node3 : nodeArray2 = node2.getChildren().getNodes()) {
                    if (!((CustomDatatypeNode)node3).getName().equals(string)) continue;
                    return node3;
                }
                continue;
            }
            if (!(node2 instanceof GlobalContentModelsNode) || !(object instanceof ContentModel)) continue;
            string = ((ContentModel)object).getName();
            for (Node node3 : nodeArray2 = node2.getChildren().getNodes()) {
                if (!((ContentModelNode)node3).getName().equals(string)) continue;
                return node3;
            }
        }
        return null;
    }
}

