/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.refactoring.CannotRefactorException;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.refactoring.ui.ReferenceableProvider;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.StartTagPanel;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.action.ShowDesignAction;
import org.netbeans.modules.xml.schema.abe.nodes.ElementNode;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.DesignGotoType;
import org.netbeans.modules.xml.schema.ui.basic.SchemaGotoType;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.netbeans.modules.xml.xam.ui.actions.GoToAction;
import org.netbeans.modules.xml.xam.ui.actions.GotoType;
import org.netbeans.modules.xml.xam.ui.actions.SourceGotoType;
import org.netbeans.modules.xml.xam.ui.cookies.GetSuperCookie;
import org.netbeans.modules.xml.xam.ui.cookies.GotoCookie;
import org.openide.ErrorManager;
import org.openide.actions.DeleteAction;
import org.openide.actions.NewAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class ABEAbstractNode
extends AbstractNode
implements GotoCookie,
PropertyChangeListener,
ReferenceableProvider {
    private InstanceUIContext context;
    private AXIComponent axiComponent;
    private Datatype datatype;
    boolean uiNode = false;
    private InstanceContent icont = new InstanceContent();
    private boolean readOnly = false;
    private static final GotoType[] GOTO_TYPES = new GotoType[]{new SourceGotoType(), new SchemaGotoType(), new DesignGotoType()};
    private static final SystemAction[] ALL_ACTIONS = new SystemAction[]{SystemAction.get(NewAction.class), SystemAction.get(DeleteAction.class), null, SystemAction.get(GoToAction.class), null, (SystemAction)RefactoringActionsFactory.whereUsedAction(), (SystemAction)RefactoringActionsFactory.editorSubmenuAction(), null, SystemAction.get(PropertiesAction.class)};
    private static final SystemAction[] SUB_ACTIONS = new SystemAction[]{SystemAction.get(GoToAction.class)};

    public ABEAbstractNode(AXIComponent aXIComponent, InstanceUIContext instanceUIContext) {
        this(aXIComponent, Children.LEAF, instanceUIContext, new InstanceContent());
    }

    public ABEAbstractNode(AXIComponent aXIComponent, Children children) {
        this(aXIComponent, children, null, new InstanceContent());
    }

    private ABEAbstractNode(AXIComponent aXIComponent, Children children, final InstanceUIContext instanceUIContext, InstanceContent instanceContent) {
        super(children, ABEAbstractNode.createLookup(aXIComponent, instanceContent, instanceUIContext));
        this.icont = instanceContent;
        this.setAXIComponent(aXIComponent);
        this.setContext(instanceUIContext);
        if (instanceUIContext != null) {
            this.uiNode = true;
            this.icont.add((Object)instanceUIContext);
            instanceUIContext.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("shutdown")) {
                        ABEAbstractNode.this.icont.remove((Object)instanceUIContext);
                        ABEAbstractNode.this.axiComponent = null;
                    }
                }
            });
        }
        this.icont.add((Object)this);
    }

    private static Lookup createLookup(AXIComponent aXIComponent, InstanceContent instanceContent, InstanceUIContext instanceUIContext) {
        AXIComponent aXIComponent2 = aXIComponent;
        if (aXIComponent.getComponentType() == AXIComponent.ComponentType.PROXY) {
            aXIComponent2 = aXIComponent.getOriginal();
        }
        final AXIComponent aXIComponent3 = aXIComponent;
        Lookup lookup = null;
        if (instanceUIContext != null) {
            lookup = instanceUIContext.getSchemaDataObject().getNodeDelegate().getLookup();
            lookup = Lookups.exclude((Lookup)lookup, (Class[])new Class[]{Node.class});
        }
        Lookup lookup2 = Lookup.EMPTY;
        try {
            lookup2 = aXIComponent.getModel().getSchemaModel().getModelSource().getLookup();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ProxyLookup(new Lookup[]{Lookups.exclude((Lookup)lookup2, (Class[])new Class[]{DataObject.class}), Lookups.singleton((Object)aXIComponent2), Lookups.singleton((Object)new GetSuperCookie(){

            public Component getSuper() {
                return UIUtilities.getSuperDefn(aXIComponent3);
            }
        }), lookup == null ? Lookup.EMPTY : lookup, new AbstractLookup((AbstractLookup.Content)instanceContent)});
    }

    public void showSuperDefinition() {
        InstanceUIContext instanceUIContext = (InstanceUIContext)this.getLookup().lookup(InstanceUIContext.class);
        UIUtilities.showDefinition(instanceUIContext, this.getAXIComponent(), true);
    }

    public HelpCtx getHelpCtx() {
        if (this instanceof ABEAbstractNode) {
            return new HelpCtx(ABEAbstractNode.class);
        }
        return new HelpCtx(this.getClass());
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        this.populateProperties(sheet);
        return sheet;
    }

    protected abstract void populateProperties(Sheet var1);

    protected abstract String getTypeDisplayName();

    public String getDisplayName() {
        String string = super.getDisplayName();
        return (string == null || string.length() == 0 ? "" : string + " ") + "[" + this.getTypeDisplayName() + "]";
    }

    public final String getHtmlDisplayName() {
        return super.getDisplayName();
    }

    public Action[] getActions(boolean bl) {
        if (this.uiNode) {
            if (this.getAXIComponent().isReadOnly()) {
                SystemAction[] systemActionArray = new SystemAction[ALL_ACTIONS.length];
                for (int i = 0; i < ALL_ACTIONS.length; ++i) {
                    String string = null;
                    if (ALL_ACTIONS[i] != null) {
                        string = (String)ALL_ACTIONS[i].getValue("Name");
                    }
                    systemActionArray[i] = string != null && string.equals("Refactor") ? null : ALL_ACTIONS[i];
                }
                return systemActionArray;
            }
            return ALL_ACTIONS;
        }
        return SUB_ACTIONS;
    }

    public InstanceUIContext getContext() {
        return this.context;
    }

    public void setContext(InstanceUIContext instanceUIContext) {
        this.context = instanceUIContext;
    }

    public AXIComponent getAXIComponent() {
        return this.axiComponent;
    }

    private void setAXIComponent(AXIComponent aXIComponent) {
        if (aXIComponent == null || aXIComponent.getModel() == null) {
            return;
        }
        this.axiComponent = aXIComponent;
        aXIComponent.getModel().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)aXIComponent.getModel()));
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.axiComponent && propertyChangeEvent.getPropertyName().equals("name")) {
            Object object = propertyChangeEvent.getOldValue();
            String string = object == null ? null : object.toString();
            this.fireDisplayNameChange(string, this.getDisplayName());
        }
    }

    public Action getPreferredAction() {
        return SystemAction.get(ShowDesignAction.class);
    }

    public NewType[] getNewTypes() {
        return new NewType[0];
    }

    public GotoType[] getGotoTypes() {
        return GOTO_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        if (!this.canWrite()) {
            return;
        }
        UIUtilities.setBusyCursor(this.context);
        try {
            if (this.getReferenceable() != null) {
                this.safeDelete();
                return;
            }
            this.doDelete();
        }
        finally {
            UIUtilities.setDefaultCursor(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete() {
        if (this.getAXIComponent() == null || this.getAXIComponent().getModel() == null) {
            return;
        }
        AXIModel aXIModel = this.getAXIComponent().getModel();
        aXIModel.startTransaction();
        try {
            ((AXIComponent)this.getAXIComponent().getParent()).removeChild(this.getAXIComponent());
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean canDestroy() {
        return this.canWrite();
    }

    public void destroy() throws IOException {
        super.destroy();
        this.remove();
    }

    public boolean canWrite() {
        AXIComponent aXIComponent = this.getAXIComponent();
        if (aXIComponent == null || aXIComponent.getModel() == null) {
            return false;
        }
        AXIComponent aXIComponent2 = aXIComponent.getOriginal();
        if (aXIComponent != aXIComponent2 && aXIComponent.isReadOnly()) {
            return false;
        }
        SchemaModel schemaModel = aXIComponent.getModel().getSchemaModel();
        return XAMUtils.isWritable((Model)schemaModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        if (string == null || this.getName().equals(string)) {
            return;
        }
        InstanceUIContext instanceUIContext = (InstanceUIContext)this.getLookup().lookup(InstanceUIContext.class);
        AXIComponent aXIComponent = this.getAXIComponent();
        if (this.canWrite()) {
            if (Utils.isValidNCName((String)string)) {
                UIUtilities.setBusyCursor(instanceUIContext);
                try {
                    this.setNameByRefactoring(string);
                }
                finally {
                    UIUtilities.setDefaultCursor(instanceUIContext);
                }
            } else if (instanceUIContext != null) {
                String string2 = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_NOT_A_NCNAME");
                UIUtilities.showErrorMessage(string2, instanceUIContext);
            }
        } else if (instanceUIContext != null) {
            String string3 = NbBundle.getMessage(ABEAbstractNode.class, (String)"MSG_IS_READONLY");
            UIUtilities.showErrorMessage(string3, instanceUIContext);
        }
    }

    public void setNameByRefactoring(String string) {
        Object object;
        NamedReferenceable namedReferenceable = this.getReferenceable();
        if (namedReferenceable == null) {
            object = this.getAXIComponent();
            if (object instanceof Element || object instanceof Attribute) {
                if ((object = object instanceof Element ? ((Element)object).getReferent() : ((Attribute)object).getReferent()) == null) {
                    this.setNameInModel(string);
                    return;
                }
                namedReferenceable = this.getReferenceable((AXIComponent)object);
            } else {
                this.setNameInModel(string);
                return;
            }
        }
        object = this.getAXIComponent().getModel();
        try {
            if (this.context != null) {
                this.context.setUserInducedEventMode(true);
            }
            SchemaModel schemaModel = object.getSchemaModel();
            SharedUtils.silentRename((Nameable)((Nameable)namedReferenceable), (String)string, (boolean)false);
            object.sync();
        }
        catch (CannotRefactorException cannotRefactorException) {
            SharedUtils.showRenameRefactoringUI((Nameable)((Nameable)namedReferenceable));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameInModel(String string) {
        try {
            this.axiComponent.getModel().startTransaction();
            if (this.axiComponent instanceof Element) {
                ((Element)this.axiComponent).setName(string);
            } else if (this.axiComponent instanceof ContentModel) {
                ((ContentModel)this.axiComponent).setName(string);
            } else if (this.axiComponent instanceof Attribute) {
                ((Attribute)this.axiComponent).setName(string);
            }
        }
        finally {
            this.axiComponent.getModel().endTransaction();
        }
    }

    public NamedReferenceable getReferenceable() {
        SchemaComponent schemaComponent = this.getAXIComponent().getOriginal().getPeer();
        if (schemaComponent instanceof NamedReferenceable && this.isValid() && schemaComponent.getModel().getModelSource().getLookup().lookup(FileObject.class) != null) {
            return (NamedReferenceable)NamedReferenceable.class.cast(schemaComponent);
        }
        return null;
    }

    private NamedReferenceable getReferenceable(AXIComponent aXIComponent) {
        SchemaComponent schemaComponent = aXIComponent.getOriginal().getPeer();
        if (schemaComponent instanceof NamedReferenceable && this.isValid() && schemaComponent.getModel().getModelSource().getLookup().lookup(FileObject.class) != null) {
            return (NamedReferenceable)NamedReferenceable.class.cast(schemaComponent);
        }
        return null;
    }

    protected boolean isValid() {
        return this.getAXIComponent().getPeer().getModel() != null;
    }

    private void safeDelete() {
        NamedReferenceable namedReferenceable = this.getReferenceable();
        AXIModel aXIModel = this.getAXIComponent().getModel();
        try {
            this.context.setUserInducedEventMode(true);
            SchemaModel schemaModel = aXIModel.getSchemaModel();
            SharedUtils.silentDeleteRefactor((NamedReferenceable)namedReferenceable, (boolean)true);
            aXIModel.sync();
        }
        catch (CannotRefactorException cannotRefactorException) {
            SharedUtils.showDeleteRefactoringUI((NamedReferenceable)namedReferenceable);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public Sheet.Set getSharedSet(Sheet sheet) {
        Sheet.Set set = null;
        set = sheet.get("shared");
        if (set != null) {
            return set;
        }
        set = sheet.createPropertiesSet();
        String string = NbBundle.getMessage(ElementNode.class, (String)"LBL_SHARED");
        String string2 = NbBundle.getMessage(ElementNode.class, (String)"LBL_SHARED_MESSAGE");
        set.setName("shared");
        set.setDisplayName(string);
        set.setShortDescription(string2);
        return set;
    }
}

