/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;

public abstract class AnnotatedBorderPanel
extends ABEBaseDropPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    private boolean drawAnnotation = true;
    Point startPoint = null;
    String annotationString;
    private boolean drawBorder = false;
    private Color borderColor = InstanceDesignConstants.XP_ORANGE;
    boolean drawBoldString = false;

    public AnnotatedBorderPanel(InstanceUIContext instanceUIContext) {
        super(instanceUIContext);
    }

    public void setDrawAnnotation(boolean bl) {
        this.drawAnnotation = bl;
    }

    void setStartDrawPoint(Point point) {
        this.startPoint = point;
    }

    void setAnnotationString(String string) {
        this.annotationString = string;
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        if (!this.drawAnnotation) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        int n = rectangle.height;
        Stroke stroke = graphics2D.getStroke();
        if (this.shouldDrawBorder()) {
            object = graphics2D.getColor();
            graphics2D.setColor(this.borderColor);
            BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.drawRoundRect(rectangle.x, rectangle.y + 1, rectangle.width, rectangle.height - 2, 10, 10);
            graphics2D.setColor((Color)object);
        }
        graphics2D.setPaint(Color.lightGray);
        object = new float[]{2.0f, 2.0f};
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, (float[])object, 0.0f));
        graphics2D.drawLine(this.startPoint.x, this.startPoint.y, this.startPoint.x, this.startPoint.y + n);
        int n2 = new JLabel().getFont().getSize();
        Font font = graphics2D.getFont();
        Color color = Color.lightGray;
        if (this.drawBoldString) {
            Font font2 = new Font(font.getName(), 1, font.getSize());
            graphics2D.setFont(font2);
            color = Color.BLACK;
        }
        int n3 = SwingUtilities.computeStringWidth(graphics2D.getFontMetrics(), "s");
        int n4 = n2 * this.annotationString.length();
        int n5 = n / n4;
        boolean bl = false;
        int n6 = this.startPoint.y;
        int n7 = this.startPoint.x - 2 - n3;
        for (int i = 0; i < n5; ++i) {
            if (bl) {
                graphics2D.setPaint(color);
                n6 += 8;
                for (char c : this.annotationString.toCharArray()) {
                    graphics2D.drawString("" + c, n7, n6);
                    n6 += n2;
                }
                n6 += n2;
                bl = false;
                continue;
            }
            bl = true;
            n6 += n4;
        }
        graphics2D.setStroke(stroke);
        graphics2D.setFont(font);
    }

    public boolean shouldDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void drawBoldString(boolean bl) {
        this.drawBoldString = bl;
    }
}

