/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class EditList {
    private BaseDocument doc;
    private List<Edit> edits;
    private Formatter formatter;
    private boolean formatAll;

    public EditList(BaseDocument baseDocument) {
        this.doc = baseDocument;
        this.edits = new ArrayList<Edit>();
    }

    public String toString() {
        return "EditList(" + this.edits + ")";
    }

    public EditList replace(int n, int n2, String string, boolean bl, int n3) {
        this.edits.add(new Edit(n, n2, string, bl, n3));
        return this;
    }

    public void applyToDocument(BaseDocument baseDocument) {
        EditList editList = new EditList(baseDocument);
        editList.formatter = this.formatter;
        editList.edits = this.edits;
        editList.apply();
    }

    public void apply() {
        this.apply(-1);
    }

    public void setFormatter(Formatter formatter, boolean bl) {
        this.formatter = formatter;
        this.formatAll = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position apply(int n) {
        if (this.edits.size() == 0) {
            if (n >= 0) {
                try {
                    return this.doc.createPosition(0);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return null;
        }
        Position position = null;
        Collections.sort(this.edits);
        Collections.reverse(this.edits);
        try {
            this.doc.atomicLock();
            int n2 = this.edits.get((int)0).offset;
            Position position2 = this.doc.createPosition(n2, Position.Bias.Forward);
            for (Edit edit : this.edits) {
                if (edit.removeLen > 0) {
                    this.doc.remove(edit.offset, edit.removeLen);
                }
                if (edit.getInsertText() == null) continue;
                this.doc.insertString(edit.offset, edit.insertText, null);
                int n3 = edit.offset + edit.insertText.length();
                if (edit.getOffset() <= n && n3 >= n) {
                    position = this.doc.createPosition(n);
                }
                if (!edit.format) continue;
                this.formatter.reindent((Document)this.doc, edit.offset, n3);
            }
            if (this.formatAll) {
                int n4 = this.edits.get((int)(this.edits.size() - 1)).offset;
                n2 = position2.getOffset();
                this.formatter.reindent((Document)this.doc, n4, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        finally {
            this.doc.atomicUnlock();
        }
        return position;
    }

    public OffsetRange getRange() {
        int n;
        int n2 = n = this.edits.get((int)0).offset;
        for (Edit edit : this.edits) {
            if (edit.offset < n) {
                n = edit.offset;
            }
            if (edit.offset <= n2) continue;
            n2 = edit.offset;
        }
        return new OffsetRange(n, n2);
    }

    public int firstLine(BaseDocument baseDocument) {
        OffsetRange offsetRange = this.getRange();
        return NbDocument.findLineNumber((StyledDocument)((StyledDocument)baseDocument), (int)offsetRange.getStart());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Edit
    implements Comparable<Edit> {
        int offset;
        int removeLen;
        String insertText;
        boolean format;
        int offsetOrdinal;

        private Edit(int n, int n2, String string, boolean bl) {
            this.offset = n;
            this.removeLen = n2;
            this.insertText = string;
            this.format = bl;
        }

        private Edit(int n, int n2, String string, boolean bl, int n3) {
            this(n, n2, string, bl);
            this.offsetOrdinal = n3;
        }

        @Override
        public int compareTo(Edit edit) {
            if (this.offset == edit.offset) {
                return edit.offsetOrdinal - this.offsetOrdinal;
            }
            return this.offset - edit.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getRemoveLen() {
            return this.removeLen;
        }

        public String getInsertText() {
            return this.insertText;
        }

        public String toString() {
            return "Edit(pos=" + this.offset + ",delete=" + this.removeLen + ",insert=" + this.insertText + ")";
        }
    }
}

