/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.gsf.api.OffsetRange;

public class EditHistory
implements DocumentListener {
    private int start = -1;
    private int originalEnd = -1;
    private int editedEnd = -1;
    private List<Edit> edits = new ArrayList<Edit>(4);
    private int delta = 0;

    public int getStart() {
        return this.start;
    }

    public boolean isInDamagedRegion(int n) {
        if (this.start == -1) {
            return false;
        }
        return n >= this.start && n <= this.editedEnd;
    }

    public boolean isInDamagedRegion(OffsetRange offsetRange) {
        if (this.start == -1) {
            return false;
        }
        return offsetRange.getStart() < this.editedEnd && offsetRange.getEnd() > this.start;
    }

    public int getEditedSize() {
        return this.editedEnd - this.start;
    }

    public int getOriginalEnd() {
        return this.originalEnd;
    }

    public int getEditedEnd() {
        return this.editedEnd;
    }

    public int getSizeDelta() {
        return this.delta;
    }

    public int getOriginalSize() {
        return this.originalEnd - this.start;
    }

    public int convertOriginalToEdited(int n) {
        if (this.start == -1 || n <= this.start) {
            return n;
        }
        if (n >= this.originalEnd) {
            return n + this.delta;
        }
        List<Edit> list = this.edits;
        int n2 = list.size();
        if (n2 == 0) {
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            Edit edit = list.get(i);
            if (n <= edit.offset) continue;
            if (edit.insert) {
                n += edit.len;
                continue;
            }
            if (n < edit.offset + edit.len) {
                n = edit.offset;
                continue;
            }
            n -= edit.len;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public int convertEditedToOriginal(int n) {
        List<Edit> list = this.edits;
        int n2 = list.size();
        if (n2 == 0) {
            return n;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            Edit edit = list.get(i);
            if (edit.insert) {
                if (n <= edit.offset) continue;
                if (n < edit.offset + edit.len) {
                    n = edit.offset;
                    continue;
                }
                n -= edit.len;
                continue;
            }
            if (n < edit.offset) continue;
            n += edit.len;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        this.edits.add(new Edit(n, n2, true));
        if (this.start == -1) {
            this.start = n;
            this.originalEnd = n;
            this.editedEnd = n + n2;
            this.delta = n2;
        } else {
            int n3 = this.convertEditedToOriginal(n);
            if (n3 > this.originalEnd) {
                this.originalEnd = n3;
            }
            if (n < this.start) {
                this.start = n;
            }
            this.editedEnd = n + n2 > this.editedEnd ? n + n2 : (this.editedEnd += n2);
            this.delta = this.getEditedSize() - this.getOriginalSize();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        this.edits.add(new Edit(n, n2, false));
        if (this.start == -1) {
            this.start = n;
            this.originalEnd = n + n2;
            this.editedEnd = n;
            this.delta = -n2;
        } else {
            int n3 = this.convertEditedToOriginal(n);
            if (n3 > this.originalEnd) {
                this.originalEnd = n3;
            }
            if (n < this.start) {
                this.start = n;
            }
            this.editedEnd = n > this.editedEnd ? n : (this.editedEnd -= n2);
            this.delta = this.getEditedSize() - this.getOriginalSize();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public String toString() {
        return "EditHistory(offset=" + this.start + ", originalSize=" + this.getOriginalSize() + ", editedSize=" + this.getEditedSize() + ", delta=" + this.delta + ")";
    }

    private class Edit {
        int offset;
        int len;
        boolean insert;

        public Edit(int n, int n2, boolean bl) {
            this.offset = n;
            this.len = n2;
            this.insert = bl;
        }
    }
}

