/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.openide.filesystems.FileObject;

public interface DeclarationFinder {
    @NonNull
    public DeclarationLocation findDeclaration(@NonNull CompilationInfo var1, int var2);

    @NonNull
    public OffsetRange getReferenceSpan(@NonNull Document var1, int var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AlternativeLocation
    extends Comparable<AlternativeLocation> {
        public ElementHandle getElement();

        public String getDisplayHtml(HtmlFormatter var1);

        public DeclarationLocation getLocation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeclarationLocation {
        public static final DeclarationLocation NONE = new DeclarationLocation(null, -1);
        private final FileObject fileObject;
        private final int offset;
        private final URL url;
        private List<AlternativeLocation> alternatives;
        private ElementHandle element;
        private String invalidMessage;

        public DeclarationLocation(@NonNull FileObject fileObject, int n) {
            this.fileObject = fileObject;
            this.offset = n;
            this.url = null;
        }

        public DeclarationLocation(@NonNull FileObject fileObject, int n, @NonNull ElementHandle elementHandle) {
            this(fileObject, n);
            this.element = elementHandle;
        }

        public DeclarationLocation(@NonNull URL uRL) {
            this.url = uRL;
            this.fileObject = null;
            this.offset = -1;
        }

        public void setInvalidMessage(String string) {
            this.invalidMessage = string;
        }

        public void addAlternative(@NonNull AlternativeLocation alternativeLocation) {
            if (this.alternatives == null) {
                this.alternatives = new ArrayList<AlternativeLocation>();
            }
            this.alternatives.add(alternativeLocation);
        }

        @CheckForNull
        public List<AlternativeLocation> getAlternativeLocations() {
            if (this.alternatives != null) {
                return this.alternatives;
            }
            return Collections.emptyList();
        }

        @CheckForNull
        public URL getUrl() {
            return this.url;
        }

        @CheckForNull
        public FileObject getFileObject() {
            return this.fileObject;
        }

        public int getOffset() {
            return this.offset;
        }

        @CheckForNull
        public ElementHandle getElement() {
            return this.element;
        }

        @CheckForNull
        public String getInvalidMessage() {
            return this.invalidMessage;
        }

        public String toString() {
            if (this == NONE) {
                return "NONE";
            }
            if (this.url != null) {
                return this.url.toExternalForm();
            }
            return this.fileObject.getNameExt() + ":" + this.offset;
        }
    }
}

