/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors.controls;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.bpel.nodes.VariableNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.VirtualVariableContainer;
import org.netbeans.modules.bpel.properties.choosers.NewMessageVarChooser;
import org.netbeans.modules.bpel.properties.choosers.VariableChooserPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.InvokeCustomEditor;
import org.netbeans.modules.bpel.properties.editors.OnEventCustomEditor;
import org.netbeans.modules.bpel.properties.editors.OnMessageCustomEditor;
import org.netbeans.modules.bpel.properties.editors.ReceiveCustomEditor;
import org.netbeans.modules.bpel.properties.editors.ReplyCustomEditor;
import org.netbeans.modules.bpel.properties.editors.controls.TreeNodeChooser;
import org.netbeans.modules.bpel.properties.editors.controls.filter.VariableTypeFilter;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MessageConfigurationController
extends EditorLifeCycleAdapter
implements Validator.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor myEditor;
    private DefaultValidator myValidator;
    private JButton btnChooseInputVariable;
    private JButton btnChooseOutputVariable;
    private JButton btnNewInputVariable;
    private JButton btnNewOutputVariable;
    private JComboBox cbxOperation;
    private JComboBox cbxPartnerLink;
    private JTextField fldInputVariable;
    private JTextField fldOutputVariable;
    private JTextField fldVariableName;
    private boolean useMyRole;
    private VirtualVariableContainer currInputVar;
    private VirtualVariableContainer currOutputVar;
    private boolean inputVisible = true;
    private boolean outputVisible = true;
    private boolean declarationVisible = true;
    private PortType currPortType;
    private boolean isOutputVarEnabled = true;
    private ConfigurationListener myListener;

    public MessageConfigurationController(CustomNodeEditor customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.useMyRole = true;
        this.createContent();
    }

    public void useParthnerRole() {
        this.useMyRole = false;
    }

    public void useMyRole() {
        this.useMyRole = true;
    }

    public void setVisibleVariables(boolean bl, boolean bl2, boolean bl3) {
        if (this.inputVisible != bl) {
            this.fldInputVariable.setVisible(bl);
            this.btnNewInputVariable.setVisible(bl);
            this.btnChooseInputVariable.setVisible(bl);
            this.inputVisible = bl;
        }
        if (this.outputVisible != bl2) {
            this.fldOutputVariable.setVisible(bl2);
            this.btnNewOutputVariable.setVisible(bl2);
            this.btnChooseOutputVariable.setVisible(bl2);
            this.outputVisible = bl2;
        }
        if (this.declarationVisible != bl3) {
            this.fldVariableName.setVisible(bl3);
            this.declarationVisible = bl3;
        }
    }

    public void createContent() {
        this.btnChooseInputVariable = new JButton();
        this.btnChooseOutputVariable = new JButton();
        this.btnNewInputVariable = new JButton();
        this.btnNewOutputVariable = new JButton();
        this.cbxOperation = new JComboBox();
        this.cbxPartnerLink = new JComboBox();
        this.fldInputVariable = new JTextField();
        this.fldOutputVariable = new JTextField();
        this.fldVariableName = new JTextField();
        this.cbxPartnerLink.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object;
                    Object object2 = MessageConfigurationController.this.cbxOperation.getSelectedItem();
                    MessageConfigurationController.this.reloadOperationList();
                    if (MessageConfigurationController.this.cbxOperation.getModel().getSize() > 0) {
                        MessageConfigurationController.this.cbxOperation.setSelectedIndex(0);
                    } else {
                        MessageConfigurationController.this.cbxOperation.setSelectedIndex(-1);
                    }
                    if (MessageConfigurationController.this.myListener != null && !Util.isEqual(object2, object = MessageConfigurationController.this.cbxOperation.getSelectedItem())) {
                        MessageConfigurationController.this.myListener.operationChanged();
                    }
                    MessageConfigurationController.this.resetVariables();
                    if (MessageConfigurationController.this.myListener != null) {
                        MessageConfigurationController.this.myListener.partnerLinkChanged();
                    }
                }
            }
        });
        this.cbxOperation.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    MessageConfigurationController.this.resetVariables();
                    if (MessageConfigurationController.this.myListener != null) {
                        MessageConfigurationController.this.myListener.operationChanged();
                    }
                }
            }
        });
        this.cbxPartnerLink.setRenderer(new DefaultListCellRenderer(){
            static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null && object instanceof PartnerLink) {
                    String string = ((PartnerLink)object).getName();
                    this.setText(string);
                }
                return this;
            }
        });
        this.cbxOperation.setRenderer(new DefaultListCellRenderer(){
            static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null && object instanceof Operation) {
                    String string = ((Operation)object).getName();
                    this.setText(string);
                }
                return this;
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                MessageConfigurationController.this.chooseVariable(MessageConfigurationController.this.btnChooseInputVariable.equals(object));
            }
        };
        this.btnChooseInputVariable.addActionListener(actionListener);
        this.btnChooseOutputVariable.addActionListener(actionListener);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                boolean bl = MessageConfigurationController.this.btnNewInputVariable.equals(object);
                VirtualVariableContainer virtualVariableContainer = MessageConfigurationController.this.prepareNewVariable(bl);
                if (virtualVariableContainer != null) {
                    if (bl) {
                        MessageConfigurationController.this.setCurrInputVar(virtualVariableContainer);
                    } else {
                        MessageConfigurationController.this.setCurrOutputVar(virtualVariableContainer);
                    }
                }
            }
        };
        this.btnNewInputVariable.addActionListener(actionListener2);
        this.btnNewOutputVariable.addActionListener(actionListener2);
        this.resetVariables();
    }

    private void chooseVariable(boolean bl) {
        Input input;
        Operation operation = (Operation)this.cbxOperation.getSelectedItem();
        if (operation == null) {
            return;
        }
        if (!this.checkIfMessageSpecified(bl, operation)) {
            return;
        }
        String string = null;
        VirtualVariableContainer virtualVariableContainer = null;
        Message message = null;
        NamedComponentReference namedComponentReference = null;
        if (bl) {
            virtualVariableContainer = this.getCurrInputVar();
            string = NbBundle.getMessage(FormBundle.class, (String)"DLG_InputVariableChooser");
            input = operation.getInput();
            if (input == null) {
                return;
            }
            namedComponentReference = input.getMessage();
        } else {
            string = NbBundle.getMessage(FormBundle.class, (String)"DLG_OutputVariableChooser");
            virtualVariableContainer = this.getCurrOutputVar();
            input = operation.getOutput();
            if (input == null) {
                return;
            }
            namedComponentReference = input.getMessage();
        }
        if (namedComponentReference != null) {
            message = (Message)namedComponentReference.get();
        }
        input = this.myEditor.getLookup();
        BpelEntity bpelEntity = (BpelEntity)this.myEditor.getEditedObject();
        VisibilityScope visibilityScope = new VisibilityScope(bpelEntity, (Lookup)input);
        VariableTypeFilter variableTypeFilter = new VariableTypeFilter(null, namedComponentReference.getQName());
        variableTypeFilter.setShowAppropriateVarOnly(true);
        NodesTreeParams nodesTreeParams = new NodesTreeParams();
        nodesTreeParams.setTargetNodeClasses(new Class[]{VariableNode.class});
        nodesTreeParams.setLeafNodeClasses(new Class[]{VariableNode.class});
        ExtendedLookup extendedLookup = new ExtendedLookup((Lookup)input, new Object[]{visibilityScope, variableTypeFilter, nodesTreeParams});
        VariableChooserPanel variableChooserPanel = new VariableChooserPanel((Lookup)extendedLookup);
        TreeNodeChooser treeNodeChooser = new TreeNodeChooser(variableChooserPanel);
        treeNodeChooser.initControls();
        if (virtualVariableContainer != null && virtualVariableContainer.isExisting()) {
            variableChooserPanel.setSelectedValue(virtualVariableContainer.getVariableDeclaration());
        }
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)treeNodeChooser, string);
        SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)defaultDialogDescriptor);
        if (defaultDialogDescriptor.isOkHasPressed()) {
            Object object;
            VariableDeclaration variableDeclaration = variableChooserPanel.getSelectedValue();
            if (variableDeclaration == null) {
                return;
            }
            boolean bl2 = false;
            WSDLReference wSDLReference = variableDeclaration.getMessageType();
            if (wSDLReference != null) {
                object = new VirtualVariableContainer(variableDeclaration, (Lookup)input);
                if (bl) {
                    if (message.equals(wSDLReference.get())) {
                        this.setCurrInputVar((VirtualVariableContainer)object);
                        bl2 = true;
                    }
                } else if (message.equals(wSDLReference.get())) {
                    this.setCurrOutputVar((VirtualVariableContainer)object);
                    bl2 = true;
                }
            }
            if (!bl2) {
                object = NbBundle.getMessage(ErrorMessagesBundle.class, (String)"ERR_INCORRECT_MESSAGE_TYPE");
                NotifyDescriptor.Message message2 = new NotifyDescriptor.Message(object, 2);
                SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)message2);
            }
        }
    }

    private VirtualVariableContainer prepareNewVariable(boolean bl) {
        Constants.MessageDirection messageDirection;
        Input input;
        Lookup lookup = this.myEditor.getLookup();
        BpelModel bpelModel = (BpelModel)lookup.lookup(BpelModel.class);
        Process process = bpelModel.getProcess();
        BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        Operation operation = (Operation)this.cbxOperation.getSelectedItem();
        if (operation == null) {
            return null;
        }
        if (!this.checkIfMessageSpecified(bl, operation)) {
            return null;
        }
        NamedComponentReference namedComponentReference = null;
        if (bl) {
            input = operation.getInput();
            if (input != null) {
                namedComponentReference = input.getMessage();
            }
            messageDirection = Constants.MessageDirection.INPUT;
        } else {
            input = operation.getOutput();
            if (input != null) {
                namedComponentReference = input.getMessage();
            }
            messageDirection = Constants.MessageDirection.OUTPUT;
        }
        if (namedComponentReference == null) {
            return null;
        }
        input = (Message)namedComponentReference.get();
        BpelEntity bpelEntity = (BpelEntity)this.myEditor.getEditedObject();
        NewMessageVarChooser newMessageVarChooser = new NewMessageVarChooser(bpelEntity, operation.getName(), (Message)input, messageDirection);
        newMessageVarChooser.initControls();
        String string = NbBundle.getMessage(FormBundle.class, (String)(bl ? "DLG_NewInputVariable" : "DLG_NewOutputVariable"));
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)newMessageVarChooser, string);
        Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)defaultDialogDescriptor);
        dialog.setVisible(true);
        if (defaultDialogDescriptor.isOkHasPressed()) {
            return newMessageVarChooser.getSelectedValue();
        }
        return null;
    }

    private boolean checkIfMessageSpecified(boolean bl, Operation operation) {
        Object object;
        Message message = null;
        NamedComponentReference namedComponentReference = null;
        if (bl) {
            object = operation.getInput();
            if (object != null) {
                namedComponentReference = object.getMessage();
            }
        } else {
            object = operation.getOutput();
            if (object != null) {
                namedComponentReference = object.getMessage();
            }
        }
        if (namedComponentReference != null) {
            message = (Message)namedComponentReference.get();
        }
        if (message == null) {
            object = NbBundle.getMessage(FormBundle.class, (String)"MSG_EmptyOperatonMessage");
            UserNotification.showMessageAsinc((String)object);
            return false;
        }
        return true;
    }

    public boolean initControls() {
        try {
            PartnerLinkContainer partnerLinkContainer;
            Process process;
            Lookup lookup = this.myEditor.getLookup();
            BpelModel bpelModel = (BpelModel)lookup.lookup(BpelModel.class);
            if (bpelModel != null && (process = bpelModel.getProcess()) != null && (partnerLinkContainer = process.getPartnerLinkContainer()) != null) {
                PartnerLink partnerLink;
                PartnerLink partnerLink2;
                PartnerLink[] partnerLinkArray = partnerLinkContainer.getPartnerLinks();
                ArrayList<PartnerLink> arrayList = new ArrayList<PartnerLink>();
                for (int i = 0; i < partnerLinkArray.length; ++i) {
                    partnerLink2 = partnerLinkArray[i];
                    if (this.myEditor instanceof InvokeCustomEditor && partnerLink2.getPartnerRole() != null) {
                        arrayList.add(partnerLink2);
                    }
                    if (!(this.myEditor instanceof ReceiveCustomEditor) && !(this.myEditor instanceof OnMessageCustomEditor) && !(this.myEditor instanceof OnEventCustomEditor) && !(this.myEditor instanceof ReplyCustomEditor) || partnerLink2.getMyRole() == null) continue;
                    arrayList.add(partnerLink2);
                }
                this.cbxPartnerLink.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.cbxPartnerLink.setSelectedIndex(-1);
                Node.Property property = PropertyUtils.lookForPropertyByType(this.myEditor.getEditedNode(), PropertyType.PARTNER_LINK);
                if (property != null && (partnerLink2 = (BpelReference)property.getValue()) != null && (partnerLink = (PartnerLink)partnerLink2.get()) != null) {
                    this.cbxPartnerLink.setSelectedItem(partnerLink);
                }
                this.reloadOperationList();
                this.setCurrentOperationSelection();
                this.setCurrentVariables();
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public boolean applyNewValues() {
        try {
            BpelReference bpelReference;
            Object object;
            Operation operation;
            Node node = this.myEditor.getEditedNode();
            Object object2 = this.myEditor.getEditedObject();
            assert (object2 instanceof ReferenceCollection);
            ReferenceCollection referenceCollection = (ReferenceCollection)object2;
            Node.Property property = null;
            PartnerLink partnerLink = (PartnerLink)this.cbxPartnerLink.getSelectedItem();
            property = PropertyUtils.lookForPropertyByType(node, PropertyType.PARTNER_LINK);
            if (property != null && partnerLink != null) {
                operation = referenceCollection.createReference((BpelReferenceable)partnerLink, PartnerLink.class);
                property.setValue((Object)operation);
            }
            operation = (Operation)this.cbxOperation.getSelectedItem();
            property = PropertyUtils.lookForPropertyByType(node, PropertyType.OPERATION);
            if (property != null && operation != null) {
                object = referenceCollection.createWSDLReference((ReferenceableWSDLComponent)operation, Operation.class);
                property.setValue(object);
            }
            if ((property = PropertyUtils.lookForPropertyByType(node, PropertyType.PORT_TYPE)) != null) {
                if (this.currPortType != null) {
                    object = referenceCollection.createWSDLReference((ReferenceableWSDLComponent)this.currPortType, PortType.class);
                    property.setValue(object);
                } else {
                    property.setValue(null);
                }
            }
            if (this.declarationVisible && (property = PropertyUtils.lookForPropertyByType(node, PropertyType.EVENT_VARIABLE_NAME)) != null) {
                object = this.fldVariableName.getText();
                if (object == null || ((String)object).length() == 0) {
                    property.setValue(null);
                } else {
                    property.setValue(object);
                }
            }
            if (this.inputVisible && (property = PropertyUtils.lookForPropertyByType(node, PropertyType.INPUT)) != null) {
                if (this.currInputVar != null) {
                    object = this.currInputVar.createNewVariable();
                    bpelReference = referenceCollection.createReference((BpelReferenceable)object, VariableDeclaration.class);
                    property.setValue((Object)bpelReference);
                } else {
                    property.setValue(null);
                }
            }
            if (this.outputVisible && (property = PropertyUtils.lookForPropertyByType(node, PropertyType.OUTPUT)) != null) {
                if (this.currOutputVar != null && this.isOutputVarEnabled) {
                    object = this.currOutputVar.createNewVariable();
                    bpelReference = referenceCollection.createReference((BpelReferenceable)object, VariableDeclaration.class);
                    property.setValue((Object)bpelReference);
                } else {
                    property.setValue(null);
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    private void reloadOperationList() {
        try {
            this.cbxOperation.setModel(new DefaultComboBoxModel());
            this.cbxOperation.setSelectedIndex(-1);
            PartnerLink partnerLink = (PartnerLink)this.cbxPartnerLink.getSelectedItem();
            this.currPortType = null;
            if (partnerLink == null) {
                this.cbxOperation.setModel(new DefaultComboBoxModel());
            } else {
                PartnerLinkType partnerLinkType;
                WSDLReference wSDLReference = this.useMyRole ? partnerLink.getMyRole() : partnerLink.getPartnerRole();
                WSDLReference wSDLReference2 = partnerLink.getPartnerLinkType();
                if (wSDLReference != null && wSDLReference2 != null && (partnerLinkType = (PartnerLinkType)wSDLReference2.get()) != null) {
                    Object object;
                    NamedComponentReference namedComponentReference = null;
                    Role role = (Role)wSDLReference.get();
                    if (role != null) {
                        if (role.equals(partnerLinkType.getRole1())) {
                            namedComponentReference = partnerLinkType.getRole1().getPortType();
                        } else if (role.equals(partnerLinkType.getRole2())) {
                            namedComponentReference = partnerLinkType.getRole2().getPortType();
                        }
                    } else {
                        object = wSDLReference.getRefString();
                        if (object != null) {
                            if (((String)object).equals(partnerLinkType.getRole1().getName())) {
                                namedComponentReference = partnerLinkType.getRole1().getPortType();
                            } else if (((String)object).equals(partnerLinkType.getRole2().getName())) {
                                namedComponentReference = partnerLinkType.getRole2().getPortType();
                            }
                        }
                    }
                    if (namedComponentReference != null) {
                        this.currPortType = (PortType)namedComponentReference.get();
                    }
                    if (this.currPortType != null) {
                        object = this.currPortType.getOperations();
                        Object[] objectArray = object.toArray();
                        this.cbxOperation.setModel(new DefaultComboBoxModel<Object>(objectArray));
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentOperationSelection() {
        Object object = this.cbxOperation.getSelectedItem();
        try {
            Operation operation;
            WSDLReference wSDLReference;
            Object object2 = PropertyUtils.lookForPropertyByType(this.myEditor.getEditedNode(), PropertyType.OPERATION);
            if (object2 != null && (wSDLReference = (WSDLReference)object2.getValue()) != null && (operation = (Operation)wSDLReference.get()) != null) {
                this.cbxOperation.setSelectedItem(operation);
                this.resetVariables();
                return;
            }
            this.cbxOperation.setSelectedIndex(-1);
            this.resetVariables();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        finally {
            Object object3;
            if (this.myListener != null && !Util.isEqual(object, object3 = this.cbxOperation.getSelectedItem())) {
                this.myListener.operationChanged();
            }
        }
    }

    private void setCurrentVariables() {
        try {
            String string;
            Object object;
            if (this.declarationVisible && (object = PropertyUtils.lookForPropertyByType(this.myEditor.getEditedNode(), PropertyType.EVENT_VARIABLE_NAME)) != null) {
                string = (String)object.getValue();
                this.fldVariableName.setText(string);
            }
            if (this.inputVisible || this.outputVisible) {
                object = this.cbxOperation.getSelectedItem();
                if (object == null) {
                    this.setCurrInputVar(null);
                    this.setCurrOutputVar(null);
                } else {
                    VirtualVariableContainer virtualVariableContainer;
                    Lookup lookup;
                    VariableDeclaration variableDeclaration;
                    BpelReference bpelReference;
                    Node.Property property;
                    boolean bl;
                    Input input;
                    assert (object instanceof Operation);
                    string = (Operation)object;
                    if (this.inputVisible) {
                        input = string.getInput();
                        bl = false;
                        if (input != null && (property = PropertyUtils.lookForPropertyByType(this.myEditor.getEditedNode(), PropertyType.INPUT)) != null && (bpelReference = (BpelReference)property.getValue()) != null && (variableDeclaration = (VariableDeclaration)bpelReference.get()) != null) {
                            lookup = this.myEditor.getLookup();
                            virtualVariableContainer = new VirtualVariableContainer(variableDeclaration, lookup);
                            this.setCurrInputVar(virtualVariableContainer);
                            bl = true;
                        }
                        if (!bl) {
                            this.setCurrInputVar(null);
                        }
                    }
                    if (this.outputVisible && this.isOutputVarEnabled) {
                        input = string.getOutput();
                        bl = false;
                        if (input != null && (property = PropertyUtils.lookForPropertyByType(this.myEditor.getEditedNode(), PropertyType.OUTPUT)) != null && (bpelReference = (BpelReference)property.getValue()) != null && (variableDeclaration = (VariableDeclaration)bpelReference.get()) != null) {
                            lookup = this.myEditor.getLookup();
                            virtualVariableContainer = new VirtualVariableContainer(variableDeclaration, lookup);
                            this.setCurrOutputVar(virtualVariableContainer);
                            bl = true;
                        }
                        if (!bl) {
                            this.setCurrOutputVar(null);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            this.resetVariables();
        }
    }

    private void resetVariables() {
        Object object = this.cbxOperation.getSelectedItem();
        if (object == null) {
            this.setCurrInputVar(null);
            this.setCurrOutputVar(null);
            this.btnNewInputVariable.setEnabled(false);
            this.btnChooseInputVariable.setEnabled(false);
            this.btnNewOutputVariable.setEnabled(false);
            this.btnChooseOutputVariable.setEnabled(false);
        } else {
            Message message;
            Object object2;
            Input input;
            Message message2;
            assert (object instanceof Operation);
            Operation operation = (Operation)object;
            if (this.inputVisible) {
                message2 = null;
                input = operation.getInput();
                if (input != null && (object2 = input.getMessage()) != null) {
                    message2 = (Message)object2.get();
                }
                if (message2 == null) {
                    this.setCurrInputVar(null);
                } else {
                    object2 = this.getCurrInputVar();
                    if (object2 != null && (message = ((VirtualVariableContainer)object2).getType().getMessage()) != null && !message.equals(message2)) {
                        this.setCurrInputVar(null);
                    }
                }
                this.btnNewInputVariable.setEnabled(input != null);
                this.btnChooseInputVariable.setEnabled(input != null);
            }
            if (this.outputVisible && this.isOutputVarEnabled) {
                message2 = null;
                input = operation.getOutput();
                if (input != null && (object2 = input.getMessage()) != null) {
                    message2 = (Message)object2.get();
                }
                if (message2 == null) {
                    this.setCurrOutputVar(null);
                } else {
                    object2 = this.getCurrOutputVar();
                    if (object2 != null && (message = ((VirtualVariableContainer)object2).getType().getMessage()) != null && !message.equals(message2)) {
                        this.setCurrInputVar(null);
                    }
                }
                this.btnNewOutputVariable.setEnabled(input != null);
                this.btnChooseOutputVariable.setEnabled(input != null);
            }
        }
    }

    public void setOutputVarEnabled(boolean bl) {
        if (bl != this.isOutputVarEnabled) {
            this.isOutputVarEnabled = bl;
            if (this.isOutputVarEnabled) {
                this.fldOutputVariable.setEnabled(true);
                Object object = this.cbxOperation.getSelectedItem();
                if (object != null && object instanceof Operation) {
                    Output output = ((Operation)object).getOutput();
                    this.btnNewOutputVariable.setEnabled(output != null);
                    this.btnChooseOutputVariable.setEnabled(output != null);
                }
            } else {
                this.fldOutputVariable.setEnabled(false);
                this.btnNewOutputVariable.setEnabled(false);
                this.btnChooseOutputVariable.setEnabled(false);
            }
        }
    }

    public VirtualVariableContainer getCurrInputVar() {
        return this.currInputVar;
    }

    public void setCurrInputVar(VirtualVariableContainer virtualVariableContainer) {
        if (this.currInputVar == null && virtualVariableContainer != null || this.currInputVar != null && !this.currInputVar.equals(virtualVariableContainer)) {
            this.currInputVar = virtualVariableContainer;
            this.fldInputVariable.setText(this.currInputVar == null ? "" : this.currInputVar.getName());
        }
    }

    public VirtualVariableContainer getCurrOutputVar() {
        return this.currOutputVar;
    }

    public void setCurrOutputVar(VirtualVariableContainer virtualVariableContainer) {
        if (this.currOutputVar == null && virtualVariableContainer != null || this.currOutputVar != null && !this.currOutputVar.equals(virtualVariableContainer)) {
            this.currOutputVar = virtualVariableContainer;
            this.fldOutputVariable.setText(this.currOutputVar == null ? "" : this.currOutputVar.getName());
        }
    }

    public void setCurrVariableName(String string) {
        this.fldVariableName.setText(string);
    }

    public String getCurrVariableName() {
        return this.fldVariableName.getText();
    }

    public DefaultValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                }

                public void doDetailedValidation() {
                    int n = MessageConfigurationController.this.cbxPartnerLink.getSelectedIndex();
                    if (n == -1) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_EMPTY_PARTNER_LINK");
                    } else {
                        int n2 = MessageConfigurationController.this.cbxOperation.getItemCount();
                        if (n2 == 0) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_PARTNER_LINK_WITHOUT_OPERATIONS");
                        } else {
                            int n3 = MessageConfigurationController.this.cbxOperation.getSelectedIndex();
                            if (n3 == -1) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_EMPTY_OPERATION");
                            }
                            if (MessageConfigurationController.this.inputVisible && !MessageConfigurationController.this.isCorrectType(true, MessageConfigurationController.this.currInputVar)) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_INCORRECT_INPUT_VAR_TYPE");
                            }
                            if (MessageConfigurationController.this.outputVisible && MessageConfigurationController.this.isOutputVarEnabled && !MessageConfigurationController.this.isCorrectType(false, MessageConfigurationController.this.currOutputVar)) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_INCORRECT_OUTPUT_VAR_TYPE");
                            }
                        }
                    }
                }
            };
        }
        return this.myValidator;
    }

    private boolean isCorrectType(boolean bl, VirtualVariableContainer virtualVariableContainer) {
        Object object = this.cbxOperation.getSelectedItem();
        if (object != null) {
            Input input;
            Operation operation = (Operation)object;
            Message message = null;
            if (bl) {
                NamedComponentReference namedComponentReference;
                input = operation.getInput();
                if (input != null && (namedComponentReference = input.getMessage()) != null) {
                    message = (Message)namedComponentReference.get();
                }
            } else {
                NamedComponentReference namedComponentReference;
                input = operation.getOutput();
                if (input != null && (namedComponentReference = input.getMessage()) != null) {
                    message = (Message)namedComponentReference.get();
                }
            }
            if (message != null && virtualVariableContainer != null && (input = virtualVariableContainer.getType().getMessage()) != null) {
                return input.equals(message);
            }
        }
        return true;
    }

    public Operation getCurrentOperation() {
        Object object = this.cbxOperation.getSelectedItem();
        return object == null ? null : (Operation)object;
    }

    public JButton getBtnChooseInputVariable() {
        return this.btnChooseInputVariable;
    }

    public JButton getBtnChooseOutputVariable() {
        return this.btnChooseOutputVariable;
    }

    public JButton getBtnNewInputVariable() {
        return this.btnNewInputVariable;
    }

    public JButton getBtnNewOutputVariable() {
        return this.btnNewOutputVariable;
    }

    public JComboBox getCbxOperation() {
        return this.cbxOperation;
    }

    public JComboBox getCbxPartnerLink() {
        return this.cbxPartnerLink;
    }

    public JTextField getFldInputVariable() {
        return this.fldInputVariable;
    }

    public JTextField getFldOutputVariable() {
        return this.fldOutputVariable;
    }

    public JTextField getFldVariableName() {
        return this.fldVariableName;
    }

    public void setConfigurationListener(ConfigurationListener configurationListener) {
        this.myListener = configurationListener;
    }

    public static interface ConfigurationListener {
        public void partnerLinkChanged();

        public void operationChanged();
    }
}

