/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PortTypeReference;
import org.netbeans.modules.bpel.model.xam.BpelAttributes;
import org.netbeans.modules.bpel.properties.editors.BpelEntityComplexName;
import org.netbeans.modules.bpel.properties.editors.CorrelationDefinitionException;
import org.netbeans.modules.bpel.properties.editors.DefineCorrelationWizard;
import org.netbeans.modules.bpel.properties.editors.OnEventComplexName;
import org.netbeans.modules.bpel.properties.editors.OnMessageComplexName;
import org.netbeans.modules.bpel.properties.editors.UnnamedActivityNameHandler;
import org.netbeans.modules.bpel.properties.editors.WizardConstants;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.wsdl.util.RelativePath;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathModelFactory;
import org.netbeans.modules.xml.xpath.ext.XPathModelHelper;
import org.netbeans.modules.xml.xpath.ext.schema.SchemaModelsStack;
import org.netbeans.modules.xml.xpath.ext.schema.XmlExNamespaceContext;
import org.netbeans.modules.xml.xpath.ext.spi.ExternalModelResolver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WizardUtils
implements WizardConstants {
    WizardUtils() {
    }

    public static String getCorrelationSetBpelEntityName(BpelEntity bpelEntity) {
        String string = null;
        if (bpelEntity instanceof OnMessage || bpelEntity instanceof OnEvent) {
            string = NbBundle.getMessage(DefineCorrelationWizard.class, (String)(bpelEntity instanceof OnMessage ? "LBL_Correlation_Set_Name_OnMessage_Pattern" : "LBL_Correlation_Set_Name_OnEvent_Pattern"));
        }
        return WizardUtils.getBpelEntityName(bpelEntity, string);
    }

    public static String getBpelEntityName(BpelEntity bpelEntity) {
        return WizardUtils.getBpelEntityName(bpelEntity, null);
    }

    public static String getBpelEntityName(BpelEntity bpelEntity, String string) {
        if (bpelEntity instanceof OnMessage || bpelEntity instanceof OnEvent) {
            assert (string != null);
            BpelEntityComplexName bpelEntityComplexName = bpelEntity instanceof OnMessage ? new OnMessageComplexName((OnMessage)bpelEntity) : new OnEventComplexName((OnEvent)bpelEntity);
            String string2 = bpelEntityComplexName.getFirstName();
            String string3 = bpelEntityComplexName.getMiddleName();
            String string4 = bpelEntityComplexName.getLastName();
            return MessageFormat.format(string, string2, string3, string4);
        }
        String string5 = bpelEntity.getAttribute((Attribute)BpelAttributes.NAME);
        return string5 != null ? string5 : UnnamedActivityNameHandler.getInstance().getActivityName(bpelEntity);
    }

    public static NamedComponentReference<? extends GlobalType> getSchemaComponentTypeRef(SchemaComponent schemaComponent) {
        NamedComponentReference namedComponentReference = null;
        try {
            namedComponentReference = ((TypeContainer)schemaComponent).getType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return namedComponentReference;
    }

    public static String getSchemaComponentTypeName(SchemaComponent schemaComponent) {
        NamedComponentReference<? extends GlobalType> namedComponentReference;
        String string = null;
        string = schemaComponent instanceof SimpleType || schemaComponent instanceof ComplexType ? schemaComponent.getAttribute(ValidationUtil.attributeName()) : ((namedComponentReference = WizardUtils.getSchemaComponentTypeRef(schemaComponent)) != null ? ((GlobalType)namedComponentReference.get()).getName() : schemaComponent.getAttribute(ValidationUtil.attributeType()));
        return string;
    }

    public static String getSchemaComponentName(SchemaComponent schemaComponent) {
        String string = null;
        string = schemaComponent instanceof SimpleType ? WizardUtils.getSchemaComponentTypeName(schemaComponent) : schemaComponent.toString();
        return string;
    }

    public static boolean isBuiltInType(SchemaComponent schemaComponent) {
        String string = WizardUtils.getSchemaComponentTypeName(schemaComponent);
        GlobalSimpleType globalSimpleType = ValidationUtil.findGlobalSimpleType((String)string, (Collection)ValidationUtil.BUILT_IN_SIMPLE_TYPES);
        return globalSimpleType != null;
    }

    public static PortType getBpelEntityPortType(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return null;
        }
        try {
            PortType portType = (PortType)((PortTypeReference)bpelEntity).getPortType().get();
            return portType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Operation getBpelEntityOperation(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return null;
        }
        PortType portType = WizardUtils.getBpelEntityPortType(bpelEntity);
        Collection collection = portType.getOperations();
        String string = bpelEntity.getAttribute((Attribute)BpelAttributes.OPERATION);
        for (Operation operation : collection) {
            if (!operation.getName().equals(string)) continue;
            return operation;
        }
        return null;
    }

    public static String validateActivity(BpelEntity bpelEntity) {
        if (WizardUtils.getBpelEntityPortType(bpelEntity) == null) {
            return NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_ErrMsg_Activity_Has_Wrong_PortType");
        }
        if (WizardUtils.getBpelEntityOperation(bpelEntity) == null) {
            return NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_ErrMsg_Activity_Has_Wrong_Operation");
        }
        return null;
    }

    public static void importRequiredSchemas(final WSDLModel wSDLModel, final List<SchemaComponent> list) {
        WizardUtils.doInTransaction((Model)wSDLModel, new Runnable(){

            public void run() {
                try {
                    for (SchemaComponent schemaComponent : list) {
                        Utility.addSchemaImport((SchemaComponent)schemaComponent, (WSDLModel)wSDLModel);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        });
    }

    public static void importWsdlIntoWsdl(final WSDLModel wSDLModel, final WSDLModel wSDLModel2) {
        WizardUtils.doInTransaction((Model)wSDLModel, new Runnable(){

            public void run() {
                try {
                    Import import_ = wSDLModel.getFactory().createImport();
                    FileObject fileObject = (FileObject)wSDLModel.getModelSource().getLookup().lookup(FileObject.class);
                    FileObject fileObject2 = (FileObject)wSDLModel2.getModelSource().getLookup().lookup(FileObject.class);
                    String string = WizardUtils.getRelativePath(fileObject, fileObject2);
                    import_.setNamespace(wSDLModel2.getDefinitions().getTargetNamespace());
                    import_.setLocation(string);
                    if (!WizardUtils.wsdlContainsImport(wSDLModel, import_)) {
                        wSDLModel.getDefinitions().addImport(import_);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        });
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject == null || fileObject2 == null) {
            throw new NullPointerException(fileObject == null ? "Base file object is null" : "Related file object is null");
        }
        String string = fileObject2.getNameExt();
        URI uRI = FileUtil.toFile((FileObject)fileObject).toURI();
        URI uRI2 = FileUtil.toFile((FileObject)fileObject2).toURI();
        if (!uRI2.equals(uRI)) {
            DefaultProjectCatalogSupport defaultProjectCatalogSupport = DefaultProjectCatalogSupport.getInstance((FileObject)fileObject);
            if (defaultProjectCatalogSupport.needsCatalogEntry(fileObject, fileObject2)) {
                try {
                    URI uRI3 = defaultProjectCatalogSupport.getReferenceURI(fileObject, fileObject2);
                    defaultProjectCatalogSupport.removeCatalogEntry(uRI3);
                    defaultProjectCatalogSupport.createCatalogEntry(fileObject, fileObject2);
                    string = defaultProjectCatalogSupport.getReferenceURI(fileObject, fileObject2).toString();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            } else {
                string = RelativePath.getRelativePath((File)FileUtil.toFile((FileObject)fileObject).getParentFile(), (File)FileUtil.toFile((FileObject)fileObject2));
            }
        }
        return string;
    }

    public static boolean wsdlContainsImport(WSDLModel wSDLModel, Import import_) {
        Collection collection = wSDLModel.getDefinitions().getImports();
        for (Import import_2 : collection) {
            if (!import_2.getNamespace().equals(import_.getNamespace()) || !import_2.getLocation().equals(import_.getLocation())) continue;
            return true;
        }
        return false;
    }

    public static boolean wsdlContainsPropertyAlias(WSDLModel wSDLModel, CorrelationProperty correlationProperty, Message message, Part part) {
        List list = ((WSDLComponent)wSDLModel.getRootComponent()).getChildren(PropertyAlias.class);
        for (PropertyAlias propertyAlias : list) {
            CorrelationProperty correlationProperty2 = null;
            Message message2 = null;
            String string = null;
            try {
                correlationProperty2 = (CorrelationProperty)propertyAlias.getPropertyName().get();
                message2 = (Message)propertyAlias.getMessageType().get();
                string = propertyAlias.getPart();
                if (!correlationProperty2.getName().equals(correlationProperty.getName()) || !message2.getName().equals(message.getName()) || !string.equals(part.getName())) continue;
                return true;
            }
            catch (Exception exception) {
                String string2 = correlationProperty2 == null ? "propertyName" : null;
                string2 = string2 == null && message2 == null ? "messageType" : string2;
                String string3 = string2 = string2 == null && string == null ? "part" : string2;
                if (string2 != null) {
                    String string4 = wSDLModel.getDefinitions().getName();
                    String string5 = ((AbstractDocumentComponent)propertyAlias).getXmlFragmentInclusive();
                    string2 = "[" + string4 + "]: " + MessageFormat.format(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_ErrMsg_Property_Alias_Wrong_Attribute_Value"), string2) + "\n" + (string5 != null ? string5 : "");
                }
                throw new CorrelationDefinitionException(string2, exception);
            }
        }
        return false;
    }

    public static String makeLocationPath(final WSDLModel wSDLModel, final List<SchemaComponent> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        XPathModelHelper xPathModelHelper = XPathModelHelper.getInstance();
        XPathModel xPathModel = xPathModelHelper.newXPathModel();
        XmlExNamespaceContext xmlExNamespaceContext = new XmlExNamespaceContext((AbstractDocumentComponent)wSDLModel.getDefinitions());
        xPathModel.setNamespaceContext((NamespaceContext)xmlExNamespaceContext);
        xPathModel.setExternalModelResolver(new ExternalModelResolver(){

            public Collection<SchemaModel> getModels(String string) {
                List list2 = wSDLModel.findSchemas(string);
                ArrayList<SchemaModel> arrayList = new ArrayList<SchemaModel>(list2.size());
                for (Schema schema : list2) {
                    SchemaModel schemaModel = schema.getModel();
                    arrayList.add(schemaModel);
                }
                return arrayList;
            }

            public Collection<SchemaModel> getVisibleModels() {
                SchemaModel schemaModel = ((SchemaComponent)list.get(0)).getModel();
                return Collections.singleton(schemaModel);
            }

            public boolean isSchemaVisible(String string) {
                List list2 = wSDLModel.findSchemas(string);
                return list2 != null && list2.size() > 0;
            }
        });
        XPathModelFactory xPathModelFactory = xPathModel.getFactory();
        ArrayList<LocationStep> arrayList = new ArrayList<LocationStep>(list.size());
        SchemaModelsStack schemaModelsStack = new SchemaModelsStack();
        for (SchemaComponent schemaComponent : list) {
            StepNodeNameTest stepNodeNameTest = new StepNodeNameTest(xPathModel, schemaComponent, schemaModelsStack);
            LocationStep locationStep = xPathModelFactory.newLocationStep(null, (StepNodeTest)stepNodeNameTest, null);
            arrayList.add(locationStep);
            schemaModelsStack.appendSchemaComponent(schemaComponent);
        }
        XPathLocationPath xPathLocationPath = xPathModelFactory.newXPathLocationPath(arrayList.toArray(new LocationStep[arrayList.size()]));
        xPathLocationPath.setAbsolute(true);
        xPathModel.setRootExpression((XPathExpression)xPathLocationPath);
        return xPathLocationPath.getExpressionString();
    }

    public static String getNamespacePrefix(final WSDLModel wSDLModel, final String string) {
        String string2 = WizardUtils.getNamespacePrefixImpl(wSDLModel, string);
        if (string2 != null) {
            return string2;
        }
        string2 = "ns";
        final int n = WizardUtils.getMaxSuffixNumber(wSDLModel, string2) + 1;
        final String string3 = string2 + n;
        WizardUtils.doInTransaction((Model)wSDLModel, new Runnable(){

            public void run() {
                if (n == 0) {
                    ((AbstractDocumentComponent)wSDLModel.getDefinitions()).addPrefix(string3, string);
                }
            }
        });
        return string3;
    }

    private static String getNamespacePrefixImpl(WSDLModel wSDLModel, String string) {
        String string2 = wSDLModel.getDefinitions().getPeer().lookupPrefix(string);
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    private static int getMaxSuffixNumber(WSDLModel wSDLModel, String string) {
        assert (string != null);
        Set set = ((AbstractDocumentComponent)wSDLModel.getDefinitions()).getPrefixes().keySet();
        int n = -1;
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= n) continue;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInTransaction(Model model, Runnable runnable) {
        boolean bl = model.isIntransaction();
        if (!bl) {
            model.startTransaction();
        }
        try {
            runnable.run();
        }
        finally {
            if (!bl) {
                model.endTransaction();
            }
        }
    }
}

