/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties;

import java.util.Collection;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;

public class ImportWsdlRegistrationHelper {
    private WSDLModel myWsdlModel;

    public ImportWsdlRegistrationHelper(WSDLModel wSDLModel) {
        this.myWsdlModel = wSDLModel;
    }

    public void addImport(Model model) {
        if (model == null) {
            return;
        }
        if (model instanceof SchemaModel) {
            FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
            if (fileObject != null && fileObject.hasExt("wsdl")) {
                this.addImportWsdl(fileObject);
                return;
            }
            this.addImport((SchemaModel)model);
            return;
        }
        if (model instanceof WSDLModel) {
            this.addImport((WSDLModel)model);
            return;
        }
    }

    private void addImportWsdl(FileObject fileObject) {
        if (fileObject == null) {
            return;
        }
        if (this.isSelfFo(fileObject)) {
            return;
        }
        WSDLModel wSDLModel = this.getWsdlModelByFo(fileObject);
        if (wSDLModel != null) {
            this.addImport(wSDLModel);
        }
    }

    private WSDLModel getWsdlModelByFo(FileObject fileObject) {
        WSDLModel wSDLModel;
        assert (fileObject != null);
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
        if (modelSource != null && (wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource)).getState() != Model.State.NOT_WELL_FORMED) {
            return wSDLModel;
        }
        return null;
    }

    private boolean isSelfFo(FileObject fileObject) {
        assert (fileObject != null);
        FileObject fileObject2 = SoaUtil.getFileObjectByModel((Model)this.myWsdlModel);
        return fileObject2.equals(fileObject);
    }

    public void addImport(WSDLModel wSDLModel) {
        if (wSDLModel == null) {
            return;
        }
        if (wSDLModel.equals(this.myWsdlModel)) {
            return;
        }
        Definitions definitions = this.myWsdlModel.getDefinitions();
        Collection collection = definitions.getImports();
        for (Import import_ : collection) {
            try {
                if (!wSDLModel.equals(import_.getImportedWSDLModel())) continue;
                return;
            }
            catch (CatalogModelException catalogModelException) {
            }
        }
        this.createImport(wSDLModel);
    }

    public void createImport(WSDLModel wSDLModel) {
        String string;
        if (wSDLModel == null) {
            return;
        }
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)wSDLModel);
        Import import_ = this.myWsdlModel.getFactory().createImport();
        String string2 = Util.getNewModelLocation((Model)this.myWsdlModel, fileObject);
        if (string2 != null) {
            import_.setLocation(string2);
        }
        if ((string = Util.getNewModelNamespace(fileObject, Constants.StandardImportType.IMPORT_WSDL)) != null) {
            import_.setNamespace(string);
        }
        this.myWsdlModel.addChildComponent((Component)this.myWsdlModel.getRootComponent(), (Component)import_, 0);
    }

    public void addImport(SchemaModel schemaModel) {
        org.netbeans.modules.xml.schema.model.Import import_;
        Collection collection;
        Definitions definitions = this.myWsdlModel.getDefinitions();
        if (definitions == null) {
            return;
        }
        Types types = definitions.getTypes();
        if (types == null) {
            types = this.myWsdlModel.getFactory().createTypes();
            definitions.setTypes(types);
        }
        Schema schema = null;
        String string = definitions.getTargetNamespace();
        if (string != null && (collection = types.getSchemas()) != null) {
            for (Schema schema2 : collection) {
                if (schema2.getTargetNamespace() == null || !schema2.getTargetNamespace().equals(string)) continue;
                schema = schema2;
                break;
            }
        }
        collection = null;
        if (schema == null) {
            collection = this.myWsdlModel.getFactory().createWSDLSchema();
            import_ = collection.getSchemaModel();
            schema = import_.getSchema();
            schema.setTargetNamespace(string);
        }
        import_ = schemaModel.getFactory().createImport();
        try {
            Schema schema2;
            if (!this.isExistSchemaRef(schema, schemaModel) && (schema2 = SoaUtil.getFileObjectByModel((Model)schemaModel)) != null) {
                String string2;
                String string3 = Util.getNewModelLocation((Model)this.myWsdlModel, (FileObject)schema2);
                if (string3 != null) {
                    import_.setSchemaLocation(string3);
                }
                if ((string2 = Util.getNewModelNamespace((FileObject)schema2, Constants.StandardImportType.IMPORT_SCHEMA)) != null) {
                    import_.setNamespace(string2);
                }
                schema.addExternalReference((SchemaModelReference)import_);
                if (collection != null) {
                    types.addExtensibilityElement((ExtensibilityElement)collection);
                }
            }
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
    }

    private boolean isExistSchemaRef(Schema schema, SchemaModel schemaModel) throws CatalogModelException {
        if (schema == null || schemaModel == null) {
            return false;
        }
        Collection collection = schema.getSchemaReferences();
        for (SchemaModelReference schemaModelReference : collection) {
            if (!schemaModel.equals(schemaModelReference.resolveReferencedModel())) continue;
            return true;
        }
        return false;
    }

    public void addImport2BpelModel(Model model, BpelModel bpelModel) {
        if (bpelModel == null || model == null) {
            return;
        }
        if (model.getClass().isAssignableFrom(SchemaModel.class)) {
            this.addImport2BpelModel((SchemaModel)SchemaModel.class.cast(model), bpelModel);
            return;
        }
        if (model.getClass().isAssignableFrom(WSDLModel.class)) {
            this.addImport2BpelModel((WSDLModel)WSDLModel.class.cast(model), bpelModel);
            return;
        }
    }

    public void addImport2BpelModel(SchemaModel schemaModel, BpelModel bpelModel) {
        throw new UnsupportedOperationException();
    }

    public void addImport2BpelModel(WSDLModel wSDLModel, BpelModel bpelModel) {
        throw new UnsupportedOperationException();
    }
}

